import { ReactNode, FC, ComponentPropsWithoutRef } from 'react';
import { GraphiQLProvider, HeaderEditor, QueryEditor, ResponseEditor, VariableEditor, EditorProps } from '@graphiql/react';
import { HistoryStore } from '@graphiql/plugin-history';
import { Sidebar } from './ui';
/**
 * API docs for this live here:
 *
 * https://graphiql-test.netlify.app/typedoc/modules/graphiql.html#graphiqlprops
 */
export interface GraphiQLProps extends GraphiQLInterfaceProps, Omit<ComponentPropsWithoutRef<typeof GraphiQLProvider>, 'children'>, Omit<ComponentPropsWithoutRef<typeof HistoryStore>, 'children'> {
}
declare type AddSuffix<Obj extends Record<string, any>, Suffix extends string> = {
    [Key in keyof Obj as `${string & Key}${Suffix}`]: Obj[Key];
};
declare type QueryEditorProps = ComponentPropsWithoutRef<typeof QueryEditor>;
declare type VariableEditorProps = ComponentPropsWithoutRef<typeof VariableEditor>;
declare type HeaderEditorProps = ComponentPropsWithoutRef<typeof HeaderEditor>;
declare type ResponseEditorProps = ComponentPropsWithoutRef<typeof ResponseEditor>;
interface GraphiQLInterfaceProps extends EditorProps, AddSuffix<Pick<QueryEditorProps, 'onEdit'>, 'Query'>, AddSuffix<Pick<VariableEditorProps, 'onEdit'>, 'Variables'>, AddSuffix<Pick<HeaderEditorProps, 'onEdit'>, 'Headers'>, Pick<ResponseEditorProps, 'responseTooltip'>, Pick<ComponentPropsWithoutRef<typeof Sidebar>, 'forcedTheme' | 'showPersistHeadersSettings'> {
    children?: ReactNode;
    /**
     * Set the default state for the editor tools.
     * - `false` hides the editor tools
     * - `true` shows the editor tools
     * - `'variables'` specifically shows the variables editor
     * - `'headers'` specifically shows the request headers editor
     * By default, the editor tools are initially shown when at least one of the
     * editors has contents.
     */
    defaultEditorToolsVisibility?: boolean | 'variables' | 'headers';
    /**
     * Toggle if the headers' editor should be shown inside the editor tools.
     * @default true
     */
    isHeadersEditorEnabled?: boolean;
    /**
     * Additional class names which will be appended to the container element.
     */
    className?: string;
    /**
     * When the user clicks a close tab button, this function is invoked with
     * the index of the tab that is about to be closed. It can return a promise
     * that should resolve to `true` (meaning the tab may be closed) or `false`
     * (meaning the tab may not be closed).
     * @param index - The index of the tab that should be closed.
     */
    confirmCloseTab?(index: number): Promise<boolean> | boolean;
}
export declare const GraphiQL: FC<GraphiQLProps> & {
    Logo: FC<{
        children?: ReactNode;
    }>;
    Toolbar: FC<{
        children?: ReactNode | FC<{
            prettify: ReactNode;
            copy: ReactNode;
            merge: ReactNode;
        }>;
    }>;
    Footer: FC<{
        children: ReactNode;
    }>;
};
export {};
