import { jsx, jsxs } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { Fragment, useState, Children, useRef } from "react";
import { GraphiQLProvider, useGraphiQLActions, pick, useGraphiQL, useDragResize, ChevronUpIcon, ChevronDownIcon, cn, UnStyledButton, Tab, Tooltip, QueryEditor, ExecuteButton, VariableEditor, HeaderEditor, Tabs, PlusIcon, Spinner, ResponseEditor } from "@graphiql/react";
import { HISTORY_PLUGIN, HistoryStore } from "@graphiql/plugin-history";
import { DOC_EXPLORER_PLUGIN, DocExplorerStore } from "@graphiql/plugin-doc-explorer";
import { GraphiQLFooter } from "./ui/footer.js";
import { GraphiQLToolbar } from "./ui/toolbar.js";
import { GraphiQLLogo } from "./ui/logo.js";
import { Sidebar } from "./ui/sidebar.js";
const GraphiQL_ = (t0) => {
  var _a, _b;
  const $ = c(54);
  let children;
  let className;
  let confirmCloseTab;
  let defaultEditorToolsVisibility;
  let forcedTheme;
  let isHeadersEditorEnabled;
  let maxHistoryLength;
  let onEditHeaders;
  let onEditQuery;
  let onEditVariables;
  let props;
  let responseTooltip;
  let showPersistHeadersSettings;
  let t1;
  let t2;
  if ($[0] !== t0) {
    ({
      maxHistoryLength,
      plugins: t1,
      referencePlugin: t2,
      onEditQuery,
      onEditVariables,
      onEditHeaders,
      responseTooltip,
      defaultEditorToolsVisibility,
      isHeadersEditorEnabled,
      showPersistHeadersSettings,
      forcedTheme,
      confirmCloseTab,
      className,
      children,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = className;
    $[3] = confirmCloseTab;
    $[4] = defaultEditorToolsVisibility;
    $[5] = forcedTheme;
    $[6] = isHeadersEditorEnabled;
    $[7] = maxHistoryLength;
    $[8] = onEditHeaders;
    $[9] = onEditQuery;
    $[10] = onEditVariables;
    $[11] = props;
    $[12] = responseTooltip;
    $[13] = showPersistHeadersSettings;
    $[14] = t1;
    $[15] = t2;
  } else {
    children = $[1];
    className = $[2];
    confirmCloseTab = $[3];
    defaultEditorToolsVisibility = $[4];
    forcedTheme = $[5];
    isHeadersEditorEnabled = $[6];
    maxHistoryLength = $[7];
    onEditHeaders = $[8];
    onEditQuery = $[9];
    onEditVariables = $[10];
    props = $[11];
    responseTooltip = $[12];
    showPersistHeadersSettings = $[13];
    t1 = $[14];
    t2 = $[15];
  }
  let t3;
  if ($[16] !== t1) {
    t3 = t1 === void 0 ? [HISTORY_PLUGIN] : t1;
    $[16] = t1;
    $[17] = t3;
  } else {
    t3 = $[17];
  }
  const plugins = t3;
  const referencePlugin = t2 === void 0 ? DOC_EXPLORER_PLUGIN : t2;
  if ((_a = props.toolbar) == null ? void 0 : _a.additionalContent) {
    throw new TypeError("The `toolbar.additionalContent` prop has been removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  if ((_b = props.toolbar) == null ? void 0 : _b.additionalComponent) {
    throw new TypeError("The `toolbar.additionalComponent` prop has been removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  if (props.keyMap) {
    throw new TypeError("`keyMap` was removed. To use Vim or Emacs keybindings in Monaco, you can use community plugins. Monaco Vim: https://github.com/brijeshb42/monaco-vim. Monaco Emacs: https://github.com/aioutecism/monaco-emacs");
  }
  if (props.readOnly) {
    throw new TypeError("The `readOnly` prop has been removed.");
  }
  const t4 = showPersistHeadersSettings ?? props.shouldPersistHeaders !== false;
  let t5;
  if ($[18] !== className || $[19] !== confirmCloseTab || $[20] !== defaultEditorToolsVisibility || $[21] !== forcedTheme || $[22] !== isHeadersEditorEnabled || $[23] !== onEditHeaders || $[24] !== onEditQuery || $[25] !== onEditVariables || $[26] !== responseTooltip || $[27] !== t4) {
    t5 = {
      showPersistHeadersSettings: t4,
      onEditQuery,
      onEditVariables,
      onEditHeaders,
      responseTooltip,
      defaultEditorToolsVisibility,
      isHeadersEditorEnabled,
      forcedTheme,
      confirmCloseTab,
      className
    };
    $[18] = className;
    $[19] = confirmCloseTab;
    $[20] = defaultEditorToolsVisibility;
    $[21] = forcedTheme;
    $[22] = isHeadersEditorEnabled;
    $[23] = onEditHeaders;
    $[24] = onEditQuery;
    $[25] = onEditVariables;
    $[26] = responseTooltip;
    $[27] = t4;
    $[28] = t5;
  } else {
    t5 = $[28];
  }
  const interfaceProps = t5;
  let t6;
  if ($[29] !== plugins) {
    t6 = plugins.includes(HISTORY_PLUGIN);
    $[29] = plugins;
    $[30] = t6;
  } else {
    t6 = $[30];
  }
  const hasHistoryPlugin = t6;
  const HistoryToUse = hasHistoryPlugin ? HistoryStore : Fragment;
  const DocExplorerToUse = referencePlugin === DOC_EXPLORER_PLUGIN ? DocExplorerStore : Fragment;
  let t7;
  if ($[31] !== referencePlugin) {
    t7 = referencePlugin ? [referencePlugin] : [];
    $[31] = referencePlugin;
    $[32] = t7;
  } else {
    t7 = $[32];
  }
  let t8;
  if ($[33] !== plugins || $[34] !== t7) {
    t8 = [...t7, ...plugins];
    $[33] = plugins;
    $[34] = t7;
    $[35] = t8;
  } else {
    t8 = $[35];
  }
  let t9;
  if ($[36] !== hasHistoryPlugin || $[37] !== maxHistoryLength) {
    t9 = hasHistoryPlugin && {
      maxHistoryLength
    };
    $[36] = hasHistoryPlugin;
    $[37] = maxHistoryLength;
    $[38] = t9;
  } else {
    t9 = $[38];
  }
  let t10;
  if ($[39] !== children || $[40] !== interfaceProps) {
    t10 = /* @__PURE__ */ jsx(GraphiQLInterface, { ...interfaceProps, children });
    $[39] = children;
    $[40] = interfaceProps;
    $[41] = t10;
  } else {
    t10 = $[41];
  }
  let t11;
  if ($[42] !== DocExplorerToUse || $[43] !== t10) {
    t11 = /* @__PURE__ */ jsx(DocExplorerToUse, { children: t10 });
    $[42] = DocExplorerToUse;
    $[43] = t10;
    $[44] = t11;
  } else {
    t11 = $[44];
  }
  let t12;
  if ($[45] !== HistoryToUse || $[46] !== t11 || $[47] !== t9) {
    t12 = /* @__PURE__ */ jsx(HistoryToUse, { ...t9, children: t11 });
    $[45] = HistoryToUse;
    $[46] = t11;
    $[47] = t9;
    $[48] = t12;
  } else {
    t12 = $[48];
  }
  let t13;
  if ($[49] !== props || $[50] !== referencePlugin || $[51] !== t12 || $[52] !== t8) {
    t13 = /* @__PURE__ */ jsx(GraphiQLProvider, { plugins: t8, referencePlugin, ...props, children: t12 });
    $[49] = props;
    $[50] = referencePlugin;
    $[51] = t12;
    $[52] = t8;
    $[53] = t13;
  } else {
    t13 = $[53];
  }
  return t13;
};
const TAB_CLASS_PREFIX = "graphiql-session-tab-";
const LABEL = {
  newTab: "New tab"
};
const GraphiQLInterface = (t0) => {
  const $ = c(146);
  const {
    forcedTheme,
    isHeadersEditorEnabled: t1,
    defaultEditorToolsVisibility,
    children: $children,
    confirmCloseTab,
    className,
    onEditQuery,
    onEditVariables,
    onEditHeaders,
    responseTooltip,
    showPersistHeadersSettings
  } = t0;
  const isHeadersEditorEnabled = t1 === void 0 ? true : t1;
  const {
    addTab,
    moveTab,
    closeTab,
    changeTab,
    setVisiblePlugin
  } = useGraphiQLActions();
  let t2;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = pick("initialVariables", "initialHeaders", "tabs", "activeTabIndex", "isFetching", "visiblePlugin");
    $[0] = t2;
  } else {
    t2 = $[0];
  }
  const {
    initialVariables,
    initialHeaders,
    tabs,
    activeTabIndex,
    isFetching,
    visiblePlugin
  } = useGraphiQL(t2);
  const PluginContent = visiblePlugin == null ? void 0 : visiblePlugin.content;
  const t3 = visiblePlugin ? void 0 : "first";
  let t4;
  if ($[1] !== setVisiblePlugin || $[2] !== t3) {
    t4 = {
      defaultSizeRelation: 0.3333333333333333,
      direction: "horizontal",
      initiallyHidden: t3,
      onHiddenElementChange(resizableElement) {
        if (resizableElement === "first") {
          setVisiblePlugin(null);
        }
      },
      sizeThresholdSecond: 200,
      storageKey: "docExplorerFlex"
    };
    $[1] = setVisiblePlugin;
    $[2] = t3;
    $[3] = t4;
  } else {
    t4 = $[3];
  }
  const pluginResize = useDragResize(t4);
  let t5;
  if ($[4] === Symbol.for("react.memo_cache_sentinel")) {
    t5 = {
      direction: "horizontal",
      storageKey: "editorFlex"
    };
    $[4] = t5;
  } else {
    t5 = $[4];
  }
  const editorResize = useDragResize(t5);
  let t6;
  if ($[5] !== initialHeaders || $[6] !== initialVariables) {
    t6 = (d) => {
      if (d === "variables" || d === "headers") {
        return;
      }
      if (typeof d === "boolean") {
        return d ? void 0 : "second";
      }
      return initialVariables || initialHeaders ? void 0 : "second";
    };
    $[5] = initialHeaders;
    $[6] = initialVariables;
    $[7] = t6;
  } else {
    t6 = $[7];
  }
  let t7;
  if ($[8] !== defaultEditorToolsVisibility || $[9] !== t6) {
    t7 = t6(defaultEditorToolsVisibility);
    $[8] = defaultEditorToolsVisibility;
    $[9] = t6;
    $[10] = t7;
  } else {
    t7 = $[10];
  }
  let t8;
  if ($[11] !== t7) {
    t8 = {
      defaultSizeRelation: 3,
      direction: "vertical",
      initiallyHidden: t7,
      sizeThresholdSecond: 60,
      storageKey: "secondaryEditorFlex"
    };
    $[11] = t7;
    $[12] = t8;
  } else {
    t8 = $[12];
  }
  const editorToolsResize = useDragResize(t8);
  let t9;
  if ($[13] !== defaultEditorToolsVisibility || $[14] !== initialHeaders || $[15] !== initialVariables || $[16] !== isHeadersEditorEnabled) {
    t9 = () => {
      if (defaultEditorToolsVisibility === "variables" || defaultEditorToolsVisibility === "headers") {
        return defaultEditorToolsVisibility;
      }
      return !initialVariables && initialHeaders && isHeadersEditorEnabled ? "headers" : "variables";
    };
    $[13] = defaultEditorToolsVisibility;
    $[14] = initialHeaders;
    $[15] = initialVariables;
    $[16] = isHeadersEditorEnabled;
    $[17] = t9;
  } else {
    t9 = $[17];
  }
  const [activeSecondaryEditor, setActiveSecondaryEditor] = useState(t9);
  let t10;
  if ($[18] !== $children) {
    let t112;
    let t122;
    if ($[20] === Symbol.for("react.memo_cache_sentinel")) {
      t112 = /* @__PURE__ */ jsx(GraphiQL.Logo, {});
      t122 = /* @__PURE__ */ jsx(GraphiQL.Toolbar, {});
      $[20] = t112;
      $[21] = t122;
    } else {
      t112 = $[20];
      t122 = $[21];
    }
    t10 = Children.toArray($children).reduce(_temp, {
      logo: t112,
      toolbar: t122,
      children: []
    });
    $[18] = $children;
    $[19] = t10;
  } else {
    t10 = $[19];
  }
  const {
    logo,
    toolbar,
    footer,
    children
  } = t10;
  let t11;
  if ($[22] !== pluginResize) {
    t11 = function onClickReference2() {
      if (pluginResize.hiddenElement === "first") {
        pluginResize.setHiddenElement(null);
      }
    };
    $[22] = pluginResize;
    $[23] = t11;
  } else {
    t11 = $[23];
  }
  const onClickReference = t11;
  let t12;
  if ($[24] !== editorToolsResize) {
    t12 = (event) => {
      if (editorToolsResize.hiddenElement === "second") {
        editorToolsResize.setHiddenElement(null);
      }
      const tabName = event.currentTarget.dataset.name;
      setActiveSecondaryEditor(tabName);
    };
    $[24] = editorToolsResize;
    $[25] = t12;
  } else {
    t12 = $[25];
  }
  const handleToolsTabClick = t12;
  let t13;
  if ($[26] !== editorToolsResize) {
    t13 = () => {
      editorToolsResize.setHiddenElement(editorToolsResize.hiddenElement === "second" ? null : "second");
    };
    $[26] = editorToolsResize;
    $[27] = t13;
  } else {
    t13 = $[27];
  }
  const toggleEditorTools = t13;
  let t14;
  if ($[28] !== closeTab || $[29] !== confirmCloseTab) {
    t14 = async (event_0) => {
      const tabButton = event_0.currentTarget.previousSibling;
      const index = Number(tabButton.id.replace(TAB_CLASS_PREFIX, ""));
      const shouldCloseTab = confirmCloseTab ? await confirmCloseTab(index) : true;
      if (!shouldCloseTab) {
        return;
      }
      closeTab(index);
    };
    $[28] = closeTab;
    $[29] = confirmCloseTab;
    $[30] = t14;
  } else {
    t14 = $[30];
  }
  const handleTabClose = t14;
  let t15;
  if ($[31] !== changeTab) {
    t15 = (event_1) => {
      const index_0 = Number(event_1.currentTarget.id.replace(TAB_CLASS_PREFIX, ""));
      changeTab(index_0);
    };
    $[31] = changeTab;
    $[32] = t15;
  } else {
    t15 = $[32];
  }
  const handleTabClick = t15;
  const editorToolsText = `${editorToolsResize.hiddenElement === "second" ? "Show" : "Hide"} editor tools`;
  const EditorToolsIcon = editorToolsResize.hiddenElement === "second" ? ChevronUpIcon : ChevronDownIcon;
  const t16 = editorResize.firstRef;
  let t17;
  if ($[33] !== onClickReference || $[34] !== onEditQuery) {
    t17 = /* @__PURE__ */ jsx(QueryEditor, { onClickReference, onEdit: onEditQuery });
    $[33] = onClickReference;
    $[34] = onEditQuery;
    $[35] = t17;
  } else {
    t17 = $[35];
  }
  let t18;
  if ($[36] === Symbol.for("react.memo_cache_sentinel")) {
    t18 = /* @__PURE__ */ jsx(ExecuteButton, {});
    $[36] = t18;
  } else {
    t18 = $[36];
  }
  let t19;
  if ($[37] !== toolbar) {
    t19 = /* @__PURE__ */ jsxs("div", { className: "graphiql-toolbar", role: "toolbar", "aria-label": "Editor Commands", children: [
      t18,
      toolbar
    ] });
    $[37] = toolbar;
    $[38] = t19;
  } else {
    t19 = $[38];
  }
  let t20;
  if ($[39] !== editorToolsResize.firstRef || $[40] !== t17 || $[41] !== t19) {
    t20 = /* @__PURE__ */ jsxs("section", { className: "graphiql-query-editor", "aria-label": "Operation Editor", ref: editorToolsResize.firstRef, children: [
      t17,
      t19
    ] });
    $[39] = editorToolsResize.firstRef;
    $[40] = t17;
    $[41] = t19;
    $[42] = t20;
  } else {
    t20 = $[42];
  }
  const t21 = editorToolsResize.dragBarRef;
  const t22 = activeSecondaryEditor === "variables" && editorToolsResize.hiddenElement !== "second" && "active";
  let t23;
  if ($[43] !== t22) {
    t23 = cn(t22);
    $[43] = t22;
    $[44] = t23;
  } else {
    t23 = $[44];
  }
  let t24;
  if ($[45] !== handleToolsTabClick || $[46] !== t23) {
    t24 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: t23, onClick: handleToolsTabClick, "data-name": "variables", children: "Variables" });
    $[45] = handleToolsTabClick;
    $[46] = t23;
    $[47] = t24;
  } else {
    t24 = $[47];
  }
  let t25;
  if ($[48] !== activeSecondaryEditor || $[49] !== editorToolsResize.hiddenElement || $[50] !== handleToolsTabClick || $[51] !== isHeadersEditorEnabled) {
    t25 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: cn(activeSecondaryEditor === "headers" && editorToolsResize.hiddenElement !== "second" && "active"), onClick: handleToolsTabClick, "data-name": "headers", children: "Headers" });
    $[48] = activeSecondaryEditor;
    $[49] = editorToolsResize.hiddenElement;
    $[50] = handleToolsTabClick;
    $[51] = isHeadersEditorEnabled;
    $[52] = t25;
  } else {
    t25 = $[52];
  }
  let t26;
  if ($[53] !== EditorToolsIcon) {
    t26 = /* @__PURE__ */ jsx(EditorToolsIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" });
    $[53] = EditorToolsIcon;
    $[54] = t26;
  } else {
    t26 = $[54];
  }
  let t27;
  if ($[55] !== editorToolsText || $[56] !== t26 || $[57] !== toggleEditorTools) {
    t27 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", onClick: toggleEditorTools, "aria-label": editorToolsText, className: "graphiql-toggle-editor-tools", children: t26 });
    $[55] = editorToolsText;
    $[56] = t26;
    $[57] = toggleEditorTools;
    $[58] = t27;
  } else {
    t27 = $[58];
  }
  let t28;
  if ($[59] !== editorToolsText || $[60] !== t27) {
    t28 = /* @__PURE__ */ jsx(Tooltip, { label: editorToolsText, children: t27 });
    $[59] = editorToolsText;
    $[60] = t27;
    $[61] = t28;
  } else {
    t28 = $[61];
  }
  let t29;
  if ($[62] !== editorToolsResize.dragBarRef || $[63] !== t24 || $[64] !== t25 || $[65] !== t28) {
    t29 = /* @__PURE__ */ jsxs("div", { ref: t21, className: "graphiql-editor-tools", children: [
      t24,
      t25,
      t28
    ] });
    $[62] = editorToolsResize.dragBarRef;
    $[63] = t24;
    $[64] = t25;
    $[65] = t28;
    $[66] = t29;
  } else {
    t29 = $[66];
  }
  const t30 = activeSecondaryEditor === "variables" ? "Variables" : "Headers";
  const t31 = activeSecondaryEditor === "variables" ? "" : "hidden";
  let t32;
  if ($[67] !== onEditVariables || $[68] !== t31) {
    t32 = /* @__PURE__ */ jsx(VariableEditor, { className: t31, onEdit: onEditVariables });
    $[67] = onEditVariables;
    $[68] = t31;
    $[69] = t32;
  } else {
    t32 = $[69];
  }
  let t33;
  if ($[70] !== activeSecondaryEditor || $[71] !== isHeadersEditorEnabled || $[72] !== onEditHeaders) {
    t33 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(HeaderEditor, { className: activeSecondaryEditor === "headers" ? "" : "hidden", onEdit: onEditHeaders });
    $[70] = activeSecondaryEditor;
    $[71] = isHeadersEditorEnabled;
    $[72] = onEditHeaders;
    $[73] = t33;
  } else {
    t33 = $[73];
  }
  let t34;
  if ($[74] !== editorToolsResize.secondRef || $[75] !== t30 || $[76] !== t32 || $[77] !== t33) {
    t34 = /* @__PURE__ */ jsxs("section", { className: "graphiql-editor-tool", "aria-label": t30, ref: editorToolsResize.secondRef, children: [
      t32,
      t33
    ] });
    $[74] = editorToolsResize.secondRef;
    $[75] = t30;
    $[76] = t32;
    $[77] = t33;
    $[78] = t34;
  } else {
    t34 = $[78];
  }
  let t35;
  if ($[79] !== editorResize.firstRef || $[80] !== t20 || $[81] !== t29 || $[82] !== t34) {
    t35 = /* @__PURE__ */ jsxs("div", { className: "graphiql-editors", ref: t16, children: [
      t20,
      t29,
      t34
    ] });
    $[79] = editorResize.firstRef;
    $[80] = t20;
    $[81] = t29;
    $[82] = t34;
    $[83] = t35;
  } else {
    t35 = $[83];
  }
  const editors = t35;
  const tabContainerRef = useRef(null);
  let t36;
  if ($[84] !== className) {
    t36 = cn("graphiql-container", className);
    $[84] = className;
    $[85] = t36;
  } else {
    t36 = $[85];
  }
  let t37;
  if ($[86] !== forcedTheme || $[87] !== pluginResize.setHiddenElement || $[88] !== showPersistHeadersSettings) {
    t37 = /* @__PURE__ */ jsx(Sidebar, { forcedTheme, showPersistHeadersSettings, setHiddenElement: pluginResize.setHiddenElement });
    $[86] = forcedTheme;
    $[87] = pluginResize.setHiddenElement;
    $[88] = showPersistHeadersSettings;
    $[89] = t37;
  } else {
    t37 = $[89];
  }
  let t38;
  if ($[90] === Symbol.for("react.memo_cache_sentinel")) {
    t38 = {
      minWidth: "200px"
    };
    $[90] = t38;
  } else {
    t38 = $[90];
  }
  let t39;
  if ($[91] !== PluginContent) {
    t39 = PluginContent && /* @__PURE__ */ jsx(PluginContent, {});
    $[91] = PluginContent;
    $[92] = t39;
  } else {
    t39 = $[92];
  }
  let t40;
  if ($[93] !== pluginResize.firstRef || $[94] !== t39) {
    t40 = /* @__PURE__ */ jsx("div", { ref: pluginResize.firstRef, className: "graphiql-plugin", style: t38, children: t39 });
    $[93] = pluginResize.firstRef;
    $[94] = t39;
    $[95] = t40;
  } else {
    t40 = $[95];
  }
  let t41;
  if ($[96] !== pluginResize.dragBarRef || $[97] !== visiblePlugin) {
    t41 = visiblePlugin && /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: pluginResize.dragBarRef });
    $[96] = pluginResize.dragBarRef;
    $[97] = visiblePlugin;
    $[98] = t41;
  } else {
    t41 = $[98];
  }
  const t42 = pluginResize.secondRef;
  let t43;
  if ($[99] !== activeTabIndex || $[100] !== handleTabClick || $[101] !== handleTabClose || $[102] !== tabs) {
    t43 = tabs.map((tab, index_1, arr) => /* @__PURE__ */ jsxs(Tab, { dragConstraints: tabContainerRef, value: tab, isActive: index_1 === activeTabIndex, children: [
      /* @__PURE__ */ jsx(Tab.Button, { "aria-controls": "graphiql-session", id: `graphiql-session-tab-${index_1}`, title: tab.title, onClick: handleTabClick, children: tab.title }),
      arr.length > 1 && /* @__PURE__ */ jsx(Tab.Close, { onClick: handleTabClose })
    ] }, tab.id));
    $[99] = activeTabIndex;
    $[100] = handleTabClick;
    $[101] = handleTabClose;
    $[102] = tabs;
    $[103] = t43;
  } else {
    t43 = $[103];
  }
  let t44;
  if ($[104] !== moveTab || $[105] !== t43 || $[106] !== tabs) {
    t44 = /* @__PURE__ */ jsx(Tabs, { ref: tabContainerRef, values: tabs, onReorder: moveTab, "aria-label": "Select active operation", className: "no-scrollbar", children: t43 });
    $[104] = moveTab;
    $[105] = t43;
    $[106] = tabs;
    $[107] = t44;
  } else {
    t44 = $[107];
  }
  let t45;
  if ($[108] === Symbol.for("react.memo_cache_sentinel")) {
    t45 = /* @__PURE__ */ jsx(PlusIcon, { "aria-hidden": "true" });
    $[108] = t45;
  } else {
    t45 = $[108];
  }
  let t46;
  if ($[109] !== addTab) {
    t46 = /* @__PURE__ */ jsx(Tooltip, { label: LABEL.newTab, children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-tab-add", onClick: addTab, "aria-label": LABEL.newTab, children: t45 }) });
    $[109] = addTab;
    $[110] = t46;
  } else {
    t46 = $[110];
  }
  let t47;
  if ($[111] !== logo || $[112] !== t44 || $[113] !== t46) {
    t47 = /* @__PURE__ */ jsxs("div", { className: "graphiql-session-header", children: [
      t44,
      t46,
      logo
    ] });
    $[111] = logo;
    $[112] = t44;
    $[113] = t46;
    $[114] = t47;
  } else {
    t47 = $[114];
  }
  const t48 = `${TAB_CLASS_PREFIX}${activeTabIndex}`;
  let t49;
  if ($[115] !== editorResize.dragBarRef) {
    t49 = /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: editorResize.dragBarRef });
    $[115] = editorResize.dragBarRef;
    $[116] = t49;
  } else {
    t49 = $[116];
  }
  let t50;
  if ($[117] !== isFetching) {
    t50 = isFetching && /* @__PURE__ */ jsx(Spinner, {});
    $[117] = isFetching;
    $[118] = t50;
  } else {
    t50 = $[118];
  }
  let t51;
  if ($[119] !== responseTooltip) {
    t51 = /* @__PURE__ */ jsx(ResponseEditor, { responseTooltip });
    $[119] = responseTooltip;
    $[120] = t51;
  } else {
    t51 = $[120];
  }
  let t52;
  if ($[121] !== editorResize.secondRef || $[122] !== footer || $[123] !== t50 || $[124] !== t51) {
    t52 = /* @__PURE__ */ jsxs("div", { className: "graphiql-response", ref: editorResize.secondRef, children: [
      t50,
      t51,
      footer
    ] });
    $[121] = editorResize.secondRef;
    $[122] = footer;
    $[123] = t50;
    $[124] = t51;
    $[125] = t52;
  } else {
    t52 = $[125];
  }
  let t53;
  if ($[126] !== editors || $[127] !== t48 || $[128] !== t49 || $[129] !== t52) {
    t53 = /* @__PURE__ */ jsxs("div", { role: "tabpanel", id: "graphiql-session", "aria-labelledby": t48, children: [
      editors,
      t49,
      t52
    ] });
    $[126] = editors;
    $[127] = t48;
    $[128] = t49;
    $[129] = t52;
    $[130] = t53;
  } else {
    t53 = $[130];
  }
  let t54;
  if ($[131] !== pluginResize.secondRef || $[132] !== t47 || $[133] !== t53) {
    t54 = /* @__PURE__ */ jsxs("div", { ref: t42, className: "graphiql-sessions", children: [
      t47,
      t53
    ] });
    $[131] = pluginResize.secondRef;
    $[132] = t47;
    $[133] = t53;
    $[134] = t54;
  } else {
    t54 = $[134];
  }
  let t55;
  if ($[135] !== t40 || $[136] !== t41 || $[137] !== t54) {
    t55 = /* @__PURE__ */ jsxs("div", { className: "graphiql-main", children: [
      t40,
      t41,
      t54
    ] });
    $[135] = t40;
    $[136] = t41;
    $[137] = t54;
    $[138] = t55;
  } else {
    t55 = $[138];
  }
  let t56;
  if ($[139] !== t36 || $[140] !== t37 || $[141] !== t55) {
    t56 = /* @__PURE__ */ jsxs("div", { className: t36, children: [
      t37,
      t55
    ] });
    $[139] = t36;
    $[140] = t37;
    $[141] = t55;
    $[142] = t56;
  } else {
    t56 = $[142];
  }
  let t57;
  if ($[143] !== children || $[144] !== t56) {
    t57 = /* @__PURE__ */ jsxs(Tooltip.Provider, { children: [
      t56,
      children
    ] });
    $[143] = children;
    $[144] = t56;
    $[145] = t57;
  } else {
    t57 = $[145];
  }
  return t57;
};
function getChildComponentType(child) {
  if (child && typeof child === "object" && "type" in child && typeof child.type === "function") {
    return child.type;
  }
}
const GraphiQL = Object.assign(GraphiQL_, {
  Logo: GraphiQLLogo,
  Toolbar: GraphiQLToolbar,
  Footer: GraphiQLFooter
});
function _temp(acc, curr) {
  bb62: switch (getChildComponentType(curr)) {
    case GraphiQL.Logo: {
      acc.logo = curr;
      break bb62;
    }
    case GraphiQL.Toolbar: {
      acc.toolbar = curr;
      break bb62;
    }
    case GraphiQL.Footer: {
      acc.footer = curr;
      break bb62;
    }
    default: {
      acc.children.push(curr);
    }
  }
  return acc;
}
export {
  GraphiQL
};
//# sourceMappingURL=GraphiQL.js.map
