import { jsxs, jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { Fragment } from "react";
import { KEY_MAP, formatShortcutForOS } from "@graphiql/react";
const SHORT_KEYS = Object.entries({
  "Execute query": formatShortcutForOS(KEY_MAP.runQuery.key),
  "Open the Command Palette (you must have focus in the editor)": "F1",
  "Prettify editors": KEY_MAP.prettify.key,
  "Copy query": KEY_MAP.copyQuery.key,
  "Re-fetch schema using introspection": KEY_MAP.refetchSchema.key,
  "Search in documentation": formatShortcutForOS(KEY_MAP.searchInDocs.key),
  "Search in editor": formatShortcutForOS(KEY_MAP.searchInEditor.key),
  "Merge fragments definitions into operation definition": KEY_MAP.mergeFragments.key
});
const ShortKeys = () => {
  const $ = c(5);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = /* @__PURE__ */ jsxs("table", { className: "graphiql-table", children: [
      /* @__PURE__ */ jsx("thead", { children: /* @__PURE__ */ jsxs("tr", { children: [
        /* @__PURE__ */ jsx("th", { children: "Short Key" }),
        /* @__PURE__ */ jsx("th", { children: "Function" })
      ] }) }),
      /* @__PURE__ */ jsx("tbody", { children: SHORT_KEYS.map(_temp2) })
    ] });
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = /* @__PURE__ */ jsx("em", { children: "i" });
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = /* @__PURE__ */ jsx("a", { href: "https://code.visualstudio.com/docs/reference/default-keybindings", target: "_blank", rel: "noreferrer", children: "Monaco editor shortcuts" });
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  let t3;
  if ($[3] === Symbol.for("react.memo_cache_sentinel")) {
    t3 = /* @__PURE__ */ jsx("a", { href: "https://code.visualstudio.com/shortcuts/keyboard-shortcuts-macos.pdf", target: "_blank", rel: "noreferrer", children: "macOS" });
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  let t4;
  if ($[4] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = /* @__PURE__ */ jsxs("div", { children: [
      t0,
      /* @__PURE__ */ jsxs("p", { children: [
        "This Graph",
        t1,
        "QL editor uses",
        " ",
        t2,
        ", with keybindings similar to VS Code. See the full list of shortcuts for",
        " ",
        t3,
        " ",
        "or",
        " ",
        /* @__PURE__ */ jsx("a", { href: "https://code.visualstudio.com/shortcuts/keyboard-shortcuts-windows.pdf", target: "_blank", rel: "noreferrer", children: "Windows" }),
        "."
      ] })
    ] });
    $[4] = t4;
  } else {
    t4 = $[4];
  }
  return t4;
};
function _temp(key, index, array) {
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("code", { className: "graphiql-key", children: key }),
    index !== array.length - 1 && " + "
  ] }, key);
}
function _temp2(t0) {
  const [title, keys] = t0;
  return /* @__PURE__ */ jsxs("tr", { children: [
    /* @__PURE__ */ jsx("td", { children: keys.split("-").map(_temp) }),
    /* @__PURE__ */ jsx("td", { children: title })
  ] }, title);
}
export {
  ShortKeys
};
//# sourceMappingURL=short-keys.js.map
