import { FC } from 'react';
import { useDragResize } from '@graphiql/react';
declare const THEMES: readonly ["light", "dark", "system"];
interface SidebarProps {
    /**
     * `forcedTheme` allows enforcement of a specific theme for GraphiQL.
     * This is useful when you want to make sure that GraphiQL is always
     * rendered with a specific theme.
     */
    forcedTheme?: (typeof THEMES)[number];
    /**
     * Indicates if settings for persisting headers should appear in the
     * settings modal.
     */
    showPersistHeadersSettings?: boolean;
    setHiddenElement: ReturnType<typeof useDragResize>['setHiddenElement'];
}
export declare const Sidebar: FC<SidebarProps>;
export {};
