import { jsx, jsxs } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useEffect, useState } from "react";
import { useStorage, useTheme, useGraphiQLActions, pick, useGraphiQL, cn, Dialog, VisuallyHidden, ButtonGroup, Button, KEY_MAP, Tooltip, UnStyledButton, ReloadIcon, KeyboardShortcutIcon, SettingsIcon } from "@graphiql/react";
import { ShortKeys } from "./short-keys.js";
const LABEL = {
  refetchSchema: `Re-fetch GraphQL schema (${KEY_MAP.refetchSchema.key})`,
  shortCutDialog: "Open short keys dialog",
  settingsDialogs: "Open settings dialog"
};
const THEMES = ["light", "dark", "system"];
const Sidebar = (t0) => {
  const $ = c(70);
  const {
    forcedTheme: $forcedTheme,
    showPersistHeadersSettings,
    setHiddenElement
  } = t0;
  const forcedTheme = $forcedTheme && THEMES.includes($forcedTheme) ? $forcedTheme : void 0;
  const storage = useStorage();
  const {
    theme,
    setTheme
  } = useTheme();
  const {
    setShouldPersistHeaders,
    introspect,
    setVisiblePlugin
  } = useGraphiQLActions();
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = pick("shouldPersistHeaders", "isIntrospecting", "visiblePlugin", "plugins");
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const {
    shouldPersistHeaders,
    isIntrospecting,
    visiblePlugin,
    plugins
  } = useGraphiQL(t1);
  let t2;
  let t3;
  if ($[1] !== forcedTheme || $[2] !== setTheme) {
    t2 = () => {
      if (forcedTheme === "system") {
        setTheme(null);
      } else {
        if (forcedTheme === "light" || forcedTheme === "dark") {
          setTheme(forcedTheme);
        }
      }
    };
    t3 = [forcedTheme, setTheme];
    $[1] = forcedTheme;
    $[2] = setTheme;
    $[3] = t2;
    $[4] = t3;
  } else {
    t2 = $[3];
    t3 = $[4];
  }
  useEffect(t2, t3);
  const [showDialog, setShowDialog] = useState(null);
  const [clearStorageStatus, setClearStorageStatus] = useState();
  let t4;
  if ($[5] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = function handleOpenShortKeysDialog2(isOpen) {
      if (!isOpen) {
        setShowDialog(null);
      }
    };
    $[5] = t4;
  } else {
    t4 = $[5];
  }
  const handleOpenShortKeysDialog = t4;
  let t5;
  if ($[6] === Symbol.for("react.memo_cache_sentinel")) {
    t5 = function handleOpenSettingsDialog2(isOpen_0) {
      if (!isOpen_0) {
        setShowDialog(null);
        setClearStorageStatus(void 0);
      }
    };
    $[6] = t5;
  } else {
    t5 = $[6];
  }
  const handleOpenSettingsDialog = t5;
  let t6;
  if ($[7] !== storage) {
    t6 = function handleClearData2() {
      try {
        storage.clear();
        setClearStorageStatus("success");
      } catch {
        setClearStorageStatus("error");
      }
    };
    $[7] = storage;
    $[8] = t6;
  } else {
    t6 = $[8];
  }
  const handleClearData = t6;
  let t7;
  if ($[9] !== setShouldPersistHeaders) {
    t7 = (event) => {
      setShouldPersistHeaders(event.currentTarget.dataset.value === "true");
    };
    $[9] = setShouldPersistHeaders;
    $[10] = t7;
  } else {
    t7 = $[10];
  }
  const handlePersistHeaders = t7;
  let t8;
  if ($[11] !== setTheme) {
    t8 = (event_0) => {
      const selectedTheme = event_0.currentTarget.dataset.theme;
      setTheme(selectedTheme || null);
    };
    $[11] = setTheme;
    $[12] = t8;
  } else {
    t8 = $[12];
  }
  const handleChangeTheme = t8;
  let t9;
  if ($[13] === Symbol.for("react.memo_cache_sentinel")) {
    t9 = (event_1) => {
      setShowDialog(event_1.currentTarget.dataset.value);
    };
    $[13] = t9;
  } else {
    t9 = $[13];
  }
  const handleShowDialog = t9;
  let t10;
  if ($[14] !== plugins || $[15] !== setHiddenElement || $[16] !== setVisiblePlugin || $[17] !== visiblePlugin) {
    t10 = (event_2) => {
      const pluginIndex = Number(event_2.currentTarget.dataset.index);
      const plugin = plugins.find((_, index) => pluginIndex === index);
      const isVisible = plugin === visiblePlugin;
      if (isVisible) {
        setVisiblePlugin(null);
        setHiddenElement("first");
      } else {
        setVisiblePlugin(plugin);
        setHiddenElement(null);
      }
    };
    $[14] = plugins;
    $[15] = setHiddenElement;
    $[16] = setVisiblePlugin;
    $[17] = visiblePlugin;
    $[18] = t10;
  } else {
    t10 = $[18];
  }
  const handlePluginClick = t10;
  let t11;
  if ($[19] !== handlePluginClick || $[20] !== plugins || $[21] !== visiblePlugin) {
    let t122;
    if ($[23] !== handlePluginClick || $[24] !== visiblePlugin) {
      t122 = (plugin_0, index_0) => {
        const isVisible_0 = plugin_0 === visiblePlugin;
        const label = `${isVisible_0 ? "Hide" : "Show"} ${plugin_0.title}`;
        return /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: cn(isVisible_0 && "active"), onClick: handlePluginClick, "data-index": index_0, "aria-label": label, children: /* @__PURE__ */ jsx(plugin_0.icon, { "aria-hidden": "true" }) }) }, plugin_0.title);
      };
      $[23] = handlePluginClick;
      $[24] = visiblePlugin;
      $[25] = t122;
    } else {
      t122 = $[25];
    }
    t11 = plugins.map(t122);
    $[19] = handlePluginClick;
    $[20] = plugins;
    $[21] = visiblePlugin;
    $[22] = t11;
  } else {
    t11 = $[22];
  }
  let t12;
  if ($[26] === Symbol.for("react.memo_cache_sentinel")) {
    t12 = {
      marginTop: "auto"
    };
    $[26] = t12;
  } else {
    t12 = $[26];
  }
  const t13 = isIntrospecting && "graphiql-spin";
  let t14;
  if ($[27] !== t13) {
    t14 = cn(t13);
    $[27] = t13;
    $[28] = t14;
  } else {
    t14 = $[28];
  }
  let t15;
  if ($[29] !== t14) {
    t15 = /* @__PURE__ */ jsx(ReloadIcon, { className: t14, "aria-hidden": "true" });
    $[29] = t14;
    $[30] = t15;
  } else {
    t15 = $[30];
  }
  let t16;
  if ($[31] !== introspect || $[32] !== isIntrospecting || $[33] !== t15) {
    t16 = /* @__PURE__ */ jsx(Tooltip, { label: LABEL.refetchSchema, children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", disabled: isIntrospecting, onClick: introspect, "aria-label": LABEL.refetchSchema, style: t12, children: t15 }) });
    $[31] = introspect;
    $[32] = isIntrospecting;
    $[33] = t15;
    $[34] = t16;
  } else {
    t16 = $[34];
  }
  let t17;
  if ($[35] === Symbol.for("react.memo_cache_sentinel")) {
    t17 = /* @__PURE__ */ jsx(Tooltip, { label: LABEL.shortCutDialog, children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "short-keys", onClick: handleShowDialog, "aria-label": LABEL.shortCutDialog, children: /* @__PURE__ */ jsx(KeyboardShortcutIcon, { "aria-hidden": "true" }) }) });
    $[35] = t17;
  } else {
    t17 = $[35];
  }
  let t18;
  if ($[36] === Symbol.for("react.memo_cache_sentinel")) {
    t18 = /* @__PURE__ */ jsx(Tooltip, { label: LABEL.settingsDialogs, children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "settings", onClick: handleShowDialog, "aria-label": LABEL.settingsDialogs, children: /* @__PURE__ */ jsx(SettingsIcon, { "aria-hidden": "true" }) }) });
    $[36] = t18;
  } else {
    t18 = $[36];
  }
  const t19 = showDialog === "short-keys";
  let t20;
  if ($[37] === Symbol.for("react.memo_cache_sentinel")) {
    t20 = /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Short Keys" });
    $[37] = t20;
  } else {
    t20 = $[37];
  }
  let t21;
  if ($[38] === Symbol.for("react.memo_cache_sentinel")) {
    t21 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      t20,
      /* @__PURE__ */ jsx(VisuallyHidden, { children: /* @__PURE__ */ jsx(Dialog.Description, { children: "This modal provides a list of available keyboard shortcuts and their functions." }) }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[38] = t21;
  } else {
    t21 = $[38];
  }
  let t22;
  if ($[39] === Symbol.for("react.memo_cache_sentinel")) {
    t22 = /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section", children: /* @__PURE__ */ jsx(ShortKeys, {}) });
    $[39] = t22;
  } else {
    t22 = $[39];
  }
  let t23;
  if ($[40] !== t19) {
    t23 = /* @__PURE__ */ jsxs(Dialog, { open: t19, onOpenChange: handleOpenShortKeysDialog, children: [
      t21,
      t22
    ] });
    $[40] = t19;
    $[41] = t23;
  } else {
    t23 = $[41];
  }
  const t24 = showDialog === "settings";
  let t25;
  if ($[42] === Symbol.for("react.memo_cache_sentinel")) {
    t25 = /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Settings" });
    $[42] = t25;
  } else {
    t25 = $[42];
  }
  let t26;
  if ($[43] === Symbol.for("react.memo_cache_sentinel")) {
    t26 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      t25,
      /* @__PURE__ */ jsx(VisuallyHidden, { children: /* @__PURE__ */ jsx(Dialog.Description, { children: "This modal lets you adjust header persistence, interface theme, and clear local storage." }) }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[43] = t26;
  } else {
    t26 = $[43];
  }
  let t27;
  if ($[44] !== handlePersistHeaders || $[45] !== shouldPersistHeaders || $[46] !== showPersistHeadersSettings) {
    t27 = showPersistHeadersSettings ? /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Persist headers" }),
        /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section-caption", children: [
          "Save headers upon reloading.",
          " ",
          /* @__PURE__ */ jsx("span", { className: "graphiql-warning-text", children: "Only enable if you trust this device." })
        ] })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", id: "enable-persist-headers", className: cn(shouldPersistHeaders && "active"), "data-value": "true", onClick: handlePersistHeaders, children: "On" }),
        /* @__PURE__ */ jsx(Button, { type: "button", id: "disable-persist-headers", className: cn(!shouldPersistHeaders && "active"), onClick: handlePersistHeaders, children: "Off" })
      ] })
    ] }) : null;
    $[44] = handlePersistHeaders;
    $[45] = shouldPersistHeaders;
    $[46] = showPersistHeadersSettings;
    $[47] = t27;
  } else {
    t27 = $[47];
  }
  let t28;
  if ($[48] !== forcedTheme || $[49] !== handleChangeTheme || $[50] !== theme) {
    t28 = !forcedTheme && /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Theme" }),
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Adjust how the interface appears." })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === null && "active"), onClick: handleChangeTheme, children: "System" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === "light" && "active"), "data-theme": "light", onClick: handleChangeTheme, children: "Light" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === "dark" && "active"), "data-theme": "dark", onClick: handleChangeTheme, children: "Dark" })
      ] })
    ] });
    $[48] = forcedTheme;
    $[49] = handleChangeTheme;
    $[50] = theme;
    $[51] = t28;
  } else {
    t28 = $[51];
  }
  let t29;
  if ($[52] === Symbol.for("react.memo_cache_sentinel")) {
    t29 = /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Clear storage" }),
      /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Remove all locally stored data and start fresh." })
    ] });
    $[52] = t29;
  } else {
    t29 = $[52];
  }
  const t30 = clearStorageStatus === "success";
  let t31;
  if ($[53] !== clearStorageStatus) {
    t31 = {
      success: "Cleared data",
      error: "Failed"
    }[clearStorageStatus] || "Clear data";
    $[53] = clearStorageStatus;
    $[54] = t31;
  } else {
    t31 = $[54];
  }
  let t32;
  if ($[55] !== clearStorageStatus || $[56] !== handleClearData || $[57] !== t30 || $[58] !== t31) {
    t32 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      t29,
      /* @__PURE__ */ jsx(Button, { type: "button", state: clearStorageStatus, disabled: t30, onClick: handleClearData, children: t31 })
    ] });
    $[55] = clearStorageStatus;
    $[56] = handleClearData;
    $[57] = t30;
    $[58] = t31;
    $[59] = t32;
  } else {
    t32 = $[59];
  }
  let t33;
  if ($[60] !== t24 || $[61] !== t27 || $[62] !== t28 || $[63] !== t32) {
    t33 = /* @__PURE__ */ jsxs(Dialog, { open: t24, onOpenChange: handleOpenSettingsDialog, children: [
      t26,
      t27,
      t28,
      t32
    ] });
    $[60] = t24;
    $[61] = t27;
    $[62] = t28;
    $[63] = t32;
    $[64] = t33;
  } else {
    t33 = $[64];
  }
  let t34;
  if ($[65] !== t11 || $[66] !== t16 || $[67] !== t23 || $[68] !== t33) {
    t34 = /* @__PURE__ */ jsxs("div", { className: "graphiql-sidebar", children: [
      t11,
      t16,
      t17,
      t18,
      t23,
      t33
    ] });
    $[65] = t11;
    $[66] = t16;
    $[67] = t23;
    $[68] = t33;
    $[69] = t34;
  } else {
    t34 = $[69];
  }
  return t34;
};
export {
  Sidebar
};
//# sourceMappingURL=sidebar.js.map
