import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useGraphiQLActions, ToolbarButton, KEY_MAP, PrettifyIcon, MergeIcon, CopyIcon } from "@graphiql/react";
const DefaultToolbarRenderProps = (t0) => {
  const $ = c(4);
  const {
    prettify,
    copy,
    merge
  } = t0;
  let t1;
  if ($[0] !== copy || $[1] !== merge || $[2] !== prettify) {
    t1 = /* @__PURE__ */ jsxs(Fragment, { children: [
      prettify,
      merge,
      copy
    ] });
    $[0] = copy;
    $[1] = merge;
    $[2] = prettify;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  return t1;
};
const GraphiQLToolbar = (t0) => {
  const $ = c(14);
  const {
    children: t1
  } = t0;
  const children = t1 === void 0 ? DefaultToolbarRenderProps : t1;
  const isRenderProp = typeof children === "function";
  const {
    copyQuery,
    prettifyEditors,
    mergeQuery
  } = useGraphiQLActions();
  if (!isRenderProp) {
    return children;
  }
  let t2;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = /* @__PURE__ */ jsx(PrettifyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" });
    $[0] = t2;
  } else {
    t2 = $[0];
  }
  let t3;
  if ($[1] !== prettifyEditors) {
    t3 = /* @__PURE__ */ jsx(ToolbarButton, { onClick: prettifyEditors, label: `Prettify query (${KEY_MAP.prettify.key})`, children: t2 });
    $[1] = prettifyEditors;
    $[2] = t3;
  } else {
    t3 = $[2];
  }
  const prettify = t3;
  let t4;
  if ($[3] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = /* @__PURE__ */ jsx(MergeIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" });
    $[3] = t4;
  } else {
    t4 = $[3];
  }
  let t5;
  if ($[4] !== mergeQuery) {
    t5 = /* @__PURE__ */ jsx(ToolbarButton, { onClick: mergeQuery, label: `Merge fragments into query (${KEY_MAP.mergeFragments.key})`, children: t4 });
    $[4] = mergeQuery;
    $[5] = t5;
  } else {
    t5 = $[5];
  }
  const merge = t5;
  let t6;
  if ($[6] === Symbol.for("react.memo_cache_sentinel")) {
    t6 = /* @__PURE__ */ jsx(CopyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" });
    $[6] = t6;
  } else {
    t6 = $[6];
  }
  let t7;
  if ($[7] !== copyQuery) {
    t7 = /* @__PURE__ */ jsx(ToolbarButton, { onClick: copyQuery, label: `Copy query (${KEY_MAP.copyQuery.key})`, children: t6 });
    $[7] = copyQuery;
    $[8] = t7;
  } else {
    t7 = $[8];
  }
  const copy = t7;
  let t8;
  if ($[9] !== children || $[10] !== copy || $[11] !== merge || $[12] !== prettify) {
    t8 = children({
      prettify,
      copy,
      merge
    });
    $[9] = children;
    $[10] = copy;
    $[11] = merge;
    $[12] = prettify;
    $[13] = t8;
  } else {
    t8 = $[13];
  }
  return t8;
};
export {
  GraphiQLToolbar
};
//# sourceMappingURL=toolbar.js.map
