"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createGraphiQLFetcher = void 0;
var lib_1 = require("./lib");
function createGraphiQLFetcher(options) {
    var httpFetch;
    var wsFetcher = null;
    if (typeof window !== null && (window === null || window === void 0 ? void 0 : window.fetch)) {
        httpFetch = window.fetch;
    }
    if ((options === null || options === void 0 ? void 0 : options.enableIncrementalDelivery) === null ||
        options.enableIncrementalDelivery !== false) {
        options.enableIncrementalDelivery = true;
    }
    if (options.fetch) {
        httpFetch = options.fetch;
    }
    if (!httpFetch) {
        throw Error('No valid fetcher implementation available');
    }
    var simpleFetcher = lib_1.createSimpleFetcher(options, httpFetch);
    if (options.subscriptionUrl) {
        wsFetcher = lib_1.createWebsocketsFetcherFromUrl(options.subscriptionUrl);
    }
    if (options.wsClient) {
        wsFetcher = lib_1.createWebsocketsFetcherFromClient(options.wsClient);
    }
    var httpFetcher = options.enableIncrementalDelivery
        ? lib_1.createMultipartFetcher(options, httpFetch)
        : simpleFetcher;
    return function (graphQLParams, fetcherOpts) {
        if (graphQLParams.operationName === 'IntrospectionQuery') {
            return (options.schemaFetcher || simpleFetcher)(graphQLParams, fetcherOpts);
        }
        var isSubscription = lib_1.isSubscriptionWithName(fetcherOpts === null || fetcherOpts === void 0 ? void 0 : fetcherOpts.documentAST, graphQLParams.operationName);
        if (isSubscription) {
            if (!wsFetcher) {
                throw Error("Your GraphiQL createFetcher is not properly configured for websocket subscriptions yet. " + (options.subscriptionUrl
                    ? "Provided URL " + options.subscriptionUrl + " failed"
                    : "Try providing options.subscriptionUrl or options.wsClient first."));
            }
            return wsFetcher(graphQLParams);
        }
        return httpFetcher(graphQLParams, fetcherOpts);
    };
}
exports.createGraphiQLFetcher = createGraphiQLFetcher;
//# sourceMappingURL=createFetcher.js.map