import { createMultipartFetcher, createSimpleFetcher, isSubscriptionWithName, createWebsocketsFetcherFromUrl, createWebsocketsFetcherFromClient, } from './lib';
export function createGraphiQLFetcher(options) {
    let httpFetch;
    let wsFetcher = null;
    if (typeof window !== null && window?.fetch) {
        httpFetch = window.fetch;
    }
    if (options?.enableIncrementalDelivery === null ||
        options.enableIncrementalDelivery !== false) {
        options.enableIncrementalDelivery = true;
    }
    if (options.fetch) {
        httpFetch = options.fetch;
    }
    if (!httpFetch) {
        throw Error('No valid fetcher implementation available');
    }
    const simpleFetcher = createSimpleFetcher(options, httpFetch);
    if (options.subscriptionUrl) {
        wsFetcher = createWebsocketsFetcherFromUrl(options.subscriptionUrl);
    }
    if (options.wsClient) {
        wsFetcher = createWebsocketsFetcherFromClient(options.wsClient);
    }
    const httpFetcher = options.enableIncrementalDelivery
        ? createMultipartFetcher(options, httpFetch)
        : simpleFetcher;
    return (graphQLParams, fetcherOpts) => {
        if (graphQLParams.operationName === 'IntrospectionQuery') {
            return (options.schemaFetcher || simpleFetcher)(graphQLParams, fetcherOpts);
        }
        const isSubscription = isSubscriptionWithName(fetcherOpts?.documentAST, graphQLParams.operationName);
        if (isSubscription) {
            if (!wsFetcher) {
                throw Error(`Your GraphiQL createFetcher is not properly configured for websocket subscriptions yet. ${options.subscriptionUrl
                    ? `Provided URL ${options.subscriptionUrl} failed`
                    : `Try providing options.subscriptionUrl or options.wsClient first.`}`);
            }
            return wsFetcher(graphQLParams);
        }
        return httpFetcher(graphQLParams, fetcherOpts);
    };
}
//# sourceMappingURL=createFetcher.js.map