import { DocumentNode } from 'graphql';
import { Client, ClientOptions } from 'graphql-ws';
import { SubscriptionClient } from 'subscriptions-transport-ws';
import type { Fetcher, FetcherResult, FetcherParams } from '@graphiql/toolkit';
import type { CreateFetcherOptions } from './types';
export declare const isSubscriptionWithName: (document: DocumentNode, name: string) => boolean;
export declare const createSimpleFetcher: (options: CreateFetcherOptions, httpFetch: typeof fetch) => Fetcher;
export declare const createWebsocketsFetcherFromUrl: (url: string, connectionParams?: ClientOptions['connectionParams']) => ((graphQLParams: FetcherParams) => AsyncIterableIterator<FetcherResult>) | undefined;
export declare const createWebsocketsFetcherFromClient: (wsClient: Client) => (graphQLParams: FetcherParams) => AsyncIterableIterator<FetcherResult>;
export declare const createLegacyWebsocketsFetcher: (legacyWsClient: SubscriptionClient) => (graphQLParams: FetcherParams) => AsyncIterableIterator<FetcherResult>;
export declare const createMultipartFetcher: (options: CreateFetcherOptions, httpFetch: typeof fetch) => Fetcher;
//# sourceMappingURL=lib.d.ts.map