import { jsxs, jsx, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { isObjectType, isInterfaceType, isInputObjectType } from "graphql";
import { useRef, useState, useEffect } from "react";
import { ComboboxOptions, ComboboxOption, ComboboxInput, Combobox } from "@headlessui/react";
import { debounce, useSchemaContext, MagnifyingGlassIcon, isMacOs } from "@graphiql/react";
import { useExplorerContext } from "../context.js";
/* empty css           */
import { renderType } from "./utils.js";
const Search = () => {
  const $ = c(33);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: Search
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    explorerNavStack,
    push
  } = useExplorerContext(t0);
  const inputRef = useRef(null);
  const getSearchResults = useSearchResults();
  const [searchValue, setSearchValue] = useState("");
  let t1;
  if ($[1] !== getSearchResults || $[2] !== searchValue) {
    t1 = () => getSearchResults(searchValue);
    $[1] = getSearchResults;
    $[2] = searchValue;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  const [results, setResults] = useState(t1);
  let t2;
  if ($[4] !== getSearchResults) {
    t2 = debounce(200, (search) => {
      setResults(getSearchResults(search));
    });
    $[4] = getSearchResults;
    $[5] = t2;
  } else {
    t2 = $[5];
  }
  const debouncedGetSearchResults = t2;
  const [ref] = useState(inputRef);
  const isFocused = ref.current === document.activeElement;
  let t3;
  let t4;
  if ($[6] !== debouncedGetSearchResults || $[7] !== searchValue) {
    t3 = () => {
      debouncedGetSearchResults(searchValue);
    };
    t4 = [debouncedGetSearchResults, searchValue];
    $[6] = debouncedGetSearchResults;
    $[7] = searchValue;
    $[8] = t3;
    $[9] = t4;
  } else {
    t3 = $[8];
    t4 = $[9];
  }
  useEffect(t3, t4);
  let t5;
  let t6;
  if ($[10] === Symbol.for("react.memo_cache_sentinel")) {
    t5 = () => {
      const handleKeyDown = function handleKeyDown2(event) {
        if (event.metaKey && event.key === "k") {
          inputRef.current.focus();
        }
      };
      window.addEventListener("keydown", handleKeyDown);
      return () => window.removeEventListener("keydown", handleKeyDown);
    };
    t6 = [];
    $[10] = t5;
    $[11] = t6;
  } else {
    t5 = $[10];
    t6 = $[11];
  }
  useEffect(t5, t6);
  let navItem;
  let onSelect;
  let t7;
  if ($[12] !== explorerNavStack || $[13] !== push) {
    navItem = explorerNavStack.at(-1);
    let t82;
    if ($[17] !== push) {
      t82 = (def) => {
        push("field" in def ? {
          name: def.field.name,
          def: def.field
        } : {
          name: def.type.name,
          def: def.type
        });
      };
      $[17] = push;
      $[18] = t82;
    } else {
      t82 = $[18];
    }
    onSelect = t82;
    t7 = explorerNavStack.length === 1 || isObjectType(navItem.def) || isInterfaceType(navItem.def) || isInputObjectType(navItem.def);
    $[12] = explorerNavStack;
    $[13] = push;
    $[14] = navItem;
    $[15] = onSelect;
    $[16] = t7;
  } else {
    navItem = $[14];
    onSelect = $[15];
    t7 = $[16];
  }
  const shouldSearchBoxAppear = t7;
  if (!shouldSearchBoxAppear) {
    return null;
  }
  const t8 = isFocused ? void 0 : "idle";
  const t9 = `Search ${navItem.name}...`;
  let t10;
  let t11;
  if ($[19] === Symbol.for("react.memo_cache_sentinel")) {
    t10 = () => {
      inputRef.current.focus();
    };
    t11 = /* @__PURE__ */ jsx(MagnifyingGlassIcon, {});
    $[19] = t10;
    $[20] = t11;
  } else {
    t10 = $[19];
    t11 = $[20];
  }
  let t12;
  if ($[21] === Symbol.for("react.memo_cache_sentinel")) {
    t12 = (event_0) => setSearchValue(event_0.target.value);
    $[21] = t12;
  } else {
    t12 = $[21];
  }
  let t13;
  if ($[22] !== searchValue) {
    t13 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-search-input", onClick: t10, children: [
      t11,
      /* @__PURE__ */ jsx(ComboboxInput, { autoComplete: "off", onChange: t12, placeholder: `${isMacOs ? "⌘" : "Ctrl"} K`, ref: inputRef, value: searchValue, "data-cy": "doc-explorer-input" })
    ] });
    $[22] = searchValue;
    $[23] = t13;
  } else {
    t13 = $[23];
  }
  let t14;
  if ($[24] !== isFocused || $[25] !== results) {
    t14 = isFocused && /* @__PURE__ */ jsxs(ComboboxOptions, { "data-cy": "doc-explorer-list", children: [
      results.within.length + results.types.length + results.fields.length === 0 ? /* @__PURE__ */ jsx("li", { className: "graphiql-doc-explorer-search-empty", children: "No results found" }) : results.within.map(_temp),
      results.within.length > 0 && results.types.length + results.fields.length > 0 ? /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-search-divider", children: "Other results" }) : null,
      results.types.map(_temp2),
      results.fields.map(_temp3)
    ] });
    $[24] = isFocused;
    $[25] = results;
    $[26] = t14;
  } else {
    t14 = $[26];
  }
  let t15;
  if ($[27] !== onSelect || $[28] !== t13 || $[29] !== t14 || $[30] !== t8 || $[31] !== t9) {
    t15 = /* @__PURE__ */ jsxs(Combobox, { as: "div", className: "graphiql-doc-explorer-search", onChange: onSelect, "data-state": t8, "aria-label": t9, children: [
      t13,
      t14
    ] });
    $[27] = onSelect;
    $[28] = t13;
    $[29] = t14;
    $[30] = t8;
    $[31] = t9;
    $[32] = t15;
  } else {
    t15 = $[32];
  }
  return t15;
};
const _useSearchResults = useSearchResults;
function useSearchResults(caller) {
  const $ = c(9);
  const t0 = caller || _useSearchResults;
  let t1;
  if ($[0] !== t0) {
    t1 = {
      nonNull: true,
      caller: t0
    };
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    explorerNavStack
  } = useExplorerContext(t1);
  const t2 = caller || _useSearchResults;
  let t3;
  if ($[2] !== t2) {
    t3 = {
      nonNull: true,
      caller: t2
    };
    $[2] = t2;
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const {
    schema
  } = useSchemaContext(t3);
  let t4;
  if ($[4] !== explorerNavStack) {
    t4 = explorerNavStack.at(-1);
    $[4] = explorerNavStack;
    $[5] = t4;
  } else {
    t4 = $[5];
  }
  const navItem = t4;
  let t5;
  if ($[6] !== navItem || $[7] !== schema) {
    t5 = (searchValue) => {
      const matches = {
        within: [],
        types: [],
        fields: []
      };
      if (!schema) {
        return matches;
      }
      const withinType = navItem.def;
      const typeMap = schema.getTypeMap();
      let typeNames = Object.keys(typeMap);
      if (withinType) {
        typeNames = typeNames.filter((n) => n !== withinType.name);
        typeNames.unshift(withinType.name);
      }
      for (const typeName of typeNames) {
        if (matches.within.length + matches.types.length + matches.fields.length >= 100) {
          break;
        }
        const type = typeMap[typeName];
        if (withinType !== type && isMatch(typeName, searchValue)) {
          matches.types.push({
            type
          });
        }
        if (!isObjectType(type) && !isInterfaceType(type) && !isInputObjectType(type)) {
          continue;
        }
        const fields = type.getFields();
        for (const fieldName in fields) {
          const field = fields[fieldName];
          let matchingArgs;
          if (!isMatch(fieldName, searchValue)) {
            if ("args" in field) {
              matchingArgs = field.args.filter((arg) => isMatch(arg.name, searchValue));
              if (matchingArgs.length === 0) {
                continue;
              }
            } else {
              continue;
            }
          }
          matches[withinType === type ? "within" : "fields"].push(...matchingArgs ? matchingArgs.map((argument) => ({
            type,
            field,
            argument
          })) : [{
            type,
            field
          }]);
        }
      }
      return matches;
    };
    $[6] = navItem;
    $[7] = schema;
    $[8] = t5;
  } else {
    t5 = $[8];
  }
  return t5;
}
function isMatch(sourceText, searchValue) {
  try {
    const escaped = searchValue.replaceAll(/[^_0-9A-Za-z]/g, (ch) => "\\" + ch);
    return new RegExp(escaped, "i").test(sourceText);
  } catch {
    return sourceText.toLowerCase().includes(searchValue.toLowerCase());
  }
}
function Type(props) {
  const $ = c(2);
  let t0;
  if ($[0] !== props.type.name) {
    t0 = /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-type", children: props.type.name });
    $[0] = props.type.name;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
}
function Field(t0) {
  const $ = c(7);
  const {
    field,
    argument
  } = t0;
  let t1;
  if ($[0] !== field.name) {
    t1 = /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-field", children: field.name });
    $[0] = field.name;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] !== argument) {
    t2 = argument ? /* @__PURE__ */ jsxs(Fragment, { children: [
      "(",
      /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-argument", children: argument.name }),
      ":",
      " ",
      renderType(argument.type, _temp4),
      ")"
    ] }) : null;
    $[2] = argument;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  let t3;
  if ($[4] !== t1 || $[5] !== t2) {
    t3 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t1,
      t2
    ] });
    $[4] = t1;
    $[5] = t2;
    $[6] = t3;
  } else {
    t3 = $[6];
  }
  return t3;
}
function _temp4(namedType) {
  return /* @__PURE__ */ jsx(Type, { type: namedType });
}
function _temp(result, i) {
  return /* @__PURE__ */ jsx(ComboboxOption, { value: result, "data-cy": "doc-explorer-option", children: /* @__PURE__ */ jsx(Field, { field: result.field, argument: result.argument }) }, `within-${i}`);
}
function _temp2(result_0, i_0) {
  return /* @__PURE__ */ jsx(ComboboxOption, { value: result_0, "data-cy": "doc-explorer-option", children: /* @__PURE__ */ jsx(Type, { type: result_0.type }) }, `type-${i_0}`);
}
function _temp3(result_1, i_1) {
  return /* @__PURE__ */ jsxs(ComboboxOption, { value: result_1, "data-cy": "doc-explorer-option", children: [
    /* @__PURE__ */ jsx(Type, { type: result_1.type }),
    ".",
    /* @__PURE__ */ jsx(Field, { field: result_1.field, argument: result_1.argument })
  ] }, `field-${i_1}`);
}
export {
  Search,
  useSearchResults
};
//# sourceMappingURL=search.js.map
