import { jsxs, jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { TypeIcon, RootTypeIcon, ImplementsIcon, FieldIcon, EnumValueIcon, DirectiveIcon, DeprecatedFieldIcon, DeprecatedEnumValueIcon, DeprecatedArgumentIcon, ArgumentIcon } from "@graphiql/react";
/* empty css            */
function ExplorerSection(props) {
  const $ = c(10);
  const Icon = TYPE_TO_ICON[props.title];
  let t0;
  if ($[0] !== Icon) {
    t0 = /* @__PURE__ */ jsx(Icon, {});
    $[0] = Icon;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== props.title || $[3] !== t0) {
    t1 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-section-title", children: [
      t0,
      props.title
    ] });
    $[2] = props.title;
    $[3] = t0;
    $[4] = t1;
  } else {
    t1 = $[4];
  }
  let t2;
  if ($[5] !== props.children) {
    t2 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-section-content", children: props.children });
    $[5] = props.children;
    $[6] = t2;
  } else {
    t2 = $[6];
  }
  let t3;
  if ($[7] !== t1 || $[8] !== t2) {
    t3 = /* @__PURE__ */ jsxs("div", { children: [
      t1,
      t2
    ] });
    $[7] = t1;
    $[8] = t2;
    $[9] = t3;
  } else {
    t3 = $[9];
  }
  return t3;
}
const TYPE_TO_ICON = {
  Arguments: ArgumentIcon,
  "Deprecated Arguments": DeprecatedArgumentIcon,
  "Deprecated Enum Values": DeprecatedEnumValueIcon,
  "Deprecated Fields": DeprecatedFieldIcon,
  Directives: DirectiveIcon,
  "Enum Values": EnumValueIcon,
  Fields: FieldIcon,
  Implements: ImplementsIcon,
  Implementations: TypeIcon,
  "Possible Types": TypeIcon,
  "Root Types": RootTypeIcon,
  Type: TypeIcon,
  "All Schema Types": TypeIcon
};
export {
  ExplorerSection
};
//# sourceMappingURL=section.js.map
