import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { isNamedType, isObjectType, isInputObjectType, isScalarType, isEnumType, isInterfaceType, isUnionType } from "graphql";
import { useState, useEffect } from "react";
import { createNullableContext, createContextHook, useSchemaContext } from "@graphiql/react";
const initialNavStackItem = {
  name: "Docs"
};
const ExplorerContext = createNullableContext("ExplorerContext");
function ExplorerContextProvider(props) {
  const $ = c(17);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: ExplorerContextProvider
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    schema,
    validationErrors,
    schemaReference
  } = useSchemaContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = [initialNavStackItem];
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const [navStack, setNavStack] = useState(t1);
  let t2;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = (item) => {
      setNavStack((currentState) => {
        const lastItem = currentState.at(-1);
        return lastItem.def === item.def ? currentState : [...currentState, item];
      });
    };
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const push = t2;
  let t3;
  if ($[3] === Symbol.for("react.memo_cache_sentinel")) {
    t3 = () => {
      setNavStack(_temp);
    };
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const pop = t3;
  let t4;
  if ($[4] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = () => {
      setNavStack(_temp2);
    };
    $[4] = t4;
  } else {
    t4 = $[4];
  }
  const reset = t4;
  let t5;
  let t6;
  if ($[5] !== schemaReference) {
    t5 = () => {
      if (!schemaReference) {
        return;
      }
      bb26: switch (schemaReference.kind) {
        case "Type": {
          push({
            name: schemaReference.type.name,
            def: schemaReference.type
          });
          break bb26;
        }
        case "Field": {
          push({
            name: schemaReference.field.name,
            def: schemaReference.field
          });
          break bb26;
        }
        case "Argument": {
          if (schemaReference.field) {
            push({
              name: schemaReference.field.name,
              def: schemaReference.field
            });
          }
          break bb26;
        }
        case "EnumValue": {
          if (schemaReference.type) {
            push({
              name: schemaReference.type.name,
              def: schemaReference.type
            });
          }
        }
      }
    };
    t6 = [schemaReference, push];
    $[5] = schemaReference;
    $[6] = t5;
    $[7] = t6;
  } else {
    t5 = $[6];
    t6 = $[7];
  }
  useEffect(t5, t6);
  let t7;
  let t8;
  if ($[8] !== schema || $[9] !== validationErrors) {
    t7 = () => {
      if (schema == null || validationErrors.length > 0) {
        reset();
      } else {
        setNavStack((oldNavStack) => {
          if (oldNavStack.length === 1) {
            return oldNavStack;
          }
          const newNavStack = [initialNavStackItem];
          let lastEntity = null;
          for (const item_0 of oldNavStack) {
            if (item_0 === initialNavStackItem) {
              continue;
            }
            if (item_0.def) {
              if (isNamedType(item_0.def)) {
                const newType = schema.getType(item_0.def.name);
                if (newType) {
                  newNavStack.push({
                    name: item_0.name,
                    def: newType
                  });
                  lastEntity = newType;
                } else {
                  break;
                }
              } else {
                if (lastEntity === null) {
                  break;
                } else {
                  if (isObjectType(lastEntity) || isInputObjectType(lastEntity)) {
                    const field = lastEntity.getFields()[item_0.name];
                    if (field) {
                      newNavStack.push({
                        name: item_0.name,
                        def: field
                      });
                    } else {
                      break;
                    }
                  } else {
                    if (isScalarType(lastEntity) || isEnumType(lastEntity) || isInterfaceType(lastEntity) || isUnionType(lastEntity)) {
                      break;
                    } else {
                      const field_0 = lastEntity;
                      if (field_0.args.some((a) => a.name === item_0.name)) {
                        newNavStack.push({
                          name: item_0.name,
                          def: field_0
                        });
                      } else {
                        break;
                      }
                    }
                  }
                }
              }
            } else {
              lastEntity = null;
              newNavStack.push(item_0);
            }
          }
          return newNavStack;
        });
      }
    };
    t8 = [schema, validationErrors];
    $[8] = schema;
    $[9] = validationErrors;
    $[10] = t7;
    $[11] = t8;
  } else {
    t7 = $[10];
    t8 = $[11];
  }
  useEffect(t7, t8);
  let t9;
  if ($[12] !== navStack) {
    t9 = {
      explorerNavStack: navStack,
      push,
      pop,
      reset
    };
    $[12] = navStack;
    $[13] = t9;
  } else {
    t9 = $[13];
  }
  const value = t9;
  let t10;
  if ($[14] !== props.children || $[15] !== value) {
    t10 = /* @__PURE__ */ jsx(ExplorerContext.Provider, { value, children: props.children });
    $[14] = props.children;
    $[15] = value;
    $[16] = t10;
  } else {
    t10 = $[16];
  }
  return t10;
}
function _temp2(currentState_1) {
  return currentState_1.length === 1 ? currentState_1 : [initialNavStackItem];
}
function _temp(currentState_0) {
  return currentState_0.length > 1 ? currentState_0.slice(0, -1) : currentState_0;
}
const useExplorerContext = createContextHook(ExplorerContext);
export {
  ExplorerContext,
  ExplorerContextProvider,
  useExplorerContext
};
//# sourceMappingURL=context.js.map
