import { jsx, jsxs } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { TypeIcon, RootTypeIcon, ImplementsIcon, FieldIcon, EnumValueIcon, DirectiveIcon, DeprecatedFieldIcon, DeprecatedEnumValueIcon, DeprecatedArgumentIcon, ArgumentIcon } from "@graphiql/react";
/* empty css            */
const ExplorerSection = (t0) => {
  const $ = c(10);
  const {
    title,
    children
  } = t0;
  const Icon = TYPE_TO_ICON[title];
  let t1;
  if ($[0] !== Icon) {
    t1 = /* @__PURE__ */ jsx(Icon, {});
    $[0] = Icon;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] !== t1 || $[3] !== title) {
    t2 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-section-title", children: [
      t1,
      title
    ] });
    $[2] = t1;
    $[3] = title;
    $[4] = t2;
  } else {
    t2 = $[4];
  }
  let t3;
  if ($[5] !== children) {
    t3 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-section-content", children });
    $[5] = children;
    $[6] = t3;
  } else {
    t3 = $[6];
  }
  let t4;
  if ($[7] !== t2 || $[8] !== t3) {
    t4 = /* @__PURE__ */ jsxs("div", { children: [
      t2,
      t3
    ] });
    $[7] = t2;
    $[8] = t3;
    $[9] = t4;
  } else {
    t4 = $[9];
  }
  return t4;
};
const TYPE_TO_ICON = {
  Arguments: ArgumentIcon,
  "Deprecated Arguments": DeprecatedArgumentIcon,
  "Deprecated Enum Values": DeprecatedEnumValueIcon,
  "Deprecated Fields": DeprecatedFieldIcon,
  Directives: DirectiveIcon,
  "Enum Values": EnumValueIcon,
  Fields: FieldIcon,
  Implements: ImplementsIcon,
  Implementations: TypeIcon,
  "Possible Types": TypeIcon,
  "Root Types": RootTypeIcon,
  Type: TypeIcon,
  "All Schema Types": TypeIcon
};
export {
  ExplorerSection
};
//# sourceMappingURL=section.js.map
