import { jsxs, jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { isType } from "graphql";
import { useSchemaContext, Spinner, ChevronLeftIcon } from "@graphiql/react";
import { useDocExplorer, useDocExplorerActions } from "../context.js";
import { FieldDocumentation } from "./field-documentation.js";
import { SchemaDocumentation } from "./schema-documentation.js";
import { Search } from "./search.js";
import { TypeDocumentation } from "./type-documentation.js";
/* empty css                 */
const DocExplorer = () => {
  const $ = c(39);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: DocExplorer
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    fetchError,
    isFetching,
    schema,
    validationErrors
  } = useSchemaContext(t0);
  const explorerNavStack = useDocExplorer();
  const {
    pop
  } = useDocExplorerActions();
  let content;
  let navItem;
  if ($[1] !== explorerNavStack || $[2] !== fetchError || $[3] !== isFetching || $[4] !== schema || $[5] !== validationErrors) {
    navItem = explorerNavStack.at(-1);
    content = null;
    if (fetchError) {
      let t12;
      if ($[8] === Symbol.for("react.memo_cache_sentinel")) {
        t12 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-error", children: "Error fetching schema" });
        $[8] = t12;
      } else {
        t12 = $[8];
      }
      content = t12;
    } else {
      if (validationErrors.length > 0) {
        let t12;
        if ($[9] !== validationErrors[0].message) {
          t12 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-error", children: [
            "Schema is invalid: ",
            validationErrors[0].message
          ] });
          $[9] = validationErrors[0].message;
          $[10] = t12;
        } else {
          t12 = $[10];
        }
        content = t12;
      } else {
        if (isFetching) {
          let t12;
          if ($[11] === Symbol.for("react.memo_cache_sentinel")) {
            t12 = /* @__PURE__ */ jsx(Spinner, {});
            $[11] = t12;
          } else {
            t12 = $[11];
          }
          content = t12;
        } else {
          if (!schema) {
            let t12;
            if ($[12] === Symbol.for("react.memo_cache_sentinel")) {
              t12 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-error", children: "No GraphQL schema available" });
              $[12] = t12;
            } else {
              t12 = $[12];
            }
            content = t12;
          } else {
            if (explorerNavStack.length === 1) {
              let t12;
              if ($[13] !== schema) {
                t12 = /* @__PURE__ */ jsx(SchemaDocumentation, { schema });
                $[13] = schema;
                $[14] = t12;
              } else {
                t12 = $[14];
              }
              content = t12;
            } else {
              if (isType(navItem.def)) {
                let t12;
                if ($[15] !== navItem.def) {
                  t12 = /* @__PURE__ */ jsx(TypeDocumentation, { type: navItem.def });
                  $[15] = navItem.def;
                  $[16] = t12;
                } else {
                  t12 = $[16];
                }
                content = t12;
              } else {
                if (navItem.def) {
                  let t12;
                  if ($[17] !== navItem.def) {
                    t12 = /* @__PURE__ */ jsx(FieldDocumentation, { field: navItem.def });
                    $[17] = navItem.def;
                    $[18] = t12;
                  } else {
                    t12 = $[18];
                  }
                  content = t12;
                }
              }
            }
          }
        }
      }
    }
    $[1] = explorerNavStack;
    $[2] = fetchError;
    $[3] = isFetching;
    $[4] = schema;
    $[5] = validationErrors;
    $[6] = content;
    $[7] = navItem;
  } else {
    content = $[6];
    navItem = $[7];
  }
  let prevName;
  if (explorerNavStack.length > 1) {
    let t12;
    if ($[19] !== explorerNavStack) {
      t12 = explorerNavStack.at(-2);
      $[19] = explorerNavStack;
      $[20] = t12;
    } else {
      t12 = $[20];
    }
    prevName = t12.name;
  }
  let t1;
  if ($[21] !== pop || $[22] !== prevName) {
    t1 = prevName && /* @__PURE__ */ jsxs("a", { href: "#", className: "graphiql-doc-explorer-back", onClick: (event) => {
      event.preventDefault();
      pop();
    }, "aria-label": `Go back to ${prevName}`, children: [
      /* @__PURE__ */ jsx(ChevronLeftIcon, {}),
      prevName
    ] });
    $[21] = pop;
    $[22] = prevName;
    $[23] = t1;
  } else {
    t1 = $[23];
  }
  let t2;
  if ($[24] !== navItem.name) {
    t2 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-title", children: navItem.name });
    $[24] = navItem.name;
    $[25] = t2;
  } else {
    t2 = $[25];
  }
  let t3;
  if ($[26] !== t1 || $[27] !== t2) {
    t3 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-header-content", children: [
      t1,
      t2
    ] });
    $[26] = t1;
    $[27] = t2;
    $[28] = t3;
  } else {
    t3 = $[28];
  }
  let t4;
  if ($[29] !== navItem.name) {
    t4 = /* @__PURE__ */ jsx(Search, {}, navItem.name);
    $[29] = navItem.name;
    $[30] = t4;
  } else {
    t4 = $[30];
  }
  let t5;
  if ($[31] !== t3 || $[32] !== t4) {
    t5 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-header", children: [
      t3,
      t4
    ] });
    $[31] = t3;
    $[32] = t4;
    $[33] = t5;
  } else {
    t5 = $[33];
  }
  let t6;
  if ($[34] !== content) {
    t6 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-content", children: content });
    $[34] = content;
    $[35] = t6;
  } else {
    t6 = $[35];
  }
  let t7;
  if ($[36] !== t5 || $[37] !== t6) {
    t7 = /* @__PURE__ */ jsxs("section", { className: "graphiql-doc-explorer", "aria-label": "Documentation Explorer", children: [
      t5,
      t6
    ] });
    $[36] = t5;
    $[37] = t6;
    $[38] = t7;
  } else {
    t7 = $[38];
  }
  return t7;
};
export {
  DocExplorer
};
//# sourceMappingURL=doc-explorer.js.map
