import { jsxs, jsx, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { isObjectType, isInterfaceType, isInputObjectType } from "graphql";
import { useRef, useState, useEffect } from "react";
import { ComboboxOptions, ComboboxOption, ComboboxInput, Combobox } from "@headlessui/react";
import { debounce, useSchemaContext, MagnifyingGlassIcon, isMacOs } from "@graphiql/react";
import { useDocExplorer, useDocExplorerActions } from "../context.js";
import { renderType } from "./utils.js";
/* empty css           */
const Search = () => {
  const $ = c(32);
  const explorerNavStack = useDocExplorer();
  const {
    push
  } = useDocExplorerActions();
  const inputRef = useRef(null);
  const getSearchResults = useSearchResults();
  const [searchValue, setSearchValue] = useState("");
  let t0;
  if ($[0] !== getSearchResults || $[1] !== searchValue) {
    t0 = () => getSearchResults(searchValue);
    $[0] = getSearchResults;
    $[1] = searchValue;
    $[2] = t0;
  } else {
    t0 = $[2];
  }
  const [results, setResults] = useState(t0);
  let t1;
  if ($[3] !== getSearchResults) {
    t1 = debounce(200, (search) => {
      setResults(getSearchResults(search));
    });
    $[3] = getSearchResults;
    $[4] = t1;
  } else {
    t1 = $[4];
  }
  const debouncedGetSearchResults = t1;
  const [ref] = useState(inputRef);
  const isFocused = ref.current === document.activeElement;
  let t2;
  let t3;
  if ($[5] !== debouncedGetSearchResults || $[6] !== searchValue) {
    t2 = () => {
      debouncedGetSearchResults(searchValue);
    };
    t3 = [debouncedGetSearchResults, searchValue];
    $[5] = debouncedGetSearchResults;
    $[6] = searchValue;
    $[7] = t2;
    $[8] = t3;
  } else {
    t2 = $[7];
    t3 = $[8];
  }
  useEffect(t2, t3);
  let t4;
  let t5;
  if ($[9] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = () => {
      const handleKeyDown = function handleKeyDown2(event) {
        if (event.metaKey && event.key === "k") {
          inputRef.current.focus();
        }
      };
      window.addEventListener("keydown", handleKeyDown);
      return () => window.removeEventListener("keydown", handleKeyDown);
    };
    t5 = [];
    $[9] = t4;
    $[10] = t5;
  } else {
    t4 = $[9];
    t5 = $[10];
  }
  useEffect(t4, t5);
  let navItem;
  let onSelect;
  let t6;
  if ($[11] !== explorerNavStack || $[12] !== push) {
    navItem = explorerNavStack.at(-1);
    let t72;
    if ($[16] !== push) {
      t72 = (def) => {
        push("field" in def ? {
          name: def.field.name,
          def: def.field
        } : {
          name: def.type.name,
          def: def.type
        });
      };
      $[16] = push;
      $[17] = t72;
    } else {
      t72 = $[17];
    }
    onSelect = t72;
    t6 = explorerNavStack.length === 1 || isObjectType(navItem.def) || isInterfaceType(navItem.def) || isInputObjectType(navItem.def);
    $[11] = explorerNavStack;
    $[12] = push;
    $[13] = navItem;
    $[14] = onSelect;
    $[15] = t6;
  } else {
    navItem = $[13];
    onSelect = $[14];
    t6 = $[15];
  }
  const shouldSearchBoxAppear = t6;
  if (!shouldSearchBoxAppear) {
    return null;
  }
  const t7 = isFocused ? void 0 : "idle";
  const t8 = `Search ${navItem.name}...`;
  let t10;
  let t9;
  if ($[18] === Symbol.for("react.memo_cache_sentinel")) {
    t9 = () => {
      inputRef.current.focus();
    };
    t10 = /* @__PURE__ */ jsx(MagnifyingGlassIcon, {});
    $[18] = t10;
    $[19] = t9;
  } else {
    t10 = $[18];
    t9 = $[19];
  }
  let t11;
  if ($[20] === Symbol.for("react.memo_cache_sentinel")) {
    t11 = (event_0) => setSearchValue(event_0.target.value);
    $[20] = t11;
  } else {
    t11 = $[20];
  }
  let t12;
  if ($[21] !== searchValue) {
    t12 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-search-input", onClick: t9, children: [
      t10,
      /* @__PURE__ */ jsx(ComboboxInput, { autoComplete: "off", onChange: t11, placeholder: `${isMacOs ? "⌘" : "Ctrl"} K`, ref: inputRef, value: searchValue, "data-cy": "doc-explorer-input" })
    ] });
    $[21] = searchValue;
    $[22] = t12;
  } else {
    t12 = $[22];
  }
  let t13;
  if ($[23] !== isFocused || $[24] !== results) {
    t13 = isFocused && /* @__PURE__ */ jsxs(ComboboxOptions, { "data-cy": "doc-explorer-list", children: [
      results.within.length + results.types.length + results.fields.length === 0 ? /* @__PURE__ */ jsx("li", { className: "graphiql-doc-explorer-search-empty", children: "No results found" }) : results.within.map(_temp),
      results.within.length > 0 && results.types.length + results.fields.length > 0 ? /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-search-divider", children: "Other results" }) : null,
      results.types.map(_temp2),
      results.fields.map(_temp3)
    ] });
    $[23] = isFocused;
    $[24] = results;
    $[25] = t13;
  } else {
    t13 = $[25];
  }
  let t14;
  if ($[26] !== onSelect || $[27] !== t12 || $[28] !== t13 || $[29] !== t7 || $[30] !== t8) {
    t14 = /* @__PURE__ */ jsxs(Combobox, { as: "div", className: "graphiql-doc-explorer-search", onChange: onSelect, "data-state": t7, "aria-label": t8, children: [
      t12,
      t13
    ] });
    $[26] = onSelect;
    $[27] = t12;
    $[28] = t13;
    $[29] = t7;
    $[30] = t8;
    $[31] = t14;
  } else {
    t14 = $[31];
  }
  return t14;
};
const _useSearchResults = useSearchResults;
function useSearchResults(caller) {
  const $ = c(7);
  const explorerNavStack = useDocExplorer();
  const t0 = caller || _useSearchResults;
  let t1;
  if ($[0] !== t0) {
    t1 = {
      nonNull: true,
      caller: t0
    };
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    schema
  } = useSchemaContext(t1);
  let t2;
  if ($[2] !== explorerNavStack) {
    t2 = explorerNavStack.at(-1);
    $[2] = explorerNavStack;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  const navItem = t2;
  let t3;
  if ($[4] !== navItem || $[5] !== schema) {
    t3 = (searchValue) => {
      const matches = {
        within: [],
        types: [],
        fields: []
      };
      if (!schema) {
        return matches;
      }
      const withinType = navItem.def;
      const typeMap = schema.getTypeMap();
      let typeNames = Object.keys(typeMap);
      if (withinType) {
        typeNames = typeNames.filter((n) => n !== withinType.name);
        typeNames.unshift(withinType.name);
      }
      for (const typeName of typeNames) {
        if (matches.within.length + matches.types.length + matches.fields.length >= 100) {
          break;
        }
        const type = typeMap[typeName];
        if (withinType !== type && isMatch(typeName, searchValue)) {
          matches.types.push({
            type
          });
        }
        if (!isObjectType(type) && !isInterfaceType(type) && !isInputObjectType(type)) {
          continue;
        }
        const fields = type.getFields();
        for (const fieldName in fields) {
          const field = fields[fieldName];
          let matchingArgs;
          if (!isMatch(fieldName, searchValue)) {
            if ("args" in field) {
              matchingArgs = field.args.filter((arg) => isMatch(arg.name, searchValue));
              if (matchingArgs.length === 0) {
                continue;
              }
            } else {
              continue;
            }
          }
          matches[withinType === type ? "within" : "fields"].push(...matchingArgs ? matchingArgs.map((argument) => ({
            type,
            field,
            argument
          })) : [{
            type,
            field
          }]);
        }
      }
      return matches;
    };
    $[4] = navItem;
    $[5] = schema;
    $[6] = t3;
  } else {
    t3 = $[6];
  }
  return t3;
}
function isMatch(sourceText, searchValue) {
  try {
    const escaped = searchValue.replaceAll(/[^_0-9A-Za-z]/g, (ch) => "\\" + ch);
    return new RegExp(escaped, "i").test(sourceText);
  } catch {
    return sourceText.toLowerCase().includes(searchValue.toLowerCase());
  }
}
const Type = (t0) => {
  const $ = c(2);
  const {
    type
  } = t0;
  let t1;
  if ($[0] !== type.name) {
    t1 = /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-type", children: type.name });
    $[0] = type.name;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  return t1;
};
const Field = (t0) => {
  const $ = c(7);
  const {
    field,
    argument
  } = t0;
  let t1;
  if ($[0] !== field.name) {
    t1 = /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-field", children: field.name });
    $[0] = field.name;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] !== argument) {
    t2 = argument ? /* @__PURE__ */ jsxs(Fragment, { children: [
      "(",
      /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-argument", children: argument.name }),
      ":",
      " ",
      renderType(argument.type, _temp4),
      ")"
    ] }) : null;
    $[2] = argument;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  let t3;
  if ($[4] !== t1 || $[5] !== t2) {
    t3 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t1,
      t2
    ] });
    $[4] = t1;
    $[5] = t2;
    $[6] = t3;
  } else {
    t3 = $[6];
  }
  return t3;
};
function _temp(result, i) {
  return /* @__PURE__ */ jsx(ComboboxOption, { value: result, "data-cy": "doc-explorer-option", children: /* @__PURE__ */ jsx(Field, { field: result.field, argument: result.argument }) }, `within-${i}`);
}
function _temp2(result_0, i_0) {
  return /* @__PURE__ */ jsx(ComboboxOption, { value: result_0, "data-cy": "doc-explorer-option", children: /* @__PURE__ */ jsx(Type, { type: result_0.type }) }, `type-${i_0}`);
}
function _temp3(result_1, i_1) {
  return /* @__PURE__ */ jsxs(ComboboxOption, { value: result_1, "data-cy": "doc-explorer-option", children: [
    /* @__PURE__ */ jsx(Type, { type: result_1.type }),
    ".",
    /* @__PURE__ */ jsx(Field, { field: result_1.field, argument: result_1.argument })
  ] }, `field-${i_1}`);
}
function _temp4(namedType) {
  return /* @__PURE__ */ jsx(Type, { type: namedType });
}
export {
  Search,
  useSearchResults
};
//# sourceMappingURL=search.js.map
