import { jsxs, Fragment } from "react/jsx-runtime";
import { isNonNullType, isListType } from "graphql";
function renderType(type, renderNamedType) {
  if (isNonNullType(type)) {
    return /* @__PURE__ */ jsxs(Fragment, { children: [
      renderType(type.ofType, renderNamedType),
      "!"
    ] });
  }
  if (isListType(type)) {
    return /* @__PURE__ */ jsxs(Fragment, { children: [
      "[",
      renderType(type.ofType, renderNamedType),
      "]"
    ] });
  }
  return renderNamedType(type);
}
export {
  renderType
};
//# sourceMappingURL=utils.js.map
