import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { isNamedType, isObjectType, isInputObjectType, isScalarType, isEnumType, isInterfaceType, isUnionType } from "graphql";
import { createContext, useRef, useEffect, useContext } from "react";
import { useSchemaContext } from "@graphiql/react";
import { createStore, useStore } from "zustand";
function createDocExplorerStore(initialNavStackItem = {
  name: "Docs"
}) {
  return createStore((set, get) => ({
    explorerNavStack: [initialNavStackItem],
    actions: {
      push(item) {
        set((state) => {
          const curr = state.explorerNavStack;
          const lastItem = curr.at(-1);
          const explorerNavStack = (
            // Avoid pushing duplicate items
            lastItem.def === item.def ? curr : [...curr, item]
          );
          return {
            explorerNavStack
          };
        });
      },
      pop() {
        set((state) => {
          const curr = state.explorerNavStack;
          const explorerNavStack = curr.length > 1 ? curr.slice(0, -1) : curr;
          return {
            explorerNavStack
          };
        });
      },
      reset() {
        set((state) => {
          const curr = state.explorerNavStack;
          const explorerNavStack = curr.length === 1 ? curr : [initialNavStackItem];
          return {
            explorerNavStack
          };
        });
      },
      resolveSchemaReferenceToNavItem(schemaReference) {
        if (!schemaReference) {
          return;
        }
        const {
          push
        } = get().actions;
        switch (schemaReference.kind) {
          case "Type": {
            push({
              name: schemaReference.type.name,
              def: schemaReference.type
            });
            break;
          }
          case "Field": {
            push({
              name: schemaReference.field.name,
              def: schemaReference.field
            });
            break;
          }
          case "Argument": {
            if (schemaReference.field) {
              push({
                name: schemaReference.field.name,
                def: schemaReference.field
              });
            }
            break;
          }
          case "EnumValue": {
            if (schemaReference.type) {
              push({
                name: schemaReference.type.name,
                def: schemaReference.type
              });
            }
            break;
          }
        }
      },
      rebuildNavStackWithSchema(schema) {
        set((state) => {
          const oldNavStack = state.explorerNavStack;
          if (oldNavStack.length === 1) {
            return oldNavStack;
          }
          const newNavStack = [initialNavStackItem];
          let lastEntity = null;
          for (const item of oldNavStack) {
            if (item === initialNavStackItem) {
              continue;
            }
            if (item.def) {
              if (isNamedType(item.def)) {
                const newType = schema.getType(item.def.name);
                if (newType) {
                  newNavStack.push({
                    name: item.name,
                    def: newType
                  });
                  lastEntity = newType;
                } else {
                  break;
                }
              } else if (lastEntity === null) {
                break;
              } else if (isObjectType(lastEntity) || isInputObjectType(lastEntity)) {
                const field = lastEntity.getFields()[item.name];
                if (field) {
                  newNavStack.push({
                    name: item.name,
                    def: field
                  });
                } else {
                  break;
                }
              } else if (isScalarType(lastEntity) || isEnumType(lastEntity) || isInterfaceType(lastEntity) || isUnionType(lastEntity)) {
                break;
              } else {
                const field = lastEntity;
                if (field.args.some((a) => a.name === item.name)) {
                  newNavStack.push({
                    name: item.name,
                    def: field
                  });
                } else {
                  break;
                }
              }
            } else {
              lastEntity = null;
              newNavStack.push(item);
            }
          }
          return {
            explorerNavStack: newNavStack
          };
        });
      }
    }
  }));
}
const DocExplorerContext = createContext(null);
const DocExplorerContextProvider = (props) => {
  const $ = c(11);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: DocExplorerContextProvider
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    schema,
    validationErrors,
    schemaReference
  } = useSchemaContext(t0);
  const storeRef = useRef(null);
  if (storeRef.current === null) {
    let t12;
    if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
      t12 = createDocExplorerStore();
      $[1] = t12;
    } else {
      t12 = $[1];
    }
    storeRef.current = t12;
  }
  let t1;
  let t2;
  if ($[2] !== schemaReference) {
    t1 = () => {
      const {
        resolveSchemaReferenceToNavItem
      } = storeRef.current.getState().actions;
      resolveSchemaReferenceToNavItem(schemaReference);
    };
    t2 = [schemaReference];
    $[2] = schemaReference;
    $[3] = t1;
    $[4] = t2;
  } else {
    t1 = $[3];
    t2 = $[4];
  }
  useEffect(t1, t2);
  let t3;
  let t4;
  if ($[5] !== schema || $[6] !== validationErrors) {
    t3 = () => {
      const {
        reset,
        rebuildNavStackWithSchema
      } = storeRef.current.getState().actions;
      if (schema == null || validationErrors.length > 0) {
        reset();
      } else {
        rebuildNavStackWithSchema(schema);
      }
    };
    t4 = [schema, validationErrors];
    $[5] = schema;
    $[6] = validationErrors;
    $[7] = t3;
    $[8] = t4;
  } else {
    t3 = $[7];
    t4 = $[8];
  }
  useEffect(t3, t4);
  let t5;
  if ($[9] !== props.children) {
    t5 = /* @__PURE__ */ jsx(DocExplorerContext.Provider, { value: storeRef, children: props.children });
    $[9] = props.children;
    $[10] = t5;
  } else {
    t5 = $[10];
  }
  return t5;
};
function useDocExplorerStore(selector) {
  const store = useContext(DocExplorerContext);
  if (!store) {
    throw new Error("Missing `DocExplorerContextProvider` in the tree");
  }
  return useStore(store.current, selector);
}
const useDocExplorer = () => {
  return useDocExplorerStore(_temp);
};
const useDocExplorerActions = () => {
  return useDocExplorerStore(_temp2);
};
function _temp(state) {
  return state.explorerNavStack;
}
function _temp2(state) {
  return state.actions;
}
export {
  DocExplorerContext,
  DocExplorerContextProvider,
  createDocExplorerStore,
  useDocExplorer,
  useDocExplorerActions
};
//# sourceMappingURL=context.js.map
