import { jsxs, jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { isType } from "graphql";
import { useSchemaStore, Spinner, ChevronLeftIcon } from "@graphiql/react";
import { useDocExplorer, useDocExplorerActions } from "../context.js";
import { FieldDocumentation } from "./field-documentation.js";
import { SchemaDocumentation } from "./schema-documentation.js";
import { Search } from "./search.js";
import { TypeDocumentation } from "./type-documentation.js";
/* empty css                 */
const DocExplorer = () => {
  const $ = c(38);
  const {
    fetchError,
    isFetching,
    schema,
    validationErrors
  } = useSchemaStore();
  const explorerNavStack = useDocExplorer();
  const {
    pop
  } = useDocExplorerActions();
  let content;
  let navItem;
  if ($[0] !== explorerNavStack || $[1] !== fetchError || $[2] !== isFetching || $[3] !== schema || $[4] !== validationErrors) {
    navItem = explorerNavStack.at(-1);
    content = null;
    if (fetchError) {
      let t02;
      if ($[7] === Symbol.for("react.memo_cache_sentinel")) {
        t02 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-error", children: "Error fetching schema" });
        $[7] = t02;
      } else {
        t02 = $[7];
      }
      content = t02;
    } else {
      if (validationErrors.length > 0) {
        let t02;
        if ($[8] !== validationErrors[0].message) {
          t02 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-error", children: [
            "Schema is invalid: ",
            validationErrors[0].message
          ] });
          $[8] = validationErrors[0].message;
          $[9] = t02;
        } else {
          t02 = $[9];
        }
        content = t02;
      } else {
        if (isFetching) {
          let t02;
          if ($[10] === Symbol.for("react.memo_cache_sentinel")) {
            t02 = /* @__PURE__ */ jsx(Spinner, {});
            $[10] = t02;
          } else {
            t02 = $[10];
          }
          content = t02;
        } else {
          if (!schema) {
            let t02;
            if ($[11] === Symbol.for("react.memo_cache_sentinel")) {
              t02 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-error", children: "No GraphQL schema available" });
              $[11] = t02;
            } else {
              t02 = $[11];
            }
            content = t02;
          } else {
            if (explorerNavStack.length === 1) {
              let t02;
              if ($[12] !== schema) {
                t02 = /* @__PURE__ */ jsx(SchemaDocumentation, { schema });
                $[12] = schema;
                $[13] = t02;
              } else {
                t02 = $[13];
              }
              content = t02;
            } else {
              if (isType(navItem.def)) {
                let t02;
                if ($[14] !== navItem.def) {
                  t02 = /* @__PURE__ */ jsx(TypeDocumentation, { type: navItem.def });
                  $[14] = navItem.def;
                  $[15] = t02;
                } else {
                  t02 = $[15];
                }
                content = t02;
              } else {
                if (navItem.def) {
                  let t02;
                  if ($[16] !== navItem.def) {
                    t02 = /* @__PURE__ */ jsx(FieldDocumentation, { field: navItem.def });
                    $[16] = navItem.def;
                    $[17] = t02;
                  } else {
                    t02 = $[17];
                  }
                  content = t02;
                }
              }
            }
          }
        }
      }
    }
    $[0] = explorerNavStack;
    $[1] = fetchError;
    $[2] = isFetching;
    $[3] = schema;
    $[4] = validationErrors;
    $[5] = content;
    $[6] = navItem;
  } else {
    content = $[5];
    navItem = $[6];
  }
  let prevName;
  if (explorerNavStack.length > 1) {
    let t02;
    if ($[18] !== explorerNavStack) {
      t02 = explorerNavStack.at(-2);
      $[18] = explorerNavStack;
      $[19] = t02;
    } else {
      t02 = $[19];
    }
    prevName = t02.name;
  }
  let t0;
  if ($[20] !== pop || $[21] !== prevName) {
    t0 = prevName && /* @__PURE__ */ jsxs("a", { href: "#", className: "graphiql-doc-explorer-back", onClick: (event) => {
      event.preventDefault();
      pop();
    }, "aria-label": `Go back to ${prevName}`, children: [
      /* @__PURE__ */ jsx(ChevronLeftIcon, {}),
      prevName
    ] });
    $[20] = pop;
    $[21] = prevName;
    $[22] = t0;
  } else {
    t0 = $[22];
  }
  let t1;
  if ($[23] !== navItem.name) {
    t1 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-title", children: navItem.name });
    $[23] = navItem.name;
    $[24] = t1;
  } else {
    t1 = $[24];
  }
  let t2;
  if ($[25] !== t0 || $[26] !== t1) {
    t2 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-header-content", children: [
      t0,
      t1
    ] });
    $[25] = t0;
    $[26] = t1;
    $[27] = t2;
  } else {
    t2 = $[27];
  }
  let t3;
  if ($[28] !== navItem.name) {
    t3 = /* @__PURE__ */ jsx(Search, {}, navItem.name);
    $[28] = navItem.name;
    $[29] = t3;
  } else {
    t3 = $[29];
  }
  let t4;
  if ($[30] !== t2 || $[31] !== t3) {
    t4 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-header", children: [
      t2,
      t3
    ] });
    $[30] = t2;
    $[31] = t3;
    $[32] = t4;
  } else {
    t4 = $[32];
  }
  let t5;
  if ($[33] !== content) {
    t5 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-content", children: content });
    $[33] = content;
    $[34] = t5;
  } else {
    t5 = $[34];
  }
  let t6;
  if ($[35] !== t4 || $[36] !== t5) {
    t6 = /* @__PURE__ */ jsxs("section", { className: "graphiql-doc-explorer", "aria-label": "Documentation Explorer", children: [
      t4,
      t5
    ] });
    $[35] = t4;
    $[36] = t5;
    $[37] = t6;
  } else {
    t6 = $[37];
  }
  return t6;
};
export {
  DocExplorer
};
//# sourceMappingURL=doc-explorer.js.map
