import { c } from "react-compiler-runtime";
import { isNamedType, isObjectType, isInputObjectType, isScalarType, isEnumType, isInterfaceType, isUnionType } from "graphql";
import { useEffect } from "react";
import { useSchemaStore, createBoundedUseStore } from "@graphiql/react";
import { createStore } from "zustand";
const INITIAL_NAV_STACK = [{
  name: "Docs"
}];
const docExplorerStore = createStore((set, get) => ({
  explorerNavStack: INITIAL_NAV_STACK,
  actions: {
    push(item) {
      set((state) => {
        const curr = state.explorerNavStack;
        const lastItem = curr.at(-1);
        const explorerNavStack = (
          // Avoid pushing duplicate items
          lastItem.def === item.def ? curr : [...curr, item]
        );
        return {
          explorerNavStack
        };
      });
    },
    pop() {
      set((state) => {
        const curr = state.explorerNavStack;
        const explorerNavStack = curr.length > 1 ? curr.slice(0, -1) : curr;
        return {
          explorerNavStack
        };
      });
    },
    reset() {
      set((state) => {
        const curr = state.explorerNavStack;
        const explorerNavStack = curr.length === 1 ? curr : INITIAL_NAV_STACK;
        return {
          explorerNavStack
        };
      });
    },
    resolveSchemaReferenceToNavItem(schemaReference) {
      if (!schemaReference) {
        return;
      }
      const {
        push
      } = get().actions;
      switch (schemaReference.kind) {
        case "Type": {
          push({
            name: schemaReference.type.name,
            def: schemaReference.type
          });
          break;
        }
        case "Field": {
          push({
            name: schemaReference.field.name,
            def: schemaReference.field
          });
          break;
        }
        case "Argument": {
          if (schemaReference.field) {
            push({
              name: schemaReference.field.name,
              def: schemaReference.field
            });
          }
          break;
        }
        case "EnumValue": {
          if (schemaReference.type) {
            push({
              name: schemaReference.type.name,
              def: schemaReference.type
            });
          }
          break;
        }
      }
    },
    rebuildNavStackWithSchema(schema) {
      set((state) => {
        const oldNavStack = state.explorerNavStack;
        if (oldNavStack.length === 1) {
          return state;
        }
        const newNavStack = [...INITIAL_NAV_STACK];
        let lastEntity = null;
        for (const item of oldNavStack) {
          if (item === INITIAL_NAV_STACK[0]) {
            continue;
          }
          if (item.def) {
            if (isNamedType(item.def)) {
              const newType = schema.getType(item.def.name);
              if (newType) {
                newNavStack.push({
                  name: item.name,
                  def: newType
                });
                lastEntity = newType;
              } else {
                break;
              }
            } else if (lastEntity === null) {
              break;
            } else if (isObjectType(lastEntity) || isInputObjectType(lastEntity)) {
              const field = lastEntity.getFields()[item.name];
              if (field) {
                newNavStack.push({
                  name: item.name,
                  def: field
                });
              } else {
                break;
              }
            } else if (isScalarType(lastEntity) || isEnumType(lastEntity) || isInterfaceType(lastEntity) || isUnionType(lastEntity)) {
              break;
            } else {
              const field = lastEntity;
              if (field.args.some((a) => a.name === item.name)) {
                newNavStack.push({
                  name: item.name,
                  def: field
                });
              } else {
                break;
              }
            }
          } else {
            lastEntity = null;
            newNavStack.push(item);
          }
        }
        return {
          explorerNavStack: newNavStack
        };
      });
    }
  }
}));
const DocExplorerContextProvider = (t0) => {
  const $ = c(7);
  const {
    children
  } = t0;
  const {
    schema,
    validationErrors,
    schemaReference
  } = useSchemaStore();
  let t1;
  let t2;
  if ($[0] !== schemaReference) {
    t1 = () => {
      const {
        resolveSchemaReferenceToNavItem
      } = docExplorerStore.getState().actions;
      resolveSchemaReferenceToNavItem(schemaReference);
    };
    t2 = [schemaReference];
    $[0] = schemaReference;
    $[1] = t1;
    $[2] = t2;
  } else {
    t1 = $[1];
    t2 = $[2];
  }
  useEffect(t1, t2);
  let t3;
  let t4;
  if ($[3] !== schema || $[4] !== validationErrors) {
    t3 = () => {
      const {
        reset,
        rebuildNavStackWithSchema
      } = docExplorerStore.getState().actions;
      if (schema == null || validationErrors.length > 0) {
        reset();
      } else {
        rebuildNavStackWithSchema(schema);
      }
    };
    t4 = [schema, validationErrors];
    $[3] = schema;
    $[4] = validationErrors;
    $[5] = t3;
    $[6] = t4;
  } else {
    t3 = $[5];
    t4 = $[6];
  }
  useEffect(t3, t4);
  return children;
};
const useDocExplorerStore = createBoundedUseStore(docExplorerStore);
const useDocExplorer = () => {
  return useDocExplorerStore(_temp);
};
const useDocExplorerActions = () => {
  return useDocExplorerStore(_temp2);
};
function _temp(state) {
  return state.explorerNavStack;
}
function _temp2(state) {
  return state.actions;
}
export {
  DocExplorerContextProvider,
  docExplorerStore,
  useDocExplorer,
  useDocExplorerActions
};
//# sourceMappingURL=context.js.map
