import { jsx } from "react/jsx-runtime";
import { usePluginStore, DocsFilledIcon, DocsIcon } from "@graphiql/react";
import { DocExplorerContextProvider, useDocExplorer, useDocExplorerActions } from "./context.js";
import { DocExplorer } from "./components/doc-explorer.js";
import { Argument } from "./components/argument.js";
import { DefaultValue } from "./components/default-value.js";
import { DeprecationReason } from "./components/deprecation-reason.js";
import { Directive } from "./components/directive.js";
import { FieldDocumentation } from "./components/field-documentation.js";
import { FieldLink } from "./components/field-link.js";
import { SchemaDocumentation } from "./components/schema-documentation.js";
import { Search } from "./components/search.js";
import { ExplorerSection } from "./components/section.js";
import { TypeDocumentation } from "./components/type-documentation.js";
import { TypeLink } from "./components/type-link.js";
const DOC_EXPLORER_PLUGIN = {
  title: "Documentation Explorer",
  icon: function Icon() {
    const {
      visiblePlugin
    } = usePluginStore();
    return visiblePlugin === DOC_EXPLORER_PLUGIN ? /* @__PURE__ */ jsx(DocsFilledIcon, {}) : /* @__PURE__ */ jsx(DocsIcon, {});
  },
  content: DocExplorer
};
export {
  Argument,
  DOC_EXPLORER_PLUGIN,
  DefaultValue,
  DeprecationReason,
  Directive,
  DocExplorer,
  DocExplorerContextProvider,
  ExplorerSection,
  FieldDocumentation,
  FieldLink,
  SchemaDocumentation,
  Search,
  TypeDocumentation,
  TypeLink,
  useDocExplorer,
  useDocExplorerActions
};
//# sourceMappingURL=index.js.map
