import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useState } from "react";
import { MarkdownContent, Button } from "@graphiql/react";
import { Argument } from "./argument.js";
import { DeprecationReason } from "./deprecation-reason.js";
import { Directive } from "./directive.js";
import { ExplorerSection } from "./section.js";
import { TypeLink } from "./type-link.js";
const FieldDocumentation = (t0) => {
  const $ = c(15);
  const {
    field
  } = t0;
  let t1;
  if ($[0] !== field.description) {
    t1 = field.description ? /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: field.description }) : null;
    $[0] = field.description;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] !== field.deprecationReason) {
    t2 = /* @__PURE__ */ jsx(DeprecationReason, { preview: false, children: field.deprecationReason });
    $[2] = field.deprecationReason;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  let t3;
  if ($[4] !== field.type) {
    t3 = /* @__PURE__ */ jsx(ExplorerSection, { title: "Type", children: /* @__PURE__ */ jsx(TypeLink, { type: field.type }) });
    $[4] = field.type;
    $[5] = t3;
  } else {
    t3 = $[5];
  }
  let t4;
  let t5;
  if ($[6] !== field) {
    t4 = /* @__PURE__ */ jsx(Arguments, { field });
    t5 = /* @__PURE__ */ jsx(Directives, { field });
    $[6] = field;
    $[7] = t4;
    $[8] = t5;
  } else {
    t4 = $[7];
    t5 = $[8];
  }
  let t6;
  if ($[9] !== t1 || $[10] !== t2 || $[11] !== t3 || $[12] !== t4 || $[13] !== t5) {
    t6 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t1,
      t2,
      t3,
      t4,
      t5
    ] });
    $[9] = t1;
    $[10] = t2;
    $[11] = t3;
    $[12] = t4;
    $[13] = t5;
    $[14] = t6;
  } else {
    t6 = $[14];
  }
  return t6;
};
const Arguments = (t0) => {
  const $ = c(12);
  const {
    field
  } = t0;
  const [showDeprecated, setShowDeprecated] = useState(false);
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = () => {
      setShowDeprecated(true);
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const handleShowDeprecated = t1;
  if (!("args" in field)) {
    return null;
  }
  let args;
  let deprecatedArgs;
  let t2;
  if ($[1] !== field.args) {
    args = [];
    deprecatedArgs = [];
    for (const argument of field.args) {
      if (argument.deprecationReason) {
        deprecatedArgs.push(argument);
      } else {
        args.push(argument);
      }
    }
    t2 = args.length > 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Arguments", children: args.map(_temp) }) : null;
    $[1] = field.args;
    $[2] = args;
    $[3] = deprecatedArgs;
    $[4] = t2;
  } else {
    args = $[2];
    deprecatedArgs = $[3];
    t2 = $[4];
  }
  let t3;
  if ($[5] !== args.length || $[6] !== deprecatedArgs || $[7] !== showDeprecated) {
    t3 = deprecatedArgs.length > 0 ? showDeprecated || args.length === 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Deprecated Arguments", children: deprecatedArgs.map(_temp2) }) : /* @__PURE__ */ jsx(Button, { type: "button", onClick: handleShowDeprecated, children: "Show Deprecated Arguments" }) : null;
    $[5] = args.length;
    $[6] = deprecatedArgs;
    $[7] = showDeprecated;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  let t4;
  if ($[9] !== t2 || $[10] !== t3) {
    t4 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t2,
      t3
    ] });
    $[9] = t2;
    $[10] = t3;
    $[11] = t4;
  } else {
    t4 = $[11];
  }
  return t4;
};
const Directives = (t0) => {
  var _a;
  const $ = c(4);
  const {
    field
  } = t0;
  const directives = (_a = field.astNode) == null ? void 0 : _a.directives;
  if (!(directives == null ? void 0 : directives.length)) {
    return null;
  }
  let t1;
  if ($[0] !== directives) {
    t1 = directives.map(_temp3);
    $[0] = directives;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] !== t1) {
    t2 = /* @__PURE__ */ jsx(ExplorerSection, { title: "Directives", children: t1 });
    $[2] = t1;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  return t2;
};
function _temp(arg) {
  return /* @__PURE__ */ jsx(Argument, { arg }, arg.name);
}
function _temp2(arg_0) {
  return /* @__PURE__ */ jsx(Argument, { arg: arg_0 }, arg_0.name);
}
function _temp3(directive) {
  return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(Directive, { directive }) }, directive.name.value);
}
export {
  FieldDocumentation
};
//# sourceMappingURL=field-documentation.js.map
