import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { MarkdownContent } from "@graphiql/react";
import { ExplorerSection } from "./section.js";
import { TypeLink } from "./type-link.js";
/* empty css                         */
const SchemaDocumentation = (t0) => {
  const $ = c(43);
  const {
    schema
  } = t0;
  let t1;
  if ($[0] !== schema) {
    t1 = schema.getQueryType();
    $[0] = schema;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const queryType = t1;
  let t2;
  if ($[2] !== schema) {
    t2 = schema.getMutationType();
    $[2] = schema;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  const mutationType = t2;
  let t3;
  if ($[4] !== schema) {
    t3 = schema.getSubscriptionType();
    $[4] = schema;
    $[5] = t3;
  } else {
    t3 = $[5];
  }
  const subscriptionType = t3;
  let T0;
  let t4;
  let t5;
  let t6;
  let t7;
  if ($[6] !== mutationType || $[7] !== queryType || $[8] !== schema || $[9] !== subscriptionType) {
    const typeMap = schema.getTypeMap();
    const t82 = queryType == null ? void 0 : queryType.name;
    const t92 = mutationType == null ? void 0 : mutationType.name;
    const t102 = subscriptionType == null ? void 0 : subscriptionType.name;
    let t11;
    if ($[15] !== t102 || $[16] !== t82 || $[17] !== t92) {
      t11 = [t82, t92, t102];
      $[15] = t102;
      $[16] = t82;
      $[17] = t92;
      $[18] = t11;
    } else {
      t11 = $[18];
    }
    const ignoreTypesInAllSchema = t11;
    const t12 = schema.description || "A GraphQL schema provides a root type for each kind of operation.";
    if ($[19] !== t12) {
      t6 = /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: t12 });
      $[19] = t12;
      $[20] = t6;
    } else {
      t6 = $[20];
    }
    let t13;
    if ($[21] !== queryType) {
      t13 = queryType ? /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-root-type", children: "query" }),
        ": ",
        /* @__PURE__ */ jsx(TypeLink, { type: queryType })
      ] }) : null;
      $[21] = queryType;
      $[22] = t13;
    } else {
      t13 = $[22];
    }
    let t14;
    if ($[23] !== mutationType) {
      t14 = mutationType && /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-root-type", children: "mutation" }),
        ": ",
        /* @__PURE__ */ jsx(TypeLink, { type: mutationType })
      ] });
      $[23] = mutationType;
      $[24] = t14;
    } else {
      t14 = $[24];
    }
    let t15;
    if ($[25] !== subscriptionType) {
      t15 = subscriptionType && /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-root-type", children: "subscription" }),
        ": ",
        /* @__PURE__ */ jsx(TypeLink, { type: subscriptionType })
      ] });
      $[25] = subscriptionType;
      $[26] = t15;
    } else {
      t15 = $[26];
    }
    if ($[27] !== t13 || $[28] !== t14 || $[29] !== t15) {
      t7 = /* @__PURE__ */ jsxs(ExplorerSection, { title: "Root Types", children: [
        t13,
        t14,
        t15
      ] });
      $[27] = t13;
      $[28] = t14;
      $[29] = t15;
      $[30] = t7;
    } else {
      t7 = $[30];
    }
    T0 = ExplorerSection;
    t5 = "All Schema Types";
    let t16;
    if ($[31] !== ignoreTypesInAllSchema) {
      t16 = (type) => {
        if (ignoreTypesInAllSchema.includes(type.name) || type.name.startsWith("__")) {
          return null;
        }
        return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(TypeLink, { type }) }, type.name);
      };
      $[31] = ignoreTypesInAllSchema;
      $[32] = t16;
    } else {
      t16 = $[32];
    }
    t4 = Object.values(typeMap).map(t16);
    $[6] = mutationType;
    $[7] = queryType;
    $[8] = schema;
    $[9] = subscriptionType;
    $[10] = T0;
    $[11] = t4;
    $[12] = t5;
    $[13] = t6;
    $[14] = t7;
  } else {
    T0 = $[10];
    t4 = $[11];
    t5 = $[12];
    t6 = $[13];
    t7 = $[14];
  }
  let t8;
  if ($[33] !== t4) {
    t8 = /* @__PURE__ */ jsx("div", { children: t4 });
    $[33] = t4;
    $[34] = t8;
  } else {
    t8 = $[34];
  }
  let t9;
  if ($[35] !== T0 || $[36] !== t5 || $[37] !== t8) {
    t9 = /* @__PURE__ */ jsx(T0, { title: t5, children: t8 });
    $[35] = T0;
    $[36] = t5;
    $[37] = t8;
    $[38] = t9;
  } else {
    t9 = $[38];
  }
  let t10;
  if ($[39] !== t6 || $[40] !== t7 || $[41] !== t9) {
    t10 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t6,
      t7,
      t9
    ] });
    $[39] = t6;
    $[40] = t7;
    $[41] = t9;
    $[42] = t10;
  } else {
    t10 = $[42];
  }
  return t10;
};
export {
  SchemaDocumentation
};
//# sourceMappingURL=schema-documentation.js.map
