import { jsxs, jsx, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { isObjectType, isInterfaceType, isInputObjectType } from "graphql";
import { useRef, useState, useEffect } from "react";
import { ComboboxOptions, ComboboxOption, ComboboxInput, Combobox } from "@headlessui/react";
import { debounce, formatShortcutForOS, KEY_MAP, useGraphiQL, MagnifyingGlassIcon } from "@graphiql/react";
import { useDocExplorer, useDocExplorerActions } from "../context.js";
import { renderType } from "./utils.js";
/* empty css           */
const Search = () => {
  const $ = c(32);
  const explorerNavStack = useDocExplorer();
  const {
    push
  } = useDocExplorerActions();
  const inputRef = useRef(null);
  const getSearchResults = useSearchResults();
  const [searchValue, setSearchValue] = useState("");
  let t0;
  if ($[0] !== getSearchResults || $[1] !== searchValue) {
    t0 = () => getSearchResults(searchValue);
    $[0] = getSearchResults;
    $[1] = searchValue;
    $[2] = t0;
  } else {
    t0 = $[2];
  }
  const [results, setResults] = useState(t0);
  let t1;
  if ($[3] !== getSearchResults) {
    t1 = debounce(200, (search) => {
      setResults(getSearchResults(search));
    });
    $[3] = getSearchResults;
    $[4] = t1;
  } else {
    t1 = $[4];
  }
  const debouncedGetSearchResults = t1;
  const [ref] = useState(inputRef);
  const isFocused = ref.current === document.activeElement;
  let t2;
  let t3;
  if ($[5] !== debouncedGetSearchResults || $[6] !== searchValue) {
    t2 = () => {
      debouncedGetSearchResults(searchValue);
    };
    t3 = [debouncedGetSearchResults, searchValue];
    $[5] = debouncedGetSearchResults;
    $[6] = searchValue;
    $[7] = t2;
    $[8] = t3;
  } else {
    t2 = $[7];
    t3 = $[8];
  }
  useEffect(t2, t3);
  let navItem;
  let onSelect;
  let t4;
  if ($[9] !== explorerNavStack || $[10] !== push) {
    navItem = explorerNavStack.at(-1);
    let t52;
    if ($[14] !== push) {
      t52 = (def) => {
        if (!def) {
          return;
        }
        push("field" in def ? {
          name: def.field.name,
          def: def.field
        } : {
          name: def.type.name,
          def: def.type
        });
      };
      $[14] = push;
      $[15] = t52;
    } else {
      t52 = $[15];
    }
    onSelect = t52;
    t4 = explorerNavStack.length === 1 || isObjectType(navItem.def) || isInterfaceType(navItem.def) || isInputObjectType(navItem.def);
    $[9] = explorerNavStack;
    $[10] = push;
    $[11] = navItem;
    $[12] = onSelect;
    $[13] = t4;
  } else {
    navItem = $[11];
    onSelect = $[12];
    t4 = $[13];
  }
  const shouldSearchBoxAppear = t4;
  if (!shouldSearchBoxAppear) {
    return null;
  }
  const t5 = isFocused ? void 0 : "idle";
  const t6 = `Search ${navItem.name}...`;
  let t7;
  let t8;
  if ($[16] === Symbol.for("react.memo_cache_sentinel")) {
    t7 = () => {
      inputRef.current.focus();
    };
    t8 = /* @__PURE__ */ jsx(MagnifyingGlassIcon, {});
    $[16] = t7;
    $[17] = t8;
  } else {
    t7 = $[16];
    t8 = $[17];
  }
  let t10;
  let t9;
  if ($[18] === Symbol.for("react.memo_cache_sentinel")) {
    t9 = (event) => setSearchValue(event.target.value);
    t10 = formatShortcutForOS(formatShortcutForOS(KEY_MAP.searchInDocs.key).replaceAll("-", " "));
    $[18] = t10;
    $[19] = t9;
  } else {
    t10 = $[18];
    t9 = $[19];
  }
  let t11;
  if ($[20] !== searchValue || $[21] !== t10) {
    t11 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-search-input", onClick: t7, children: [
      t8,
      /* @__PURE__ */ jsx(ComboboxInput, { autoComplete: "off", onChange: t9, placeholder: t10, ref: inputRef, value: searchValue, "data-cy": "doc-explorer-input" })
    ] });
    $[20] = searchValue;
    $[21] = t10;
    $[22] = t11;
  } else {
    t11 = $[22];
  }
  let t12;
  if ($[23] !== isFocused || $[24] !== results) {
    t12 = isFocused && /* @__PURE__ */ jsxs(ComboboxOptions, { "data-cy": "doc-explorer-list", children: [
      results.within.length + results.types.length + results.fields.length === 0 ? /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-search-empty", children: "No results found" }) : results.within.map(_temp),
      results.within.length > 0 && results.types.length + results.fields.length > 0 ? /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-search-divider", children: "Other results" }) : null,
      results.types.map(_temp2),
      results.fields.map(_temp3)
    ] });
    $[23] = isFocused;
    $[24] = results;
    $[25] = t12;
  } else {
    t12 = $[25];
  }
  let t13;
  if ($[26] !== onSelect || $[27] !== t11 || $[28] !== t12 || $[29] !== t5 || $[30] !== t6) {
    t13 = /* @__PURE__ */ jsxs(Combobox, { as: "div", className: "graphiql-doc-explorer-search", onChange: onSelect, "data-state": t5, "aria-label": t6, children: [
      t11,
      t12
    ] });
    $[26] = onSelect;
    $[27] = t11;
    $[28] = t12;
    $[29] = t5;
    $[30] = t6;
    $[31] = t13;
  } else {
    t13 = $[31];
  }
  return t13;
};
function useSearchResults() {
  const $ = c(5);
  const explorerNavStack = useDocExplorer();
  const schema = useGraphiQL(_temp4);
  let t0;
  if ($[0] !== explorerNavStack) {
    t0 = explorerNavStack.at(-1);
    $[0] = explorerNavStack;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  const navItem = t0;
  let t1;
  if ($[2] !== navItem || $[3] !== schema) {
    t1 = (searchValue) => {
      const matches = {
        within: [],
        types: [],
        fields: []
      };
      if (!schema) {
        return matches;
      }
      const withinType = navItem.def;
      const typeMap = schema.getTypeMap();
      let typeNames = Object.keys(typeMap);
      if (withinType) {
        typeNames = typeNames.filter((n) => n !== withinType.name);
        typeNames.unshift(withinType.name);
      }
      for (const typeName of typeNames) {
        if (matches.within.length + matches.types.length + matches.fields.length >= 100) {
          break;
        }
        const type = typeMap[typeName];
        if (withinType !== type && isMatch(typeName, searchValue)) {
          matches.types.push({
            type
          });
        }
        if (!isObjectType(type) && !isInterfaceType(type) && !isInputObjectType(type)) {
          continue;
        }
        const fields = type.getFields();
        for (const fieldName in fields) {
          const field = fields[fieldName];
          let matchingArgs;
          if (!isMatch(fieldName, searchValue)) {
            if ("args" in field) {
              matchingArgs = field.args.filter((arg) => isMatch(arg.name, searchValue));
              if (matchingArgs.length === 0) {
                continue;
              }
            } else {
              continue;
            }
          }
          matches[withinType === type ? "within" : "fields"].push(...matchingArgs ? matchingArgs.map((argument) => ({
            type,
            field,
            argument
          })) : [{
            type,
            field
          }]);
        }
      }
      return matches;
    };
    $[2] = navItem;
    $[3] = schema;
    $[4] = t1;
  } else {
    t1 = $[4];
  }
  return t1;
}
function _temp4(state) {
  return state.schema;
}
function isMatch(sourceText, searchValue) {
  try {
    const escaped = searchValue.replaceAll(/[^_0-9A-Za-z]/g, (ch) => "\\" + ch);
    return new RegExp(escaped, "i").test(sourceText);
  } catch {
    return sourceText.toLowerCase().includes(searchValue.toLowerCase());
  }
}
const Type = (t0) => {
  const $ = c(2);
  const {
    type
  } = t0;
  let t1;
  if ($[0] !== type.name) {
    t1 = /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-type", children: type.name });
    $[0] = type.name;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  return t1;
};
const Field = (t0) => {
  const $ = c(7);
  const {
    field,
    argument
  } = t0;
  let t1;
  if ($[0] !== field.name) {
    t1 = /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-field", children: field.name });
    $[0] = field.name;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] !== argument) {
    t2 = argument ? /* @__PURE__ */ jsxs(Fragment, { children: [
      "(",
      /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-argument", children: argument.name }),
      ":",
      " ",
      renderType(argument.type, _temp5),
      ")"
    ] }) : null;
    $[2] = argument;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  let t3;
  if ($[4] !== t1 || $[5] !== t2) {
    t3 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t1,
      t2
    ] });
    $[4] = t1;
    $[5] = t2;
    $[6] = t3;
  } else {
    t3 = $[6];
  }
  return t3;
};
function _temp(result, i) {
  return /* @__PURE__ */ jsx(ComboboxOption, { value: result, "data-cy": "doc-explorer-option", children: /* @__PURE__ */ jsx(Field, { field: result.field, argument: result.argument }) }, `within-${i}`);
}
function _temp2(result_0, i_0) {
  return /* @__PURE__ */ jsx(ComboboxOption, { value: result_0, "data-cy": "doc-explorer-option", children: /* @__PURE__ */ jsx(Type, { type: result_0.type }) }, `type-${i_0}`);
}
function _temp3(result_1, i_1) {
  return /* @__PURE__ */ jsxs(ComboboxOption, { value: result_1, "data-cy": "doc-explorer-option", children: [
    /* @__PURE__ */ jsx(Type, { type: result_1.type }),
    ".",
    /* @__PURE__ */ jsx(Field, { field: result_1.field, argument: result_1.argument })
  ] }, `field-${i_1}`);
}
function _temp5(namedType) {
  return /* @__PURE__ */ jsx(Type, { type: namedType });
}
export {
  Search,
  useSearchResults
};
//# sourceMappingURL=search.js.map
