import { GraphQLArgument, GraphQLField, GraphQLInputField, GraphQLNamedType, GraphQLSchema } from 'graphql';
import { FC, ReactNode } from 'react';
import { SchemaReference, GraphiQLPlugin } from '@graphiql/react';
export declare const DOC_EXPLORER_PLUGIN: GraphiQLPlugin;
export declare type DocExplorerFieldDef = GraphQLField<unknown, unknown> | GraphQLInputField | GraphQLArgument;
export declare type DocExplorerNavStackItem = {
    /**
     * The name of the item.
     */
    name: string;
    /**
     * The definition object of the item, this can be a named type, a field, an
     * input field or an argument.
     */
    def?: GraphQLNamedType | DocExplorerFieldDef;
};
export declare type DocExplorerNavStack = [
    DocExplorerNavStackItem,
    ...DocExplorerNavStackItem[]
];
export declare type DocExplorerStoreType = {
    /**
     * A stack of navigation items. The last item in the list is the current one.
     * This list always contains at least one item.
     */
    explorerNavStack: DocExplorerNavStack;
    actions: {
        /**
         * Push an item to the navigation stack.
         * @param item The item that should be pushed to the stack.
         */
        push(item: DocExplorerNavStackItem): void;
        /**
         * Pop the last item from the navigation stack.
         */
        pop(): void;
        /**
         * Reset the navigation stack to its initial state, this will remove all but
         * the initial stack item.
         */
        reset(): void;
        resolveSchemaReferenceToNavItem(schemaReference: SchemaReference | null): void;
        /**
         * Replace the nav stack with an updated version using the new schema.
         */
        rebuildNavStackWithSchema(schema: GraphQLSchema): void;
    };
};
export declare const docExplorerStore: import('zustand').StoreApi<DocExplorerStoreType>;
export declare const DocExplorerStore: FC<{
    children: ReactNode;
}>;
export declare const useDocExplorer: () => DocExplorerNavStack;
/**
 * Actions are functions used to update values in your store. They are static and never change.
 * @see https://tkdodo.eu/blog/working-with-zustand#separate-actions-from-state
 */
export declare const useDocExplorerActions: () => {
    /**
     * Push an item to the navigation stack.
     * @param item The item that should be pushed to the stack.
     */
    push(item: DocExplorerNavStackItem): void;
    /**
     * Pop the last item from the navigation stack.
     */
    pop(): void;
    /**
     * Reset the navigation stack to its initial state, this will remove all but
     * the initial stack item.
     */
    reset(): void;
    resolveSchemaReferenceToNavItem(schemaReference: SchemaReference | null): void;
    /**
     * Replace the nav stack with an updated version using the new schema.
     */
    rebuildNavStackWithSchema(schema: GraphQLSchema): void;
};
