import { GraphQLEnumType, GraphQLNamedType, GraphQLField, GraphQLArgument, GraphQLDirective, GraphQLSchema, GraphQLEnumValue } from 'graphql';
import { Maybe } from 'graphql/jsutils/Maybe';
/**
 * Copied from packages/codemirror-graphql/src/jump.ts
 */
export declare function getSchemaReference(kind: string, typeInfo: any): FieldReference | DirectiveReference | ArgumentReference | EnumValueReference | TypeReference | undefined;
declare type ArgumentReference = {
    kind: 'Argument';
    argument: GraphQLArgument;
    field?: GraphQLField<unknown, unknown>;
    type?: GraphQLNamedType;
    directive?: GraphQLDirective;
    schema?: GraphQLSchema;
};
declare type DirectiveReference = {
    kind: 'Directive';
    directive: GraphQLDirective;
    schema?: GraphQLSchema;
};
declare type EnumValueReference = {
    kind: 'EnumValue';
    value?: GraphQLEnumValue;
    type?: GraphQLEnumType;
    schema?: GraphQLSchema;
};
declare type FieldReference = {
    kind: 'Field';
    field: GraphQLField<unknown, unknown>;
    type: Maybe<GraphQLNamedType>;
    schema?: GraphQLSchema;
};
declare type TypeReference = {
    kind: 'Type';
    type: GraphQLNamedType;
    schema?: GraphQLSchema;
};
export {};
