import { getNamedType } from "graphql";
function getSchemaReference(kind, typeInfo) {
  if (kind === "Field" && typeInfo.fieldDef || kind === "AliasedField" && typeInfo.fieldDef) {
    return getFieldReference(typeInfo);
  }
  if (kind === "Directive" && typeInfo.directiveDef) {
    return getDirectiveReference(typeInfo);
  }
  if (kind === "Argument" && typeInfo.argDef) {
    return getArgumentReference(typeInfo);
  }
  if (kind === "EnumValue" && typeInfo.enumValue) {
    return getEnumValueReference(typeInfo);
  }
  if (kind === "NamedType" && typeInfo.type) {
    return getTypeReference(typeInfo);
  }
}
function getArgumentReference(typeInfo) {
  return typeInfo.directiveDef ? {
    kind: "Argument",
    schema: typeInfo.schema,
    argument: typeInfo.argDef,
    directive: typeInfo.directiveDef
  } : {
    kind: "Argument",
    schema: typeInfo.schema,
    argument: typeInfo.argDef,
    field: typeInfo.fieldDef,
    type: isMetaField(typeInfo.fieldDef) ? null : typeInfo.parentType
  };
}
function getDirectiveReference(typeInfo) {
  return {
    kind: "Directive",
    schema: typeInfo.schema,
    directive: typeInfo.directiveDef
  };
}
function getFieldReference(typeInfo) {
  return {
    kind: "Field",
    schema: typeInfo.schema,
    field: typeInfo.fieldDef,
    type: isMetaField(typeInfo.fieldDef) ? null : typeInfo.parentType
  };
}
function getTypeReference(typeInfo, type) {
  return {
    kind: "Type",
    schema: typeInfo.schema,
    type: type || typeInfo.type
  };
}
function getEnumValueReference(typeInfo) {
  return {
    kind: "EnumValue",
    value: typeInfo.enumValue || void 0,
    type: typeInfo.inputType ? getNamedType(typeInfo.inputType) : void 0
  };
}
function isMetaField(fieldDef) {
  return fieldDef.name.slice(0, 2) === "__";
}
export {
  getSchemaReference
};
//# sourceMappingURL=schema-reference.js.map
