import { QueryStoreItem } from '@graphiql/toolkit';
import { ReactNode } from 'react';
export declare type HistoryContextType = {
    addToHistory(operation: {
        query?: string;
        variables?: string;
        headers?: string;
        operationName?: string;
    }): void;
    editLabel(args: {
        query?: string;
        variables?: string;
        headers?: string;
        operationName?: string;
        label?: string;
        favorite?: boolean;
    }): void;
    hide(): void;
    isVisible: boolean;
    items: readonly QueryStoreItem[];
    show(): void;
    toggle(): void;
    toggleFavorite(args: {
        query?: string;
        variables?: string;
        headers?: string;
        operationName?: string;
        label?: string;
        favorite?: boolean;
    }): void;
};
export declare const HistoryContext: import("react").Context<HistoryContextType | null>;
declare type HistoryContextProviderProps = {
    children: ReactNode;
    maxHistoryLength?: number;
    onToggle?(isOpen: boolean): void;
};
export declare function HistoryContextProvider(props: HistoryContextProviderProps): JSX.Element;
export declare const useHistoryContext: {
    (options: {
        nonNull: true;
        caller?: Function | undefined;
    }): HistoryContextType;
    (options: {
        nonNull?: boolean | undefined;
        caller?: Function | undefined;
    }): HistoryContextType | null;
    (): HistoryContextType | null;
};
export {};
