import { Fetcher } from '@graphiql/toolkit';
import { GraphQLError, GraphQLSchema, IntrospectionQuery } from 'graphql';
import { ReactNode } from 'react';
/**
 * There's a semantic difference between `null` and `undefined`:
 * - When `null` is passed explicitly as prop, GraphiQL will run schema-less
 *   (i.e. it will never attempt to fetch the schema, even when calling the
 *   `introspect` function).
 * - When `schema` is `undefined` GraphiQL will attempt to fetch the schema
 *   when calling `introspect`.
 */
declare type MaybeGraphQLSchema = GraphQLSchema | null | undefined;
export declare type SchemaContextType = {
    fetchError: string | null;
    introspect(): void;
    isFetching: boolean;
    schema: MaybeGraphQLSchema;
    validationErrors: readonly GraphQLError[];
};
export declare const SchemaContext: import("react").Context<SchemaContextType | null>;
declare type SchemaContextProviderProps = {
    children: ReactNode;
    dangerouslyAssumeSchemaIsValid?: boolean;
    fetcher: Fetcher;
    onSchemaChange?(schema: GraphQLSchema): void;
    schema?: GraphQLSchema | IntrospectionQuery | null;
} & IntrospectionArgs;
export declare function SchemaContextProvider(props: SchemaContextProviderProps): JSX.Element;
export declare const useSchemaContext: {
    (options: {
        nonNull: true;
        caller?: Function | undefined;
    }): SchemaContextType;
    (options: {
        nonNull?: boolean | undefined;
        caller?: Function | undefined;
    }): SchemaContextType | null;
    (): SchemaContextType | null;
};
declare type IntrospectionArgs = {
    inputValueDeprecation?: boolean;
    introspectionQueryName?: string;
    schemaDescription?: boolean;
};
export {};
