/// <reference types="react" />
declare type ResizableElement = 'first' | 'second';
declare type UseDragResizeArgs = {
    defaultSizeRelation?: number;
    direction: 'horizontal' | 'vertical';
    initiallyHidden?: ResizableElement;
    onHiddenElementChange?(hiddenElement: ResizableElement | null): void;
    sizeThresholdFirst?: number;
    sizeThresholdSecond?: number;
    storageKey?: string;
};
export declare function useDragResize({ defaultSizeRelation, direction, initiallyHidden, onHiddenElementChange, sizeThresholdFirst, sizeThresholdSecond, storageKey, }: UseDragResizeArgs): {
    dragBarRef: import("react").RefObject<HTMLDivElement>;
    hiddenElement: ResizableElement | null;
    firstRef: import("react").RefObject<HTMLDivElement>;
    setHiddenElement: (element: ResizableElement | null) => void;
    secondRef: import("react").RefObject<HTMLDivElement>;
};
export {};
