import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import * as React from "react";
import { createContext, useContext, useRef, useState, useEffect, forwardRef, useMemo, useCallback, useLayoutEffect } from "react";
import { clsx } from "clsx";
import { print, astFromValue, validateSchema, getIntrospectionQuery, isSchema, buildClientSchema, isNamedType, isObjectType, isInputObjectType, isScalarType, isEnumType, isInterfaceType, isUnionType, isNonNullType, isListType, isAbstractType, isType, parse, visit } from "graphql";
import { StorageAPI, HistoryStore, formatResult, isObservable, formatError, isAsyncIterable, fetcherReturnToPromise, isPromise, mergeAst, fillLeafs, getSelectedOperationName } from "@graphiql/toolkit";
import { getFragmentDependenciesForAST, GraphQLDocumentMode, getOperationFacts } from "graphql-language-service";
import setValue from "set-value";
import getValue from "get-value";
import copyToClipboard from "copy-to-clipboard";
import * as D from "@radix-ui/react-dialog";
import { Root } from "@radix-ui/react-visually-hidden";
import { Trigger, Root as Root$1, Portal, Content as Content$1, Item as Item$1 } from "@radix-ui/react-dropdown-menu";
import MarkdownIt from "markdown-it";
import { Reorder } from "framer-motion";
import * as T from "@radix-ui/react-tooltip";
import { Combobox } from "@headlessui/react";
import ReactDOM from "react-dom";
function createNullableContext(name) {
  const context = createContext(null);
  context.displayName = name;
  return context;
}
function createContextHook(context) {
  function useGivenContext(options) {
    var _a;
    const value = useContext(context);
    if (value === null && (options == null ? void 0 : options.nonNull)) {
      throw new Error(`Tried to use \`${((_a = options.caller) == null ? void 0 : _a.name) || "a component"}\` without the necessary context. Make sure to render the \`${context.displayName}Provider\` component higher up the tree.`);
    }
    return value;
  }
  Object.defineProperty(useGivenContext, "name", {
    value: `use${context.displayName}`
  });
  return useGivenContext;
}
const StorageContext = createNullableContext("StorageContext");
function StorageContextProvider(props) {
  const $ = c(8);
  const isInitialRender = useRef(true);
  let t0;
  if ($[0] !== props.storage) {
    t0 = () => new StorageAPI(props.storage);
    $[0] = props.storage;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  const [storage, setStorage] = useState(t0);
  let t1;
  let t2;
  if ($[2] !== props.storage) {
    t1 = () => {
      if (isInitialRender.current) {
        isInitialRender.current = false;
      } else {
        setStorage(new StorageAPI(props.storage));
      }
    };
    t2 = [props.storage];
    $[2] = props.storage;
    $[3] = t1;
    $[4] = t2;
  } else {
    t1 = $[3];
    t2 = $[4];
  }
  useEffect(t1, t2);
  let t3;
  if ($[5] !== props.children || $[6] !== storage) {
    t3 = /* @__PURE__ */ jsx(StorageContext.Provider, { value: storage, children: props.children });
    $[5] = props.children;
    $[6] = storage;
    $[7] = t3;
  } else {
    t3 = $[7];
  }
  return t3;
}
const useStorageContext = createContextHook(StorageContext);
const SvgArgument = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 14 14", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M5.0484 1.40838C6.12624 0.33054 7.87376 0.330541 8.9516 1.40838L12.5916 5.0484C13.6695 6.12624 13.6695 7.87376 12.5916 8.9516L8.9516 12.5916C7.87376 13.6695 6.12624 13.6695 5.0484 12.5916L1.40838 8.9516C0.33054 7.87376 0.330541 6.12624 1.40838 5.0484L5.0484 1.40838Z", stroke: "currentColor", strokeWidth: 1.2 }), /* @__PURE__ */ React.createElement("rect", { x: 6, y: 6, width: 2, height: 2, rx: 1, fill: "currentColor" }));
const SvgChevronDown = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 14 9", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M1 1L7 7L13 1", stroke: "currentColor", strokeWidth: 1.5 }));
const SvgChevronLeft = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 7 10", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M6 1.04819L2 5.04819L6 9.04819", stroke: "currentColor", strokeWidth: 1.75 }));
const SvgChevronUp = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 14 9", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M13 8L7 2L1 8", stroke: "currentColor", strokeWidth: 1.5 }));
const SvgClose = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 14 14", stroke: "currentColor", strokeWidth: 3, xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M1 1L12.9998 12.9997" }), /* @__PURE__ */ React.createElement("path", { d: "M13 1L1.00079 13.0003" }));
const SvgCopy = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "-2 -2 22 22", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M11.25 14.2105V15.235C11.25 16.3479 10.3479 17.25 9.23501 17.25H2.76499C1.65214 17.25 0.75 16.3479 0.75 15.235L0.75 8.76499C0.75 7.65214 1.65214 6.75 2.76499 6.75L3.78947 6.75", stroke: "currentColor", strokeWidth: 1.5 }), /* @__PURE__ */ React.createElement("rect", { x: 6.75, y: 0.75, width: 10.5, height: 10.5, rx: 2.2069, stroke: "currentColor", strokeWidth: 1.5 }));
const SvgDeprecatedArgument = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 14 14", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M5.0484 1.40838C6.12624 0.33054 7.87376 0.330541 8.9516 1.40838L12.5916 5.0484C13.6695 6.12624 13.6695 7.87376 12.5916 8.9516L8.9516 12.5916C7.87376 13.6695 6.12624 13.6695 5.0484 12.5916L1.40838 8.9516C0.33054 7.87376 0.330541 6.12624 1.40838 5.0484L5.0484 1.40838Z", stroke: "currentColor", strokeWidth: 1.2 }), /* @__PURE__ */ React.createElement("path", { d: "M5 9L9 5", stroke: "currentColor", strokeWidth: 1.2 }), /* @__PURE__ */ React.createElement("path", { d: "M5 5L9 9", stroke: "currentColor", strokeWidth: 1.2 }));
const SvgDeprecatedEnumValue = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 12 12", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M4 8L8 4", stroke: "currentColor", strokeWidth: 1.2 }), /* @__PURE__ */ React.createElement("path", { d: "M4 4L8 8", stroke: "currentColor", strokeWidth: 1.2 }), /* @__PURE__ */ React.createElement("path", { fillRule: "evenodd", clipRule: "evenodd", d: "M8.5 1.2H9C9.99411 1.2 10.8 2.00589 10.8 3V9C10.8 9.99411 9.99411 10.8 9 10.8H8.5V12H9C10.6569 12 12 10.6569 12 9V3C12 1.34315 10.6569 0 9 0H8.5V1.2ZM3.5 1.2V0H3C1.34315 0 0 1.34315 0 3V9C0 10.6569 1.34315 12 3 12H3.5V10.8H3C2.00589 10.8 1.2 9.99411 1.2 9V3C1.2 2.00589 2.00589 1.2 3 1.2H3.5Z", fill: "currentColor" }));
const SvgDeprecatedField = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 12 12", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("rect", { x: 0.6, y: 0.6, width: 10.8, height: 10.8, rx: 3.4, stroke: "currentColor", strokeWidth: 1.2 }), /* @__PURE__ */ React.createElement("path", { d: "M4 8L8 4", stroke: "currentColor", strokeWidth: 1.2 }), /* @__PURE__ */ React.createElement("path", { d: "M4 4L8 8", stroke: "currentColor", strokeWidth: 1.2 }));
const SvgDirective = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0.5 12 12", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("rect", { x: 7, y: 5.5, width: 2, height: 2, rx: 1, transform: "rotate(90 7 5.5)", fill: "currentColor" }), /* @__PURE__ */ React.createElement("path", { fillRule: "evenodd", clipRule: "evenodd", d: "M10.8 9L10.8 9.5C10.8 10.4941 9.99411 11.3 9 11.3L3 11.3C2.00589 11.3 1.2 10.4941 1.2 9.5L1.2 9L-3.71547e-07 9L-3.93402e-07 9.5C-4.65826e-07 11.1569 1.34314 12.5 3 12.5L9 12.5C10.6569 12.5 12 11.1569 12 9.5L12 9L10.8 9ZM10.8 4L12 4L12 3.5C12 1.84315 10.6569 0.5 9 0.5L3 0.5C1.34315 0.5 -5.87117e-08 1.84315 -1.31135e-07 3.5L-1.5299e-07 4L1.2 4L1.2 3.5C1.2 2.50589 2.00589 1.7 3 1.7L9 1.7C9.99411 1.7 10.8 2.50589 10.8 3.5L10.8 4Z", fill: "currentColor" }));
const SvgDocsFilled = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 20 24", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M0.75 3C0.75 1.75736 1.75736 0.75 3 0.75H17.25C17.8023 0.75 18.25 1.19772 18.25 1.75V5.25", stroke: "currentColor", strokeWidth: 1.5 }), /* @__PURE__ */ React.createElement("path", { d: "M0.75 3C0.75 4.24264 1.75736 5.25 3 5.25H18.25C18.8023 5.25 19.25 5.69771 19.25 6.25V22.25C19.25 22.8023 18.8023 23.25 18.25 23.25H3C1.75736 23.25 0.75 22.2426 0.75 21V3Z", stroke: "currentColor", strokeWidth: 1.5 }), /* @__PURE__ */ React.createElement("path", { fillRule: "evenodd", clipRule: "evenodd", d: "M3 5.25C1.75736 5.25 0.75 4.24264 0.75 3V21C0.75 22.2426 1.75736 23.25 3 23.25H18.25C18.8023 23.25 19.25 22.8023 19.25 22.25V6.25C19.25 5.69771 18.8023 5.25 18.25 5.25H3ZM13 11L6 11V12.5L13 12.5V11Z", fill: "currentColor" }));
const SvgDocs = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 20 24", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M0.75 3C0.75 4.24264 1.75736 5.25 3 5.25H17.25M0.75 3C0.75 1.75736 1.75736 0.75 3 0.75H16.25C16.8023 0.75 17.25 1.19772 17.25 1.75V5.25M0.75 3V21C0.75 22.2426 1.75736 23.25 3 23.25H18.25C18.8023 23.25 19.25 22.8023 19.25 22.25V6.25C19.25 5.69771 18.8023 5.25 18.25 5.25H17.25", stroke: "currentColor", strokeWidth: 1.5 }), /* @__PURE__ */ React.createElement("line", { x1: 13, y1: 11.75, x2: 6, y2: 11.75, stroke: "currentColor", strokeWidth: 1.5 }));
const SvgEnumValue = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 12 12", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("rect", { x: 5, y: 5, width: 2, height: 2, rx: 1, fill: "currentColor" }), /* @__PURE__ */ React.createElement("path", { fillRule: "evenodd", clipRule: "evenodd", d: "M8.5 1.2H9C9.99411 1.2 10.8 2.00589 10.8 3V9C10.8 9.99411 9.99411 10.8 9 10.8H8.5V12H9C10.6569 12 12 10.6569 12 9V3C12 1.34315 10.6569 0 9 0H8.5V1.2ZM3.5 1.2V0H3C1.34315 0 0 1.34315 0 3V9C0 10.6569 1.34315 12 3 12H3.5V10.8H3C2.00589 10.8 1.2 9.99411 1.2 9V3C1.2 2.00589 2.00589 1.2 3 1.2H3.5Z", fill: "currentColor" }));
const SvgField = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 12 13", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("rect", { x: 0.6, y: 1.1, width: 10.8, height: 10.8, rx: 2.4, stroke: "currentColor", strokeWidth: 1.2 }), /* @__PURE__ */ React.createElement("rect", { x: 5, y: 5.5, width: 2, height: 2, rx: 1, fill: "currentColor" }));
const SvgHistory = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 24 20", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M1.59375 9.52344L4.87259 12.9944L8.07872 9.41249", stroke: "currentColor", strokeWidth: 1.5, strokeLinecap: "square" }), /* @__PURE__ */ React.createElement("path", { d: "M13.75 5.25V10.75H18.75", stroke: "currentColor", strokeWidth: 1.5, strokeLinecap: "square" }), /* @__PURE__ */ React.createElement("path", { d: "M4.95427 11.9332C4.55457 10.0629 4.74441 8.11477 5.49765 6.35686C6.25089 4.59894 7.5305 3.11772 9.16034 2.11709C10.7902 1.11647 12.6901 0.645626 14.5986 0.769388C16.5071 0.893151 18.3303 1.60543 19.8172 2.80818C21.3042 4.01093 22.3818 5.64501 22.9017 7.48548C23.4216 9.32595 23.3582 11.2823 22.7203 13.0853C22.0824 14.8883 20.9013 16.4492 19.3396 17.5532C17.778 18.6572 15.9125 19.25 14 19.25", stroke: "currentColor", strokeWidth: 1.5 }));
const SvgImplements = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 12 12", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("circle", { cx: 6, cy: 6, r: 5.4, stroke: "currentColor", strokeWidth: 1.2, strokeDasharray: "4.241025 4.241025", transform: "rotate(22.5)", "transform-origin": "center" }), /* @__PURE__ */ React.createElement("circle", { cx: 6, cy: 6, r: 1, fill: "currentColor" }));
const SvgKeyboardShortcut = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 19 18", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M1.5 14.5653C1.5 15.211 1.75652 15.8303 2.21314 16.2869C2.66975 16.7435 3.28905 17 3.9348 17C4.58054 17 5.19984 16.7435 5.65646 16.2869C6.11307 15.8303 6.36959 15.211 6.36959 14.5653V12.1305H3.9348C3.28905 12.1305 2.66975 12.387 2.21314 12.8437C1.75652 13.3003 1.5 13.9195 1.5 14.5653Z", stroke: "currentColor", strokeWidth: 1.125, strokeLinecap: "round", strokeLinejoin: "round" }), /* @__PURE__ */ React.createElement("path", { d: "M3.9348 1.00063C3.28905 1.00063 2.66975 1.25715 2.21314 1.71375C1.75652 2.17035 1.5 2.78964 1.5 3.43537C1.5 4.0811 1.75652 4.70038 2.21314 5.15698C2.66975 5.61358 3.28905 5.8701 3.9348 5.8701H6.36959V3.43537C6.36959 2.78964 6.11307 2.17035 5.65646 1.71375C5.19984 1.25715 4.58054 1.00063 3.9348 1.00063Z", stroke: "currentColor", strokeWidth: 1.125, strokeLinecap: "round", strokeLinejoin: "round" }), /* @__PURE__ */ React.createElement("path", { d: "M15.0652 12.1305H12.6304V14.5653C12.6304 15.0468 12.7732 15.5175 13.0407 15.9179C13.3083 16.3183 13.6885 16.6304 14.1334 16.8147C14.5783 16.9989 15.0679 17.0472 15.5402 16.9532C16.0125 16.8593 16.4464 16.6274 16.7869 16.2869C17.1274 15.9464 17.3593 15.5126 17.4532 15.0403C17.5472 14.568 17.4989 14.0784 17.3147 13.6335C17.1304 13.1886 16.8183 12.8084 16.4179 12.5409C16.0175 12.2733 15.5468 12.1305 15.0652 12.1305Z", stroke: "currentColor", strokeWidth: 1.125, strokeLinecap: "round", strokeLinejoin: "round" }), /* @__PURE__ */ React.createElement("path", { d: "M12.6318 5.86775H6.36955V12.1285H12.6318V5.86775Z", stroke: "currentColor", strokeWidth: 1.125, strokeLinecap: "round", strokeLinejoin: "round" }), /* @__PURE__ */ React.createElement("path", { d: "M17.5 3.43473C17.5 2.789 17.2435 2.16972 16.7869 1.71312C16.3303 1.25652 15.711 1 15.0652 1C14.4195 1 13.8002 1.25652 13.3435 1.71312C12.8869 2.16972 12.6304 2.789 12.6304 3.43473V5.86946H15.0652C15.711 5.86946 16.3303 5.61295 16.7869 5.15635C17.2435 4.69975 17.5 4.08046 17.5 3.43473Z", stroke: "currentColor", strokeWidth: 1.125, strokeLinecap: "round", strokeLinejoin: "round" }));
const SvgMagnifyingGlass = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 13 13", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("circle", { cx: 5, cy: 5, r: 4.35, stroke: "currentColor", strokeWidth: 1.3 }), /* @__PURE__ */ React.createElement("line", { x1: 8.45962, y1: 8.54038, x2: 11.7525, y2: 11.8333, stroke: "currentColor", strokeWidth: 1.3 }));
const SvgMerge = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "-2 -2 22 22", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M17.2492 6V2.9569C17.2492 1.73806 16.2611 0.75 15.0423 0.75L2.9569 0.75C1.73806 0.75 0.75 1.73806 0.75 2.9569L0.75 6", stroke: "currentColor", strokeWidth: 1.5 }), /* @__PURE__ */ React.createElement("path", { d: "M0.749873 12V15.0431C0.749873 16.2619 1.73794 17.25 2.95677 17.25H15.0421C16.261 17.25 17.249 16.2619 17.249 15.0431V12", stroke: "currentColor", strokeWidth: 1.5 }), /* @__PURE__ */ React.createElement("path", { d: "M6 4.5L9 7.5L12 4.5", stroke: "currentColor", strokeWidth: 1.5 }), /* @__PURE__ */ React.createElement("path", { d: "M12 13.5L9 10.5L6 13.5", stroke: "currentColor", strokeWidth: 1.5 }));
const SvgPen = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 14 14", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M0.75 13.25L0.0554307 12.967C-0.0593528 13.2488 0.00743073 13.5719 0.224488 13.7851C0.441545 13.9983 0.765869 14.0592 1.04549 13.9393L0.75 13.25ZM12.8214 1.83253L12.2911 2.36286L12.2911 2.36286L12.8214 1.83253ZM12.8214 3.90194L13.3517 4.43227L12.8214 3.90194ZM10.0981 1.17859L9.56773 0.648259L10.0981 1.17859ZM12.1675 1.17859L12.6978 0.648258L12.6978 0.648257L12.1675 1.17859ZM2.58049 8.75697L3.27506 9.03994L2.58049 8.75697ZM2.70066 8.57599L3.23099 9.10632L2.70066 8.57599ZM5.2479 11.4195L4.95355 10.7297L5.2479 11.4195ZM5.42036 11.303L4.89003 10.7727L5.42036 11.303ZM4.95355 10.7297C4.08882 11.0987 3.41842 11.362 2.73535 11.6308C2.05146 11.9 1.35588 12.1743 0.454511 12.5607L1.04549 13.9393C1.92476 13.5624 2.60256 13.2951 3.28469 13.0266C3.96762 12.7578 4.65585 12.4876 5.54225 12.1093L4.95355 10.7297ZM1.44457 13.533L3.27506 9.03994L1.88592 8.474L0.0554307 12.967L1.44457 13.533ZM3.23099 9.10632L10.6284 1.70892L9.56773 0.648259L2.17033 8.04566L3.23099 9.10632ZM11.6371 1.70892L12.2911 2.36286L13.3517 1.3022L12.6978 0.648258L11.6371 1.70892ZM12.2911 3.37161L4.89003 10.7727L5.95069 11.8333L13.3517 4.43227L12.2911 3.37161ZM12.2911 2.36286C12.5696 2.64142 12.5696 3.09305 12.2911 3.37161L13.3517 4.43227C14.2161 3.56792 14.2161 2.16654 13.3517 1.3022L12.2911 2.36286ZM10.6284 1.70892C10.9069 1.43036 11.3586 1.43036 11.6371 1.70892L12.6978 0.648257C11.8335 -0.216088 10.4321 -0.216084 9.56773 0.648259L10.6284 1.70892ZM3.27506 9.03994C3.26494 9.06479 3.24996 9.08735 3.23099 9.10632L2.17033 8.04566C2.04793 8.16806 1.95123 8.31369 1.88592 8.474L3.27506 9.03994ZM5.54225 12.1093C5.69431 12.0444 5.83339 11.9506 5.95069 11.8333L4.89003 10.7727C4.90863 10.7541 4.92988 10.7398 4.95355 10.7297L5.54225 12.1093Z", fill: "currentColor" }), /* @__PURE__ */ React.createElement("path", { d: "M11.5 4.5L9.5 2.5", stroke: "currentColor", strokeWidth: 1.4026, strokeLinecap: "round", strokeLinejoin: "round" }), /* @__PURE__ */ React.createElement("path", { d: "M5.5 10.5L3.5 8.5", stroke: "currentColor", strokeWidth: 1.4026, strokeLinecap: "round", strokeLinejoin: "round" }));
const SvgPlay = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 16 18", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M1.32226e-07 1.6609C7.22332e-08 0.907329 0.801887 0.424528 1.46789 0.777117L15.3306 8.11621C16.0401 8.49182 16.0401 9.50818 15.3306 9.88379L1.46789 17.2229C0.801886 17.5755 1.36076e-06 17.0927 1.30077e-06 16.3391L1.32226e-07 1.6609Z", fill: "currentColor" }));
const SvgPlus = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 10 16", fill: "currentColor", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { fillRule: "evenodd", clipRule: "evenodd", d: "M4.25 9.25V13.5H5.75V9.25L10 9.25V7.75L5.75 7.75V3.5H4.25V7.75L0 7.75V9.25L4.25 9.25Z" }));
const SvgPrettify = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { width: 25, height: 25, viewBox: "0 0 25 25", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M10.2852 24.0745L13.7139 18.0742", stroke: "currentColor", strokeWidth: 1.5625 }), /* @__PURE__ */ React.createElement("path", { d: "M14.5742 24.0749L17.1457 19.7891", stroke: "currentColor", strokeWidth: 1.5625 }), /* @__PURE__ */ React.createElement("path", { d: "M19.4868 24.0735L20.7229 21.7523C21.3259 20.6143 21.5457 19.3122 21.3496 18.0394C21.1535 16.7666 20.5519 15.591 19.6342 14.6874L23.7984 6.87853C24.0123 6.47728 24.0581 6.00748 23.9256 5.57249C23.7932 5.1375 23.4933 4.77294 23.0921 4.55901C22.6908 4.34509 22.221 4.29932 21.7861 4.43178C21.3511 4.56424 20.9865 4.86408 20.7726 5.26533L16.6084 13.0742C15.3474 12.8142 14.0362 12.9683 12.8699 13.5135C11.7035 14.0586 10.7443 14.9658 10.135 16.1L6 24.0735", stroke: "currentColor", strokeWidth: 1.5625 }), /* @__PURE__ */ React.createElement("path", { d: "M4 15L5 13L7 12L5 11L4 9L3 11L1 12L3 13L4 15Z", stroke: "currentColor", strokeWidth: 1.5625, strokeLinejoin: "round" }), /* @__PURE__ */ React.createElement("path", { d: "M11.5 8L12.6662 5.6662L15 4.5L12.6662 3.3338L11.5 1L10.3338 3.3338L8 4.5L10.3338 5.6662L11.5 8Z", stroke: "currentColor", strokeWidth: 1.5625, strokeLinejoin: "round" }));
const SvgReload = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 16 16", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M4.75 9.25H1.25V12.75", stroke: "currentColor", strokeWidth: 1, strokeLinecap: "square" }), /* @__PURE__ */ React.createElement("path", { d: "M11.25 6.75H14.75V3.25", stroke: "currentColor", strokeWidth: 1, strokeLinecap: "square" }), /* @__PURE__ */ React.createElement("path", { d: "M14.1036 6.65539C13.8 5.27698 13.0387 4.04193 11.9437 3.15131C10.8487 2.26069 9.48447 1.76694 8.0731 1.75043C6.66173 1.73392 5.28633 2.19563 4.17079 3.0604C3.05526 3.92516 2.26529 5.14206 1.92947 6.513", stroke: "currentColor", strokeWidth: 1 }), /* @__PURE__ */ React.createElement("path", { d: "M1.89635 9.34461C2.20001 10.723 2.96131 11.9581 4.05631 12.8487C5.15131 13.7393 6.51553 14.2331 7.9269 14.2496C9.33827 14.2661 10.7137 13.8044 11.8292 12.9396C12.9447 12.0748 13.7347 10.8579 14.0705 9.487", stroke: "currentColor", strokeWidth: 1 }));
const SvgRootType = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 13 13", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("rect", { x: 0.6, y: 0.6, width: 11.8, height: 11.8, rx: 5.9, stroke: "currentColor", strokeWidth: 1.2 }), /* @__PURE__ */ React.createElement("path", { d: "M4.25 7.5C4.25 6 5.75 5 6.5 6.5C7.25 8 8.75 7 8.75 5.5", stroke: "currentColor", strokeWidth: 1.2 }));
const SvgSettings = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 21 20", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { fillRule: "evenodd", clipRule: "evenodd", d: "M9.29186 1.92702C9.06924 1.82745 8.87014 1.68202 8.70757 1.50024L7.86631 0.574931C7.62496 0.309957 7.30773 0.12592 6.95791 0.0479385C6.60809 -0.0300431 6.24274 0.00182978 5.91171 0.139208C5.58068 0.276585 5.3001 0.512774 5.10828 0.815537C4.91645 1.1183 4.82272 1.47288 4.83989 1.83089L4.90388 3.08019C4.91612 3.32348 4.87721 3.56662 4.78968 3.79394C4.70215 4.02126 4.56794 4.2277 4.39571 4.39994C4.22347 4.57219 4.01704 4.7064 3.78974 4.79394C3.56243 4.88147 3.3193 4.92038 3.07603 4.90814L1.8308 4.84414C1.47162 4.82563 1.11553 4.91881 0.811445 5.11086C0.507359 5.30292 0.270203 5.58443 0.132561 5.91671C-0.00508149 6.249 -0.0364554 6.61576 0.0427496 6.9666C0.121955 7.31744 0.307852 7.63514 0.5749 7.87606L1.50016 8.71204C1.68193 8.87461 1.82735 9.07373 1.92692 9.29636C2.02648 9.51898 2.07794 9.76012 2.07794 10.004C2.07794 10.2479 2.02648 10.489 1.92692 10.7116C1.82735 10.9343 1.68193 11.1334 1.50016 11.296L0.5749 12.1319C0.309856 12.3729 0.125575 12.6898 0.0471809 13.0393C-0.0312128 13.3888 9.64098e-05 13.754 0.13684 14.0851C0.273583 14.4162 0.509106 14.6971 0.811296 14.8894C1.11349 15.0817 1.46764 15.1762 1.82546 15.1599L3.0707 15.0959C3.31397 15.0836 3.5571 15.1225 3.7844 15.2101C4.01171 15.2976 4.21814 15.4318 4.39037 15.6041C4.56261 15.7763 4.69682 15.9827 4.78435 16.2101C4.87188 16.4374 4.91078 16.6805 4.89855 16.9238L4.83455 18.1691C4.81605 18.5283 4.90921 18.8844 5.10126 19.1885C5.2933 19.4926 5.5748 19.7298 5.90707 19.8674C6.23934 20.0051 6.60608 20.0365 6.9569 19.9572C7.30772 19.878 7.6254 19.6921 7.86631 19.4251L8.7129 18.4998C8.87547 18.318 9.07458 18.1725 9.29719 18.073C9.51981 17.9734 9.76093 17.9219 10.0048 17.9219C10.2487 17.9219 10.4898 17.9734 10.7124 18.073C10.935 18.1725 11.1341 18.318 11.2967 18.4998L12.1326 19.4251C12.3735 19.6921 12.6912 19.878 13.042 19.9572C13.3929 20.0365 13.7596 20.0051 14.0919 19.8674C14.4241 19.7298 14.7056 19.4926 14.8977 19.1885C15.0897 18.8844 15.1829 18.5283 15.1644 18.1691L15.1004 16.9238C15.0882 16.6805 15.1271 16.4374 15.2146 16.2101C15.3021 15.9827 15.4363 15.7763 15.6086 15.6041C15.7808 15.4318 15.9872 15.2976 16.2145 15.2101C16.4418 15.1225 16.685 15.0836 16.9282 15.0959L18.1735 15.1599C18.5326 15.1784 18.8887 15.0852 19.1928 14.8931C19.4969 14.7011 19.7341 14.4196 19.8717 14.0873C20.0093 13.755 20.0407 13.3882 19.9615 13.0374C19.8823 12.6866 19.6964 12.3689 19.4294 12.1279L18.5041 11.292C18.3223 11.1294 18.1769 10.9303 18.0774 10.7076C17.9778 10.485 17.9263 10.2439 17.9263 10C17.9263 9.75612 17.9778 9.51499 18.0774 9.29236C18.1769 9.06973 18.3223 8.87062 18.5041 8.70804L19.4294 7.87206C19.6964 7.63114 19.8823 7.31344 19.9615 6.9626C20.0407 6.61176 20.0093 6.245 19.8717 5.91271C19.7341 5.58043 19.4969 5.29892 19.1928 5.10686C18.8887 4.91481 18.5326 4.82163 18.1735 4.84014L16.9282 4.90414C16.685 4.91638 16.4418 4.87747 16.2145 4.78994C15.9872 4.7024 15.7808 4.56818 15.6086 4.39594C15.4363 4.2237 15.3021 4.01726 15.2146 3.78994C15.1271 3.56262 15.0882 3.31948 15.1004 3.07619L15.1644 1.83089C15.1829 1.4717 15.0897 1.11559 14.8977 0.811487C14.7056 0.507385 14.4241 0.270217 14.0919 0.132568C13.7596 -0.00508182 13.3929 -0.0364573 13.042 0.0427519C12.6912 0.121961 12.3735 0.307869 12.1326 0.574931L11.2914 1.50024C11.1288 1.68202 10.9297 1.82745 10.7071 1.92702C10.4845 2.02659 10.2433 2.07805 9.99947 2.07805C9.7556 2.07805 9.51448 2.02659 9.29186 1.92702ZM14.3745 10C14.3745 12.4162 12.4159 14.375 9.99977 14.375C7.58365 14.375 5.625 12.4162 5.625 10C5.625 7.58375 7.58365 5.625 9.99977 5.625C12.4159 5.625 14.3745 7.58375 14.3745 10Z", fill: "currentColor" }));
const SvgStarFilled = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 14 14", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M6.5782 1.07092C6.71096 0.643026 7.28904 0.643027 7.4218 1.07092L8.59318 4.84622C8.65255 5.03758 8.82284 5.16714 9.01498 5.16714L12.8056 5.16714C13.2353 5.16714 13.4139 5.74287 13.0663 6.00732L9.99962 8.34058C9.84418 8.45885 9.77913 8.66848 9.83851 8.85984L11.0099 12.6351C11.1426 13.063 10.675 13.4189 10.3274 13.1544L7.26069 10.8211C7.10524 10.7029 6.89476 10.7029 6.73931 10.8211L3.6726 13.1544C3.32502 13.4189 2.85735 13.063 2.99012 12.6351L4.16149 8.85984C4.22087 8.66848 4.15582 8.45885 4.00038 8.34058L0.933671 6.00732C0.586087 5.74287 0.764722 5.16714 1.19436 5.16714L4.98502 5.16714C5.17716 5.16714 5.34745 5.03758 5.40682 4.84622L6.5782 1.07092Z", fill: "currentColor", stroke: "currentColor" }));
const SvgStar = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 14 14", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M6.5782 1.07092C6.71096 0.643026 7.28904 0.643027 7.4218 1.07092L8.59318 4.84622C8.65255 5.03758 8.82284 5.16714 9.01498 5.16714L12.8056 5.16714C13.2353 5.16714 13.4139 5.74287 13.0663 6.00732L9.99962 8.34058C9.84418 8.45885 9.77913 8.66848 9.83851 8.85984L11.0099 12.6351C11.1426 13.063 10.675 13.4189 10.3274 13.1544L7.26069 10.8211C7.10524 10.7029 6.89476 10.7029 6.73931 10.8211L3.6726 13.1544C3.32502 13.4189 2.85735 13.063 2.99012 12.6351L4.16149 8.85984C4.22087 8.66848 4.15582 8.45885 4.00038 8.34058L0.933671 6.00732C0.586087 5.74287 0.764722 5.16714 1.19436 5.16714L4.98502 5.16714C5.17716 5.16714 5.34745 5.03758 5.40682 4.84622L6.5782 1.07092Z", stroke: "currentColor", strokeWidth: 1.5 }));
const SvgStop = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 16 16", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("rect", { width: 16, height: 16, rx: 2, fill: "currentColor" }));
const SvgTrash = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { width: "1em", height: "5em", xmlns: "http://www.w3.org/2000/svg", fillRule: "evenodd", "aria-hidden": "true", viewBox: "0 0 23 23", style: {
  height: "1.5em"
}, clipRule: "evenodd", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("path", { d: "M19 24h-14c-1.104 0-2-.896-2-2v-17h-1v-2h6v-1.5c0-.827.673-1.5 1.5-1.5h5c.825 0 1.5.671 1.5 1.5v1.5h6v2h-1v17c0 1.104-.896 2-2 2zm0-19h-14v16.5c0 .276.224.5.5.5h13c.276 0 .5-.224.5-.5v-16.5zm-7 7.586l3.293-3.293 1.414 1.414-3.293 3.293 3.293 3.293-1.414 1.414-3.293-3.293-3.293 3.293-1.414-1.414 3.293-3.293-3.293-3.293 1.414-1.414 3.293 3.293zm2-10.586h-4v1h4v-1z", fill: "currentColor", strokeWidth: 0.25, stroke: "currentColor" }));
const SvgType = ({
  title,
  titleId,
  ...props
}) => /* @__PURE__ */ React.createElement("svg", { height: "1em", viewBox: "0 0 13 13", fill: "none", xmlns: "http://www.w3.org/2000/svg", "aria-labelledby": titleId, ...props }, title ? /* @__PURE__ */ React.createElement("title", { id: titleId }, title) : null, /* @__PURE__ */ React.createElement("rect", { x: 0.6, y: 0.6, width: 11.8, height: 11.8, rx: 5.9, stroke: "currentColor", strokeWidth: 1.2 }), /* @__PURE__ */ React.createElement("rect", { x: 5.5, y: 5.5, width: 2, height: 2, rx: 1, fill: "currentColor" }));
const ArgumentIcon = generateIcon(SvgArgument);
const ChevronDownIcon = generateIcon(SvgChevronDown);
const ChevronLeftIcon = generateIcon(SvgChevronLeft);
const ChevronUpIcon = generateIcon(SvgChevronUp);
const CloseIcon = generateIcon(SvgClose);
const CopyIcon = generateIcon(SvgCopy);
const DeprecatedArgumentIcon = generateIcon(SvgDeprecatedArgument);
const DeprecatedEnumValueIcon = generateIcon(SvgDeprecatedEnumValue);
const DeprecatedFieldIcon = generateIcon(SvgDeprecatedField);
const DirectiveIcon = generateIcon(SvgDirective);
const DocsFilledIcon = generateIcon(SvgDocsFilled);
const DocsIcon = generateIcon(SvgDocs);
const EnumValueIcon = generateIcon(SvgEnumValue);
const FieldIcon = generateIcon(SvgField);
const HistoryIcon = generateIcon(SvgHistory);
const ImplementsIcon = generateIcon(SvgImplements);
const KeyboardShortcutIcon = generateIcon(SvgKeyboardShortcut);
const MagnifyingGlassIcon = generateIcon(SvgMagnifyingGlass);
const MergeIcon = generateIcon(SvgMerge);
const PenIcon = generateIcon(SvgPen);
const PlayIcon = generateIcon(SvgPlay);
const PlusIcon = generateIcon(SvgPlus);
const PrettifyIcon = generateIcon(SvgPrettify);
const ReloadIcon = generateIcon(SvgReload);
const RootTypeIcon = generateIcon(SvgRootType);
const SettingsIcon = generateIcon(SvgSettings);
const StarFilledIcon = generateIcon(SvgStarFilled);
const StarIcon = generateIcon(SvgStar);
const StopIcon = generateIcon(SvgStop);
const TrashIcon = generateIcon(SvgTrash);
const TypeIcon = generateIcon(SvgType);
function generateIcon(RawComponent) {
  const title = RawComponent.name.replace("Svg", "").replaceAll(/([A-Z])/g, " $1").trimStart().toLowerCase() + " icon";
  function IconComponent(props) {
    const $ = c(2);
    let t0;
    if ($[0] !== props) {
      t0 = /* @__PURE__ */ jsx(RawComponent, { title, ...props });
      $[0] = props;
      $[1] = t0;
    } else {
      t0 = $[1];
    }
    return t0;
  }
  IconComponent.displayName = RawComponent.name;
  return IconComponent;
}
const UnStyledButton = forwardRef((props, ref) => {
  const $ = c(6);
  let t0;
  if ($[0] !== props.className) {
    t0 = clsx("graphiql-un-styled", props.className);
    $[0] = props.className;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== props || $[3] !== ref || $[4] !== t0) {
    t1 = /* @__PURE__ */ jsx("button", { ...props, ref, className: t0 });
    $[2] = props;
    $[3] = ref;
    $[4] = t0;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  return t1;
});
UnStyledButton.displayName = "UnStyledButton";
const Button$1 = forwardRef((props, ref) => {
  const $ = c(7);
  let t0;
  if ($[0] !== props.className || $[1] !== props.state) {
    t0 = clsx("graphiql-button", {
      success: "graphiql-button-success",
      error: "graphiql-button-error"
    }[props.state], props.className);
    $[0] = props.className;
    $[1] = props.state;
    $[2] = t0;
  } else {
    t0 = $[2];
  }
  let t1;
  if ($[3] !== props || $[4] !== ref || $[5] !== t0) {
    t1 = /* @__PURE__ */ jsx("button", { ...props, ref, className: t0 });
    $[3] = props;
    $[4] = ref;
    $[5] = t0;
    $[6] = t1;
  } else {
    t1 = $[6];
  }
  return t1;
});
Button$1.displayName = "Button";
const ButtonGroup = forwardRef((props, ref) => {
  const $ = c(6);
  let t0;
  if ($[0] !== props.className) {
    t0 = clsx("graphiql-button-group", props.className);
    $[0] = props.className;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== props || $[3] !== ref || $[4] !== t0) {
    t1 = /* @__PURE__ */ jsx("div", { ...props, ref, className: t0 });
    $[2] = props;
    $[3] = ref;
    $[4] = t0;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  return t1;
});
ButtonGroup.displayName = "ButtonGroup";
const createComponentGroup = (root, children) => Object.entries(children).reduce((r, [key, value]) => {
  r[key] = value;
  return r;
}, root);
const DialogClose = forwardRef((props, ref) => {
  const $ = c(8);
  let t0;
  if ($[0] !== props.className) {
    t0 = clsx("graphiql-dialog-close", props.className);
    $[0] = props.className;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  let t2;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = /* @__PURE__ */ jsx(Root, { children: "Close dialog" });
    t2 = /* @__PURE__ */ jsx(CloseIcon, {});
    $[2] = t1;
    $[3] = t2;
  } else {
    t1 = $[2];
    t2 = $[3];
  }
  let t3;
  if ($[4] !== props || $[5] !== ref || $[6] !== t0) {
    t3 = /* @__PURE__ */ jsx(D.Close, { asChild: true, children: /* @__PURE__ */ jsxs(UnStyledButton, { ...props, ref, type: "button", className: t0, children: [
      t1,
      t2
    ] }) });
    $[4] = props;
    $[5] = ref;
    $[6] = t0;
    $[7] = t3;
  } else {
    t3 = $[7];
  }
  return t3;
});
DialogClose.displayName = "Dialog.Close";
function DialogRoot(t0) {
  const $ = c(9);
  let children;
  let props;
  if ($[0] !== t0) {
    ({
      children,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = props;
  } else {
    children = $[1];
    props = $[2];
  }
  let t1;
  if ($[3] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = /* @__PURE__ */ jsx(D.Overlay, { className: "graphiql-dialog-overlay" });
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  let t2;
  if ($[4] !== children) {
    t2 = /* @__PURE__ */ jsxs(D.Portal, { children: [
      t1,
      /* @__PURE__ */ jsx(D.Content, { className: "graphiql-dialog", children })
    ] });
    $[4] = children;
    $[5] = t2;
  } else {
    t2 = $[5];
  }
  let t3;
  if ($[6] !== props || $[7] !== t2) {
    t3 = /* @__PURE__ */ jsx(D.Root, { ...props, children: t2 });
    $[6] = props;
    $[7] = t2;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  return t3;
}
const Dialog = createComponentGroup(DialogRoot, {
  Close: DialogClose,
  Title: D.Title,
  Trigger: D.Trigger,
  Description: D.Description
});
const Button = forwardRef((props, ref) => {
  const $ = c(6);
  let t0;
  if ($[0] !== props.className) {
    t0 = clsx("graphiql-un-styled", props.className);
    $[0] = props.className;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== props || $[3] !== ref || $[4] !== t0) {
    t1 = /* @__PURE__ */ jsx(Trigger, { asChild: true, children: /* @__PURE__ */ jsx("button", { ...props, ref, className: t0 }) });
    $[2] = props;
    $[3] = ref;
    $[4] = t0;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  return t1;
});
Button.displayName = "DropdownMenuButton";
function Content(t0) {
  const $ = c(14);
  let children;
  let className;
  let props;
  let t1;
  let t2;
  if ($[0] !== t0) {
    ({
      children,
      align: t1,
      sideOffset: t2,
      className,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = className;
    $[3] = props;
    $[4] = t1;
    $[5] = t2;
  } else {
    children = $[1];
    className = $[2];
    props = $[3];
    t1 = $[4];
    t2 = $[5];
  }
  const align = t1 === void 0 ? "start" : t1;
  const sideOffset = t2 === void 0 ? 5 : t2;
  let t3;
  if ($[6] !== className) {
    t3 = clsx("graphiql-dropdown-content", className);
    $[6] = className;
    $[7] = t3;
  } else {
    t3 = $[7];
  }
  let t4;
  if ($[8] !== align || $[9] !== children || $[10] !== props || $[11] !== sideOffset || $[12] !== t3) {
    t4 = /* @__PURE__ */ jsx(Portal, { children: /* @__PURE__ */ jsx(Content$1, { align, sideOffset, className: t3, ...props, children }) });
    $[8] = align;
    $[9] = children;
    $[10] = props;
    $[11] = sideOffset;
    $[12] = t3;
    $[13] = t4;
  } else {
    t4 = $[13];
  }
  return t4;
}
const Item = ({
  className,
  children,
  ...props
}) => /* @__PURE__ */ jsx(Item$1, { className: clsx("graphiql-dropdown-item", className), ...props, children });
const DropdownMenu = createComponentGroup(Root$1, {
  Button,
  Item,
  Content
});
const markdown = new MarkdownIt({
  breaks: true,
  linkify: true
});
const MarkdownContent = forwardRef((t0, ref) => {
  const $ = c(18);
  let children;
  let onlyShowFirstChild;
  let props;
  let type;
  if ($[0] !== t0) {
    ({
      children,
      onlyShowFirstChild,
      type,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = onlyShowFirstChild;
    $[3] = props;
    $[4] = type;
  } else {
    children = $[1];
    onlyShowFirstChild = $[2];
    props = $[3];
    type = $[4];
  }
  const t1 = `graphiql-markdown-${type}`;
  const t2 = onlyShowFirstChild && "graphiql-markdown-preview";
  let t3;
  if ($[5] !== props.className || $[6] !== t1 || $[7] !== t2) {
    t3 = clsx(t1, t2, props.className);
    $[5] = props.className;
    $[6] = t1;
    $[7] = t2;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  let t4;
  if ($[9] !== children) {
    t4 = markdown.render(children);
    $[9] = children;
    $[10] = t4;
  } else {
    t4 = $[10];
  }
  let t5;
  if ($[11] !== t4) {
    t5 = {
      __html: t4
    };
    $[11] = t4;
    $[12] = t5;
  } else {
    t5 = $[12];
  }
  let t6;
  if ($[13] !== props || $[14] !== ref || $[15] !== t3 || $[16] !== t5) {
    t6 = /* @__PURE__ */ jsx("div", { ...props, ref, className: t3, dangerouslySetInnerHTML: t5 });
    $[13] = props;
    $[14] = ref;
    $[15] = t3;
    $[16] = t5;
    $[17] = t6;
  } else {
    t6 = $[17];
  }
  return t6;
});
MarkdownContent.displayName = "MarkdownContent";
const Spinner = forwardRef((props, ref) => {
  const $ = c(6);
  let t0;
  if ($[0] !== props.className) {
    t0 = clsx("graphiql-spinner", props.className);
    $[0] = props.className;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== props || $[3] !== ref || $[4] !== t0) {
    t1 = /* @__PURE__ */ jsx("div", { ...props, ref, className: t0 });
    $[2] = props;
    $[3] = ref;
    $[4] = t0;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  return t1;
});
Spinner.displayName = "Spinner";
function TooltipRoot(t0) {
  const $ = c(10);
  const {
    children,
    align: t1,
    side: t2,
    sideOffset: t3,
    label
  } = t0;
  const align = t1 === void 0 ? "start" : t1;
  const side = t2 === void 0 ? "bottom" : t2;
  const sideOffset = t3 === void 0 ? 5 : t3;
  let t4;
  if ($[0] !== children) {
    t4 = /* @__PURE__ */ jsx(T.Trigger, { asChild: true, children });
    $[0] = children;
    $[1] = t4;
  } else {
    t4 = $[1];
  }
  let t5;
  if ($[2] !== align || $[3] !== label || $[4] !== side || $[5] !== sideOffset) {
    t5 = /* @__PURE__ */ jsx(T.Portal, { children: /* @__PURE__ */ jsx(T.Content, { className: "graphiql-tooltip", align, side, sideOffset, children: label }) });
    $[2] = align;
    $[3] = label;
    $[4] = side;
    $[5] = sideOffset;
    $[6] = t5;
  } else {
    t5 = $[6];
  }
  let t6;
  if ($[7] !== t4 || $[8] !== t5) {
    t6 = /* @__PURE__ */ jsxs(T.Root, { children: [
      t4,
      t5
    ] });
    $[7] = t4;
    $[8] = t5;
    $[9] = t6;
  } else {
    t6 = $[9];
  }
  return t6;
}
const Tooltip = createComponentGroup(TooltipRoot, {
  Provider: T.Provider
});
const TabRoot = forwardRef((t0, ref) => {
  const $ = c(16);
  let children;
  let className;
  let isActive;
  let props;
  let value;
  if ($[0] !== t0) {
    ({
      isActive,
      value,
      children,
      className,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = className;
    $[3] = isActive;
    $[4] = props;
    $[5] = value;
  } else {
    children = $[1];
    className = $[2];
    isActive = $[3];
    props = $[4];
    value = $[5];
  }
  const t1 = isActive ? "true" : void 0;
  const t2 = isActive && "graphiql-tab-active";
  let t3;
  if ($[6] !== className || $[7] !== t2) {
    t3 = clsx("graphiql-tab", t2, className);
    $[6] = className;
    $[7] = t2;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  let t4;
  if ($[9] !== children || $[10] !== props || $[11] !== ref || $[12] !== t1 || $[13] !== t3 || $[14] !== value) {
    t4 = /* @__PURE__ */ jsx(Reorder.Item, { ...props, ref, value, "aria-selected": t1, role: "tab", className: t3, children });
    $[9] = children;
    $[10] = props;
    $[11] = ref;
    $[12] = t1;
    $[13] = t3;
    $[14] = value;
    $[15] = t4;
  } else {
    t4 = $[15];
  }
  return t4;
});
TabRoot.displayName = "Tab";
const TabButton = forwardRef((props, ref) => {
  const $ = c(6);
  let t0;
  if ($[0] !== props.className) {
    t0 = clsx("graphiql-tab-button", props.className);
    $[0] = props.className;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== props || $[3] !== ref || $[4] !== t0) {
    t1 = /* @__PURE__ */ jsx(UnStyledButton, { ...props, ref, type: "button", className: t0, children: props.children });
    $[2] = props;
    $[3] = ref;
    $[4] = t0;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  return t1;
});
TabButton.displayName = "Tab.Button";
const TabClose = forwardRef((props, ref) => {
  const $ = c(7);
  let t0;
  if ($[0] !== props.className) {
    t0 = clsx("graphiql-tab-close", props.className);
    $[0] = props.className;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = /* @__PURE__ */ jsx(CloseIcon, {});
    $[2] = t1;
  } else {
    t1 = $[2];
  }
  let t2;
  if ($[3] !== props || $[4] !== ref || $[5] !== t0) {
    t2 = /* @__PURE__ */ jsx(Tooltip, { label: "Close Tab", children: /* @__PURE__ */ jsx(UnStyledButton, { "aria-label": "Close Tab", ...props, ref, type: "button", className: t0, children: t1 }) });
    $[3] = props;
    $[4] = ref;
    $[5] = t0;
    $[6] = t2;
  } else {
    t2 = $[6];
  }
  return t2;
});
TabClose.displayName = "Tab.Close";
const Tab = createComponentGroup(TabRoot, {
  Button: TabButton,
  Close: TabClose
});
const Tabs = forwardRef((t0, ref) => {
  const $ = c(15);
  let children;
  let className;
  let onReorder;
  let props;
  let values;
  if ($[0] !== t0) {
    ({
      values,
      onReorder,
      children,
      className,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = className;
    $[3] = onReorder;
    $[4] = props;
    $[5] = values;
  } else {
    children = $[1];
    className = $[2];
    onReorder = $[3];
    props = $[4];
    values = $[5];
  }
  let t1;
  if ($[6] !== className) {
    t1 = clsx("graphiql-tabs", className);
    $[6] = className;
    $[7] = t1;
  } else {
    t1 = $[7];
  }
  let t2;
  if ($[8] !== children || $[9] !== onReorder || $[10] !== props || $[11] !== ref || $[12] !== t1 || $[13] !== values) {
    t2 = /* @__PURE__ */ jsx(Reorder.Group, { ...props, ref, values, onReorder, axis: "x", role: "tablist", className: t1, children });
    $[8] = children;
    $[9] = onReorder;
    $[10] = props;
    $[11] = ref;
    $[12] = t1;
    $[13] = values;
    $[14] = t2;
  } else {
    t2 = $[14];
  }
  return t2;
});
Tabs.displayName = "Tabs";
const HistoryContext = createNullableContext("HistoryContext");
function HistoryContextProvider(t0) {
  const $ = c(11);
  const {
    maxHistoryLength: t1,
    children
  } = t0;
  const maxHistoryLength = t1 === void 0 ? DEFAULT_HISTORY_LENGTH : t1;
  const storage = useStorageContext();
  let t2;
  if ($[0] !== maxHistoryLength || $[1] !== storage) {
    t2 = () => new HistoryStore(storage || new StorageAPI(null), maxHistoryLength);
    $[0] = maxHistoryLength;
    $[1] = storage;
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const [historyStore] = useState(t2);
  let t3;
  if ($[3] !== historyStore.queries) {
    t3 = () => historyStore.queries || [];
    $[3] = historyStore.queries;
    $[4] = t3;
  } else {
    t3 = $[4];
  }
  const [items, setItems] = useState(t3);
  let t4;
  if ($[5] !== historyStore || $[6] !== items) {
    t4 = {
      addToHistory(operation) {
        historyStore.updateHistory(operation);
        setItems(historyStore.queries);
      },
      editLabel(operation_0, index) {
        historyStore.editLabel(operation_0, index);
        setItems(historyStore.queries);
      },
      items,
      toggleFavorite(operation_1) {
        historyStore.toggleFavorite(operation_1);
        setItems(historyStore.queries);
      },
      setActive: _temp$8,
      deleteFromHistory(item_0, clearFavorites) {
        historyStore.deleteHistory(item_0, clearFavorites);
        setItems(historyStore.queries);
      }
    };
    $[5] = historyStore;
    $[6] = items;
    $[7] = t4;
  } else {
    t4 = $[7];
  }
  const value = t4;
  let t5;
  if ($[8] !== children || $[9] !== value) {
    t5 = /* @__PURE__ */ jsx(HistoryContext.Provider, { value, children });
    $[8] = children;
    $[9] = value;
    $[10] = t5;
  } else {
    t5 = $[10];
  }
  return t5;
}
function _temp$8(item) {
  return item;
}
const useHistoryContext = createContextHook(HistoryContext);
const DEFAULT_HISTORY_LENGTH = 20;
function History() {
  const {
    items: all,
    deleteFromHistory
  } = useHistoryContext({
    nonNull: true
  });
  let items = all.slice().map((item, i) => ({
    ...item,
    index: i
  })).reverse();
  const favorites = items.filter((item_0) => item_0.favorite);
  if (favorites.length) {
    items = items.filter((item_1) => !item_1.favorite);
  }
  const [clearStatus, setClearStatus] = useState(null);
  useEffect(() => {
    if (clearStatus) {
      setTimeout(() => {
        setClearStatus(null);
      }, 2e3);
    }
  }, [clearStatus]);
  const handleClearStatus = () => {
    try {
      for (const item_2 of items) {
        deleteFromHistory(item_2, true);
      }
      setClearStatus("success");
    } catch {
      setClearStatus("error");
    }
  };
  return /* @__PURE__ */ jsxs("section", { "aria-label": "History", className: "graphiql-history", children: [
    /* @__PURE__ */ jsxs("div", { className: "graphiql-history-header", children: [
      "History",
      (clearStatus || items.length > 0) && /* @__PURE__ */ jsx(Button$1, { type: "button", state: clearStatus || void 0, disabled: !items.length, onClick: handleClearStatus, children: {
        success: "Cleared",
        error: "Failed to Clear"
      }[clearStatus] || "Clear" })
    ] }),
    Boolean(favorites.length) && /* @__PURE__ */ jsx("ul", { className: "graphiql-history-items", children: favorites.map((item_3) => /* @__PURE__ */ jsx(HistoryItem, { item: item_3 }, item_3.index)) }),
    Boolean(favorites.length) && Boolean(items.length) && /* @__PURE__ */ jsx("div", { className: "graphiql-history-item-spacer" }),
    Boolean(items.length) && /* @__PURE__ */ jsx("ul", { className: "graphiql-history-items", children: items.map((item_4) => /* @__PURE__ */ jsx(HistoryItem, { item: item_4 }, item_4.index)) })
  ] });
}
function HistoryItem(props) {
  const $ = c(40);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: HistoryItem
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    editLabel,
    toggleFavorite,
    deleteFromHistory,
    setActive
  } = useHistoryContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: HistoryItem
    };
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    headerEditor,
    queryEditor,
    variableEditor
  } = useEditorContext(t1);
  const inputRef = useRef(null);
  const buttonRef = useRef(null);
  const [isEditable, setIsEditable] = useState(false);
  let t2;
  let t3;
  if ($[2] !== isEditable) {
    t2 = () => {
      var _a;
      if (isEditable) {
        (_a = inputRef.current) == null ? void 0 : _a.focus();
      }
    };
    t3 = [isEditable];
    $[2] = isEditable;
    $[3] = t2;
    $[4] = t3;
  } else {
    t2 = $[3];
    t3 = $[4];
  }
  useEffect(t2, t3);
  let t4;
  if ($[5] !== props.item.label || $[6] !== props.item.operationName || $[7] !== props.item.query) {
    t4 = props.item.label || props.item.operationName || formatQuery(props.item.query);
    $[5] = props.item.label;
    $[6] = props.item.operationName;
    $[7] = props.item.query;
    $[8] = t4;
  } else {
    t4 = $[8];
  }
  const displayName = t4;
  let t5;
  if ($[9] !== editLabel || $[10] !== props.item) {
    t5 = () => {
      var _a;
      setIsEditable(false);
      const {
        index,
        ...item
      } = props.item;
      editLabel({
        ...item,
        label: (_a = inputRef.current) == null ? void 0 : _a.value
      }, index);
    };
    $[9] = editLabel;
    $[10] = props.item;
    $[11] = t5;
  } else {
    t5 = $[11];
  }
  const handleSave = t5;
  let t6;
  if ($[12] === Symbol.for("react.memo_cache_sentinel")) {
    t6 = () => {
      setIsEditable(false);
    };
    $[12] = t6;
  } else {
    t6 = $[12];
  }
  const handleClose = t6;
  let t7;
  if ($[13] === Symbol.for("react.memo_cache_sentinel")) {
    t7 = (e) => {
      e.stopPropagation();
      setIsEditable(true);
    };
    $[13] = t7;
  } else {
    t7 = $[13];
  }
  const handleEditLabel = t7;
  let t8;
  if ($[14] !== headerEditor || $[15] !== props.item || $[16] !== queryEditor || $[17] !== setActive || $[18] !== variableEditor) {
    t8 = () => {
      const {
        query,
        variables,
        headers
      } = props.item;
      queryEditor == null ? void 0 : queryEditor.setValue(query ?? "");
      variableEditor == null ? void 0 : variableEditor.setValue(variables ?? "");
      headerEditor == null ? void 0 : headerEditor.setValue(headers ?? "");
      setActive(props.item);
    };
    $[14] = headerEditor;
    $[15] = props.item;
    $[16] = queryEditor;
    $[17] = setActive;
    $[18] = variableEditor;
    $[19] = t8;
  } else {
    t8 = $[19];
  }
  const handleHistoryItemClick = t8;
  let t9;
  if ($[20] !== deleteFromHistory || $[21] !== props.item) {
    t9 = (e_0) => {
      e_0.stopPropagation();
      deleteFromHistory(props.item);
    };
    $[20] = deleteFromHistory;
    $[21] = props.item;
    $[22] = t9;
  } else {
    t9 = $[22];
  }
  const handleDeleteItemFromHistory = t9;
  let t10;
  if ($[23] !== props.item || $[24] !== toggleFavorite) {
    t10 = (e_1) => {
      e_1.stopPropagation();
      toggleFavorite(props.item);
    };
    $[23] = props.item;
    $[24] = toggleFavorite;
    $[25] = t10;
  } else {
    t10 = $[25];
  }
  const handleToggleFavorite = t10;
  const t11 = isEditable && "editable";
  let t12;
  if ($[26] !== t11) {
    t12 = clsx("graphiql-history-item", t11);
    $[26] = t11;
    $[27] = t12;
  } else {
    t12 = $[27];
  }
  let t13;
  if ($[28] !== displayName || $[29] !== editLabel || $[30] !== handleDeleteItemFromHistory || $[31] !== handleHistoryItemClick || $[32] !== handleSave || $[33] !== handleToggleFavorite || $[34] !== isEditable || $[35] !== props.item) {
    t13 = isEditable ? /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx("input", { type: "text", defaultValue: props.item.label, ref: inputRef, onKeyDown: (e_2) => {
        if (e_2.key === "Esc") {
          setIsEditable(false);
        } else {
          if (e_2.key === "Enter") {
            setIsEditable(false);
            editLabel({
              ...props.item,
              label: e_2.currentTarget.value
            });
          }
        }
      }, placeholder: "Type a label" }),
      /* @__PURE__ */ jsx(UnStyledButton, { type: "button", ref: buttonRef, onClick: handleSave, children: "Save" }),
      /* @__PURE__ */ jsx(UnStyledButton, { type: "button", ref: buttonRef, onClick: handleClose, children: /* @__PURE__ */ jsx(CloseIcon, {}) })
    ] }) : /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(Tooltip, { label: "Set active", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-history-item-label", onClick: handleHistoryItemClick, "aria-label": "Set active", children: displayName }) }),
      /* @__PURE__ */ jsx(Tooltip, { label: "Edit label", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-history-item-action", onClick: handleEditLabel, "aria-label": "Edit label", children: /* @__PURE__ */ jsx(PenIcon, { "aria-hidden": "true" }) }) }),
      /* @__PURE__ */ jsx(Tooltip, { label: props.item.favorite ? "Remove favorite" : "Add favorite", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-history-item-action", onClick: handleToggleFavorite, "aria-label": props.item.favorite ? "Remove favorite" : "Add favorite", children: props.item.favorite ? /* @__PURE__ */ jsx(StarFilledIcon, { "aria-hidden": "true" }) : /* @__PURE__ */ jsx(StarIcon, { "aria-hidden": "true" }) }) }),
      /* @__PURE__ */ jsx(Tooltip, { label: "Delete from history", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-history-item-action", onClick: handleDeleteItemFromHistory, "aria-label": "Delete from history", children: /* @__PURE__ */ jsx(TrashIcon, { "aria-hidden": "true" }) }) })
    ] });
    $[28] = displayName;
    $[29] = editLabel;
    $[30] = handleDeleteItemFromHistory;
    $[31] = handleHistoryItemClick;
    $[32] = handleSave;
    $[33] = handleToggleFavorite;
    $[34] = isEditable;
    $[35] = props.item;
    $[36] = t13;
  } else {
    t13 = $[36];
  }
  let t14;
  if ($[37] !== t12 || $[38] !== t13) {
    t14 = /* @__PURE__ */ jsx("li", { className: t12, children: t13 });
    $[37] = t12;
    $[38] = t13;
    $[39] = t14;
  } else {
    t14 = $[39];
  }
  return t14;
}
function formatQuery(query) {
  return query == null ? void 0 : query.split("\n").map((line) => line.replace(/#(.*)/, "")).join(" ").replaceAll("{", " { ").replaceAll("}", " } ").replaceAll(/[\s]{2,}/g, " ");
}
const ExecutionContext = createNullableContext("ExecutionContext");
function ExecutionContextProvider(t0) {
  const $ = c(27);
  const {
    fetcher,
    getDefaultFieldNames,
    children,
    operationName
  } = t0;
  if (!fetcher) {
    throw new TypeError("The `ExecutionContextProvider` component requires a `fetcher` function to be passed as prop.");
  }
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: ExecutionContextProvider
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const {
    externalFragments,
    headerEditor,
    queryEditor,
    responseEditor,
    variableEditor,
    updateActiveTabValues
  } = useEditorContext(t1);
  const history = useHistoryContext();
  let t2;
  if ($[1] !== getDefaultFieldNames) {
    t2 = {
      getDefaultFieldNames,
      caller: ExecutionContextProvider
    };
    $[1] = getDefaultFieldNames;
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const autoCompleteLeafs = useAutoCompleteLeafs(t2);
  const [isFetching, setIsFetching] = useState(false);
  const [subscription, setSubscription] = useState(null);
  const queryIdRef = useRef(0);
  let t3;
  if ($[3] !== subscription) {
    t3 = () => {
      subscription == null ? void 0 : subscription.unsubscribe();
      setIsFetching(false);
      setSubscription(null);
    };
    $[3] = subscription;
    $[4] = t3;
  } else {
    t3 = $[4];
  }
  const stop = t3;
  let t4;
  if ($[5] !== autoCompleteLeafs || $[6] !== externalFragments || $[7] !== fetcher || $[8] !== headerEditor || $[9] !== history || $[10] !== operationName || $[11] !== queryEditor || $[12] !== responseEditor || $[13] !== stop || $[14] !== subscription || $[15] !== updateActiveTabValues || $[16] !== variableEditor) {
    t4 = async () => {
      if (!queryEditor || !responseEditor) {
        return;
      }
      if (subscription) {
        stop();
        return;
      }
      const setResponse = (value) => {
        responseEditor.setValue(value);
        updateActiveTabValues({
          response: value
        });
      };
      queryIdRef.current = queryIdRef.current + 1;
      const queryId = queryIdRef.current;
      let query = autoCompleteLeafs() || queryEditor.getValue();
      const variablesString = variableEditor == null ? void 0 : variableEditor.getValue();
      let variables;
      try {
        variables = tryParseJsonObject({
          json: variablesString,
          errorMessageParse: "Variables are invalid JSON",
          errorMessageType: "Variables are not a JSON object."
        });
      } catch (t52) {
        const error = t52;
        setResponse(error instanceof Error ? error.message : `${error}`);
        return;
      }
      const headersString = headerEditor == null ? void 0 : headerEditor.getValue();
      let headers;
      try {
        headers = tryParseJsonObject({
          json: headersString,
          errorMessageParse: "Headers are invalid JSON",
          errorMessageType: "Headers are not a JSON object."
        });
      } catch (t62) {
        const error_0 = t62;
        setResponse(error_0 instanceof Error ? error_0.message : `${error_0}`);
        return;
      }
      if (externalFragments) {
        const fragmentDependencies = queryEditor.documentAST ? getFragmentDependenciesForAST(queryEditor.documentAST, externalFragments) : [];
        if (fragmentDependencies.length > 0) {
          query = query + ("\n" + fragmentDependencies.map(_temp$7).join("\n"));
        }
      }
      setResponse("");
      setIsFetching(true);
      const opName = operationName ?? queryEditor.operationName ?? void 0;
      history == null ? void 0 : history.addToHistory({
        query,
        variables: variablesString,
        headers: headersString,
        operationName: opName
      });
      const _headers = headers ?? void 0;
      const documentAST = queryEditor.documentAST ?? void 0;
      try {
        const fullResponse = {};
        const handleResponse = (result) => {
          if (queryId !== queryIdRef.current) {
            return;
          }
          let maybeMultipart = Array.isArray(result) ? result : false;
          if (!maybeMultipart && typeof result === "object" && result !== null && "hasNext" in result) {
            maybeMultipart = [result];
          }
          if (maybeMultipart) {
            for (const part of maybeMultipart) {
              mergeIncrementalResult(fullResponse, part);
            }
            setIsFetching(false);
            setResponse(formatResult(fullResponse));
          } else {
            const response = formatResult(result);
            setIsFetching(false);
            setResponse(response);
          }
        };
        const fetch2 = fetcher({
          query,
          variables,
          operationName: opName
        }, {
          headers: _headers,
          documentAST
        });
        const value_0 = await Promise.resolve(fetch2);
        if (isObservable(value_0)) {
          setSubscription(value_0.subscribe({
            next(result_0) {
              handleResponse(result_0);
            },
            error(error_2) {
              setIsFetching(false);
              if (error_2) {
                setResponse(formatError(error_2));
              }
              setSubscription(null);
            },
            complete() {
              setIsFetching(false);
              setSubscription(null);
            }
          }));
        } else {
          if (isAsyncIterable(value_0)) {
            setSubscription({
              unsubscribe: () => {
                var _a, _b;
                return (_b = (_a = value_0[Symbol.asyncIterator]()).return) == null ? void 0 : _b.call(_a);
              }
            });
            await handleAsyncResults(handleResponse, value_0);
            setIsFetching(false);
            setSubscription(null);
          } else {
            handleResponse(value_0);
          }
        }
      } catch (t72) {
        const error_1 = t72;
        setIsFetching(false);
        setResponse(formatError(error_1));
        setSubscription(null);
      }
    };
    $[5] = autoCompleteLeafs;
    $[6] = externalFragments;
    $[7] = fetcher;
    $[8] = headerEditor;
    $[9] = history;
    $[10] = operationName;
    $[11] = queryEditor;
    $[12] = responseEditor;
    $[13] = stop;
    $[14] = subscription;
    $[15] = updateActiveTabValues;
    $[16] = variableEditor;
    $[17] = t4;
  } else {
    t4 = $[17];
  }
  const run = t4;
  const isSubscribed = Boolean(subscription);
  const t5 = operationName ?? null;
  let t6;
  if ($[18] !== isFetching || $[19] !== isSubscribed || $[20] !== run || $[21] !== stop || $[22] !== t5) {
    t6 = {
      isFetching,
      isSubscribed,
      operationName: t5,
      run,
      stop
    };
    $[18] = isFetching;
    $[19] = isSubscribed;
    $[20] = run;
    $[21] = stop;
    $[22] = t5;
    $[23] = t6;
  } else {
    t6 = $[23];
  }
  const value_1 = t6;
  let t7;
  if ($[24] !== children || $[25] !== value_1) {
    t7 = /* @__PURE__ */ jsx(ExecutionContext.Provider, { value: value_1, children });
    $[24] = children;
    $[25] = value_1;
    $[26] = t7;
  } else {
    t7 = $[26];
  }
  return t7;
}
function _temp$7(node) {
  return print(node);
}
async function handleAsyncResults(onResponse, value) {
  for await (const result of value) {
    onResponse(result);
  }
}
const useExecutionContext = createContextHook(ExecutionContext);
function tryParseJsonObject({
  json,
  errorMessageParse,
  errorMessageType
}) {
  let parsed;
  try {
    parsed = json && json.trim() !== "" ? JSON.parse(json) : void 0;
  } catch (error) {
    throw new Error(`${errorMessageParse}: ${error instanceof Error ? error.message : error}.`);
  }
  const isObject = typeof parsed === "object" && parsed !== null && !Array.isArray(parsed);
  if (parsed !== void 0 && !isObject) {
    throw new Error(errorMessageType);
  }
  return parsed;
}
const pathsMap = /* @__PURE__ */ new WeakMap();
function mergeIncrementalResult(executionResult, incrementalResult) {
  var _a, _b, _c;
  let path = ["data", ...incrementalResult.path ?? []];
  for (const result of [executionResult, incrementalResult]) {
    if (result.pending) {
      let paths = pathsMap.get(executionResult);
      if (paths === void 0) {
        paths = /* @__PURE__ */ new Map();
        pathsMap.set(executionResult, paths);
      }
      for (const {
        id,
        path: pendingPath
      } of result.pending) {
        paths.set(id, ["data", ...pendingPath]);
      }
    }
  }
  const {
    items
  } = incrementalResult;
  if (items) {
    const {
      id
    } = incrementalResult;
    if (id) {
      path = (_a = pathsMap.get(executionResult)) == null ? void 0 : _a.get(id);
      if (path === void 0) {
        throw new Error("Invalid incremental delivery format.");
      }
      const list = getValue(executionResult, path.join("."));
      list.push(...items);
    } else {
      path = ["data", ...incrementalResult.path ?? []];
      for (const item of items) {
        setValue(executionResult, path.join("."), item);
        path[path.length - 1]++;
      }
    }
  }
  const {
    data
  } = incrementalResult;
  if (data) {
    const {
      id
    } = incrementalResult;
    if (id) {
      path = (_b = pathsMap.get(executionResult)) == null ? void 0 : _b.get(id);
      if (path === void 0) {
        throw new Error("Invalid incremental delivery format.");
      }
      const {
        subPath
      } = incrementalResult;
      if (subPath !== void 0) {
        path = [...path, ...subPath];
      }
    }
    setValue(executionResult, path.join("."), data, {
      merge: true
    });
  }
  if (incrementalResult.errors) {
    executionResult.errors || (executionResult.errors = []);
    executionResult.errors.push(...incrementalResult.errors);
  }
  if (incrementalResult.extensions) {
    setValue(executionResult, "extensions", incrementalResult.extensions, {
      merge: true
    });
  }
  if (incrementalResult.incremental) {
    for (const incrementalSubResult of incrementalResult.incremental) {
      mergeIncrementalResult(executionResult, incrementalSubResult);
    }
  }
  if (incrementalResult.completed) {
    for (const {
      id,
      errors
    } of incrementalResult.completed) {
      (_c = pathsMap.get(executionResult)) == null ? void 0 : _c.delete(id);
      if (errors) {
        executionResult.errors || (executionResult.errors = []);
        executionResult.errors.push(...errors);
      }
    }
  }
}
const isMacOs = typeof navigator !== "undefined" && navigator.userAgent.includes("Mac");
const DEFAULT_EDITOR_THEME = "graphiql";
const DEFAULT_KEY_MAP = "sublime";
const commonKeys = {
  // Persistent search box in Query Editor
  [isMacOs ? "Cmd-F" : "Ctrl-F"]: "findPersistent",
  "Cmd-G": "findPersistent",
  "Ctrl-G": "findPersistent",
  // Editor improvements
  "Ctrl-Left": "goSubwordLeft",
  "Ctrl-Right": "goSubwordRight",
  "Alt-Left": "goGroupLeft",
  "Alt-Right": "goGroupRight"
};
async function importCodeMirror(addons, options) {
  const CodeMirror = await import("codemirror").then((c2) => (
    // Depending on bundler and settings the dynamic import either returns a
    // function (e.g. parcel) or an object containing a `default` property
    typeof c2 === "function" ? c2 : c2.default
  ));
  await Promise.all((options == null ? void 0 : options.useCommonAddons) === false ? addons : [
    import("codemirror/addon/hint/show-hint.js"),
    import("codemirror/addon/edit/matchbrackets.js"),
    import("codemirror/addon/edit/closebrackets.js"),
    import("codemirror/addon/fold/brace-fold.js"),
    import("codemirror/addon/fold/foldgutter.js"),
    import("codemirror/addon/lint/lint.js"),
    import("codemirror/addon/search/searchcursor.js"),
    import("codemirror/addon/search/jump-to-line.js"),
    import("codemirror/addon/dialog/dialog.js"),
    // @ts-expect-error
    import("codemirror/keymap/sublime.js"),
    ...addons
  ]);
  return CodeMirror;
}
const printDefault = (ast) => {
  if (!ast) {
    return "";
  }
  return print(ast);
};
function DefaultValue(t0) {
  const $ = c(12);
  const {
    field
  } = t0;
  if (!("defaultValue" in field) || field.defaultValue === void 0) {
    return null;
  }
  const t1 = field.defaultValue;
  const t2 = field.type;
  let t3;
  let t4;
  let t5;
  let t6;
  if ($[0] !== field.defaultValue || $[1] !== field.type) {
    t6 = Symbol.for("react.early_return_sentinel");
    bb0: {
      const ast = astFromValue(t1, t2);
      if (!ast) {
        t6 = null;
        break bb0;
      }
      t5 = " = ";
      t3 = "graphiql-doc-explorer-default-value";
      t4 = printDefault(ast);
    }
    $[0] = field.defaultValue;
    $[1] = field.type;
    $[2] = t3;
    $[3] = t4;
    $[4] = t5;
    $[5] = t6;
  } else {
    t3 = $[2];
    t4 = $[3];
    t5 = $[4];
    t6 = $[5];
  }
  if (t6 !== Symbol.for("react.early_return_sentinel")) {
    return t6;
  }
  let t7;
  if ($[6] !== t3 || $[7] !== t4) {
    t7 = /* @__PURE__ */ jsx("span", { className: t3, children: t4 });
    $[6] = t3;
    $[7] = t4;
    $[8] = t7;
  } else {
    t7 = $[8];
  }
  let t8;
  if ($[9] !== t5 || $[10] !== t7) {
    t8 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t5,
      t7
    ] });
    $[9] = t5;
    $[10] = t7;
    $[11] = t8;
  } else {
    t8 = $[11];
  }
  return t8;
}
const SchemaContext = createNullableContext("SchemaContext");
function SchemaContextProvider(t0) {
  const $ = c(38);
  let fetcher;
  let onSchemaChange;
  let props;
  if ($[0] !== t0) {
    ({
      fetcher,
      onSchemaChange,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = fetcher;
    $[2] = onSchemaChange;
    $[3] = props;
  } else {
    fetcher = $[1];
    onSchemaChange = $[2];
    props = $[3];
  }
  if (!fetcher) {
    throw new TypeError("The `SchemaContextProvider` component requires a `fetcher` function to be passed as prop.");
  }
  let t1;
  if ($[4] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: SchemaContextProvider
    };
    $[4] = t1;
  } else {
    t1 = $[4];
  }
  const {
    initialHeaders,
    headerEditor
  } = useEditorContext(t1);
  const [schema, setSchema] = useState();
  const [isFetching, setIsFetching] = useState(false);
  const [fetchError, setFetchError] = useState(null);
  const counterRef = useRef(0);
  let t2;
  let t3;
  if ($[5] !== props.schema) {
    t2 = () => {
      setSchema(isSchema(props.schema) || props.schema == null ? props.schema : void 0);
      counterRef.current = counterRef.current + 1;
    };
    t3 = [props.schema];
    $[5] = props.schema;
    $[6] = t2;
    $[7] = t3;
  } else {
    t2 = $[6];
    t3 = $[7];
  }
  useEffect(t2, t3);
  const headersRef = useRef(initialHeaders);
  let t4;
  if ($[8] !== headerEditor) {
    t4 = () => {
      if (headerEditor) {
        headersRef.current = headerEditor.getValue();
      }
    };
    $[8] = headerEditor;
    $[9] = t4;
  } else {
    t4 = $[9];
  }
  useEffect(t4);
  let t5;
  if ($[10] !== props.inputValueDeprecation || $[11] !== props.introspectionQueryName || $[12] !== props.schemaDescription) {
    t5 = {
      inputValueDeprecation: props.inputValueDeprecation,
      introspectionQueryName: props.introspectionQueryName,
      schemaDescription: props.schemaDescription
    };
    $[10] = props.inputValueDeprecation;
    $[11] = props.introspectionQueryName;
    $[12] = props.schemaDescription;
    $[13] = t5;
  } else {
    t5 = $[13];
  }
  const {
    introspectionQuery,
    introspectionQueryName,
    introspectionQuerySansSubscriptions
  } = useIntrospectionQuery(t5);
  let t6;
  if ($[14] !== fetcher || $[15] !== introspectionQuery || $[16] !== introspectionQueryName || $[17] !== introspectionQuerySansSubscriptions || $[18] !== onSchemaChange || $[19] !== props.schema) {
    t6 = () => {
      if (isSchema(props.schema) || props.schema === null) {
        return;
      }
      const counter = counterRef.current = counterRef.current + 1;
      const maybeIntrospectionData = props.schema;
      const fetchIntrospectionData = async function fetchIntrospectionData2() {
        if (maybeIntrospectionData) {
          return maybeIntrospectionData;
        }
        const parsedHeaders = parseHeaderString(headersRef.current);
        if (!parsedHeaders.isValidJSON) {
          setFetchError("Introspection failed as headers are invalid.");
          return;
        }
        const fetcherOpts = parsedHeaders.headers ? {
          headers: parsedHeaders.headers
        } : {};
        const fetch2 = fetcherReturnToPromise(fetcher({
          query: introspectionQuery,
          operationName: introspectionQueryName
        }, fetcherOpts));
        if (!isPromise(fetch2)) {
          setFetchError("Fetcher did not return a Promise for introspection.");
          return;
        }
        setIsFetching(true);
        setFetchError(null);
        let result = await fetch2;
        if (typeof result !== "object" || result === null || !("data" in result)) {
          const fetch22 = fetcherReturnToPromise(fetcher({
            query: introspectionQuerySansSubscriptions,
            operationName: introspectionQueryName
          }, fetcherOpts));
          if (!isPromise(fetch22)) {
            throw new Error("Fetcher did not return a Promise for introspection.");
          }
          result = await fetch22;
        }
        setIsFetching(false);
        if ((result == null ? void 0 : result.data) && "__schema" in result.data) {
          return result.data;
        }
        const responseString = typeof result === "string" ? result : formatResult(result);
        setFetchError(responseString);
      };
      fetchIntrospectionData().then((introspectionData) => {
        if (counter !== counterRef.current || !introspectionData) {
          return;
        }
        try {
          const newSchema = buildClientSchema(introspectionData);
          setSchema(newSchema);
          if (onSchemaChange) {
            onSchemaChange(newSchema);
          }
        } catch (t72) {
          const error = t72;
          setFetchError(formatError(error));
        }
      }).catch((error_0) => {
        if (counter !== counterRef.current) {
          return;
        }
        setFetchError(formatError(error_0));
        setIsFetching(false);
      });
    };
    $[14] = fetcher;
    $[15] = introspectionQuery;
    $[16] = introspectionQueryName;
    $[17] = introspectionQuerySansSubscriptions;
    $[18] = onSchemaChange;
    $[19] = props.schema;
    $[20] = t6;
  } else {
    t6 = $[20];
  }
  const introspect = t6;
  let t7;
  let t8;
  if ($[21] !== introspect) {
    t7 = () => {
      introspect();
    };
    t8 = [introspect];
    $[21] = introspect;
    $[22] = t7;
    $[23] = t8;
  } else {
    t7 = $[22];
    t8 = $[23];
  }
  useEffect(t7, t8);
  let t9;
  if ($[24] !== introspect) {
    t9 = () => {
      const triggerIntrospection = function triggerIntrospection2(event) {
        if (event.ctrlKey && event.key === "R") {
          introspect();
        }
      };
      window.addEventListener("keydown", triggerIntrospection);
      return () => {
        window.removeEventListener("keydown", triggerIntrospection);
      };
    };
    $[24] = introspect;
    $[25] = t9;
  } else {
    t9 = $[25];
  }
  useEffect(t9);
  let t10;
  if ($[26] !== props.dangerouslyAssumeSchemaIsValid || $[27] !== schema) {
    t10 = !schema || props.dangerouslyAssumeSchemaIsValid ? [] : validateSchema(schema);
    $[26] = props.dangerouslyAssumeSchemaIsValid;
    $[27] = schema;
    $[28] = t10;
  } else {
    t10 = $[28];
  }
  const validationErrors = t10;
  let t11;
  if ($[29] !== fetchError || $[30] !== introspect || $[31] !== isFetching || $[32] !== schema || $[33] !== validationErrors) {
    t11 = {
      fetchError,
      introspect,
      isFetching,
      schema,
      validationErrors
    };
    $[29] = fetchError;
    $[30] = introspect;
    $[31] = isFetching;
    $[32] = schema;
    $[33] = validationErrors;
    $[34] = t11;
  } else {
    t11 = $[34];
  }
  const value = t11;
  let t12;
  if ($[35] !== props.children || $[36] !== value) {
    t12 = /* @__PURE__ */ jsx(SchemaContext.Provider, { value, children: props.children });
    $[35] = props.children;
    $[36] = value;
    $[37] = t12;
  } else {
    t12 = $[37];
  }
  return t12;
}
const useSchemaContext = createContextHook(SchemaContext);
function useIntrospectionQuery({
  inputValueDeprecation,
  introspectionQueryName,
  schemaDescription
}) {
  const queryName = introspectionQueryName || "IntrospectionQuery";
  let query = getIntrospectionQuery({
    inputValueDeprecation,
    schemaDescription
  });
  if (introspectionQueryName) {
    query = query.replace("query IntrospectionQuery", `query ${queryName}`);
  }
  const querySansSubscriptions = query.replace("subscriptionType { name }", "");
  return {
    introspectionQueryName: queryName,
    introspectionQuery: query,
    introspectionQuerySansSubscriptions: querySansSubscriptions
  };
}
function parseHeaderString(headersString) {
  let headers = null;
  let isValidJSON = true;
  try {
    if (headersString) {
      headers = JSON.parse(headersString);
    }
  } catch {
    isValidJSON = false;
  }
  return {
    headers,
    isValidJSON
  };
}
const initialNavStackItem = {
  name: "Docs"
};
const ExplorerContext = createNullableContext("ExplorerContext");
function ExplorerContextProvider(props) {
  const $ = c(14);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: ExplorerContextProvider
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    schema,
    validationErrors
  } = useSchemaContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = [initialNavStackItem];
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const [navStack, setNavStack] = useState(t1);
  let t2;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = (item) => {
      setNavStack((currentState) => {
        const lastItem = currentState.at(-1);
        return lastItem.def === item.def ? currentState : [...currentState, item];
      });
    };
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const push = t2;
  let t3;
  if ($[3] === Symbol.for("react.memo_cache_sentinel")) {
    t3 = () => {
      setNavStack(_temp$6);
    };
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const pop = t3;
  let t4;
  if ($[4] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = () => {
      setNavStack(_temp2$3);
    };
    $[4] = t4;
  } else {
    t4 = $[4];
  }
  const reset = t4;
  let t5;
  let t6;
  if ($[5] !== schema || $[6] !== validationErrors) {
    t5 = () => {
      if (schema == null || validationErrors.length > 0) {
        reset();
      } else {
        setNavStack((oldNavStack) => {
          if (oldNavStack.length === 1) {
            return oldNavStack;
          }
          const newNavStack = [initialNavStackItem];
          let lastEntity = null;
          for (const item_0 of oldNavStack) {
            if (item_0 === initialNavStackItem) {
              continue;
            }
            if (item_0.def) {
              if (isNamedType(item_0.def)) {
                const newType = schema.getType(item_0.def.name);
                if (newType) {
                  newNavStack.push({
                    name: item_0.name,
                    def: newType
                  });
                  lastEntity = newType;
                } else {
                  break;
                }
              } else {
                if (lastEntity === null) {
                  break;
                } else {
                  if (isObjectType(lastEntity) || isInputObjectType(lastEntity)) {
                    const field = lastEntity.getFields()[item_0.name];
                    if (field) {
                      newNavStack.push({
                        name: item_0.name,
                        def: field
                      });
                    } else {
                      break;
                    }
                  } else {
                    if (isScalarType(lastEntity) || isEnumType(lastEntity) || isInterfaceType(lastEntity) || isUnionType(lastEntity)) {
                      break;
                    } else {
                      const field_0 = lastEntity;
                      const arg = field_0.args.find((a) => a.name === item_0.name);
                      if (arg) {
                        newNavStack.push({
                          name: item_0.name,
                          def: field_0
                        });
                      } else {
                        break;
                      }
                    }
                  }
                }
              }
            } else {
              lastEntity = null;
              newNavStack.push(item_0);
            }
          }
          return newNavStack;
        });
      }
    };
    t6 = [schema, validationErrors];
    $[5] = schema;
    $[6] = validationErrors;
    $[7] = t5;
    $[8] = t6;
  } else {
    t5 = $[7];
    t6 = $[8];
  }
  useEffect(t5, t6);
  let t7;
  if ($[9] !== navStack) {
    t7 = {
      explorerNavStack: navStack,
      push,
      pop,
      reset
    };
    $[9] = navStack;
    $[10] = t7;
  } else {
    t7 = $[10];
  }
  const value = t7;
  let t8;
  if ($[11] !== props.children || $[12] !== value) {
    t8 = /* @__PURE__ */ jsx(ExplorerContext.Provider, { value, children: props.children });
    $[11] = props.children;
    $[12] = value;
    $[13] = t8;
  } else {
    t8 = $[13];
  }
  return t8;
}
function _temp2$3(currentState_1) {
  return currentState_1.length === 1 ? currentState_1 : [initialNavStackItem];
}
function _temp$6(currentState_0) {
  return currentState_0.length > 1 ? currentState_0.slice(0, -1) : currentState_0;
}
const useExplorerContext = createContextHook(ExplorerContext);
function renderType(type, renderNamedType) {
  if (isNonNullType(type)) {
    return /* @__PURE__ */ jsxs(Fragment, { children: [
      renderType(type.ofType, renderNamedType),
      "!"
    ] });
  }
  if (isListType(type)) {
    return /* @__PURE__ */ jsxs(Fragment, { children: [
      "[",
      renderType(type.ofType, renderNamedType),
      "]"
    ] });
  }
  return renderNamedType(type);
}
function TypeLink(props) {
  const $ = c(6);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: TypeLink
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    push
  } = useExplorerContext(t0);
  if (!props.type) {
    return null;
  }
  let t1;
  if ($[1] !== push) {
    t1 = (namedType) => /* @__PURE__ */ jsx("a", { className: "graphiql-doc-explorer-type-name", onClick: (event) => {
      event.preventDefault();
      push({
        name: namedType.name,
        def: namedType
      });
    }, href: "#", children: namedType.name });
    $[1] = push;
    $[2] = t1;
  } else {
    t1 = $[2];
  }
  let t2;
  if ($[3] !== props.type || $[4] !== t1) {
    t2 = renderType(props.type, t1);
    $[3] = props.type;
    $[4] = t1;
    $[5] = t2;
  } else {
    t2 = $[5];
  }
  return t2;
}
function Argument(t0) {
  const $ = c(19);
  const {
    arg,
    showDefaultValue,
    inline
  } = t0;
  let t1;
  if ($[0] !== arg.name) {
    t1 = /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-argument-name", children: arg.name });
    $[0] = arg.name;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] !== arg.type) {
    t2 = /* @__PURE__ */ jsx(TypeLink, { type: arg.type });
    $[2] = arg.type;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  let t3;
  if ($[4] !== arg || $[5] !== showDefaultValue) {
    t3 = showDefaultValue !== false && /* @__PURE__ */ jsx(DefaultValue, { field: arg });
    $[4] = arg;
    $[5] = showDefaultValue;
    $[6] = t3;
  } else {
    t3 = $[6];
  }
  let t4;
  if ($[7] !== t1 || $[8] !== t2 || $[9] !== t3) {
    t4 = /* @__PURE__ */ jsxs("span", { children: [
      t1,
      ": ",
      t2,
      t3
    ] });
    $[7] = t1;
    $[8] = t2;
    $[9] = t3;
    $[10] = t4;
  } else {
    t4 = $[10];
  }
  const definition = t4;
  if (inline) {
    return definition;
  }
  let t5;
  if ($[11] !== arg.description) {
    t5 = arg.description ? /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: arg.description }) : null;
    $[11] = arg.description;
    $[12] = t5;
  } else {
    t5 = $[12];
  }
  let t6;
  if ($[13] !== arg.deprecationReason) {
    t6 = arg.deprecationReason ? /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-argument-deprecation", children: [
      /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-argument-deprecation-label", children: "Deprecated" }),
      /* @__PURE__ */ jsx(MarkdownContent, { type: "deprecation", children: arg.deprecationReason })
    ] }) : null;
    $[13] = arg.deprecationReason;
    $[14] = t6;
  } else {
    t6 = $[14];
  }
  let t7;
  if ($[15] !== definition || $[16] !== t5 || $[17] !== t6) {
    t7 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-argument", children: [
      definition,
      t5,
      t6
    ] });
    $[15] = definition;
    $[16] = t5;
    $[17] = t6;
    $[18] = t7;
  } else {
    t7 = $[18];
  }
  return t7;
}
function DeprecationReason(props) {
  const $ = c(3);
  let t0;
  if ($[0] !== props.children || $[1] !== props.preview) {
    t0 = props.children ? /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-deprecation", children: [
      /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-deprecation-label", children: "Deprecated" }),
      /* @__PURE__ */ jsx(MarkdownContent, { type: "deprecation", onlyShowFirstChild: props.preview ?? true, children: props.children })
    ] }) : null;
    $[0] = props.children;
    $[1] = props.preview;
    $[2] = t0;
  } else {
    t0 = $[2];
  }
  return t0;
}
function Directive(t0) {
  const $ = c(2);
  const {
    directive
  } = t0;
  let t1;
  if ($[0] !== directive.name.value) {
    t1 = /* @__PURE__ */ jsxs("span", { className: "graphiql-doc-explorer-directive", children: [
      "@",
      directive.name.value
    ] });
    $[0] = directive.name.value;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  return t1;
}
function ExplorerSection(props) {
  const $ = c(10);
  const Icon2 = TYPE_TO_ICON[props.title];
  let t0;
  if ($[0] !== Icon2) {
    t0 = /* @__PURE__ */ jsx(Icon2, {});
    $[0] = Icon2;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== props.title || $[3] !== t0) {
    t1 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-section-title", children: [
      t0,
      props.title
    ] });
    $[2] = props.title;
    $[3] = t0;
    $[4] = t1;
  } else {
    t1 = $[4];
  }
  let t2;
  if ($[5] !== props.children) {
    t2 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-section-content", children: props.children });
    $[5] = props.children;
    $[6] = t2;
  } else {
    t2 = $[6];
  }
  let t3;
  if ($[7] !== t1 || $[8] !== t2) {
    t3 = /* @__PURE__ */ jsxs("div", { children: [
      t1,
      t2
    ] });
    $[7] = t1;
    $[8] = t2;
    $[9] = t3;
  } else {
    t3 = $[9];
  }
  return t3;
}
const TYPE_TO_ICON = {
  Arguments: ArgumentIcon,
  "Deprecated Arguments": DeprecatedArgumentIcon,
  "Deprecated Enum Values": DeprecatedEnumValueIcon,
  "Deprecated Fields": DeprecatedFieldIcon,
  Directives: DirectiveIcon,
  "Enum Values": EnumValueIcon,
  Fields: FieldIcon,
  Implements: ImplementsIcon,
  Implementations: TypeIcon,
  "Possible Types": TypeIcon,
  "Root Types": RootTypeIcon,
  Type: TypeIcon,
  "All Schema Types": TypeIcon
};
function FieldDocumentation(props) {
  const $ = c(15);
  let t0;
  if ($[0] !== props.field.description) {
    t0 = props.field.description ? /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: props.field.description }) : null;
    $[0] = props.field.description;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== props.field.deprecationReason) {
    t1 = /* @__PURE__ */ jsx(DeprecationReason, { preview: false, children: props.field.deprecationReason });
    $[2] = props.field.deprecationReason;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  let t2;
  if ($[4] !== props.field.type) {
    t2 = /* @__PURE__ */ jsx(ExplorerSection, { title: "Type", children: /* @__PURE__ */ jsx(TypeLink, { type: props.field.type }) });
    $[4] = props.field.type;
    $[5] = t2;
  } else {
    t2 = $[5];
  }
  let t3;
  let t4;
  if ($[6] !== props.field) {
    t3 = /* @__PURE__ */ jsx(Arguments, { field: props.field });
    t4 = /* @__PURE__ */ jsx(Directives, { field: props.field });
    $[6] = props.field;
    $[7] = t3;
    $[8] = t4;
  } else {
    t3 = $[7];
    t4 = $[8];
  }
  let t5;
  if ($[9] !== t0 || $[10] !== t1 || $[11] !== t2 || $[12] !== t3 || $[13] !== t4) {
    t5 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t0,
      t1,
      t2,
      t3,
      t4
    ] });
    $[9] = t0;
    $[10] = t1;
    $[11] = t2;
    $[12] = t3;
    $[13] = t4;
    $[14] = t5;
  } else {
    t5 = $[14];
  }
  return t5;
}
function Arguments(t0) {
  const $ = c(12);
  const {
    field
  } = t0;
  const [showDeprecated, setShowDeprecated] = useState(false);
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = () => {
      setShowDeprecated(true);
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const handleShowDeprecated = t1;
  if (!("args" in field)) {
    return null;
  }
  let args;
  let deprecatedArgs;
  let t2;
  if ($[1] !== field.args) {
    args = [];
    deprecatedArgs = [];
    for (const argument of field.args) {
      if (argument.deprecationReason) {
        deprecatedArgs.push(argument);
      } else {
        args.push(argument);
      }
    }
    t2 = args.length > 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Arguments", children: args.map(_temp$5) }) : null;
    $[1] = field.args;
    $[2] = args;
    $[3] = deprecatedArgs;
    $[4] = t2;
  } else {
    args = $[2];
    deprecatedArgs = $[3];
    t2 = $[4];
  }
  let t3;
  if ($[5] !== args.length || $[6] !== deprecatedArgs || $[7] !== showDeprecated) {
    t3 = deprecatedArgs.length > 0 ? showDeprecated || args.length === 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Deprecated Arguments", children: deprecatedArgs.map(_temp2$2) }) : /* @__PURE__ */ jsx(Button$1, { type: "button", onClick: handleShowDeprecated, children: "Show Deprecated Arguments" }) : null;
    $[5] = args.length;
    $[6] = deprecatedArgs;
    $[7] = showDeprecated;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  let t4;
  if ($[9] !== t2 || $[10] !== t3) {
    t4 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t2,
      t3
    ] });
    $[9] = t2;
    $[10] = t3;
    $[11] = t4;
  } else {
    t4 = $[11];
  }
  return t4;
}
function _temp2$2(arg_0) {
  return /* @__PURE__ */ jsx(Argument, { arg: arg_0 }, arg_0.name);
}
function _temp$5(arg) {
  return /* @__PURE__ */ jsx(Argument, { arg }, arg.name);
}
function Directives(t0) {
  var _a, _b, _c;
  const $ = c(6);
  const {
    field
  } = t0;
  let t1;
  if ($[0] !== ((_a = field.astNode) == null ? void 0 : _a.directives)) {
    t1 = ((_b = field.astNode) == null ? void 0 : _b.directives) || [];
    $[0] = (_c = field.astNode) == null ? void 0 : _c.directives;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const directives = t1;
  if (!directives || directives.length === 0) {
    return null;
  }
  let t2;
  if ($[2] !== directives) {
    t2 = directives.map(_temp3$2);
    $[2] = directives;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  let t3;
  if ($[4] !== t2) {
    t3 = /* @__PURE__ */ jsx(ExplorerSection, { title: "Directives", children: t2 });
    $[4] = t2;
    $[5] = t3;
  } else {
    t3 = $[5];
  }
  return t3;
}
function _temp3$2(directive) {
  return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(Directive, { directive }) }, directive.name.value);
}
function SchemaDocumentation(props) {
  var _a, _b, _c, _d;
  const $ = c(39);
  let t0;
  if ($[0] !== props.schema) {
    t0 = props.schema.getQueryType();
    $[0] = props.schema;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  const queryType = t0;
  let t1;
  if ($[2] !== props.schema) {
    t1 = (_b = (_a = props.schema).getMutationType) == null ? void 0 : _b.call(_a);
    $[2] = props.schema;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  const mutationType = t1;
  let t2;
  if ($[4] !== props.schema) {
    t2 = (_d = (_c = props.schema).getSubscriptionType) == null ? void 0 : _d.call(_c);
    $[4] = props.schema;
    $[5] = t2;
  } else {
    t2 = $[5];
  }
  const subscriptionType = t2;
  let T0;
  let t3;
  let t4;
  let t5;
  let t6;
  if ($[6] !== mutationType || $[7] !== props.schema || $[8] !== queryType || $[9] !== subscriptionType) {
    const typeMap = props.schema.getTypeMap();
    const t72 = queryType == null ? void 0 : queryType.name;
    const t82 = mutationType == null ? void 0 : mutationType.name;
    const t9 = subscriptionType == null ? void 0 : subscriptionType.name;
    let t10;
    if ($[15] !== t72 || $[16] !== t82 || $[17] !== t9) {
      t10 = [t72, t82, t9];
      $[15] = t72;
      $[16] = t82;
      $[17] = t9;
      $[18] = t10;
    } else {
      t10 = $[18];
    }
    const ignoreTypesInAllSchema = t10;
    const t11 = props.schema.description || "A GraphQL schema provides a root type for each kind of operation.";
    if ($[19] !== t11) {
      t5 = /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: t11 });
      $[19] = t11;
      $[20] = t5;
    } else {
      t5 = $[20];
    }
    let t12;
    if ($[21] !== queryType) {
      t12 = queryType ? /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-root-type", children: "query" }),
        ": ",
        /* @__PURE__ */ jsx(TypeLink, { type: queryType })
      ] }) : null;
      $[21] = queryType;
      $[22] = t12;
    } else {
      t12 = $[22];
    }
    let t13;
    if ($[23] !== mutationType) {
      t13 = mutationType && /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-root-type", children: "mutation" }),
        ": ",
        /* @__PURE__ */ jsx(TypeLink, { type: mutationType })
      ] });
      $[23] = mutationType;
      $[24] = t13;
    } else {
      t13 = $[24];
    }
    let t14;
    if ($[25] !== subscriptionType) {
      t14 = subscriptionType && /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-root-type", children: "subscription" }),
        ": ",
        /* @__PURE__ */ jsx(TypeLink, { type: subscriptionType })
      ] });
      $[25] = subscriptionType;
      $[26] = t14;
    } else {
      t14 = $[26];
    }
    if ($[27] !== t12 || $[28] !== t13 || $[29] !== t14) {
      t6 = /* @__PURE__ */ jsxs(ExplorerSection, { title: "Root Types", children: [
        t12,
        t13,
        t14
      ] });
      $[27] = t12;
      $[28] = t13;
      $[29] = t14;
      $[30] = t6;
    } else {
      t6 = $[30];
    }
    T0 = ExplorerSection;
    t3 = "All Schema Types";
    t4 = typeMap && /* @__PURE__ */ jsx("div", { children: Object.values(typeMap).map((type) => {
      if (ignoreTypesInAllSchema.includes(type.name) || type.name.startsWith("__")) {
        return null;
      }
      return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(TypeLink, { type }) }, type.name);
    }) });
    $[6] = mutationType;
    $[7] = props.schema;
    $[8] = queryType;
    $[9] = subscriptionType;
    $[10] = T0;
    $[11] = t3;
    $[12] = t4;
    $[13] = t5;
    $[14] = t6;
  } else {
    T0 = $[10];
    t3 = $[11];
    t4 = $[12];
    t5 = $[13];
    t6 = $[14];
  }
  let t7;
  if ($[31] !== T0 || $[32] !== t3 || $[33] !== t4) {
    t7 = /* @__PURE__ */ jsx(T0, { title: t3, children: t4 });
    $[31] = T0;
    $[32] = t3;
    $[33] = t4;
    $[34] = t7;
  } else {
    t7 = $[34];
  }
  let t8;
  if ($[35] !== t5 || $[36] !== t6 || $[37] !== t7) {
    t8 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t5,
      t6,
      t7
    ] });
    $[35] = t5;
    $[36] = t6;
    $[37] = t7;
    $[38] = t8;
  } else {
    t8 = $[38];
  }
  return t8;
}
function debounce(duration, fn) {
  let timeout;
  return function(...args) {
    if (timeout) {
      window.clearTimeout(timeout);
    }
    timeout = window.setTimeout(() => {
      timeout = null;
      fn(...args);
    }, duration);
  };
}
function Search() {
  "use no memo";
  const {
    explorerNavStack,
    push
  } = useExplorerContext({
    nonNull: true,
    caller: Search
  });
  const inputRef = useRef(null);
  const getSearchResults = useSearchResults();
  const [searchValue, setSearchValue] = useState("");
  const [results, setResults] = useState(getSearchResults(searchValue));
  const debouncedGetSearchResults = useMemo(() => debounce(200, (search) => {
    setResults(getSearchResults(search));
  }), [getSearchResults]);
  useEffect(() => {
    debouncedGetSearchResults(searchValue);
  }, [debouncedGetSearchResults, searchValue]);
  useEffect(() => {
    function handleKeyDown(event) {
      var _a;
      if (event.metaKey && event.key === "k") {
        (_a = inputRef.current) == null ? void 0 : _a.focus();
      }
    }
    window.addEventListener("keydown", handleKeyDown);
    return () => window.removeEventListener("keydown", handleKeyDown);
  }, []);
  const navItem = explorerNavStack.at(-1);
  const onSelect = useCallback((def) => {
    push("field" in def ? {
      name: def.field.name,
      def: def.field
    } : {
      name: def.type.name,
      def: def.type
    });
  }, [push]);
  const isFocused = useRef(false);
  const handleFocus = useCallback((e) => {
    isFocused.current = e.type === "focus";
  }, []);
  const shouldSearchBoxAppear = explorerNavStack.length === 1 || isObjectType(navItem.def) || isInterfaceType(navItem.def) || isInputObjectType(navItem.def);
  if (!shouldSearchBoxAppear) {
    return null;
  }
  return /* @__PURE__ */ jsxs(Combobox, { as: "div", className: "graphiql-doc-explorer-search", onChange: onSelect, "data-state": isFocused ? void 0 : "idle", "aria-label": `Search ${navItem.name}...`, children: [
    /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-search-input", onClick: () => {
      var _a;
      (_a = inputRef.current) == null ? void 0 : _a.focus();
    }, children: [
      /* @__PURE__ */ jsx(MagnifyingGlassIcon, {}),
      /* @__PURE__ */ jsx(Combobox.Input, { autoComplete: "off", onFocus: handleFocus, onBlur: handleFocus, onChange: (event_0) => setSearchValue(event_0.target.value), placeholder: `${isMacOs ? "⌘" : "Ctrl"} K`, ref: inputRef, value: searchValue, "data-cy": "doc-explorer-input" })
    ] }),
    isFocused.current && /* @__PURE__ */ jsxs(Combobox.Options, { "data-cy": "doc-explorer-list", children: [
      results.within.length + results.types.length + results.fields.length === 0 ? /* @__PURE__ */ jsx("li", { className: "graphiql-doc-explorer-search-empty", children: "No results found" }) : results.within.map((result, i) => /* @__PURE__ */ jsx(Combobox.Option, { value: result, "data-cy": "doc-explorer-option", children: /* @__PURE__ */ jsx(Field$1, { field: result.field, argument: result.argument }) }, `within-${i}`)),
      results.within.length > 0 && results.types.length + results.fields.length > 0 ? /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-search-divider", children: "Other results" }) : null,
      results.types.map((result_0, i_0) => /* @__PURE__ */ jsx(Combobox.Option, { value: result_0, "data-cy": "doc-explorer-option", children: /* @__PURE__ */ jsx(Type, { type: result_0.type }) }, `type-${i_0}`)),
      results.fields.map((result_1, i_1) => /* @__PURE__ */ jsxs(Combobox.Option, { value: result_1, "data-cy": "doc-explorer-option", children: [
        /* @__PURE__ */ jsx(Type, { type: result_1.type }),
        ".",
        /* @__PURE__ */ jsx(Field$1, { field: result_1.field, argument: result_1.argument })
      ] }, `field-${i_1}`))
    ] })
  ] });
}
const _useSearchResults = useSearchResults;
function useSearchResults(caller) {
  const $ = c(9);
  const t0 = caller || _useSearchResults;
  let t1;
  if ($[0] !== t0) {
    t1 = {
      nonNull: true,
      caller: t0
    };
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    explorerNavStack
  } = useExplorerContext(t1);
  const t2 = caller || _useSearchResults;
  let t3;
  if ($[2] !== t2) {
    t3 = {
      nonNull: true,
      caller: t2
    };
    $[2] = t2;
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const {
    schema
  } = useSchemaContext(t3);
  let t4;
  if ($[4] !== explorerNavStack) {
    t4 = explorerNavStack.at(-1);
    $[4] = explorerNavStack;
    $[5] = t4;
  } else {
    t4 = $[5];
  }
  const navItem = t4;
  let t5;
  if ($[6] !== navItem || $[7] !== schema) {
    t5 = (searchValue) => {
      const matches = {
        within: [],
        types: [],
        fields: []
      };
      if (!schema) {
        return matches;
      }
      const withinType = navItem.def;
      const typeMap = schema.getTypeMap();
      let typeNames = Object.keys(typeMap);
      if (withinType) {
        typeNames = typeNames.filter((n) => n !== withinType.name);
        typeNames.unshift(withinType.name);
      }
      for (const typeName of typeNames) {
        if (matches.within.length + matches.types.length + matches.fields.length >= 100) {
          break;
        }
        const type = typeMap[typeName];
        if (withinType !== type && isMatch(typeName, searchValue)) {
          matches.types.push({
            type
          });
        }
        if (!isObjectType(type) && !isInterfaceType(type) && !isInputObjectType(type)) {
          continue;
        }
        const fields = type.getFields();
        for (const fieldName in fields) {
          const field = fields[fieldName];
          let matchingArgs;
          if (!isMatch(fieldName, searchValue)) {
            if ("args" in field) {
              matchingArgs = field.args.filter((arg) => isMatch(arg.name, searchValue));
              if (matchingArgs.length === 0) {
                continue;
              }
            } else {
              continue;
            }
          }
          matches[withinType === type ? "within" : "fields"].push(...matchingArgs ? matchingArgs.map((argument) => ({
            type,
            field,
            argument
          })) : [{
            type,
            field
          }]);
        }
      }
      return matches;
    };
    $[6] = navItem;
    $[7] = schema;
    $[8] = t5;
  } else {
    t5 = $[8];
  }
  return t5;
}
function isMatch(sourceText, searchValue) {
  try {
    const escaped = searchValue.replaceAll(/[^_0-9A-Za-z]/g, (ch) => "\\" + ch);
    return sourceText.search(new RegExp(escaped, "i")) !== -1;
  } catch {
    return sourceText.toLowerCase().includes(searchValue.toLowerCase());
  }
}
function Type(props) {
  const $ = c(2);
  let t0;
  if ($[0] !== props.type.name) {
    t0 = /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-type", children: props.type.name });
    $[0] = props.type.name;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
}
function Field$1(t0) {
  const $ = c(7);
  const {
    field,
    argument
  } = t0;
  let t1;
  if ($[0] !== field.name) {
    t1 = /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-field", children: field.name });
    $[0] = field.name;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] !== argument) {
    t2 = argument ? /* @__PURE__ */ jsxs(Fragment, { children: [
      "(",
      /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-search-argument", children: argument.name }),
      ":",
      " ",
      renderType(argument.type, _temp$4),
      ")"
    ] }) : null;
    $[2] = argument;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  let t3;
  if ($[4] !== t1 || $[5] !== t2) {
    t3 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t1,
      t2
    ] });
    $[4] = t1;
    $[5] = t2;
    $[6] = t3;
  } else {
    t3 = $[6];
  }
  return t3;
}
function _temp$4(namedType) {
  return /* @__PURE__ */ jsx(Type, { type: namedType });
}
function FieldLink(props) {
  const $ = c(7);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    push
  } = useExplorerContext(t0);
  let t1;
  if ($[1] !== props.field || $[2] !== push) {
    t1 = (event) => {
      event.preventDefault();
      push({
        name: props.field.name,
        def: props.field
      });
    };
    $[1] = props.field;
    $[2] = push;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  let t2;
  if ($[4] !== props.field.name || $[5] !== t1) {
    t2 = /* @__PURE__ */ jsx("a", { className: "graphiql-doc-explorer-field-name", onClick: t1, href: "#", children: props.field.name });
    $[4] = props.field.name;
    $[5] = t1;
    $[6] = t2;
  } else {
    t2 = $[6];
  }
  return t2;
}
function TypeDocumentation(props) {
  const $ = c(2);
  let t0;
  if ($[0] !== props.type) {
    t0 = isNamedType(props.type) ? /* @__PURE__ */ jsxs(Fragment, { children: [
      props.type.description ? /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: props.type.description }) : null,
      /* @__PURE__ */ jsx(ImplementsInterfaces, { type: props.type }),
      /* @__PURE__ */ jsx(Fields, { type: props.type }),
      /* @__PURE__ */ jsx(EnumValues, { type: props.type }),
      /* @__PURE__ */ jsx(PossibleTypes, { type: props.type })
    ] }) : null;
    $[0] = props.type;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
}
function ImplementsInterfaces(t0) {
  const $ = c(5);
  const {
    type
  } = t0;
  if (!isObjectType(type)) {
    return null;
  }
  let t1;
  if ($[0] !== type) {
    t1 = type.getInterfaces();
    $[0] = type;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const interfaces = t1;
  let t2;
  if ($[2] !== interfaces.length || $[3] !== type) {
    t2 = interfaces.length > 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Implements", children: type.getInterfaces().map(_temp$3) }) : null;
    $[2] = interfaces.length;
    $[3] = type;
    $[4] = t2;
  } else {
    t2 = $[4];
  }
  return t2;
}
function _temp$3(implementedInterface) {
  return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(TypeLink, { type: implementedInterface }) }, implementedInterface.name);
}
function Fields(t0) {
  const $ = c(12);
  const {
    type
  } = t0;
  const [showDeprecated, setShowDeprecated] = useState(false);
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = () => {
      setShowDeprecated(true);
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const handleShowDeprecated = t1;
  if (!isObjectType(type) && !isInterfaceType(type) && !isInputObjectType(type)) {
    return null;
  }
  let deprecatedFields;
  let fields;
  let t2;
  if ($[1] !== type) {
    const fieldMap = type.getFields();
    fields = [];
    deprecatedFields = [];
    for (const field of Object.keys(fieldMap).map((name) => fieldMap[name])) {
      if (field.deprecationReason) {
        deprecatedFields.push(field);
      } else {
        fields.push(field);
      }
    }
    t2 = fields.length > 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Fields", children: fields.map(_temp2$1) }) : null;
    $[1] = type;
    $[2] = deprecatedFields;
    $[3] = fields;
    $[4] = t2;
  } else {
    deprecatedFields = $[2];
    fields = $[3];
    t2 = $[4];
  }
  let t3;
  if ($[5] !== deprecatedFields || $[6] !== fields.length || $[7] !== showDeprecated) {
    t3 = deprecatedFields.length > 0 ? showDeprecated || fields.length === 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Deprecated Fields", children: deprecatedFields.map(_temp3$1) }) : /* @__PURE__ */ jsx(Button$1, { type: "button", onClick: handleShowDeprecated, children: "Show Deprecated Fields" }) : null;
    $[5] = deprecatedFields;
    $[6] = fields.length;
    $[7] = showDeprecated;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  let t4;
  if ($[9] !== t2 || $[10] !== t3) {
    t4 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t2,
      t3
    ] });
    $[9] = t2;
    $[10] = t3;
    $[11] = t4;
  } else {
    t4 = $[11];
  }
  return t4;
}
function _temp3$1(field_1) {
  return /* @__PURE__ */ jsx(Field, { field: field_1 }, field_1.name);
}
function _temp2$1(field_0) {
  return /* @__PURE__ */ jsx(Field, { field: field_0 }, field_0.name);
}
function Field(t0) {
  const $ = c(22);
  const {
    field
  } = t0;
  let t1;
  let t2;
  let t3;
  if ($[0] !== field) {
    const args = "args" in field ? field.args.filter(_temp4$1) : [];
    t3 = "graphiql-doc-explorer-item";
    t1 = /* @__PURE__ */ jsx(FieldLink, { field });
    t2 = args.length > 0 ? /* @__PURE__ */ jsxs(Fragment, { children: [
      "(",
      /* @__PURE__ */ jsx("span", { children: args.map((arg_0) => args.length === 1 ? /* @__PURE__ */ jsx(Argument, { arg: arg_0, inline: true }, arg_0.name) : /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-argument-multiple", children: /* @__PURE__ */ jsx(Argument, { arg: arg_0, inline: true }) }, arg_0.name)) }),
      ")"
    ] }) : null;
    $[0] = field;
    $[1] = t1;
    $[2] = t2;
    $[3] = t3;
  } else {
    t1 = $[1];
    t2 = $[2];
    t3 = $[3];
  }
  let t4;
  if ($[4] !== field.type) {
    t4 = /* @__PURE__ */ jsx(TypeLink, { type: field.type });
    $[4] = field.type;
    $[5] = t4;
  } else {
    t4 = $[5];
  }
  let t5;
  if ($[6] !== field) {
    t5 = /* @__PURE__ */ jsx(DefaultValue, { field });
    $[6] = field;
    $[7] = t5;
  } else {
    t5 = $[7];
  }
  let t6;
  if ($[8] !== t1 || $[9] !== t2 || $[10] !== t4 || $[11] !== t5) {
    t6 = /* @__PURE__ */ jsxs("div", { children: [
      t1,
      t2,
      ": ",
      t4,
      t5
    ] });
    $[8] = t1;
    $[9] = t2;
    $[10] = t4;
    $[11] = t5;
    $[12] = t6;
  } else {
    t6 = $[12];
  }
  let t7;
  if ($[13] !== field.description) {
    t7 = field.description ? /* @__PURE__ */ jsx(MarkdownContent, { type: "description", onlyShowFirstChild: true, children: field.description }) : null;
    $[13] = field.description;
    $[14] = t7;
  } else {
    t7 = $[14];
  }
  let t8;
  if ($[15] !== field.deprecationReason) {
    t8 = /* @__PURE__ */ jsx(DeprecationReason, { children: field.deprecationReason });
    $[15] = field.deprecationReason;
    $[16] = t8;
  } else {
    t8 = $[16];
  }
  let t9;
  if ($[17] !== t3 || $[18] !== t6 || $[19] !== t7 || $[20] !== t8) {
    t9 = /* @__PURE__ */ jsxs("div", { className: t3, children: [
      t6,
      t7,
      t8
    ] });
    $[17] = t3;
    $[18] = t6;
    $[19] = t7;
    $[20] = t8;
    $[21] = t9;
  } else {
    t9 = $[21];
  }
  return t9;
}
function _temp4$1(arg) {
  return !arg.deprecationReason;
}
function EnumValues(t0) {
  const $ = c(12);
  const {
    type
  } = t0;
  const [showDeprecated, setShowDeprecated] = useState(false);
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = () => {
      setShowDeprecated(true);
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const handleShowDeprecated = t1;
  if (!isEnumType(type)) {
    return null;
  }
  let deprecatedValues;
  let t2;
  let values;
  if ($[1] !== type) {
    values = [];
    deprecatedValues = [];
    for (const value of type.getValues()) {
      if (value.deprecationReason) {
        deprecatedValues.push(value);
      } else {
        values.push(value);
      }
    }
    t2 = values.length > 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Enum Values", children: values.map(_temp5) }) : null;
    $[1] = type;
    $[2] = deprecatedValues;
    $[3] = t2;
    $[4] = values;
  } else {
    deprecatedValues = $[2];
    t2 = $[3];
    values = $[4];
  }
  let t3;
  if ($[5] !== deprecatedValues || $[6] !== showDeprecated || $[7] !== values.length) {
    t3 = deprecatedValues.length > 0 ? showDeprecated || values.length === 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Deprecated Enum Values", children: deprecatedValues.map(_temp6) }) : /* @__PURE__ */ jsx(Button$1, { type: "button", onClick: handleShowDeprecated, children: "Show Deprecated Values" }) : null;
    $[5] = deprecatedValues;
    $[6] = showDeprecated;
    $[7] = values.length;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  let t4;
  if ($[9] !== t2 || $[10] !== t3) {
    t4 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t2,
      t3
    ] });
    $[9] = t2;
    $[10] = t3;
    $[11] = t4;
  } else {
    t4 = $[11];
  }
  return t4;
}
function _temp6(value_1) {
  return /* @__PURE__ */ jsx(EnumValue, { value: value_1 }, value_1.name);
}
function _temp5(value_0) {
  return /* @__PURE__ */ jsx(EnumValue, { value: value_0 }, value_0.name);
}
function EnumValue(t0) {
  const $ = c(10);
  const {
    value
  } = t0;
  let t1;
  if ($[0] !== value.name) {
    t1 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-enum-value", children: value.name });
    $[0] = value.name;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] !== value.description) {
    t2 = value.description ? /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: value.description }) : null;
    $[2] = value.description;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  let t3;
  if ($[4] !== value.deprecationReason) {
    t3 = value.deprecationReason ? /* @__PURE__ */ jsx(MarkdownContent, { type: "deprecation", children: value.deprecationReason }) : null;
    $[4] = value.deprecationReason;
    $[5] = t3;
  } else {
    t3 = $[5];
  }
  let t4;
  if ($[6] !== t1 || $[7] !== t2 || $[8] !== t3) {
    t4 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-item", children: [
      t1,
      t2,
      t3
    ] });
    $[6] = t1;
    $[7] = t2;
    $[8] = t3;
    $[9] = t4;
  } else {
    t4 = $[9];
  }
  return t4;
}
function PossibleTypes(t0) {
  const $ = c(7);
  const {
    type
  } = t0;
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const {
    schema
  } = useSchemaContext(t1);
  if (!schema || !isAbstractType(type)) {
    return null;
  }
  const t2 = isInterfaceType(type) ? "Implementations" : "Possible Types";
  let t3;
  if ($[1] !== schema || $[2] !== type) {
    t3 = schema.getPossibleTypes(type).map(_temp7);
    $[1] = schema;
    $[2] = type;
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  let t4;
  if ($[4] !== t2 || $[5] !== t3) {
    t4 = /* @__PURE__ */ jsx(ExplorerSection, { title: t2, children: t3 });
    $[4] = t2;
    $[5] = t3;
    $[6] = t4;
  } else {
    t4 = $[6];
  }
  return t4;
}
function _temp7(possibleType) {
  return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(TypeLink, { type: possibleType }) }, possibleType.name);
}
function DocExplorer() {
  const $ = c(40);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: DocExplorer
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    fetchError,
    isFetching,
    schema,
    validationErrors
  } = useSchemaContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: DocExplorer
    };
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    explorerNavStack,
    pop
  } = useExplorerContext(t1);
  let content;
  let navItem;
  if ($[2] !== explorerNavStack || $[3] !== fetchError || $[4] !== isFetching || $[5] !== schema || $[6] !== validationErrors) {
    navItem = explorerNavStack.at(-1);
    content = null;
    if (fetchError) {
      let t22;
      if ($[9] === Symbol.for("react.memo_cache_sentinel")) {
        t22 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-error", children: "Error fetching schema" });
        $[9] = t22;
      } else {
        t22 = $[9];
      }
      content = t22;
    } else {
      if (validationErrors.length > 0) {
        const t22 = validationErrors[0];
        let t32;
        if ($[10] !== t22.message) {
          t32 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-error", children: [
            "Schema is invalid: ",
            t22.message
          ] });
          $[10] = t22.message;
          $[11] = t32;
        } else {
          t32 = $[11];
        }
        content = t32;
      } else {
        if (isFetching) {
          let t22;
          if ($[12] === Symbol.for("react.memo_cache_sentinel")) {
            t22 = /* @__PURE__ */ jsx(Spinner, {});
            $[12] = t22;
          } else {
            t22 = $[12];
          }
          content = t22;
        } else {
          if (!schema) {
            let t22;
            if ($[13] === Symbol.for("react.memo_cache_sentinel")) {
              t22 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-error", children: "No GraphQL schema available" });
              $[13] = t22;
            } else {
              t22 = $[13];
            }
            content = t22;
          } else {
            if (explorerNavStack.length === 1) {
              let t22;
              if ($[14] !== schema) {
                t22 = /* @__PURE__ */ jsx(SchemaDocumentation, { schema });
                $[14] = schema;
                $[15] = t22;
              } else {
                t22 = $[15];
              }
              content = t22;
            } else {
              if (isType(navItem.def)) {
                let t22;
                if ($[16] !== navItem.def) {
                  t22 = /* @__PURE__ */ jsx(TypeDocumentation, { type: navItem.def });
                  $[16] = navItem.def;
                  $[17] = t22;
                } else {
                  t22 = $[17];
                }
                content = t22;
              } else {
                if (navItem.def) {
                  let t22;
                  if ($[18] !== navItem.def) {
                    t22 = /* @__PURE__ */ jsx(FieldDocumentation, { field: navItem.def });
                    $[18] = navItem.def;
                    $[19] = t22;
                  } else {
                    t22 = $[19];
                  }
                  content = t22;
                }
              }
            }
          }
        }
      }
    }
    $[2] = explorerNavStack;
    $[3] = fetchError;
    $[4] = isFetching;
    $[5] = schema;
    $[6] = validationErrors;
    $[7] = content;
    $[8] = navItem;
  } else {
    content = $[7];
    navItem = $[8];
  }
  let prevName;
  if (explorerNavStack.length > 1) {
    let t22;
    if ($[20] !== explorerNavStack) {
      t22 = explorerNavStack.at(-2);
      $[20] = explorerNavStack;
      $[21] = t22;
    } else {
      t22 = $[21];
    }
    prevName = t22.name;
  }
  let t2;
  if ($[22] !== pop || $[23] !== prevName) {
    t2 = prevName && /* @__PURE__ */ jsxs("a", { href: "#", className: "graphiql-doc-explorer-back", onClick: (event) => {
      event.preventDefault();
      pop();
    }, "aria-label": `Go back to ${prevName}`, children: [
      /* @__PURE__ */ jsx(ChevronLeftIcon, {}),
      prevName
    ] });
    $[22] = pop;
    $[23] = prevName;
    $[24] = t2;
  } else {
    t2 = $[24];
  }
  let t3;
  if ($[25] !== navItem.name) {
    t3 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-title", children: navItem.name });
    $[25] = navItem.name;
    $[26] = t3;
  } else {
    t3 = $[26];
  }
  let t4;
  if ($[27] !== t2 || $[28] !== t3) {
    t4 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-header-content", children: [
      t2,
      t3
    ] });
    $[27] = t2;
    $[28] = t3;
    $[29] = t4;
  } else {
    t4 = $[29];
  }
  let t5;
  if ($[30] !== navItem.name) {
    t5 = /* @__PURE__ */ jsx(Search, {}, navItem.name);
    $[30] = navItem.name;
    $[31] = t5;
  } else {
    t5 = $[31];
  }
  let t6;
  if ($[32] !== t4 || $[33] !== t5) {
    t6 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-header", children: [
      t4,
      t5
    ] });
    $[32] = t4;
    $[33] = t5;
    $[34] = t6;
  } else {
    t6 = $[34];
  }
  let t7;
  if ($[35] !== content) {
    t7 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-content", children: content });
    $[35] = content;
    $[36] = t7;
  } else {
    t7 = $[36];
  }
  let t8;
  if ($[37] !== t6 || $[38] !== t7) {
    t8 = /* @__PURE__ */ jsxs("section", { className: "graphiql-doc-explorer", "aria-label": "Documentation Explorer", children: [
      t6,
      t7
    ] });
    $[37] = t6;
    $[38] = t7;
    $[39] = t8;
  } else {
    t8 = $[39];
  }
  return t8;
}
const DOC_EXPLORER_PLUGIN = {
  title: "Documentation Explorer",
  icon: function Icon() {
    const pluginContext = usePluginContext();
    return (pluginContext == null ? void 0 : pluginContext.visiblePlugin) === DOC_EXPLORER_PLUGIN ? /* @__PURE__ */ jsx(DocsFilledIcon, {}) : /* @__PURE__ */ jsx(DocsIcon, {});
  },
  content: DocExplorer
};
const HISTORY_PLUGIN = {
  title: "History",
  icon: HistoryIcon,
  content: History
};
const PluginContext = createNullableContext("PluginContext");
function PluginContextProvider(props) {
  const $ = c(27);
  const storage = useStorageContext();
  const explorerContext = useExplorerContext();
  const historyContext = useHistoryContext();
  const hasExplorerContext = Boolean(explorerContext);
  const hasHistoryContext = Boolean(historyContext);
  let t0;
  let pluginList;
  if ($[0] !== hasExplorerContext || $[1] !== hasHistoryContext || $[2] !== props.plugins) {
    pluginList = [];
    const pluginTitles = {};
    if (hasExplorerContext) {
      pluginList.push(DOC_EXPLORER_PLUGIN);
      pluginTitles[DOC_EXPLORER_PLUGIN.title] = true;
    }
    if (hasHistoryContext) {
      pluginList.push(HISTORY_PLUGIN);
      pluginTitles[HISTORY_PLUGIN.title] = true;
    }
    let t12;
    if ($[4] !== props.plugins) {
      t12 = props.plugins || [];
      $[4] = props.plugins;
      $[5] = t12;
    } else {
      t12 = $[5];
    }
    for (const plugin of t12) {
      if (typeof plugin.title !== "string" || !plugin.title) {
        throw new Error("All GraphiQL plugins must have a unique title");
      }
      if (pluginTitles[plugin.title]) {
        throw new Error(`All GraphiQL plugins must have a unique title, found two plugins with the title '${plugin.title}'`);
      } else {
        pluginList.push(plugin);
        pluginTitles[plugin.title] = true;
      }
    }
    $[0] = hasExplorerContext;
    $[1] = hasHistoryContext;
    $[2] = props.plugins;
    $[3] = pluginList;
  } else {
    pluginList = $[3];
  }
  t0 = pluginList;
  const plugins = t0;
  let t1;
  if ($[6] !== plugins || $[7] !== props.visiblePlugin || $[8] !== storage) {
    t1 = () => {
      const storedValue = storage == null ? void 0 : storage.get(STORAGE_KEY$4);
      const pluginForStoredValue = plugins.find((plugin_0) => plugin_0.title === storedValue);
      if (pluginForStoredValue) {
        return pluginForStoredValue;
      }
      if (storedValue) {
        storage == null ? void 0 : storage.set(STORAGE_KEY$4, "");
      }
      if (!props.visiblePlugin) {
        return null;
      }
      return plugins.find((plugin_1) => (typeof props.visiblePlugin === "string" ? plugin_1.title : plugin_1) === props.visiblePlugin) || null;
    };
    $[6] = plugins;
    $[7] = props.visiblePlugin;
    $[8] = storage;
    $[9] = t1;
  } else {
    t1 = $[9];
  }
  const [visiblePlugin, internalSetVisiblePlugin] = useState(t1);
  const {
    onTogglePluginVisibility,
    children
  } = props;
  let t2;
  if ($[10] !== onTogglePluginVisibility || $[11] !== plugins) {
    t2 = (plugin_2) => {
      const newVisiblePlugin = plugin_2 ? plugins.find((p) => (typeof plugin_2 === "string" ? p.title : p) === plugin_2) || null : null;
      internalSetVisiblePlugin((current) => {
        if (newVisiblePlugin === current) {
          return current;
        }
        onTogglePluginVisibility == null ? void 0 : onTogglePluginVisibility(newVisiblePlugin);
        return newVisiblePlugin;
      });
    };
    $[10] = onTogglePluginVisibility;
    $[11] = plugins;
    $[12] = t2;
  } else {
    t2 = $[12];
  }
  const setVisiblePlugin = t2;
  let t3;
  if ($[13] !== props.visiblePlugin || $[14] !== setVisiblePlugin) {
    t3 = () => {
      if (props.visiblePlugin) {
        setVisiblePlugin(props.visiblePlugin);
      }
    };
    $[13] = props.visiblePlugin;
    $[14] = setVisiblePlugin;
    $[15] = t3;
  } else {
    t3 = $[15];
  }
  let t4;
  if ($[16] !== plugins || $[17] !== props.visiblePlugin || $[18] !== setVisiblePlugin) {
    t4 = [plugins, props.visiblePlugin, setVisiblePlugin];
    $[16] = plugins;
    $[17] = props.visiblePlugin;
    $[18] = setVisiblePlugin;
    $[19] = t4;
  } else {
    t4 = $[19];
  }
  useEffect(t3, t4);
  let t5;
  if ($[20] !== plugins || $[21] !== setVisiblePlugin || $[22] !== visiblePlugin) {
    t5 = {
      plugins,
      setVisiblePlugin,
      visiblePlugin
    };
    $[20] = plugins;
    $[21] = setVisiblePlugin;
    $[22] = visiblePlugin;
    $[23] = t5;
  } else {
    t5 = $[23];
  }
  const value = t5;
  let t6;
  if ($[24] !== children || $[25] !== value) {
    t6 = /* @__PURE__ */ jsx(PluginContext.Provider, { value, children });
    $[24] = children;
    $[25] = value;
    $[26] = t6;
  } else {
    t6 = $[26];
  }
  return t6;
}
const usePluginContext = createContextHook(PluginContext);
const STORAGE_KEY$4 = "visiblePlugin";
function onHasCompletion(_cm, data, schema, explorer, plugin, callback) {
  void importCodeMirror([], {
    useCommonAddons: false
  }).then((CodeMirror) => {
    let information;
    let fieldName;
    let typeNamePill;
    let typeNamePrefix;
    let typeName;
    let typeNameSuffix;
    let description;
    let deprecation;
    let deprecationReason;
    CodeMirror.on(
      data,
      "select",
      // @ts-expect-error
      (ctx, el) => {
        if (!information) {
          const hintsUl = el.parentNode;
          information = document.createElement("div");
          information.className = "CodeMirror-hint-information";
          hintsUl.append(information);
          const header = document.createElement("header");
          header.className = "CodeMirror-hint-information-header";
          information.append(header);
          fieldName = document.createElement("span");
          fieldName.className = "CodeMirror-hint-information-field-name";
          header.append(fieldName);
          typeNamePill = document.createElement("span");
          typeNamePill.className = "CodeMirror-hint-information-type-name-pill";
          header.append(typeNamePill);
          typeNamePrefix = document.createElement("span");
          typeNamePill.append(typeNamePrefix);
          typeName = document.createElement("a");
          typeName.className = "CodeMirror-hint-information-type-name";
          typeName.href = "javascript:void 0";
          typeName.addEventListener("click", onClickHintInformation);
          typeNamePill.append(typeName);
          typeNameSuffix = document.createElement("span");
          typeNamePill.append(typeNameSuffix);
          description = document.createElement("div");
          description.className = "CodeMirror-hint-information-description";
          information.append(description);
          deprecation = document.createElement("div");
          deprecation.className = "CodeMirror-hint-information-deprecation";
          information.append(deprecation);
          const deprecationLabel = document.createElement("span");
          deprecationLabel.className = "CodeMirror-hint-information-deprecation-label";
          deprecationLabel.textContent = "Deprecated";
          deprecation.append(deprecationLabel);
          deprecationReason = document.createElement("div");
          deprecationReason.className = "CodeMirror-hint-information-deprecation-reason";
          deprecation.append(deprecationReason);
          const defaultInformationPadding = parseInt(window.getComputedStyle(information).paddingBottom.replace(/px$/, ""), 10) || 0;
          const defaultInformationMaxHeight = parseInt(window.getComputedStyle(information).maxHeight.replace(/px$/, ""), 10) || 0;
          const handleScroll = () => {
            if (information) {
              information.style.paddingTop = hintsUl.scrollTop + defaultInformationPadding + "px";
              information.style.maxHeight = hintsUl.scrollTop + defaultInformationMaxHeight + "px";
            }
          };
          hintsUl.addEventListener("scroll", handleScroll);
          let onRemoveFn;
          hintsUl.addEventListener("DOMNodeRemoved", onRemoveFn = (event) => {
            if (event.target !== hintsUl) {
              return;
            }
            hintsUl.removeEventListener("scroll", handleScroll);
            hintsUl.removeEventListener("DOMNodeRemoved", onRemoveFn);
            if (information) {
              information.removeEventListener("click", onClickHintInformation);
            }
            information = null;
            fieldName = null;
            typeNamePill = null;
            typeNamePrefix = null;
            typeName = null;
            typeNameSuffix = null;
            description = null;
            deprecation = null;
            deprecationReason = null;
            onRemoveFn = null;
          });
        }
        if (fieldName) {
          fieldName.textContent = ctx.text;
        }
        if (typeNamePill && typeNamePrefix && typeName && typeNameSuffix) {
          if (ctx.type) {
            typeNamePill.style.display = "inline";
            const renderType2 = (type) => {
              if (isNonNullType(type)) {
                typeNameSuffix.textContent = "!" + typeNameSuffix.textContent;
                renderType2(type.ofType);
              } else if (isListType(type)) {
                typeNamePrefix.textContent += "[";
                typeNameSuffix.textContent = "]" + typeNameSuffix.textContent;
                renderType2(type.ofType);
              } else {
                typeName.textContent = type.name;
              }
            };
            typeNamePrefix.textContent = "";
            typeNameSuffix.textContent = "";
            renderType2(ctx.type);
          } else {
            typeNamePrefix.textContent = "";
            typeName.textContent = "";
            typeNameSuffix.textContent = "";
            typeNamePill.style.display = "none";
          }
        }
        if (description) {
          if (ctx.description) {
            description.style.display = "block";
            description.innerHTML = markdown.render(ctx.description);
          } else {
            description.style.display = "none";
            description.innerHTML = "";
          }
        }
        if (deprecation && deprecationReason) {
          if (ctx.deprecationReason) {
            deprecation.style.display = "block";
            deprecationReason.innerHTML = markdown.render(ctx.deprecationReason);
          } else {
            deprecation.style.display = "none";
            deprecationReason.innerHTML = "";
          }
        }
      }
    );
  });
  function onClickHintInformation(event) {
    if (!schema || !explorer || !plugin || !(event.currentTarget instanceof HTMLElement)) {
      return;
    }
    const typeName = event.currentTarget.textContent || "";
    const type = schema.getType(typeName);
    if (type) {
      plugin.setVisiblePlugin(DOC_EXPLORER_PLUGIN);
      explorer.push({
        name: type.name,
        def: type
      });
      callback == null ? void 0 : callback(type);
    }
  }
}
function useSynchronizeValue(editor, value) {
  const $ = c(4);
  let t0;
  let t1;
  if ($[0] !== editor || $[1] !== value) {
    t0 = () => {
      if (editor && typeof value === "string" && value !== editor.getValue()) {
        editor.setValue(value);
      }
    };
    t1 = [editor, value];
    $[0] = editor;
    $[1] = value;
    $[2] = t0;
    $[3] = t1;
  } else {
    t0 = $[2];
    t1 = $[3];
  }
  useEffect(t0, t1);
}
function useSynchronizeOption(editor, option, value) {
  const $ = c(5);
  let t0;
  let t1;
  if ($[0] !== editor || $[1] !== option || $[2] !== value) {
    t0 = () => {
      if (editor) {
        editor.setOption(option, value);
      }
    };
    t1 = [editor, option, value];
    $[0] = editor;
    $[1] = option;
    $[2] = value;
    $[3] = t0;
    $[4] = t1;
  } else {
    t0 = $[3];
    t1 = $[4];
  }
  useEffect(t0, t1);
}
function useChangeHandler(editor, callback, storageKey, tabProperty, caller) {
  const $ = c(10);
  let t0;
  if ($[0] !== caller) {
    t0 = {
      nonNull: true,
      caller
    };
    $[0] = caller;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  const {
    updateActiveTabValues
  } = useEditorContext(t0);
  const storage = useStorageContext();
  let t1;
  let t2;
  if ($[2] !== callback || $[3] !== editor || $[4] !== storage || $[5] !== storageKey || $[6] !== tabProperty || $[7] !== updateActiveTabValues) {
    t1 = () => {
      if (!editor) {
        return;
      }
      const store = debounce(500, (value) => {
        if (!storage || storageKey === null) {
          return;
        }
        storage.set(storageKey, value);
      });
      const updateTab = debounce(100, (value_0) => {
        updateActiveTabValues({
          [tabProperty]: value_0
        });
      });
      const handleChange = (editorInstance, changeObj) => {
        if (!changeObj) {
          return;
        }
        const newValue = editorInstance.getValue();
        store(newValue);
        updateTab(newValue);
        callback == null ? void 0 : callback(newValue);
      };
      editor.on("change", handleChange);
      return () => editor.off("change", handleChange);
    };
    t2 = [callback, editor, storage, storageKey, tabProperty, updateActiveTabValues];
    $[2] = callback;
    $[3] = editor;
    $[4] = storage;
    $[5] = storageKey;
    $[6] = tabProperty;
    $[7] = updateActiveTabValues;
    $[8] = t1;
    $[9] = t2;
  } else {
    t1 = $[8];
    t2 = $[9];
  }
  useEffect(t1, t2);
}
function useCompletion(editor, callback, caller) {
  const $ = c(9);
  let t0;
  if ($[0] !== caller) {
    t0 = {
      nonNull: true,
      caller
    };
    $[0] = caller;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  const {
    schema
  } = useSchemaContext(t0);
  const explorer = useExplorerContext();
  const plugin = usePluginContext();
  let t1;
  let t2;
  if ($[2] !== callback || $[3] !== editor || $[4] !== explorer || $[5] !== plugin || $[6] !== schema) {
    t1 = () => {
      if (!editor) {
        return;
      }
      const handleCompletion = (instance, changeObj) => {
        onHasCompletion(instance, changeObj, schema, explorer, plugin, (type) => {
          callback == null ? void 0 : callback({
            kind: "Type",
            type,
            schema: schema || void 0
          });
        });
      };
      editor.on("hasCompletion", handleCompletion);
      return () => editor.off("hasCompletion", handleCompletion);
    };
    t2 = [callback, editor, explorer, plugin, schema];
    $[2] = callback;
    $[3] = editor;
    $[4] = explorer;
    $[5] = plugin;
    $[6] = schema;
    $[7] = t1;
    $[8] = t2;
  } else {
    t1 = $[7];
    t2 = $[8];
  }
  useEffect(t1, t2);
}
function useKeyMap(editor, keys, callback) {
  const $ = c(5);
  let t0;
  let t1;
  if ($[0] !== callback || $[1] !== editor || $[2] !== keys) {
    t0 = () => {
      if (!editor) {
        return;
      }
      for (const key of keys) {
        editor.removeKeyMap(key);
      }
      if (callback) {
        const keyMap = {};
        for (const key_0 of keys) {
          keyMap[key_0] = () => callback();
        }
        editor.addKeyMap(keyMap);
      }
    };
    t1 = [editor, keys, callback];
    $[0] = callback;
    $[1] = editor;
    $[2] = keys;
    $[3] = t0;
    $[4] = t1;
  } else {
    t0 = $[3];
    t1 = $[4];
  }
  useEffect(t0, t1);
}
const _useCopyQuery = useCopyQuery;
const _useMergeQuery = useMergeQuery;
const _usePrettifyEditors = usePrettifyEditors;
const _useAutoCompleteLeafs = useAutoCompleteLeafs;
function useCopyQuery(t0) {
  const $ = c(7);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    caller,
    onCopyQuery
  } = t1;
  const t2 = caller || _useCopyQuery;
  let t3;
  if ($[2] !== t2) {
    t3 = {
      nonNull: true,
      caller: t2
    };
    $[2] = t2;
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const {
    queryEditor
  } = useEditorContext(t3);
  let t4;
  if ($[4] !== onCopyQuery || $[5] !== queryEditor) {
    t4 = () => {
      if (!queryEditor) {
        return;
      }
      const query = queryEditor.getValue();
      copyToClipboard(query);
      onCopyQuery == null ? void 0 : onCopyQuery(query);
    };
    $[4] = onCopyQuery;
    $[5] = queryEditor;
    $[6] = t4;
  } else {
    t4 = $[6];
  }
  return t4;
}
function useMergeQuery(t0) {
  const $ = c(8);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    caller
  } = t1;
  const t2 = caller || _useMergeQuery;
  let t3;
  if ($[2] !== t2) {
    t3 = {
      nonNull: true,
      caller: t2
    };
    $[2] = t2;
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const {
    queryEditor
  } = useEditorContext(t3);
  let t4;
  if ($[4] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = {
      nonNull: true,
      caller: _useMergeQuery
    };
    $[4] = t4;
  } else {
    t4 = $[4];
  }
  const {
    schema
  } = useSchemaContext(t4);
  let t5;
  if ($[5] !== queryEditor || $[6] !== schema) {
    t5 = () => {
      const documentAST = queryEditor == null ? void 0 : queryEditor.documentAST;
      const query = queryEditor == null ? void 0 : queryEditor.getValue();
      if (!documentAST || !query) {
        return;
      }
      queryEditor.setValue(print(mergeAst(documentAST, schema)));
    };
    $[5] = queryEditor;
    $[6] = schema;
    $[7] = t5;
  } else {
    t5 = $[7];
  }
  return t5;
}
function usePrettifyEditors(t0) {
  const $ = c(8);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    caller
  } = t1;
  const t2 = caller || _usePrettifyEditors;
  let t3;
  if ($[2] !== t2) {
    t3 = {
      nonNull: true,
      caller: t2
    };
    $[2] = t2;
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const {
    queryEditor,
    headerEditor,
    variableEditor
  } = useEditorContext(t3);
  let t4;
  if ($[4] !== headerEditor || $[5] !== queryEditor || $[6] !== variableEditor) {
    t4 = () => {
      if (variableEditor) {
        const variableEditorContent = variableEditor.getValue();
        try {
          const prettifiedVariableEditorContent = JSON.stringify(JSON.parse(variableEditorContent), null, 2);
          if (prettifiedVariableEditorContent !== variableEditorContent) {
            variableEditor.setValue(prettifiedVariableEditorContent);
          }
        } catch {
        }
      }
      if (headerEditor) {
        const headerEditorContent = headerEditor.getValue();
        try {
          const prettifiedHeaderEditorContent = JSON.stringify(JSON.parse(headerEditorContent), null, 2);
          if (prettifiedHeaderEditorContent !== headerEditorContent) {
            headerEditor.setValue(prettifiedHeaderEditorContent);
          }
        } catch {
        }
      }
      if (queryEditor) {
        const editorContent = queryEditor.getValue();
        const prettifiedEditorContent = print(parse(editorContent));
        if (prettifiedEditorContent !== editorContent) {
          queryEditor.setValue(prettifiedEditorContent);
        }
      }
    };
    $[4] = headerEditor;
    $[5] = queryEditor;
    $[6] = variableEditor;
    $[7] = t4;
  } else {
    t4 = $[7];
  }
  return t4;
}
function useAutoCompleteLeafs(t0) {
  const $ = c(10);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    getDefaultFieldNames,
    caller
  } = t1;
  const t2 = caller || _useAutoCompleteLeafs;
  let t3;
  if ($[2] !== t2) {
    t3 = {
      nonNull: true,
      caller: t2
    };
    $[2] = t2;
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const {
    schema
  } = useSchemaContext(t3);
  const t4 = caller || _useAutoCompleteLeafs;
  let t5;
  if ($[4] !== t4) {
    t5 = {
      nonNull: true,
      caller: t4
    };
    $[4] = t4;
    $[5] = t5;
  } else {
    t5 = $[5];
  }
  const {
    queryEditor
  } = useEditorContext(t5);
  let t6;
  if ($[6] !== getDefaultFieldNames || $[7] !== queryEditor || $[8] !== schema) {
    t6 = () => {
      if (!queryEditor) {
        return;
      }
      const query = queryEditor.getValue();
      const {
        insertions,
        result
      } = fillLeafs(schema, query, getDefaultFieldNames);
      if (insertions && insertions.length > 0) {
        queryEditor.operation(() => {
          const cursor = queryEditor.getCursor();
          const cursorIndex = queryEditor.indexFromPos(cursor);
          queryEditor.setValue(result || "");
          let added;
          added = 0;
          const markers = insertions.map((t7) => {
            const {
              index,
              string
            } = t7;
            added = added + string.length;
            return queryEditor.markText(queryEditor.posFromIndex(index + added), queryEditor.posFromIndex(index + added), {
              className: "auto-inserted-leaf",
              clearOnEnter: true,
              title: "Automatically added leaf fields"
            });
          });
          setTimeout(() => {
            for (const marker of markers) {
              marker.clear();
            }
          }, 7e3);
          let newCursorIndex = cursorIndex;
          for (const {
            index: index_0,
            string: string_0
          } of insertions) {
            if (index_0 < cursorIndex) {
              newCursorIndex = newCursorIndex + string_0.length;
            }
          }
          queryEditor.setCursor(queryEditor.posFromIndex(newCursorIndex));
        });
      }
      return result;
    };
    $[6] = getDefaultFieldNames;
    $[7] = queryEditor;
    $[8] = schema;
    $[9] = t6;
  } else {
    t6 = $[9];
  }
  return t6;
}
const useEditorState = (editor) => {
  "use no memo";
  const context = useEditorContext({
    nonNull: true
  });
  const editorInstance = context[`${editor}Editor`];
  let valueString = "";
  const editorValue = (editorInstance == null ? void 0 : editorInstance.getValue()) ?? false;
  if (editorValue && editorValue.length > 0) {
    valueString = editorValue;
  }
  const handleEditorValue = useCallback((value) => editorInstance == null ? void 0 : editorInstance.setValue(value), [editorInstance]);
  return useMemo(() => [valueString, handleEditorValue], [valueString, handleEditorValue]);
};
const useOperationsEditorState = () => {
  return useEditorState("query");
};
const useVariablesEditorState = () => {
  return useEditorState("variable");
};
const useHeadersEditorState = () => {
  return useEditorState("header");
};
function useOptimisticState(t0) {
  const $ = c(12);
  const [upstreamState, upstreamSetState] = t0;
  let t1;
  if ($[0] !== upstreamState) {
    t1 = {
      pending: null,
      last: upstreamState
    };
    $[0] = upstreamState;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const lastStateRef = useRef(t1);
  const [state, setOperationsText] = useState(upstreamState);
  let t2;
  let t3;
  if ($[2] !== state || $[3] !== upstreamSetState || $[4] !== upstreamState) {
    t2 = () => {
      if (lastStateRef.current.last === upstreamState) ;
      else {
        lastStateRef.current.last = upstreamState;
        if (lastStateRef.current.pending === null) {
          setOperationsText(upstreamState);
        } else {
          if (lastStateRef.current.pending === upstreamState) {
            lastStateRef.current.pending = null;
            if (upstreamState !== state) {
              lastStateRef.current.pending = state;
              upstreamSetState(state);
            }
          } else {
            lastStateRef.current.pending = null;
            setOperationsText(upstreamState);
          }
        }
      }
    };
    t3 = [upstreamState, state, upstreamSetState];
    $[2] = state;
    $[3] = upstreamSetState;
    $[4] = upstreamState;
    $[5] = t2;
    $[6] = t3;
  } else {
    t2 = $[5];
    t3 = $[6];
  }
  useEffect(t2, t3);
  let t4;
  if ($[7] !== upstreamSetState) {
    t4 = (newState) => {
      setOperationsText(newState);
      if (lastStateRef.current.pending === null && lastStateRef.current.last !== newState) {
        lastStateRef.current.pending = newState;
        upstreamSetState(newState);
      }
    };
    $[7] = upstreamSetState;
    $[8] = t4;
  } else {
    t4 = $[8];
  }
  const setState = t4;
  let t5;
  if ($[9] !== setState || $[10] !== state) {
    t5 = [state, setState];
    $[9] = setState;
    $[10] = state;
    $[11] = t5;
  } else {
    t5 = $[11];
  }
  return t5;
}
function importCodeMirrorImports$3() {
  return importCodeMirror([
    // @ts-expect-error
    import("codemirror/mode/javascript/javascript.js")
  ]);
}
const _useHeaderEditor = useHeaderEditor;
function useHeaderEditor(t0, caller) {
  const $ = c(17);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    editorTheme: t2,
    keyMap: t3,
    onEdit,
    readOnly: t4
  } = t1;
  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;
  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;
  const readOnly = t4 === void 0 ? false : t4;
  const t5 = caller || _useHeaderEditor;
  let t6;
  if ($[2] !== t5) {
    t6 = {
      nonNull: true,
      caller: t5
    };
    $[2] = t5;
    $[3] = t6;
  } else {
    t6 = $[3];
  }
  const {
    initialHeaders,
    headerEditor,
    setHeaderEditor,
    shouldPersistHeaders
  } = useEditorContext(t6);
  const executionContext = useExecutionContext();
  const t7 = caller || _useHeaderEditor;
  let t8;
  if ($[4] !== t7) {
    t8 = {
      caller: t7
    };
    $[4] = t7;
    $[5] = t8;
  } else {
    t8 = $[5];
  }
  const merge = useMergeQuery(t8);
  const t9 = caller || _useHeaderEditor;
  let t10;
  if ($[6] !== t9) {
    t10 = {
      caller: t9
    };
    $[6] = t9;
    $[7] = t10;
  } else {
    t10 = $[7];
  }
  const prettify = usePrettifyEditors(t10);
  const ref = useRef(null);
  let t11;
  let t12;
  if ($[8] !== editorTheme || $[9] !== initialHeaders || $[10] !== readOnly || $[11] !== setHeaderEditor) {
    t11 = () => {
      let isActive;
      isActive = true;
      importCodeMirrorImports$3().then((CodeMirror) => {
        if (!isActive) {
          return;
        }
        const container = ref.current;
        if (!container) {
          return;
        }
        const newEditor = CodeMirror(container, {
          value: initialHeaders,
          lineNumbers: true,
          tabSize: 2,
          mode: {
            name: "javascript",
            json: true
          },
          theme: editorTheme,
          autoCloseBrackets: true,
          matchBrackets: true,
          showCursorWhenSelecting: true,
          readOnly: readOnly ? "nocursor" : false,
          foldGutter: true,
          gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],
          extraKeys: commonKeys
        });
        newEditor.addKeyMap({
          "Cmd-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          },
          "Ctrl-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          },
          "Alt-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          },
          "Shift-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          }
        });
        newEditor.on("keyup", _temp$2);
        setHeaderEditor(newEditor);
      });
      return () => {
        isActive = false;
      };
    };
    t12 = [editorTheme, initialHeaders, readOnly, setHeaderEditor];
    $[8] = editorTheme;
    $[9] = initialHeaders;
    $[10] = readOnly;
    $[11] = setHeaderEditor;
    $[12] = t11;
    $[13] = t12;
  } else {
    t11 = $[12];
    t12 = $[13];
  }
  useEffect(t11, t12);
  useSynchronizeOption(headerEditor, "keyMap", keyMap);
  useChangeHandler(headerEditor, onEdit, shouldPersistHeaders ? STORAGE_KEY$3 : null, "headers", _useHeaderEditor);
  let t13;
  if ($[14] === Symbol.for("react.memo_cache_sentinel")) {
    t13 = ["Cmd-Enter", "Ctrl-Enter"];
    $[14] = t13;
  } else {
    t13 = $[14];
  }
  useKeyMap(headerEditor, t13, executionContext == null ? void 0 : executionContext.run);
  let t14;
  if ($[15] === Symbol.for("react.memo_cache_sentinel")) {
    t14 = ["Shift-Ctrl-P"];
    $[15] = t14;
  } else {
    t14 = $[15];
  }
  useKeyMap(headerEditor, t14, prettify);
  let t15;
  if ($[16] === Symbol.for("react.memo_cache_sentinel")) {
    t15 = ["Shift-Ctrl-M"];
    $[16] = t15;
  } else {
    t15 = $[16];
  }
  useKeyMap(headerEditor, t15, merge);
  return ref;
}
function _temp$2(editorInstance, event) {
  const {
    code,
    key,
    shiftKey
  } = event;
  const isLetter = code.startsWith("Key");
  const isNumber = !shiftKey && code.startsWith("Digit");
  if (isLetter || isNumber || key === "_" || key === '"') {
    editorInstance.execCommand("autocomplete");
  }
}
const STORAGE_KEY$3 = "headers";
const invalidCharacters = Array.from({
  length: 11
}, (_, i) => {
  return String.fromCharCode(8192 + i);
}).concat(["\u2028", "\u2029", " ", " "]);
const sanitizeRegex = new RegExp("[" + invalidCharacters.join("") + "]", "g");
function normalizeWhitespace(line) {
  return line.replace(sanitizeRegex, " ");
}
function importCodeMirrorImports$2() {
  return importCodeMirror([import("codemirror/addon/comment/comment.js"), import("codemirror/addon/search/search.js"), import("codemirror-graphql/esm/hint.js"), import("codemirror-graphql/esm/lint.js"), import("codemirror-graphql/esm/info.js"), import("codemirror-graphql/esm/jump.js"), import("codemirror-graphql/esm/mode.js")]);
}
const _useQueryEditor = useQueryEditor;
function updateVariableEditor(variableEditor, operationFacts) {
  variableEditor.state.lint.linterOptions.variableToType = operationFacts == null ? void 0 : operationFacts.variableToType;
  variableEditor.options.lint.variableToType = operationFacts == null ? void 0 : operationFacts.variableToType;
  variableEditor.options.hintOptions.variableToType = operationFacts == null ? void 0 : operationFacts.variableToType;
}
function updateEditorSchema(editor, schema) {
  editor.state.lint.linterOptions.schema = schema;
  editor.options.lint.schema = schema;
  editor.options.hintOptions.schema = schema;
  editor.options.info.schema = schema;
  editor.options.jump.schema = schema;
}
function updateEditorValidationRules(editor, validationRules) {
  editor.state.lint.linterOptions.validationRules = validationRules;
  editor.options.lint.validationRules = validationRules;
}
function updateEditorExternalFragments(editor, externalFragmentList) {
  editor.state.lint.linterOptions.externalFragments = externalFragmentList;
  editor.options.lint.externalFragments = externalFragmentList;
  editor.options.hintOptions.externalFragments = externalFragmentList;
}
function useQueryEditor(t0, caller) {
  const $ = c(41);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    editorTheme: t2,
    keyMap: t3,
    onClickReference,
    onCopyQuery,
    onEdit,
    readOnly: t4
  } = t1;
  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;
  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;
  const readOnly = t4 === void 0 ? false : t4;
  const t5 = caller || _useQueryEditor;
  let t6;
  if ($[2] !== t5) {
    t6 = {
      nonNull: true,
      caller: t5
    };
    $[2] = t5;
    $[3] = t6;
  } else {
    t6 = $[3];
  }
  const {
    schema
  } = useSchemaContext(t6);
  const t7 = caller || _useQueryEditor;
  let t8;
  if ($[4] !== t7) {
    t8 = {
      nonNull: true,
      caller: t7
    };
    $[4] = t7;
    $[5] = t8;
  } else {
    t8 = $[5];
  }
  const {
    externalFragments,
    initialQuery,
    queryEditor,
    setOperationName,
    setQueryEditor,
    validationRules,
    variableEditor,
    updateActiveTabValues
  } = useEditorContext(t8);
  const executionContext = useExecutionContext();
  const storage = useStorageContext();
  const explorer = useExplorerContext();
  const plugin = usePluginContext();
  const t9 = caller || _useQueryEditor;
  let t10;
  if ($[6] !== onCopyQuery || $[7] !== t9) {
    t10 = {
      caller: t9,
      onCopyQuery
    };
    $[6] = onCopyQuery;
    $[7] = t9;
    $[8] = t10;
  } else {
    t10 = $[8];
  }
  const copy = useCopyQuery(t10);
  const t11 = caller || _useQueryEditor;
  let t12;
  if ($[9] !== t11) {
    t12 = {
      caller: t11
    };
    $[9] = t11;
    $[10] = t12;
  } else {
    t12 = $[10];
  }
  const merge = useMergeQuery(t12);
  const t13 = caller || _useQueryEditor;
  let t14;
  if ($[11] !== t13) {
    t14 = {
      caller: t13
    };
    $[11] = t13;
    $[12] = t14;
  } else {
    t14 = $[12];
  }
  const prettify = usePrettifyEditors(t14);
  const ref = useRef(null);
  const codeMirrorRef = useRef();
  const onClickReferenceRef = useRef(_temp$1);
  let t15;
  let t16;
  if ($[13] !== explorer || $[14] !== onClickReference || $[15] !== plugin) {
    t15 = () => {
      onClickReferenceRef.current = (reference) => {
        if (!explorer || !plugin) {
          return;
        }
        plugin.setVisiblePlugin(DOC_EXPLORER_PLUGIN);
        bb47: switch (reference.kind) {
          case "Type": {
            explorer.push({
              name: reference.type.name,
              def: reference.type
            });
            break bb47;
          }
          case "Field": {
            explorer.push({
              name: reference.field.name,
              def: reference.field
            });
            break bb47;
          }
          case "Argument": {
            if (reference.field) {
              explorer.push({
                name: reference.field.name,
                def: reference.field
              });
            }
            break bb47;
          }
          case "EnumValue": {
            if (reference.type) {
              explorer.push({
                name: reference.type.name,
                def: reference.type
              });
            }
          }
        }
        onClickReference == null ? void 0 : onClickReference(reference);
      };
    };
    t16 = [explorer, onClickReference, plugin];
    $[13] = explorer;
    $[14] = onClickReference;
    $[15] = plugin;
    $[16] = t15;
    $[17] = t16;
  } else {
    t15 = $[16];
    t16 = $[17];
  }
  useEffect(t15, t16);
  let t17;
  let t18;
  if ($[18] !== editorTheme || $[19] !== initialQuery || $[20] !== readOnly || $[21] !== setQueryEditor) {
    t17 = () => {
      let isActive;
      isActive = true;
      importCodeMirrorImports$2().then((CodeMirror) => {
        if (!isActive) {
          return;
        }
        codeMirrorRef.current = CodeMirror;
        const container = ref.current;
        if (!container) {
          return;
        }
        const newEditor = CodeMirror(container, {
          value: initialQuery,
          lineNumbers: true,
          tabSize: 2,
          foldGutter: true,
          mode: "graphql",
          theme: editorTheme,
          autoCloseBrackets: true,
          matchBrackets: true,
          showCursorWhenSelecting: true,
          readOnly: readOnly ? "nocursor" : false,
          lint: {
            schema: void 0,
            validationRules: null,
            externalFragments: void 0
          },
          hintOptions: {
            schema: void 0,
            closeOnUnfocus: false,
            completeSingle: false,
            container,
            externalFragments: void 0,
            autocompleteOptions: {
              mode: GraphQLDocumentMode.EXECUTABLE
            }
          },
          info: {
            schema: void 0,
            renderDescription: _temp2,
            onClick(reference_0) {
              onClickReferenceRef.current(reference_0);
            }
          },
          jump: {
            schema: void 0,
            onClick(reference_1) {
              onClickReferenceRef.current(reference_1);
            }
          },
          gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],
          extraKeys: {
            ...commonKeys,
            "Cmd-S"() {
            },
            "Ctrl-S"() {
            }
          }
        });
        newEditor.addKeyMap({
          "Cmd-Space"() {
            newEditor.showHint({
              completeSingle: true,
              container
            });
          },
          "Ctrl-Space"() {
            newEditor.showHint({
              completeSingle: true,
              container
            });
          },
          "Alt-Space"() {
            newEditor.showHint({
              completeSingle: true,
              container
            });
          },
          "Shift-Space"() {
            newEditor.showHint({
              completeSingle: true,
              container
            });
          },
          "Shift-Alt-Space"() {
            newEditor.showHint({
              completeSingle: true,
              container
            });
          }
        });
        newEditor.on("keyup", _temp3);
        let showingHints;
        showingHints = false;
        newEditor.on("startCompletion", () => {
          showingHints = true;
        });
        newEditor.on("endCompletion", () => {
          showingHints = false;
        });
        newEditor.on("keydown", (editorInstance_0, event_0) => {
          if (event_0.key === "Escape" && showingHints) {
            event_0.stopPropagation();
          }
        });
        newEditor.on("beforeChange", _temp4);
        newEditor.documentAST = null;
        newEditor.operationName = null;
        newEditor.operations = null;
        newEditor.variableToType = null;
        setQueryEditor(newEditor);
      });
      return () => {
        isActive = false;
      };
    };
    t18 = [editorTheme, initialQuery, readOnly, setQueryEditor];
    $[18] = editorTheme;
    $[19] = initialQuery;
    $[20] = readOnly;
    $[21] = setQueryEditor;
    $[22] = t17;
    $[23] = t18;
  } else {
    t17 = $[22];
    t18 = $[23];
  }
  useEffect(t17, t18);
  useSynchronizeOption(queryEditor, "keyMap", keyMap);
  let t19;
  let t20;
  if ($[24] !== onEdit || $[25] !== queryEditor || $[26] !== schema || $[27] !== setOperationName || $[28] !== storage || $[29] !== updateActiveTabValues || $[30] !== variableEditor) {
    t19 = () => {
      if (!queryEditor) {
        return;
      }
      const getAndUpdateOperationFacts = function getAndUpdateOperationFacts2(editorInstance_2) {
        var _a;
        const operationFacts = getOperationFacts(schema, editorInstance_2.getValue());
        const operationName = getSelectedOperationName(editorInstance_2.operations ?? void 0, editorInstance_2.operationName ?? void 0, operationFacts == null ? void 0 : operationFacts.operations);
        editorInstance_2.documentAST = (operationFacts == null ? void 0 : operationFacts.documentAST) ?? null;
        editorInstance_2.operationName = operationName ?? null;
        editorInstance_2.operations = (operationFacts == null ? void 0 : operationFacts.operations) ?? null;
        if (variableEditor) {
          updateVariableEditor(variableEditor, operationFacts);
          (_a = codeMirrorRef.current) == null ? void 0 : _a.signal(variableEditor, "change", variableEditor);
        }
        return operationFacts ? {
          ...operationFacts,
          operationName
        } : null;
      };
      const handleChange = debounce(100, (editorInstance_3) => {
        const query = editorInstance_3.getValue();
        storage == null ? void 0 : storage.set(STORAGE_KEY_QUERY, query);
        const currentOperationName = editorInstance_3.operationName;
        const operationFacts_0 = getAndUpdateOperationFacts(editorInstance_3);
        if ((operationFacts_0 == null ? void 0 : operationFacts_0.operationName) !== void 0) {
          storage == null ? void 0 : storage.set(STORAGE_KEY_OPERATION_NAME, operationFacts_0.operationName);
        }
        onEdit == null ? void 0 : onEdit(query, operationFacts_0 == null ? void 0 : operationFacts_0.documentAST);
        if ((operationFacts_0 == null ? void 0 : operationFacts_0.operationName) && currentOperationName !== operationFacts_0.operationName) {
          setOperationName(operationFacts_0.operationName);
        }
        updateActiveTabValues({
          query,
          operationName: (operationFacts_0 == null ? void 0 : operationFacts_0.operationName) ?? null
        });
      });
      getAndUpdateOperationFacts(queryEditor);
      queryEditor.on("change", handleChange);
      return () => queryEditor.off("change", handleChange);
    };
    t20 = [onEdit, queryEditor, schema, setOperationName, storage, variableEditor, updateActiveTabValues];
    $[24] = onEdit;
    $[25] = queryEditor;
    $[26] = schema;
    $[27] = setOperationName;
    $[28] = storage;
    $[29] = updateActiveTabValues;
    $[30] = variableEditor;
    $[31] = t19;
    $[32] = t20;
  } else {
    t19 = $[31];
    t20 = $[32];
  }
  useEffect(t19, t20);
  useSynchronizeSchema(queryEditor, schema ?? null, codeMirrorRef);
  useSynchronizeValidationRules(queryEditor, validationRules ?? null, codeMirrorRef);
  useSynchronizeExternalFragments(queryEditor, externalFragments, codeMirrorRef);
  useCompletion(queryEditor, onClickReference || null, _useQueryEditor);
  const run = executionContext == null ? void 0 : executionContext.run;
  let t21;
  if ($[33] !== queryEditor || $[34] !== run || $[35] !== setOperationName) {
    t21 = () => {
      var _a;
      if (!run || !queryEditor || !queryEditor.operations || !queryEditor.hasFocus()) {
        run == null ? void 0 : run();
        return;
      }
      const cursorIndex = queryEditor.indexFromPos(queryEditor.getCursor());
      let operationName_0;
      for (const operation of queryEditor.operations) {
        if (operation.loc && operation.loc.start <= cursorIndex && operation.loc.end >= cursorIndex) {
          operationName_0 = (_a = operation.name) == null ? void 0 : _a.value;
        }
      }
      if (operationName_0 && operationName_0 !== queryEditor.operationName) {
        setOperationName(operationName_0);
      }
      run();
    };
    $[33] = queryEditor;
    $[34] = run;
    $[35] = setOperationName;
    $[36] = t21;
  } else {
    t21 = $[36];
  }
  const runAtCursor = t21;
  let t22;
  if ($[37] === Symbol.for("react.memo_cache_sentinel")) {
    t22 = ["Cmd-Enter", "Ctrl-Enter"];
    $[37] = t22;
  } else {
    t22 = $[37];
  }
  useKeyMap(queryEditor, t22, runAtCursor);
  let t23;
  if ($[38] === Symbol.for("react.memo_cache_sentinel")) {
    t23 = ["Shift-Ctrl-C"];
    $[38] = t23;
  } else {
    t23 = $[38];
  }
  useKeyMap(queryEditor, t23, copy);
  let t24;
  if ($[39] === Symbol.for("react.memo_cache_sentinel")) {
    t24 = ["Shift-Ctrl-P", "Shift-Ctrl-F"];
    $[39] = t24;
  } else {
    t24 = $[39];
  }
  useKeyMap(queryEditor, t24, prettify);
  let t25;
  if ($[40] === Symbol.for("react.memo_cache_sentinel")) {
    t25 = ["Shift-Ctrl-M"];
    $[40] = t25;
  } else {
    t25 = $[40];
  }
  useKeyMap(queryEditor, t25, merge);
  return ref;
}
function _temp4(editorInstance_1, change) {
  var _a;
  if (change.origin === "paste") {
    const text_0 = change.text.map(normalizeWhitespace);
    (_a = change.update) == null ? void 0 : _a.call(change, change.from, change.to, text_0);
  }
}
function _temp3(editorInstance, event) {
  if (AUTO_COMPLETE_AFTER_KEY.test(event.key)) {
    editorInstance.execCommand("autocomplete");
  }
}
function _temp2(text) {
  return markdown.render(text);
}
function _temp$1() {
}
function useSynchronizeSchema(editor, schema, codeMirrorRef) {
  const $ = c(5);
  let t0;
  let t1;
  if ($[0] !== codeMirrorRef || $[1] !== editor || $[2] !== schema) {
    t0 = () => {
      if (!editor) {
        return;
      }
      const didChange = editor.options.lint.schema !== schema;
      updateEditorSchema(editor, schema);
      if (didChange && codeMirrorRef.current) {
        codeMirrorRef.current.signal(editor, "change", editor);
      }
    };
    t1 = [editor, schema, codeMirrorRef];
    $[0] = codeMirrorRef;
    $[1] = editor;
    $[2] = schema;
    $[3] = t0;
    $[4] = t1;
  } else {
    t0 = $[3];
    t1 = $[4];
  }
  useEffect(t0, t1);
}
function useSynchronizeValidationRules(editor, validationRules, codeMirrorRef) {
  const $ = c(5);
  let t0;
  let t1;
  if ($[0] !== codeMirrorRef || $[1] !== editor || $[2] !== validationRules) {
    t0 = () => {
      if (!editor) {
        return;
      }
      const didChange = editor.options.lint.validationRules !== validationRules;
      updateEditorValidationRules(editor, validationRules);
      if (didChange && codeMirrorRef.current) {
        codeMirrorRef.current.signal(editor, "change", editor);
      }
    };
    t1 = [editor, validationRules, codeMirrorRef];
    $[0] = codeMirrorRef;
    $[1] = editor;
    $[2] = validationRules;
    $[3] = t0;
    $[4] = t1;
  } else {
    t0 = $[3];
    t1 = $[4];
  }
  useEffect(t0, t1);
}
function useSynchronizeExternalFragments(editor, externalFragments, codeMirrorRef) {
  const $ = c(9);
  let t0;
  if ($[0] !== externalFragments) {
    t0 = externalFragments.values();
    $[0] = externalFragments;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== t0) {
    t1 = [...t0];
    $[2] = t0;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  const externalFragmentList = t1;
  let t2;
  let t3;
  if ($[4] !== codeMirrorRef || $[5] !== editor || $[6] !== externalFragmentList) {
    t2 = () => {
      if (!editor) {
        return;
      }
      const didChange = editor.options.lint.externalFragments !== externalFragmentList;
      updateEditorExternalFragments(editor, externalFragmentList);
      if (didChange && codeMirrorRef.current) {
        codeMirrorRef.current.signal(editor, "change", editor);
      }
    };
    t3 = [editor, externalFragmentList, codeMirrorRef];
    $[4] = codeMirrorRef;
    $[5] = editor;
    $[6] = externalFragmentList;
    $[7] = t2;
    $[8] = t3;
  } else {
    t2 = $[7];
    t3 = $[8];
  }
  useEffect(t2, t3);
}
const AUTO_COMPLETE_AFTER_KEY = /^[a-zA-Z0-9_@(]$/;
const STORAGE_KEY_QUERY = "query";
const STORAGE_KEY_OPERATION_NAME = "operationName";
function getDefaultTabState({
  defaultQuery,
  defaultHeaders,
  headers,
  defaultTabs,
  query,
  variables,
  storage,
  shouldPersistHeaders
}) {
  const storedState = storage == null ? void 0 : storage.get(STORAGE_KEY$2);
  try {
    if (!storedState) {
      throw new Error("Storage for tabs is empty");
    }
    const parsed = JSON.parse(storedState);
    const headersForHash = shouldPersistHeaders ? headers : void 0;
    if (isTabsState(parsed)) {
      const expectedHash = hashFromTabContents({
        query,
        variables,
        headers: headersForHash
      });
      let matchingTabIndex = -1;
      for (let index = 0; index < parsed.tabs.length; index++) {
        const tab = parsed.tabs[index];
        tab.hash = hashFromTabContents({
          query: tab.query,
          variables: tab.variables,
          headers: tab.headers
        });
        if (tab.hash === expectedHash) {
          matchingTabIndex = index;
        }
      }
      if (matchingTabIndex >= 0) {
        parsed.activeTabIndex = matchingTabIndex;
      } else {
        const operationName = query ? fuzzyExtractOperationName(query) : null;
        parsed.tabs.push({
          id: guid(),
          hash: expectedHash,
          title: operationName || DEFAULT_TITLE,
          query,
          variables,
          headers,
          operationName,
          response: null
        });
        parsed.activeTabIndex = parsed.tabs.length - 1;
      }
      return parsed;
    }
    throw new Error("Storage for tabs is invalid");
  } catch {
    return {
      activeTabIndex: 0,
      tabs: (defaultTabs || [{
        query: query ?? defaultQuery,
        variables,
        headers: headers ?? defaultHeaders
      }]).map(createTab)
    };
  }
}
function isTabsState(obj) {
  return obj && typeof obj === "object" && !Array.isArray(obj) && hasNumberKey(obj, "activeTabIndex") && "tabs" in obj && Array.isArray(obj.tabs) && obj.tabs.every(isTabState);
}
function isTabState(obj) {
  return obj && typeof obj === "object" && !Array.isArray(obj) && hasStringKey(obj, "id") && hasStringKey(obj, "title") && hasStringOrNullKey(obj, "query") && hasStringOrNullKey(obj, "variables") && hasStringOrNullKey(obj, "headers") && hasStringOrNullKey(obj, "operationName") && hasStringOrNullKey(obj, "response");
}
function hasNumberKey(obj, key) {
  return key in obj && typeof obj[key] === "number";
}
function hasStringKey(obj, key) {
  return key in obj && typeof obj[key] === "string";
}
function hasStringOrNullKey(obj, key) {
  return key in obj && (typeof obj[key] === "string" || obj[key] === null);
}
function useSynchronizeActiveTabValues({
  queryEditor,
  variableEditor,
  headerEditor,
  responseEditor
}) {
  return useCallback((state) => {
    const query = (queryEditor == null ? void 0 : queryEditor.getValue()) ?? null;
    const variables = (variableEditor == null ? void 0 : variableEditor.getValue()) ?? null;
    const headers = (headerEditor == null ? void 0 : headerEditor.getValue()) ?? null;
    const operationName = (queryEditor == null ? void 0 : queryEditor.operationName) ?? null;
    const response = (responseEditor == null ? void 0 : responseEditor.getValue()) ?? null;
    return setPropertiesInActiveTab(state, {
      query,
      variables,
      headers,
      response,
      operationName
    });
  }, [queryEditor, variableEditor, headerEditor, responseEditor]);
}
function serializeTabState(tabState, shouldPersistHeaders = false) {
  return JSON.stringify(tabState, (key, value) => key === "hash" || key === "response" || !shouldPersistHeaders && key === "headers" ? null : value);
}
function useStoreTabs({
  storage,
  shouldPersistHeaders
}) {
  const store = useMemo(() => debounce(500, (value) => {
    storage == null ? void 0 : storage.set(STORAGE_KEY$2, value);
  }), [storage]);
  return useCallback((currentState) => {
    store(serializeTabState(currentState, shouldPersistHeaders));
  }, [shouldPersistHeaders, store]);
}
function useSetEditorValues({
  queryEditor,
  variableEditor,
  headerEditor,
  responseEditor,
  defaultHeaders
}) {
  return useCallback(({
    query,
    variables,
    headers,
    response
  }) => {
    queryEditor == null ? void 0 : queryEditor.setValue(query ?? "");
    variableEditor == null ? void 0 : variableEditor.setValue(variables ?? "");
    headerEditor == null ? void 0 : headerEditor.setValue(headers ?? defaultHeaders ?? "");
    responseEditor == null ? void 0 : responseEditor.setValue(response ?? "");
  }, [headerEditor, queryEditor, responseEditor, variableEditor, defaultHeaders]);
}
function createTab({
  query = null,
  variables = null,
  headers = null
} = {}) {
  return {
    id: guid(),
    hash: hashFromTabContents({
      query,
      variables,
      headers
    }),
    title: query && fuzzyExtractOperationName(query) || DEFAULT_TITLE,
    query,
    variables,
    headers,
    operationName: null,
    response: null
  };
}
function setPropertiesInActiveTab(state, partialTab) {
  return {
    ...state,
    tabs: state.tabs.map((tab, index) => {
      if (index !== state.activeTabIndex) {
        return tab;
      }
      const newTab = {
        ...tab,
        ...partialTab
      };
      return {
        ...newTab,
        hash: hashFromTabContents(newTab),
        title: newTab.operationName || (newTab.query ? fuzzyExtractOperationName(newTab.query) : void 0) || DEFAULT_TITLE
      };
    })
  };
}
function guid() {
  const s4 = () => {
    return Math.floor((1 + Math.random()) * 65536).toString(16).slice(1);
  };
  return `${s4()}${s4()}-${s4()}-${s4()}-${s4()}-${s4()}${s4()}${s4()}`;
}
function hashFromTabContents(args) {
  return [args.query ?? "", args.variables ?? "", args.headers ?? ""].join("|");
}
function fuzzyExtractOperationName(str) {
  const regex = /^(?!#).*(query|subscription|mutation)\s+([a-zA-Z0-9_]+)/m;
  const match = regex.exec(str);
  return (match == null ? void 0 : match[2]) ?? null;
}
function clearHeadersFromTabs(storage) {
  const persistedTabs = storage == null ? void 0 : storage.get(STORAGE_KEY$2);
  if (persistedTabs) {
    const parsedTabs = JSON.parse(persistedTabs);
    storage == null ? void 0 : storage.set(STORAGE_KEY$2, JSON.stringify(parsedTabs, (key, value) => key === "headers" ? null : value));
  }
}
const DEFAULT_TITLE = "<untitled>";
const STORAGE_KEY$2 = "tabState";
function importCodeMirrorImports$1() {
  return importCodeMirror([import("codemirror-graphql/esm/variables/hint.js"), import("codemirror-graphql/esm/variables/lint.js"), import("codemirror-graphql/esm/variables/mode.js")]);
}
const _useVariableEditor = useVariableEditor;
function useVariableEditor(t0, caller) {
  const $ = c(17);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    editorTheme: t2,
    keyMap: t3,
    onClickReference,
    onEdit,
    readOnly: t4
  } = t1;
  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;
  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;
  const readOnly = t4 === void 0 ? false : t4;
  const t5 = caller || _useVariableEditor;
  let t6;
  if ($[2] !== t5) {
    t6 = {
      nonNull: true,
      caller: t5
    };
    $[2] = t5;
    $[3] = t6;
  } else {
    t6 = $[3];
  }
  const {
    initialVariables,
    variableEditor,
    setVariableEditor
  } = useEditorContext(t6);
  const executionContext = useExecutionContext();
  const t7 = caller || _useVariableEditor;
  let t8;
  if ($[4] !== t7) {
    t8 = {
      caller: t7
    };
    $[4] = t7;
    $[5] = t8;
  } else {
    t8 = $[5];
  }
  const merge = useMergeQuery(t8);
  const t9 = caller || _useVariableEditor;
  let t10;
  if ($[6] !== t9) {
    t10 = {
      caller: t9
    };
    $[6] = t9;
    $[7] = t10;
  } else {
    t10 = $[7];
  }
  const prettify = usePrettifyEditors(t10);
  const ref = useRef(null);
  const codeMirrorRef = useRef();
  let t11;
  let t12;
  if ($[8] !== editorTheme || $[9] !== initialVariables || $[10] !== readOnly || $[11] !== setVariableEditor) {
    t11 = () => {
      let isActive;
      isActive = true;
      importCodeMirrorImports$1().then((CodeMirror) => {
        if (!isActive) {
          return;
        }
        codeMirrorRef.current = CodeMirror;
        const container = ref.current;
        if (!container) {
          return;
        }
        const newEditor = CodeMirror(container, {
          value: initialVariables,
          lineNumbers: true,
          tabSize: 2,
          mode: "graphql-variables",
          theme: editorTheme,
          autoCloseBrackets: true,
          matchBrackets: true,
          showCursorWhenSelecting: true,
          readOnly: readOnly ? "nocursor" : false,
          foldGutter: true,
          lint: {
            variableToType: void 0
          },
          hintOptions: {
            closeOnUnfocus: false,
            completeSingle: false,
            container,
            variableToType: void 0
          },
          gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],
          extraKeys: commonKeys
        });
        newEditor.addKeyMap({
          "Cmd-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          },
          "Ctrl-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          },
          "Alt-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          },
          "Shift-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          }
        });
        newEditor.on("keyup", _temp);
        setVariableEditor(newEditor);
      });
      return () => {
        isActive = false;
      };
    };
    t12 = [editorTheme, initialVariables, readOnly, setVariableEditor];
    $[8] = editorTheme;
    $[9] = initialVariables;
    $[10] = readOnly;
    $[11] = setVariableEditor;
    $[12] = t11;
    $[13] = t12;
  } else {
    t11 = $[12];
    t12 = $[13];
  }
  useEffect(t11, t12);
  useSynchronizeOption(variableEditor, "keyMap", keyMap);
  useChangeHandler(variableEditor, onEdit, STORAGE_KEY$1, "variables", _useVariableEditor);
  useCompletion(variableEditor, onClickReference || null, _useVariableEditor);
  let t13;
  if ($[14] === Symbol.for("react.memo_cache_sentinel")) {
    t13 = ["Cmd-Enter", "Ctrl-Enter"];
    $[14] = t13;
  } else {
    t13 = $[14];
  }
  useKeyMap(variableEditor, t13, executionContext == null ? void 0 : executionContext.run);
  let t14;
  if ($[15] === Symbol.for("react.memo_cache_sentinel")) {
    t14 = ["Shift-Ctrl-P"];
    $[15] = t14;
  } else {
    t14 = $[15];
  }
  useKeyMap(variableEditor, t14, prettify);
  let t15;
  if ($[16] === Symbol.for("react.memo_cache_sentinel")) {
    t15 = ["Shift-Ctrl-M"];
    $[16] = t15;
  } else {
    t15 = $[16];
  }
  useKeyMap(variableEditor, t15, merge);
  return ref;
}
function _temp(editorInstance, event) {
  const {
    code,
    key,
    shiftKey
  } = event;
  const isLetter = code.startsWith("Key");
  const isNumber = !shiftKey && code.startsWith("Digit");
  if (isLetter || isNumber || key === "_" || key === '"') {
    editorInstance.execCommand("autocomplete");
  }
}
const STORAGE_KEY$1 = "variables";
const EditorContext = createNullableContext("EditorContext");
function EditorContextProvider(props) {
  const $ = c(89);
  const storage = useStorageContext();
  const [headerEditor, setHeaderEditor] = useState(null);
  const [queryEditor, setQueryEditor] = useState(null);
  const [responseEditor, setResponseEditor] = useState(null);
  const [variableEditor, setVariableEditor] = useState(null);
  let t0;
  if ($[0] !== props.shouldPersistHeaders || $[1] !== storage) {
    t0 = () => {
      const isStored = (storage == null ? void 0 : storage.get(PERSIST_HEADERS_STORAGE_KEY)) !== null;
      return props.shouldPersistHeaders !== false && isStored ? (storage == null ? void 0 : storage.get(PERSIST_HEADERS_STORAGE_KEY)) === "true" : Boolean(props.shouldPersistHeaders);
    };
    $[0] = props.shouldPersistHeaders;
    $[1] = storage;
    $[2] = t0;
  } else {
    t0 = $[2];
  }
  const [shouldPersistHeaders, setShouldPersistHeadersInternal] = useState(t0);
  useSynchronizeValue(headerEditor, props.headers);
  useSynchronizeValue(queryEditor, props.query);
  useSynchronizeValue(responseEditor, props.response);
  useSynchronizeValue(variableEditor, props.variables);
  let t1;
  if ($[3] !== shouldPersistHeaders || $[4] !== storage) {
    t1 = {
      storage,
      shouldPersistHeaders
    };
    $[3] = shouldPersistHeaders;
    $[4] = storage;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  const storeTabs = useStoreTabs(t1);
  let t2;
  if ($[6] !== props.defaultHeaders || $[7] !== props.defaultQuery || $[8] !== props.defaultTabs || $[9] !== props.headers || $[10] !== props.query || $[11] !== props.response || $[12] !== props.variables || $[13] !== shouldPersistHeaders || $[14] !== storage || $[15] !== storeTabs) {
    t2 = () => {
      const query = props.query ?? (storage == null ? void 0 : storage.get(STORAGE_KEY_QUERY)) ?? null;
      const variables = props.variables ?? (storage == null ? void 0 : storage.get(STORAGE_KEY$1)) ?? null;
      const headers = props.headers ?? (storage == null ? void 0 : storage.get(STORAGE_KEY$3)) ?? null;
      const response = props.response ?? "";
      const tabState = getDefaultTabState({
        query,
        variables,
        headers,
        defaultTabs: props.defaultTabs,
        defaultQuery: props.defaultQuery || DEFAULT_QUERY,
        defaultHeaders: props.defaultHeaders,
        storage,
        shouldPersistHeaders
      });
      storeTabs(tabState);
      return {
        query: query ?? (tabState.activeTabIndex === 0 ? tabState.tabs[0].query : null) ?? "",
        variables: variables ?? "",
        headers: headers ?? props.defaultHeaders ?? "",
        response,
        tabState
      };
    };
    $[6] = props.defaultHeaders;
    $[7] = props.defaultQuery;
    $[8] = props.defaultTabs;
    $[9] = props.headers;
    $[10] = props.query;
    $[11] = props.response;
    $[12] = props.variables;
    $[13] = shouldPersistHeaders;
    $[14] = storage;
    $[15] = storeTabs;
    $[16] = t2;
  } else {
    t2 = $[16];
  }
  const [initialState] = useState(t2);
  const [tabState_0, setTabState] = useState(initialState.tabState);
  let t3;
  if ($[17] !== headerEditor || $[18] !== storage || $[19] !== tabState_0) {
    t3 = (persist) => {
      if (persist) {
        storage == null ? void 0 : storage.set(STORAGE_KEY$3, (headerEditor == null ? void 0 : headerEditor.getValue()) ?? "");
        const serializedTabs = serializeTabState(tabState_0, true);
        storage == null ? void 0 : storage.set(STORAGE_KEY$2, serializedTabs);
      } else {
        storage == null ? void 0 : storage.set(STORAGE_KEY$3, "");
        clearHeadersFromTabs(storage);
      }
      setShouldPersistHeadersInternal(persist);
      storage == null ? void 0 : storage.set(PERSIST_HEADERS_STORAGE_KEY, persist.toString());
    };
    $[17] = headerEditor;
    $[18] = storage;
    $[19] = tabState_0;
    $[20] = t3;
  } else {
    t3 = $[20];
  }
  const setShouldPersistHeaders = t3;
  const lastShouldPersistHeadersProp = useRef();
  let t4;
  let t5;
  if ($[21] !== props.shouldPersistHeaders || $[22] !== setShouldPersistHeaders) {
    t4 = () => {
      const propValue = Boolean(props.shouldPersistHeaders);
      if ((lastShouldPersistHeadersProp == null ? void 0 : lastShouldPersistHeadersProp.current) !== propValue) {
        setShouldPersistHeaders(propValue);
        lastShouldPersistHeadersProp.current = propValue;
      }
    };
    t5 = [props.shouldPersistHeaders, setShouldPersistHeaders];
    $[21] = props.shouldPersistHeaders;
    $[22] = setShouldPersistHeaders;
    $[23] = t4;
    $[24] = t5;
  } else {
    t4 = $[23];
    t5 = $[24];
  }
  useEffect(t4, t5);
  let t6;
  if ($[25] !== headerEditor || $[26] !== queryEditor || $[27] !== responseEditor || $[28] !== variableEditor) {
    t6 = {
      queryEditor,
      variableEditor,
      headerEditor,
      responseEditor
    };
    $[25] = headerEditor;
    $[26] = queryEditor;
    $[27] = responseEditor;
    $[28] = variableEditor;
    $[29] = t6;
  } else {
    t6 = $[29];
  }
  const synchronizeActiveTabValues = useSynchronizeActiveTabValues(t6);
  const {
    onTabChange,
    defaultHeaders,
    defaultQuery,
    children
  } = props;
  let t7;
  if ($[30] !== defaultHeaders || $[31] !== headerEditor || $[32] !== queryEditor || $[33] !== responseEditor || $[34] !== variableEditor) {
    t7 = {
      queryEditor,
      variableEditor,
      headerEditor,
      responseEditor,
      defaultHeaders
    };
    $[30] = defaultHeaders;
    $[31] = headerEditor;
    $[32] = queryEditor;
    $[33] = responseEditor;
    $[34] = variableEditor;
    $[35] = t7;
  } else {
    t7 = $[35];
  }
  const setEditorValues = useSetEditorValues(t7);
  let t8;
  if ($[36] !== defaultHeaders || $[37] !== defaultQuery || $[38] !== onTabChange || $[39] !== setEditorValues || $[40] !== storeTabs || $[41] !== synchronizeActiveTabValues) {
    t8 = () => {
      setTabState((current) => {
        const updatedValues = synchronizeActiveTabValues(current);
        const updated = {
          tabs: [...updatedValues.tabs, createTab({
            headers: defaultHeaders,
            query: defaultQuery ?? DEFAULT_QUERY
          })],
          activeTabIndex: updatedValues.tabs.length
        };
        storeTabs(updated);
        setEditorValues(updated.tabs[updated.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated);
        return updated;
      });
    };
    $[36] = defaultHeaders;
    $[37] = defaultQuery;
    $[38] = onTabChange;
    $[39] = setEditorValues;
    $[40] = storeTabs;
    $[41] = synchronizeActiveTabValues;
    $[42] = t8;
  } else {
    t8 = $[42];
  }
  const addTab = t8;
  let t9;
  if ($[43] !== onTabChange || $[44] !== setEditorValues || $[45] !== storeTabs) {
    t9 = (index) => {
      setTabState((current_0) => {
        const updated_0 = {
          ...current_0,
          activeTabIndex: index
        };
        storeTabs(updated_0);
        setEditorValues(updated_0.tabs[updated_0.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated_0);
        return updated_0;
      });
    };
    $[43] = onTabChange;
    $[44] = setEditorValues;
    $[45] = storeTabs;
    $[46] = t9;
  } else {
    t9 = $[46];
  }
  const changeTab = t9;
  let t10;
  if ($[47] !== onTabChange || $[48] !== setEditorValues || $[49] !== storeTabs) {
    t10 = (newOrder) => {
      setTabState((current_1) => {
        const activeTab = current_1.tabs[current_1.activeTabIndex];
        const updated_1 = {
          tabs: newOrder,
          activeTabIndex: newOrder.indexOf(activeTab)
        };
        storeTabs(updated_1);
        setEditorValues(updated_1.tabs[updated_1.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated_1);
        return updated_1;
      });
    };
    $[47] = onTabChange;
    $[48] = setEditorValues;
    $[49] = storeTabs;
    $[50] = t10;
  } else {
    t10 = $[50];
  }
  const moveTab = t10;
  let t11;
  if ($[51] !== onTabChange || $[52] !== setEditorValues || $[53] !== storeTabs) {
    t11 = (index_0) => {
      setTabState((current_2) => {
        const updated_2 = {
          tabs: current_2.tabs.filter((_tab, i) => index_0 !== i),
          activeTabIndex: Math.max(current_2.activeTabIndex - 1, 0)
        };
        storeTabs(updated_2);
        setEditorValues(updated_2.tabs[updated_2.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated_2);
        return updated_2;
      });
    };
    $[51] = onTabChange;
    $[52] = setEditorValues;
    $[53] = storeTabs;
    $[54] = t11;
  } else {
    t11 = $[54];
  }
  const closeTab = t11;
  let t12;
  if ($[55] !== onTabChange || $[56] !== storeTabs) {
    t12 = (partialTab) => {
      setTabState((current_3) => {
        const updated_3 = setPropertiesInActiveTab(current_3, partialTab);
        storeTabs(updated_3);
        onTabChange == null ? void 0 : onTabChange(updated_3);
        return updated_3;
      });
    };
    $[55] = onTabChange;
    $[56] = storeTabs;
    $[57] = t12;
  } else {
    t12 = $[57];
  }
  const updateActiveTabValues = t12;
  const {
    onEditOperationName
  } = props;
  let t13;
  if ($[58] !== onEditOperationName || $[59] !== queryEditor || $[60] !== updateActiveTabValues) {
    t13 = (operationName) => {
      if (!queryEditor) {
        return;
      }
      updateQueryEditor(queryEditor, operationName);
      updateActiveTabValues({
        operationName
      });
      onEditOperationName == null ? void 0 : onEditOperationName(operationName);
    };
    $[58] = onEditOperationName;
    $[59] = queryEditor;
    $[60] = updateActiveTabValues;
    $[61] = t13;
  } else {
    t13 = $[61];
  }
  const setOperationName = t13;
  let t14;
  let map;
  if ($[62] !== props.externalFragments) {
    map = /* @__PURE__ */ new Map();
    if (Array.isArray(props.externalFragments)) {
      for (const fragment of props.externalFragments) {
        map.set(fragment.name.value, fragment);
      }
    } else {
      if (typeof props.externalFragments === "string") {
        visit(parse(props.externalFragments, {}), {
          FragmentDefinition(fragment_0) {
            map.set(fragment_0.name.value, fragment_0);
          }
        });
      } else {
        if (props.externalFragments) {
          throw new Error("The `externalFragments` prop must either be a string that contains the fragment definitions in SDL or a list of FragmentDefinitionNode objects.");
        }
      }
    }
    $[62] = props.externalFragments;
    $[63] = map;
  } else {
    map = $[63];
  }
  t14 = map;
  const externalFragments = t14;
  let t15;
  if ($[64] !== props.validationRules) {
    t15 = props.validationRules || [];
    $[64] = props.validationRules;
    $[65] = t15;
  } else {
    t15 = $[65];
  }
  const validationRules = t15;
  let t16;
  if ($[66] !== addTab || $[67] !== changeTab || $[68] !== closeTab || $[69] !== externalFragments || $[70] !== headerEditor || $[71] !== initialState.headers || $[72] !== initialState.query || $[73] !== initialState.response || $[74] !== initialState.variables || $[75] !== moveTab || $[76] !== queryEditor || $[77] !== responseEditor || $[78] !== setOperationName || $[79] !== setShouldPersistHeaders || $[80] !== shouldPersistHeaders || $[81] !== tabState_0 || $[82] !== updateActiveTabValues || $[83] !== validationRules || $[84] !== variableEditor) {
    t16 = {
      ...tabState_0,
      addTab,
      changeTab,
      moveTab,
      closeTab,
      updateActiveTabValues,
      headerEditor,
      queryEditor,
      responseEditor,
      variableEditor,
      setHeaderEditor,
      setQueryEditor,
      setResponseEditor,
      setVariableEditor,
      setOperationName,
      initialQuery: initialState.query,
      initialVariables: initialState.variables,
      initialHeaders: initialState.headers,
      initialResponse: initialState.response,
      externalFragments,
      validationRules,
      shouldPersistHeaders,
      setShouldPersistHeaders
    };
    $[66] = addTab;
    $[67] = changeTab;
    $[68] = closeTab;
    $[69] = externalFragments;
    $[70] = headerEditor;
    $[71] = initialState.headers;
    $[72] = initialState.query;
    $[73] = initialState.response;
    $[74] = initialState.variables;
    $[75] = moveTab;
    $[76] = queryEditor;
    $[77] = responseEditor;
    $[78] = setOperationName;
    $[79] = setShouldPersistHeaders;
    $[80] = shouldPersistHeaders;
    $[81] = tabState_0;
    $[82] = updateActiveTabValues;
    $[83] = validationRules;
    $[84] = variableEditor;
    $[85] = t16;
  } else {
    t16 = $[85];
  }
  const value = t16;
  let t17;
  if ($[86] !== children || $[87] !== value) {
    t17 = /* @__PURE__ */ jsx(EditorContext.Provider, { value, children });
    $[86] = children;
    $[87] = value;
    $[88] = t17;
  } else {
    t17 = $[88];
  }
  return t17;
}
function updateQueryEditor(queryEditor, operationName) {
  queryEditor.operationName = operationName;
}
const useEditorContext = createContextHook(EditorContext);
const PERSIST_HEADERS_STORAGE_KEY = "shouldPersistHeaders";
const DEFAULT_QUERY = `# Welcome to GraphiQL
#
# GraphiQL is an in-browser tool for writing, validating, and
# testing GraphQL queries.
#
# Type queries into this side of the screen, and you will see intelligent
# typeaheads aware of the current GraphQL type schema and live syntax and
# validation errors highlighted within the text.
#
# GraphQL queries typically start with a "{" character. Lines that start
# with a # are ignored.
#
# An example GraphQL query might look like:
#
#     {
#       field(arg: "value") {
#         subField
#       }
#     }
#
# Keyboard shortcuts:
#
#   Prettify query:  Shift-Ctrl-P (or press the prettify button)
#
#  Merge fragments:  Shift-Ctrl-M (or press the merge button)
#
#        Run Query:  Ctrl-Enter (or press the play button)
#
#    Auto Complete:  Ctrl-Space (or just start typing)
#

`;
function HeaderEditor(t0) {
  const $ = c(13);
  let hookArgs;
  let isHidden;
  if ($[0] !== t0) {
    ({
      isHidden,
      ...hookArgs
    } = t0);
    $[0] = t0;
    $[1] = hookArgs;
    $[2] = isHidden;
  } else {
    hookArgs = $[1];
    isHidden = $[2];
  }
  let t1;
  if ($[3] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: HeaderEditor
    };
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  const {
    headerEditor
  } = useEditorContext(t1);
  const ref = useHeaderEditor(hookArgs, HeaderEditor);
  let t2;
  let t3;
  if ($[4] !== headerEditor || $[5] !== isHidden) {
    t2 = () => {
      if (!isHidden) {
        headerEditor == null ? void 0 : headerEditor.refresh();
      }
    };
    t3 = [headerEditor, isHidden];
    $[4] = headerEditor;
    $[5] = isHidden;
    $[6] = t2;
    $[7] = t3;
  } else {
    t2 = $[6];
    t3 = $[7];
  }
  useEffect(t2, t3);
  const t4 = isHidden && "hidden";
  let t5;
  if ($[8] !== t4) {
    t5 = clsx("graphiql-editor", t4);
    $[8] = t4;
    $[9] = t5;
  } else {
    t5 = $[9];
  }
  let t6;
  if ($[10] !== ref || $[11] !== t5) {
    t6 = /* @__PURE__ */ jsx("div", { className: t5, ref });
    $[10] = ref;
    $[11] = t5;
    $[12] = t6;
  } else {
    t6 = $[12];
  }
  return t6;
}
function ImagePreview(props) {
  var _a;
  const $ = c(14);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      width: null,
      height: null
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const [dimensions, setDimensions] = useState(t0);
  const [mime, setMime] = useState(null);
  const ref = useRef(null);
  const src = (_a = tokenToURL(props.token)) == null ? void 0 : _a.href;
  let t1;
  let t2;
  if ($[1] !== src) {
    t1 = () => {
      if (!ref.current) {
        return;
      }
      if (!src) {
        setDimensions({
          width: null,
          height: null
        });
        setMime(null);
        return;
      }
      fetch(src, {
        method: "HEAD"
      }).then((response) => {
        setMime(response.headers.get("Content-Type"));
      }).catch(() => {
        setMime(null);
      });
    };
    t2 = [src];
    $[1] = src;
    $[2] = t1;
    $[3] = t2;
  } else {
    t1 = $[2];
    t2 = $[3];
  }
  useEffect(t1, t2);
  let t3;
  if ($[4] !== dimensions.height || $[5] !== dimensions.width || $[6] !== mime) {
    t3 = dimensions.width !== null && dimensions.height !== null ? /* @__PURE__ */ jsxs("div", { children: [
      dimensions.width,
      "x",
      dimensions.height,
      mime === null ? null : " " + mime
    ] }) : null;
    $[4] = dimensions.height;
    $[5] = dimensions.width;
    $[6] = mime;
    $[7] = t3;
  } else {
    t3 = $[7];
  }
  const dims = t3;
  let t4;
  if ($[8] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = () => {
      var _a2, _b;
      setDimensions({
        width: ((_a2 = ref.current) == null ? void 0 : _a2.naturalWidth) ?? null,
        height: ((_b = ref.current) == null ? void 0 : _b.naturalHeight) ?? null
      });
    };
    $[8] = t4;
  } else {
    t4 = $[8];
  }
  let t5;
  if ($[9] !== src) {
    t5 = /* @__PURE__ */ jsx("img", { onLoad: t4, ref, src });
    $[9] = src;
    $[10] = t5;
  } else {
    t5 = $[10];
  }
  let t6;
  if ($[11] !== dims || $[12] !== t5) {
    t6 = /* @__PURE__ */ jsxs("div", { children: [
      t5,
      dims
    ] });
    $[11] = dims;
    $[12] = t5;
    $[13] = t6;
  } else {
    t6 = $[13];
  }
  return t6;
}
ImagePreview.shouldRender = function shouldRender(token) {
  const url = tokenToURL(token);
  return url ? isImageURL(url) : false;
};
function tokenToURL(token) {
  if (token.type !== "string") {
    return;
  }
  const value = token.string.slice(1).slice(0, -1).trim();
  try {
    const {
      location
    } = window;
    return new URL(value, location.protocol + "//" + location.host);
  } catch {
    return;
  }
}
function isImageURL(url) {
  return /\.(bmp|gif|jpe?g|png|svg|webp)$/.test(url.pathname);
}
function QueryEditor(props) {
  const $ = c(2);
  const ref = useQueryEditor(props, QueryEditor);
  let t0;
  if ($[0] !== ref) {
    t0 = /* @__PURE__ */ jsx("div", { className: "graphiql-editor", ref });
    $[0] = ref;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
}
function importCodeMirrorImports() {
  return importCodeMirror([
    import("codemirror/addon/fold/foldgutter.js"),
    import("codemirror/addon/fold/brace-fold.js"),
    import("codemirror/addon/dialog/dialog.js"),
    import("codemirror/addon/search/search.js"),
    import("codemirror/addon/search/searchcursor.js"),
    import("codemirror/addon/search/jump-to-line.js"),
    // @ts-expect-error
    import("codemirror/keymap/sublime.js"),
    import("codemirror-graphql/esm/results/mode.js"),
    import("codemirror-graphql/esm/utils/info-addon.js")
  ], {
    useCommonAddons: false
  });
}
const _useResponseEditor = useResponseEditor;
function useResponseEditor(t0, caller) {
  const $ = c(19);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    responseTooltip,
    editorTheme: t2,
    keyMap: t3
  } = t1;
  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;
  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;
  const t4 = caller || _useResponseEditor;
  let t5;
  if ($[2] !== t4) {
    t5 = {
      nonNull: true,
      caller: t4
    };
    $[2] = t4;
    $[3] = t5;
  } else {
    t5 = $[3];
  }
  const {
    fetchError,
    validationErrors
  } = useSchemaContext(t5);
  const t6 = caller || _useResponseEditor;
  let t7;
  if ($[4] !== t6) {
    t7 = {
      nonNull: true,
      caller: t6
    };
    $[4] = t6;
    $[5] = t7;
  } else {
    t7 = $[5];
  }
  const {
    initialResponse,
    responseEditor,
    setResponseEditor
  } = useEditorContext(t7);
  const ref = useRef(null);
  const responseTooltipRef = useRef(responseTooltip);
  let t8;
  let t9;
  if ($[6] !== responseTooltip) {
    t8 = () => {
      responseTooltipRef.current = responseTooltip;
    };
    t9 = [responseTooltip];
    $[6] = responseTooltip;
    $[7] = t8;
    $[8] = t9;
  } else {
    t8 = $[7];
    t9 = $[8];
  }
  useEffect(t8, t9);
  let t10;
  let t11;
  if ($[9] !== editorTheme || $[10] !== initialResponse || $[11] !== setResponseEditor) {
    t10 = () => {
      let isActive;
      isActive = true;
      importCodeMirrorImports().then((CodeMirror) => {
        if (!isActive) {
          return;
        }
        const tooltipDiv = document.createElement("div");
        CodeMirror.registerHelper("info", "graphql-results", (token, _options, _cm, pos) => {
          const infoElements = [];
          const ResponseTooltipComponent = responseTooltipRef.current;
          if (ResponseTooltipComponent) {
            infoElements.push(/* @__PURE__ */ jsx(ResponseTooltipComponent, { pos, token }));
          }
          if (ImagePreview.shouldRender(token)) {
            infoElements.push(/* @__PURE__ */ jsx(ImagePreview, { token }, "image-preview"));
          }
          if (!infoElements.length) {
            ReactDOM.unmountComponentAtNode(tooltipDiv);
            return null;
          }
          ReactDOM.render(infoElements, tooltipDiv);
          return tooltipDiv;
        });
        const container = ref.current;
        if (!container) {
          return;
        }
        const newEditor = CodeMirror(container, {
          value: initialResponse,
          lineWrapping: true,
          readOnly: true,
          theme: editorTheme,
          mode: "graphql-results",
          foldGutter: true,
          gutters: ["CodeMirror-foldgutter"],
          info: true,
          extraKeys: commonKeys
        });
        setResponseEditor(newEditor);
      });
      return () => {
        isActive = false;
      };
    };
    t11 = [editorTheme, initialResponse, setResponseEditor];
    $[9] = editorTheme;
    $[10] = initialResponse;
    $[11] = setResponseEditor;
    $[12] = t10;
    $[13] = t11;
  } else {
    t10 = $[12];
    t11 = $[13];
  }
  useEffect(t10, t11);
  useSynchronizeOption(responseEditor, "keyMap", keyMap);
  let t12;
  let t13;
  if ($[14] !== fetchError || $[15] !== responseEditor || $[16] !== validationErrors) {
    t12 = () => {
      if (fetchError) {
        responseEditor == null ? void 0 : responseEditor.setValue(fetchError);
      }
      if (validationErrors.length > 0) {
        responseEditor == null ? void 0 : responseEditor.setValue(formatError(validationErrors));
      }
    };
    t13 = [responseEditor, fetchError, validationErrors];
    $[14] = fetchError;
    $[15] = responseEditor;
    $[16] = validationErrors;
    $[17] = t12;
    $[18] = t13;
  } else {
    t12 = $[17];
    t13 = $[18];
  }
  useEffect(t12, t13);
  return ref;
}
function ResponseEditor(props) {
  const $ = c(2);
  const ref = useResponseEditor(props, ResponseEditor);
  let t0;
  if ($[0] !== ref) {
    t0 = /* @__PURE__ */ jsx("section", { className: "result-window", "aria-label": "Result Window", "aria-live": "polite", "aria-atomic": "true", ref });
    $[0] = ref;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
}
function VariableEditor(t0) {
  const $ = c(13);
  let hookArgs;
  let isHidden;
  if ($[0] !== t0) {
    ({
      isHidden,
      ...hookArgs
    } = t0);
    $[0] = t0;
    $[1] = hookArgs;
    $[2] = isHidden;
  } else {
    hookArgs = $[1];
    isHidden = $[2];
  }
  let t1;
  if ($[3] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: VariableEditor
    };
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  const {
    variableEditor
  } = useEditorContext(t1);
  const ref = useVariableEditor(hookArgs, VariableEditor);
  let t2;
  let t3;
  if ($[4] !== isHidden || $[5] !== variableEditor) {
    t2 = () => {
      if (variableEditor && !isHidden) {
        variableEditor.refresh();
      }
    };
    t3 = [variableEditor, isHidden];
    $[4] = isHidden;
    $[5] = variableEditor;
    $[6] = t2;
    $[7] = t3;
  } else {
    t2 = $[6];
    t3 = $[7];
  }
  useEffect(t2, t3);
  const t4 = isHidden && "hidden";
  let t5;
  if ($[8] !== t4) {
    t5 = clsx("graphiql-editor", t4);
    $[8] = t4;
    $[9] = t5;
  } else {
    t5 = $[9];
  }
  let t6;
  if ($[10] !== ref || $[11] !== t5) {
    t6 = /* @__PURE__ */ jsx("div", { className: t5, ref });
    $[10] = ref;
    $[11] = t5;
    $[12] = t6;
  } else {
    t6 = $[12];
  }
  return t6;
}
function GraphiQLProvider(t0) {
  const $ = c(39);
  const {
    children,
    dangerouslyAssumeSchemaIsValid,
    defaultQuery,
    defaultHeaders,
    defaultTabs,
    externalFragments,
    fetcher,
    getDefaultFieldNames,
    headers,
    inputValueDeprecation,
    introspectionQueryName,
    maxHistoryLength,
    onEditOperationName,
    onSchemaChange,
    onTabChange,
    onTogglePluginVisibility,
    operationName,
    plugins,
    query,
    response,
    schema,
    schemaDescription,
    shouldPersistHeaders,
    storage,
    validationRules,
    variables,
    visiblePlugin
  } = t0;
  let t1;
  if ($[0] !== children || $[1] !== onTogglePluginVisibility || $[2] !== plugins || $[3] !== visiblePlugin) {
    t1 = /* @__PURE__ */ jsx(ExplorerContextProvider, { children: /* @__PURE__ */ jsx(PluginContextProvider, { onTogglePluginVisibility, plugins, visiblePlugin, children }) });
    $[0] = children;
    $[1] = onTogglePluginVisibility;
    $[2] = plugins;
    $[3] = visiblePlugin;
    $[4] = t1;
  } else {
    t1 = $[4];
  }
  let t2;
  if ($[5] !== fetcher || $[6] !== getDefaultFieldNames || $[7] !== operationName || $[8] !== t1) {
    t2 = /* @__PURE__ */ jsx(ExecutionContextProvider, { getDefaultFieldNames, fetcher, operationName, children: t1 });
    $[5] = fetcher;
    $[6] = getDefaultFieldNames;
    $[7] = operationName;
    $[8] = t1;
    $[9] = t2;
  } else {
    t2 = $[9];
  }
  let t3;
  if ($[10] !== dangerouslyAssumeSchemaIsValid || $[11] !== fetcher || $[12] !== inputValueDeprecation || $[13] !== introspectionQueryName || $[14] !== onSchemaChange || $[15] !== schema || $[16] !== schemaDescription || $[17] !== t2) {
    t3 = /* @__PURE__ */ jsx(SchemaContextProvider, { dangerouslyAssumeSchemaIsValid, fetcher, inputValueDeprecation, introspectionQueryName, onSchemaChange, schema, schemaDescription, children: t2 });
    $[10] = dangerouslyAssumeSchemaIsValid;
    $[11] = fetcher;
    $[12] = inputValueDeprecation;
    $[13] = introspectionQueryName;
    $[14] = onSchemaChange;
    $[15] = schema;
    $[16] = schemaDescription;
    $[17] = t2;
    $[18] = t3;
  } else {
    t3 = $[18];
  }
  let t4;
  if ($[19] !== defaultHeaders || $[20] !== defaultQuery || $[21] !== defaultTabs || $[22] !== externalFragments || $[23] !== headers || $[24] !== onEditOperationName || $[25] !== onTabChange || $[26] !== query || $[27] !== response || $[28] !== shouldPersistHeaders || $[29] !== t3 || $[30] !== validationRules || $[31] !== variables) {
    t4 = /* @__PURE__ */ jsx(EditorContextProvider, { defaultQuery, defaultHeaders, defaultTabs, externalFragments, headers, onEditOperationName, onTabChange, query, response, shouldPersistHeaders, validationRules, variables, children: t3 });
    $[19] = defaultHeaders;
    $[20] = defaultQuery;
    $[21] = defaultTabs;
    $[22] = externalFragments;
    $[23] = headers;
    $[24] = onEditOperationName;
    $[25] = onTabChange;
    $[26] = query;
    $[27] = response;
    $[28] = shouldPersistHeaders;
    $[29] = t3;
    $[30] = validationRules;
    $[31] = variables;
    $[32] = t4;
  } else {
    t4 = $[32];
  }
  let t5;
  if ($[33] !== maxHistoryLength || $[34] !== t4) {
    t5 = /* @__PURE__ */ jsx(HistoryContextProvider, { maxHistoryLength, children: t4 });
    $[33] = maxHistoryLength;
    $[34] = t4;
    $[35] = t5;
  } else {
    t5 = $[35];
  }
  let t6;
  if ($[36] !== storage || $[37] !== t5) {
    t6 = /* @__PURE__ */ jsx(StorageContextProvider, { storage, children: t5 });
    $[36] = storage;
    $[37] = t5;
    $[38] = t6;
  } else {
    t6 = $[38];
  }
  return t6;
}
function useTheme(t0) {
  const $ = c(11);
  const defaultTheme = t0 === void 0 ? null : t0;
  const storageContext = useStorageContext();
  let t1;
  if ($[0] !== defaultTheme || $[1] !== storageContext) {
    t1 = () => {
      if (!storageContext) {
        return null;
      }
      const stored = storageContext.get(STORAGE_KEY);
      switch (stored) {
        case "light": {
          return "light";
        }
        case "dark": {
          return "dark";
        }
        default: {
          if (typeof stored === "string") {
            storageContext.set(STORAGE_KEY, "");
          }
          return defaultTheme;
        }
      }
    };
    $[0] = defaultTheme;
    $[1] = storageContext;
    $[2] = t1;
  } else {
    t1 = $[2];
  }
  const [theme, setThemeInternal] = useState(t1);
  let t2;
  let t3;
  if ($[3] !== theme) {
    t2 = () => {
      if (typeof window === "undefined") {
        return;
      }
      document.body.classList.remove("graphiql-light", "graphiql-dark");
      if (theme) {
        document.body.classList.add(`graphiql-${theme}`);
      }
    };
    t3 = [theme];
    $[3] = theme;
    $[4] = t2;
    $[5] = t3;
  } else {
    t2 = $[4];
    t3 = $[5];
  }
  useLayoutEffect(t2, t3);
  let t4;
  if ($[6] !== storageContext) {
    t4 = (newTheme) => {
      storageContext == null ? void 0 : storageContext.set(STORAGE_KEY, newTheme || "");
      setThemeInternal(newTheme);
    };
    $[6] = storageContext;
    $[7] = t4;
  } else {
    t4 = $[7];
  }
  const setTheme = t4;
  let t5;
  if ($[8] !== setTheme || $[9] !== theme) {
    t5 = {
      theme,
      setTheme
    };
    $[8] = setTheme;
    $[9] = theme;
    $[10] = t5;
  } else {
    t5 = $[10];
  }
  return t5;
}
const STORAGE_KEY = "theme";
function useDragResize(t0) {
  const $ = c(31);
  const {
    defaultSizeRelation: t1,
    direction,
    initiallyHidden,
    onHiddenElementChange,
    sizeThresholdFirst: t2,
    sizeThresholdSecond: t3,
    storageKey
  } = t0;
  const defaultSizeRelation = t1 === void 0 ? DEFAULT_FLEX : t1;
  const sizeThresholdFirst = t2 === void 0 ? 100 : t2;
  const sizeThresholdSecond = t3 === void 0 ? 100 : t3;
  const storage = useStorageContext();
  let t4;
  if ($[0] !== storage || $[1] !== storageKey) {
    t4 = debounce(500, (value) => {
      if (storageKey) {
        storage == null ? void 0 : storage.set(storageKey, value);
      }
    });
    $[0] = storage;
    $[1] = storageKey;
    $[2] = t4;
  } else {
    t4 = $[2];
  }
  const store = t4;
  let t5;
  if ($[3] !== initiallyHidden || $[4] !== storage || $[5] !== storageKey) {
    t5 = () => {
      const storedValue = storageKey && (storage == null ? void 0 : storage.get(storageKey));
      if (storedValue === HIDE_FIRST || initiallyHidden === "first") {
        return "first";
      }
      if (storedValue === HIDE_SECOND || initiallyHidden === "second") {
        return "second";
      }
      return null;
    };
    $[3] = initiallyHidden;
    $[4] = storage;
    $[5] = storageKey;
    $[6] = t5;
  } else {
    t5 = $[6];
  }
  const [hiddenElement, setHiddenElement] = useState(t5);
  let t6;
  if ($[7] !== hiddenElement || $[8] !== onHiddenElementChange) {
    t6 = (element) => {
      if (element !== hiddenElement) {
        setHiddenElement(element);
        onHiddenElementChange == null ? void 0 : onHiddenElementChange(element);
      }
    };
    $[7] = hiddenElement;
    $[8] = onHiddenElementChange;
    $[9] = t6;
  } else {
    t6 = $[9];
  }
  const setHiddenElementWithCallback = t6;
  const firstRef = useRef(null);
  const dragBarRef = useRef(null);
  const secondRef = useRef(null);
  const defaultFlexRef = useRef(`${defaultSizeRelation}`);
  let t7;
  if ($[10] !== storage || $[11] !== storageKey) {
    t7 = () => {
      const storedValue_0 = storageKey && (storage == null ? void 0 : storage.get(storageKey)) || defaultFlexRef.current;
      if (firstRef.current) {
        firstRef.current.style.display = "flex";
        firstRef.current.style.flex = storedValue_0 === HIDE_FIRST || storedValue_0 === HIDE_SECOND ? defaultFlexRef.current : storedValue_0;
      }
      if (secondRef.current) {
        secondRef.current.style.display = "flex";
        secondRef.current.style.flex = "1";
      }
      if (dragBarRef.current) {
        dragBarRef.current.style.display = "flex";
      }
    };
    $[10] = storage;
    $[11] = storageKey;
    $[12] = t7;
  } else {
    t7 = $[12];
  }
  let t8;
  if ($[13] !== direction || $[14] !== storage || $[15] !== storageKey) {
    t8 = [direction, storage, storageKey];
    $[13] = direction;
    $[14] = storage;
    $[15] = storageKey;
    $[16] = t8;
  } else {
    t8 = $[16];
  }
  useLayoutEffect(t7, t8);
  let t10;
  let t9;
  if ($[17] !== hiddenElement || $[18] !== storage || $[19] !== storageKey) {
    t9 = () => {
      const hide = (resizableElement) => {
        const element_0 = resizableElement === "first" ? firstRef.current : secondRef.current;
        if (!element_0) {
          return;
        }
        element_0.style.left = "-1000px";
        element_0.style.position = "absolute";
        element_0.style.opacity = "0";
        element_0.style.height = "500px";
        element_0.style.width = "500px";
        if (firstRef.current) {
          const flex = parseFloat(firstRef.current.style.flex);
          if (!Number.isFinite(flex) || flex < 1) {
            firstRef.current.style.flex = "1";
          }
        }
      };
      const show = (resizableElement_0) => {
        const element_1 = resizableElement_0 === "first" ? firstRef.current : secondRef.current;
        if (!element_1) {
          return;
        }
        element_1.style.width = "";
        element_1.style.height = "";
        element_1.style.opacity = "";
        element_1.style.position = "";
        element_1.style.left = "";
        if (storage && storageKey) {
          const storedValue_1 = storage.get(storageKey);
          if (firstRef.current && storedValue_1 !== HIDE_FIRST && storedValue_1 !== HIDE_SECOND) {
            firstRef.current.style.flex = storedValue_1 || defaultFlexRef.current;
          }
        }
      };
      if (hiddenElement === "first") {
        hide("first");
      } else {
        show("first");
      }
      if (hiddenElement === "second") {
        hide("second");
      } else {
        show("second");
      }
    };
    t10 = [hiddenElement, storage, storageKey];
    $[17] = hiddenElement;
    $[18] = storage;
    $[19] = storageKey;
    $[20] = t10;
    $[21] = t9;
  } else {
    t10 = $[20];
    t9 = $[21];
  }
  useLayoutEffect(t9, t10);
  let t11;
  let t12;
  if ($[22] !== direction || $[23] !== setHiddenElementWithCallback || $[24] !== sizeThresholdFirst || $[25] !== sizeThresholdSecond || $[26] !== store) {
    t11 = () => {
      if (!dragBarRef.current || !firstRef.current || !secondRef.current) {
        return;
      }
      const dragBarContainer = dragBarRef.current;
      const firstContainer = firstRef.current;
      const wrapper = firstContainer.parentElement;
      const eventProperty = direction === "horizontal" ? "clientX" : "clientY";
      const rectProperty = direction === "horizontal" ? "left" : "top";
      const adjacentRectProperty = direction === "horizontal" ? "right" : "bottom";
      const sizeProperty = direction === "horizontal" ? "clientWidth" : "clientHeight";
      const handleMouseDown = function handleMouseDown2(downEvent) {
        downEvent.preventDefault();
        const offset = downEvent[eventProperty] - dragBarContainer.getBoundingClientRect()[rectProperty];
        const handleMouseMove = function handleMouseMove2(moveEvent) {
          if (moveEvent.buttons === 0) {
            return handleMouseUp();
          }
          const firstSize = moveEvent[eventProperty] - wrapper.getBoundingClientRect()[rectProperty] - offset;
          const secondSize = wrapper.getBoundingClientRect()[adjacentRectProperty] - moveEvent[eventProperty] + offset - dragBarContainer[sizeProperty];
          if (firstSize < sizeThresholdFirst) {
            setHiddenElementWithCallback("first");
            store(HIDE_FIRST);
          } else {
            if (secondSize < sizeThresholdSecond) {
              setHiddenElementWithCallback("second");
              store(HIDE_SECOND);
            } else {
              setHiddenElementWithCallback(null);
              const newFlex = `${firstSize / secondSize}`;
              firstContainer.style.flex = newFlex;
              store(newFlex);
            }
          }
        };
        function handleMouseUp() {
          document.removeEventListener("mousemove", handleMouseMove);
          document.removeEventListener("mouseup", handleMouseUp);
        }
        document.addEventListener("mousemove", handleMouseMove);
        document.addEventListener("mouseup", handleMouseUp);
      };
      dragBarContainer.addEventListener("mousedown", handleMouseDown);
      const reset = function reset2() {
        if (firstRef.current) {
          firstRef.current.style.flex = defaultFlexRef.current;
        }
        store(defaultFlexRef.current);
        setHiddenElementWithCallback(null);
      };
      dragBarContainer.addEventListener("dblclick", reset);
      return () => {
        dragBarContainer.removeEventListener("mousedown", handleMouseDown);
        dragBarContainer.removeEventListener("dblclick", reset);
      };
    };
    t12 = [direction, setHiddenElementWithCallback, sizeThresholdFirst, sizeThresholdSecond, store];
    $[22] = direction;
    $[23] = setHiddenElementWithCallback;
    $[24] = sizeThresholdFirst;
    $[25] = sizeThresholdSecond;
    $[26] = store;
    $[27] = t11;
    $[28] = t12;
  } else {
    t11 = $[27];
    t12 = $[28];
  }
  useEffect(t11, t12);
  let t13;
  if ($[29] !== hiddenElement) {
    t13 = {
      dragBarRef,
      hiddenElement,
      firstRef,
      setHiddenElement,
      secondRef
    };
    $[29] = hiddenElement;
    $[30] = t13;
  } else {
    t13 = $[30];
  }
  return t13;
}
const DEFAULT_FLEX = 1;
const HIDE_FIRST = "hide-first";
const HIDE_SECOND = "hide-second";
const ToolbarButton = forwardRef((t0, ref) => {
  const $ = c(19);
  let label;
  let onClick;
  let props;
  if ($[0] !== t0) {
    ({
      label,
      onClick,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = label;
    $[2] = onClick;
    $[3] = props;
  } else {
    label = $[1];
    onClick = $[2];
    props = $[3];
  }
  const [error, setError] = useState(null);
  let t1;
  if ($[4] !== onClick) {
    t1 = (event) => {
      try {
        if (onClick) {
          onClick(event);
        }
        setError(null);
      } catch (t22) {
        const err = t22;
        setError(err instanceof Error ? err : new Error(`Toolbar button click failed: ${err}`));
      }
    };
    $[4] = onClick;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  const handleClick = t1;
  const t2 = error && "error";
  let t3;
  if ($[6] !== props.className || $[7] !== t2) {
    t3 = clsx("graphiql-toolbar-button", t2, props.className);
    $[6] = props.className;
    $[7] = t2;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  const t4 = error ? error.message : label;
  const t5 = error ? "true" : props["aria-invalid"];
  let t6;
  if ($[9] !== handleClick || $[10] !== props || $[11] !== ref || $[12] !== t3 || $[13] !== t4 || $[14] !== t5) {
    t6 = /* @__PURE__ */ jsx(UnStyledButton, { ...props, ref, type: "button", className: t3, onClick: handleClick, "aria-label": t4, "aria-invalid": t5 });
    $[9] = handleClick;
    $[10] = props;
    $[11] = ref;
    $[12] = t3;
    $[13] = t4;
    $[14] = t5;
    $[15] = t6;
  } else {
    t6 = $[15];
  }
  let t7;
  if ($[16] !== label || $[17] !== t6) {
    t7 = /* @__PURE__ */ jsx(Tooltip, { label, children: t6 });
    $[16] = label;
    $[17] = t6;
    $[18] = t7;
  } else {
    t7 = $[18];
  }
  return t7;
});
ToolbarButton.displayName = "ToolbarButton";
function ExecuteButton() {
  const $ = c(19);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: ExecuteButton
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    queryEditor,
    setOperationName
  } = useEditorContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: ExecuteButton
    };
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    isFetching,
    isSubscribed,
    operationName,
    run,
    stop
  } = useExecutionContext(t1);
  let t2;
  if ($[2] !== (queryEditor == null ? void 0 : queryEditor.operations)) {
    t2 = (queryEditor == null ? void 0 : queryEditor.operations) || [];
    $[2] = queryEditor == null ? void 0 : queryEditor.operations;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  const operations = t2;
  const hasOptions = operations.length > 1 && typeof operationName !== "string";
  const isRunning = isFetching || isSubscribed;
  const label = `${isRunning ? "Stop" : "Execute"} query (Ctrl-Enter)`;
  let t3;
  if ($[4] !== isRunning) {
    t3 = isRunning ? /* @__PURE__ */ jsx(StopIcon, {}) : /* @__PURE__ */ jsx(PlayIcon, {});
    $[4] = isRunning;
    $[5] = t3;
  } else {
    t3 = $[5];
  }
  let t4;
  if ($[6] !== label || $[7] !== t3) {
    t4 = {
      type: "button",
      className: "graphiql-execute-button",
      children: t3,
      "aria-label": label
    };
    $[6] = label;
    $[7] = t3;
    $[8] = t4;
  } else {
    t4 = $[8];
  }
  const buttonProps = t4;
  let t5;
  if ($[9] !== buttonProps || $[10] !== hasOptions || $[11] !== isRunning || $[12] !== label || $[13] !== operations || $[14] !== queryEditor || $[15] !== run || $[16] !== setOperationName || $[17] !== stop) {
    t5 = hasOptions && !isRunning ? /* @__PURE__ */ jsxs(DropdownMenu, { children: [
      /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx(DropdownMenu.Button, { ...buttonProps }) }),
      /* @__PURE__ */ jsx(DropdownMenu.Content, { children: operations.map((operation, i) => {
        const opName = operation.name ? operation.name.value : `<Unnamed ${operation.operation}>`;
        return /* @__PURE__ */ jsx(DropdownMenu.Item, { onSelect: () => {
          var _a;
          const selectedOperationName = (_a = operation.name) == null ? void 0 : _a.value;
          if (queryEditor && selectedOperationName && selectedOperationName !== queryEditor.operationName) {
            setOperationName(selectedOperationName);
          }
          run();
        }, children: opName }, `${opName}-${i}`);
      }) })
    ] }) : /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx("button", { ...buttonProps, onClick: () => {
      if (isRunning) {
        stop();
      } else {
        run();
      }
    } }) });
    $[9] = buttonProps;
    $[10] = hasOptions;
    $[11] = isRunning;
    $[12] = label;
    $[13] = operations;
    $[14] = queryEditor;
    $[15] = run;
    $[16] = setOperationName;
    $[17] = stop;
    $[18] = t5;
  } else {
    t5 = $[18];
  }
  return t5;
}
const ToolbarMenuRoot = (t0) => {
  const $ = c(20);
  let button;
  let children;
  let label;
  let props;
  if ($[0] !== t0) {
    ({
      button,
      children,
      label,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = button;
    $[2] = children;
    $[3] = label;
    $[4] = props;
  } else {
    button = $[1];
    children = $[2];
    label = $[3];
    props = $[4];
  }
  let t1;
  if ($[5] !== props.className) {
    t1 = clsx("graphiql-un-styled graphiql-toolbar-menu", props.className);
    $[5] = props.className;
    $[6] = t1;
  } else {
    t1 = $[6];
  }
  let t2;
  if ($[7] !== button || $[8] !== label || $[9] !== t1) {
    t2 = /* @__PURE__ */ jsx(DropdownMenu.Button, { className: t1, "aria-label": label, children: button });
    $[7] = button;
    $[8] = label;
    $[9] = t1;
    $[10] = t2;
  } else {
    t2 = $[10];
  }
  let t3;
  if ($[11] !== label || $[12] !== t2) {
    t3 = /* @__PURE__ */ jsx(Tooltip, { label, children: t2 });
    $[11] = label;
    $[12] = t2;
    $[13] = t3;
  } else {
    t3 = $[13];
  }
  let t4;
  if ($[14] !== children) {
    t4 = /* @__PURE__ */ jsx(DropdownMenu.Content, { children });
    $[14] = children;
    $[15] = t4;
  } else {
    t4 = $[15];
  }
  let t5;
  if ($[16] !== props || $[17] !== t3 || $[18] !== t4) {
    t5 = /* @__PURE__ */ jsxs(DropdownMenu, { ...props, children: [
      t3,
      t4
    ] });
    $[16] = props;
    $[17] = t3;
    $[18] = t4;
    $[19] = t5;
  } else {
    t5 = $[19];
  }
  return t5;
};
const ToolbarMenu = createComponentGroup(ToolbarMenuRoot, {
  Item: DropdownMenu.Item
});
export {
  Argument,
  ArgumentIcon,
  Button$1 as Button,
  ButtonGroup,
  ChevronDownIcon,
  ChevronLeftIcon,
  ChevronUpIcon,
  CloseIcon,
  CopyIcon,
  DOC_EXPLORER_PLUGIN,
  DefaultValue,
  DeprecatedArgumentIcon,
  DeprecatedEnumValueIcon,
  DeprecatedFieldIcon,
  DeprecationReason,
  Dialog,
  DialogRoot,
  Directive,
  DirectiveIcon,
  DocExplorer,
  DocsFilledIcon,
  DocsIcon,
  DropdownMenu,
  EditorContext,
  EditorContextProvider,
  EnumValueIcon,
  ExecuteButton,
  ExecutionContext,
  ExecutionContextProvider,
  ExplorerContext,
  ExplorerContextProvider,
  ExplorerSection,
  FieldDocumentation,
  FieldIcon,
  FieldLink,
  GraphiQLProvider,
  HISTORY_PLUGIN,
  HeaderEditor,
  History,
  HistoryContext,
  HistoryContextProvider,
  HistoryIcon,
  ImagePreview,
  ImplementsIcon,
  KeyboardShortcutIcon,
  MagnifyingGlassIcon,
  MarkdownContent,
  MergeIcon,
  PenIcon,
  PlayIcon,
  PluginContext,
  PluginContextProvider,
  PlusIcon,
  PrettifyIcon,
  QueryEditor,
  ReloadIcon,
  ResponseEditor,
  RootTypeIcon,
  SchemaContext,
  SchemaContextProvider,
  SchemaDocumentation,
  Search,
  SettingsIcon,
  Spinner,
  StarFilledIcon,
  StarIcon,
  StopIcon,
  StorageContext,
  StorageContextProvider,
  Tab,
  Tabs,
  ToolbarButton,
  ToolbarMenu,
  Tooltip,
  TooltipRoot,
  TrashIcon,
  TypeDocumentation,
  TypeIcon,
  TypeLink,
  UnStyledButton,
  VariableEditor,
  isMacOs,
  useAutoCompleteLeafs,
  useCopyQuery,
  useDragResize,
  useEditorContext,
  useEditorState,
  useExecutionContext,
  useExplorerContext,
  useHeaderEditor,
  useHeadersEditorState,
  useHistoryContext,
  useMergeQuery,
  useOperationsEditorState,
  useOptimisticState,
  usePluginContext,
  usePrettifyEditors,
  useQueryEditor,
  useResponseEditor,
  useSchemaContext,
  useStorageContext,
  useTheme,
  useVariableEditor,
  useVariablesEditorState
};
//# sourceMappingURL=index.mjs.map
