import { isMacOs } from "../utility/is-macos.js";
const DEFAULT_EDITOR_THEME = "graphiql";
const DEFAULT_KEY_MAP = "sublime";
const commonKeys = {
  // Persistent search box in Query Editor
  [isMacOs ? "Cmd-F" : "Ctrl-F"]: "findPersistent",
  "Cmd-G": "findPersistent",
  "Ctrl-G": "findPersistent",
  // Editor improvements
  "Ctrl-Left": "goSubwordLeft",
  "Ctrl-Right": "goSubwordRight",
  "Alt-Left": "goGroupLeft",
  "Alt-Right": "goGroupRight"
};
async function importCodeMirror(addons, options) {
  const CodeMirror = await import("codemirror").then((mod) => (
    // Depending on bundler and settings the dynamic import either returns a
    // function (e.g., parcel) or an object containing a `default` property
    typeof mod === "function" ? mod : mod.default
  ));
  await Promise.all((options == null ? void 0 : options.useCommonAddons) === false ? addons : [
    import("codemirror/addon/hint/show-hint.js"),
    import("codemirror/addon/edit/matchbrackets.js"),
    import("codemirror/addon/edit/closebrackets.js"),
    import("codemirror/addon/fold/brace-fold.js"),
    import("codemirror/addon/fold/foldgutter.js"),
    import("codemirror/addon/lint/lint.js"),
    import("codemirror/addon/search/searchcursor.js"),
    import("codemirror/addon/search/jump-to-line.js"),
    import("codemirror/addon/dialog/dialog.js"),
    // @ts-expect-error
    import("codemirror/keymap/sublime.js"),
    ...addons
  ]);
  return CodeMirror;
}
export {
  DEFAULT_EDITOR_THEME,
  DEFAULT_KEY_MAP,
  commonKeys,
  importCodeMirror
};
//# sourceMappingURL=common.js.map
