import { isNonNullType, isListType } from "graphql";
import { markdown } from "../markdown.js";
import { DOC_EXPLORER_PLUGIN } from "../plugin.js";
import { importCodeMirror } from "./common.js";
function onHasCompletion(_cm, data, schema, explorer, plugin, callback) {
  void importCodeMirror([], {
    useCommonAddons: false
  }).then((CodeMirror) => {
    let information;
    let fieldName;
    let typeNamePill;
    let typeNamePrefix;
    let typeName;
    let typeNameSuffix;
    let description;
    let deprecation;
    let deprecationReason;
    CodeMirror.on(
      data,
      "select",
      // @ts-expect-error
      (ctx, el) => {
        if (!information) {
          const hintsUl = el.parentNode;
          information = document.createElement("div");
          information.className = "CodeMirror-hint-information";
          hintsUl.append(information);
          const header = document.createElement("header");
          header.className = "CodeMirror-hint-information-header";
          information.append(header);
          fieldName = document.createElement("span");
          fieldName.className = "CodeMirror-hint-information-field-name";
          header.append(fieldName);
          typeNamePill = document.createElement("span");
          typeNamePill.className = "CodeMirror-hint-information-type-name-pill";
          header.append(typeNamePill);
          typeNamePrefix = document.createElement("span");
          typeNamePill.append(typeNamePrefix);
          typeName = document.createElement("a");
          typeName.className = "CodeMirror-hint-information-type-name";
          typeName.href = "javascript:void 0";
          typeName.addEventListener("click", onClickHintInformation);
          typeNamePill.append(typeName);
          typeNameSuffix = document.createElement("span");
          typeNamePill.append(typeNameSuffix);
          description = document.createElement("div");
          description.className = "CodeMirror-hint-information-description";
          information.append(description);
          deprecation = document.createElement("div");
          deprecation.className = "CodeMirror-hint-information-deprecation";
          information.append(deprecation);
          const deprecationLabel = document.createElement("span");
          deprecationLabel.className = "CodeMirror-hint-information-deprecation-label";
          deprecationLabel.textContent = "Deprecated";
          deprecation.append(deprecationLabel);
          deprecationReason = document.createElement("div");
          deprecationReason.className = "CodeMirror-hint-information-deprecation-reason";
          deprecation.append(deprecationReason);
          const defaultInformationPadding = parseInt(window.getComputedStyle(information).paddingBottom.replace(/px$/, ""), 10) || 0;
          const defaultInformationMaxHeight = parseInt(window.getComputedStyle(information).maxHeight.replace(/px$/, ""), 10) || 0;
          const handleScroll = () => {
            if (information) {
              information.style.paddingTop = hintsUl.scrollTop + defaultInformationPadding + "px";
              information.style.maxHeight = hintsUl.scrollTop + defaultInformationMaxHeight + "px";
            }
          };
          hintsUl.addEventListener("scroll", handleScroll);
          let onRemoveFn;
          hintsUl.addEventListener("DOMNodeRemoved", onRemoveFn = (event) => {
            if (event.target !== hintsUl) {
              return;
            }
            hintsUl.removeEventListener("scroll", handleScroll);
            hintsUl.removeEventListener("DOMNodeRemoved", onRemoveFn);
            if (information) {
              information.removeEventListener("click", onClickHintInformation);
            }
            information = null;
            fieldName = null;
            typeNamePill = null;
            typeNamePrefix = null;
            typeName = null;
            typeNameSuffix = null;
            description = null;
            deprecation = null;
            deprecationReason = null;
            onRemoveFn = null;
          });
        }
        if (fieldName) {
          fieldName.textContent = ctx.text;
        }
        if (typeNamePill && typeNamePrefix && typeName && typeNameSuffix) {
          if (ctx.type) {
            typeNamePill.style.display = "inline";
            const renderType = (type) => {
              if (isNonNullType(type)) {
                typeNameSuffix.textContent = "!" + typeNameSuffix.textContent;
                renderType(type.ofType);
              } else if (isListType(type)) {
                typeNamePrefix.textContent += "[";
                typeNameSuffix.textContent = "]" + typeNameSuffix.textContent;
                renderType(type.ofType);
              } else {
                typeName.textContent = type.name;
              }
            };
            typeNamePrefix.textContent = "";
            typeNameSuffix.textContent = "";
            renderType(ctx.type);
          } else {
            typeNamePrefix.textContent = "";
            typeName.textContent = "";
            typeNameSuffix.textContent = "";
            typeNamePill.style.display = "none";
          }
        }
        if (description) {
          if (ctx.description) {
            description.style.display = "block";
            description.innerHTML = markdown.render(ctx.description);
          } else {
            description.style.display = "none";
            description.innerHTML = "";
          }
        }
        if (deprecation && deprecationReason) {
          if (ctx.deprecationReason) {
            deprecation.style.display = "block";
            deprecationReason.innerHTML = markdown.render(ctx.deprecationReason);
          } else {
            deprecation.style.display = "none";
            deprecationReason.innerHTML = "";
          }
        }
      }
    );
  });
  function onClickHintInformation(event) {
    if (!schema || !explorer || !plugin || !(event.currentTarget instanceof HTMLElement)) {
      return;
    }
    const typeName = event.currentTarget.textContent || "";
    const type = schema.getType(typeName);
    if (type) {
      plugin.setVisiblePlugin(DOC_EXPLORER_PLUGIN);
      explorer.push({
        name: type.name,
        def: type
      });
      callback == null ? void 0 : callback(type);
    }
  }
}
export {
  onHasCompletion
};
//# sourceMappingURL=completion.js.map
