import { jsxs, jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useState, useRef, useEffect } from "react";
function ImagePreview(props) {
  var _a;
  const $ = c(14);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      width: null,
      height: null
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const [dimensions, setDimensions] = useState(t0);
  const [mime, setMime] = useState(null);
  const ref = useRef(null);
  const src = (_a = tokenToURL(props.token)) == null ? void 0 : _a.href;
  let t1;
  let t2;
  if ($[1] !== src) {
    t1 = () => {
      if (!ref.current) {
        return;
      }
      if (!src) {
        setDimensions({
          width: null,
          height: null
        });
        setMime(null);
        return;
      }
      fetch(src, {
        method: "HEAD"
      }).then((response) => {
        setMime(response.headers.get("Content-Type"));
      }).catch(() => {
        setMime(null);
      });
    };
    t2 = [src];
    $[1] = src;
    $[2] = t1;
    $[3] = t2;
  } else {
    t1 = $[2];
    t2 = $[3];
  }
  useEffect(t1, t2);
  let t3;
  if ($[4] !== dimensions.height || $[5] !== dimensions.width || $[6] !== mime) {
    t3 = dimensions.width !== null && dimensions.height !== null ? /* @__PURE__ */ jsxs("div", { children: [
      dimensions.width,
      "x",
      dimensions.height,
      mime === null ? null : " " + mime
    ] }) : null;
    $[4] = dimensions.height;
    $[5] = dimensions.width;
    $[6] = mime;
    $[7] = t3;
  } else {
    t3 = $[7];
  }
  const dims = t3;
  let t4;
  if ($[8] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = () => {
      var _a2, _b;
      setDimensions({
        width: ((_a2 = ref.current) == null ? void 0 : _a2.naturalWidth) ?? null,
        height: ((_b = ref.current) == null ? void 0 : _b.naturalHeight) ?? null
      });
    };
    $[8] = t4;
  } else {
    t4 = $[8];
  }
  let t5;
  if ($[9] !== src) {
    t5 = /* @__PURE__ */ jsx("img", { onLoad: t4, ref, src });
    $[9] = src;
    $[10] = t5;
  } else {
    t5 = $[10];
  }
  let t6;
  if ($[11] !== dims || $[12] !== t5) {
    t6 = /* @__PURE__ */ jsxs("div", { children: [
      t5,
      dims
    ] });
    $[11] = dims;
    $[12] = t5;
    $[13] = t6;
  } else {
    t6 = $[13];
  }
  return t6;
}
ImagePreview.shouldRender = function shouldRender(token) {
  const url = tokenToURL(token);
  return url ? isImageURL(url) : false;
};
function tokenToURL(token) {
  if (token.type !== "string") {
    return;
  }
  const value = token.string.slice(1).slice(0, -1).trim();
  try {
    return new URL(value, location.protocol + "//" + location.host);
  } catch {
  }
}
function isImageURL(url) {
  return /\.(bmp|gif|jpe?g|png|svg|webp)$/.test(url.pathname);
}
export {
  ImagePreview
};
//# sourceMappingURL=image-preview.js.map
