import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { visit, parse } from "graphql";
import { useState, useRef, useEffect } from "react";
import { useStorageContext } from "../storage.js";
import { createNullableContext, createContextHook } from "../utility/context.js";
import { STORAGE_KEY as STORAGE_KEY$1 } from "./header-editor.js";
import { useSynchronizeValue } from "./hooks.js";
import { STORAGE_KEY_QUERY } from "./query-editor.js";
import { useStoreTabs, useSynchronizeActiveTabValues, useSetEditorValues, getDefaultTabState, serializeTabState, STORAGE_KEY as STORAGE_KEY$2, clearHeadersFromTabs, createTab, setPropertiesInActiveTab } from "./tabs.js";
import { STORAGE_KEY } from "./variable-editor.js";
const EditorContext = createNullableContext("EditorContext");
function EditorContextProvider(props) {
  const $ = c(89);
  const storage = useStorageContext();
  const [headerEditor, setHeaderEditor] = useState(null);
  const [queryEditor, setQueryEditor] = useState(null);
  const [responseEditor, setResponseEditor] = useState(null);
  const [variableEditor, setVariableEditor] = useState(null);
  let t0;
  if ($[0] !== props.shouldPersistHeaders || $[1] !== storage) {
    t0 = () => {
      const isStored = (storage == null ? void 0 : storage.get(PERSIST_HEADERS_STORAGE_KEY)) !== null;
      return props.shouldPersistHeaders !== false && isStored ? (storage == null ? void 0 : storage.get(PERSIST_HEADERS_STORAGE_KEY)) === "true" : Boolean(props.shouldPersistHeaders);
    };
    $[0] = props.shouldPersistHeaders;
    $[1] = storage;
    $[2] = t0;
  } else {
    t0 = $[2];
  }
  const [shouldPersistHeaders, setShouldPersistHeadersInternal] = useState(t0);
  useSynchronizeValue(headerEditor, props.headers);
  useSynchronizeValue(queryEditor, props.query);
  useSynchronizeValue(responseEditor, props.response);
  useSynchronizeValue(variableEditor, props.variables);
  let t1;
  if ($[3] !== shouldPersistHeaders || $[4] !== storage) {
    t1 = {
      storage,
      shouldPersistHeaders
    };
    $[3] = shouldPersistHeaders;
    $[4] = storage;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  const storeTabs = useStoreTabs(t1);
  let t2;
  if ($[6] !== props.defaultHeaders || $[7] !== props.defaultQuery || $[8] !== props.defaultTabs || $[9] !== props.headers || $[10] !== props.query || $[11] !== props.response || $[12] !== props.variables || $[13] !== shouldPersistHeaders || $[14] !== storage || $[15] !== storeTabs) {
    t2 = () => {
      const query = props.query ?? (storage == null ? void 0 : storage.get(STORAGE_KEY_QUERY)) ?? null;
      const variables = props.variables ?? (storage == null ? void 0 : storage.get(STORAGE_KEY)) ?? null;
      const headers = props.headers ?? (storage == null ? void 0 : storage.get(STORAGE_KEY$1)) ?? null;
      const response = props.response ?? "";
      const tabState = getDefaultTabState({
        query,
        variables,
        headers,
        defaultTabs: props.defaultTabs,
        defaultQuery: props.defaultQuery || DEFAULT_QUERY,
        defaultHeaders: props.defaultHeaders,
        storage,
        shouldPersistHeaders
      });
      storeTabs(tabState);
      return {
        query: query ?? (tabState.activeTabIndex === 0 ? tabState.tabs[0].query : null) ?? "",
        variables: variables ?? "",
        headers: headers ?? props.defaultHeaders ?? "",
        response,
        tabState
      };
    };
    $[6] = props.defaultHeaders;
    $[7] = props.defaultQuery;
    $[8] = props.defaultTabs;
    $[9] = props.headers;
    $[10] = props.query;
    $[11] = props.response;
    $[12] = props.variables;
    $[13] = shouldPersistHeaders;
    $[14] = storage;
    $[15] = storeTabs;
    $[16] = t2;
  } else {
    t2 = $[16];
  }
  const [initialState] = useState(t2);
  const [tabState_0, setTabState] = useState(initialState.tabState);
  let t3;
  if ($[17] !== headerEditor || $[18] !== storage || $[19] !== tabState_0) {
    t3 = (persist) => {
      if (persist) {
        storage == null ? void 0 : storage.set(STORAGE_KEY$1, (headerEditor == null ? void 0 : headerEditor.getValue()) ?? "");
        const serializedTabs = serializeTabState(tabState_0, true);
        storage == null ? void 0 : storage.set(STORAGE_KEY$2, serializedTabs);
      } else {
        storage == null ? void 0 : storage.set(STORAGE_KEY$1, "");
        clearHeadersFromTabs(storage);
      }
      setShouldPersistHeadersInternal(persist);
      storage == null ? void 0 : storage.set(PERSIST_HEADERS_STORAGE_KEY, persist.toString());
    };
    $[17] = headerEditor;
    $[18] = storage;
    $[19] = tabState_0;
    $[20] = t3;
  } else {
    t3 = $[20];
  }
  const setShouldPersistHeaders = t3;
  const lastShouldPersistHeadersProp = useRef(void 0);
  let t4;
  let t5;
  if ($[21] !== props.shouldPersistHeaders || $[22] !== setShouldPersistHeaders) {
    t4 = () => {
      const propValue = Boolean(props.shouldPersistHeaders);
      if ((lastShouldPersistHeadersProp == null ? void 0 : lastShouldPersistHeadersProp.current) !== propValue) {
        setShouldPersistHeaders(propValue);
        lastShouldPersistHeadersProp.current = propValue;
      }
    };
    t5 = [props.shouldPersistHeaders, setShouldPersistHeaders];
    $[21] = props.shouldPersistHeaders;
    $[22] = setShouldPersistHeaders;
    $[23] = t4;
    $[24] = t5;
  } else {
    t4 = $[23];
    t5 = $[24];
  }
  useEffect(t4, t5);
  let t6;
  if ($[25] !== headerEditor || $[26] !== queryEditor || $[27] !== responseEditor || $[28] !== variableEditor) {
    t6 = {
      queryEditor,
      variableEditor,
      headerEditor,
      responseEditor
    };
    $[25] = headerEditor;
    $[26] = queryEditor;
    $[27] = responseEditor;
    $[28] = variableEditor;
    $[29] = t6;
  } else {
    t6 = $[29];
  }
  const synchronizeActiveTabValues = useSynchronizeActiveTabValues(t6);
  const {
    onTabChange,
    defaultHeaders,
    defaultQuery,
    children
  } = props;
  let t7;
  if ($[30] !== defaultHeaders || $[31] !== headerEditor || $[32] !== queryEditor || $[33] !== responseEditor || $[34] !== variableEditor) {
    t7 = {
      queryEditor,
      variableEditor,
      headerEditor,
      responseEditor,
      defaultHeaders
    };
    $[30] = defaultHeaders;
    $[31] = headerEditor;
    $[32] = queryEditor;
    $[33] = responseEditor;
    $[34] = variableEditor;
    $[35] = t7;
  } else {
    t7 = $[35];
  }
  const setEditorValues = useSetEditorValues(t7);
  let t8;
  if ($[36] !== defaultHeaders || $[37] !== defaultQuery || $[38] !== onTabChange || $[39] !== setEditorValues || $[40] !== storeTabs || $[41] !== synchronizeActiveTabValues) {
    t8 = () => {
      setTabState((current) => {
        const updatedValues = synchronizeActiveTabValues(current);
        const updated = {
          tabs: [...updatedValues.tabs, createTab({
            headers: defaultHeaders,
            query: defaultQuery ?? DEFAULT_QUERY
          })],
          activeTabIndex: updatedValues.tabs.length
        };
        storeTabs(updated);
        setEditorValues(updated.tabs[updated.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated);
        return updated;
      });
    };
    $[36] = defaultHeaders;
    $[37] = defaultQuery;
    $[38] = onTabChange;
    $[39] = setEditorValues;
    $[40] = storeTabs;
    $[41] = synchronizeActiveTabValues;
    $[42] = t8;
  } else {
    t8 = $[42];
  }
  const addTab = t8;
  let t9;
  if ($[43] !== onTabChange || $[44] !== setEditorValues || $[45] !== storeTabs) {
    t9 = (index) => {
      setTabState((current_0) => {
        const updated_0 = {
          ...current_0,
          activeTabIndex: index
        };
        storeTabs(updated_0);
        setEditorValues(updated_0.tabs[updated_0.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated_0);
        return updated_0;
      });
    };
    $[43] = onTabChange;
    $[44] = setEditorValues;
    $[45] = storeTabs;
    $[46] = t9;
  } else {
    t9 = $[46];
  }
  const changeTab = t9;
  let t10;
  if ($[47] !== onTabChange || $[48] !== setEditorValues || $[49] !== storeTabs) {
    t10 = (newOrder) => {
      setTabState((current_1) => {
        const activeTab = current_1.tabs[current_1.activeTabIndex];
        const updated_1 = {
          tabs: newOrder,
          activeTabIndex: newOrder.indexOf(activeTab)
        };
        storeTabs(updated_1);
        setEditorValues(updated_1.tabs[updated_1.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated_1);
        return updated_1;
      });
    };
    $[47] = onTabChange;
    $[48] = setEditorValues;
    $[49] = storeTabs;
    $[50] = t10;
  } else {
    t10 = $[50];
  }
  const moveTab = t10;
  let t11;
  if ($[51] !== onTabChange || $[52] !== setEditorValues || $[53] !== storeTabs) {
    t11 = (index_0) => {
      setTabState((current_2) => {
        const updated_2 = {
          tabs: current_2.tabs.filter((_tab, i) => index_0 !== i),
          activeTabIndex: Math.max(current_2.activeTabIndex - 1, 0)
        };
        storeTabs(updated_2);
        setEditorValues(updated_2.tabs[updated_2.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated_2);
        return updated_2;
      });
    };
    $[51] = onTabChange;
    $[52] = setEditorValues;
    $[53] = storeTabs;
    $[54] = t11;
  } else {
    t11 = $[54];
  }
  const closeTab = t11;
  let t12;
  if ($[55] !== onTabChange || $[56] !== storeTabs) {
    t12 = (partialTab) => {
      setTabState((current_3) => {
        const updated_3 = setPropertiesInActiveTab(current_3, partialTab);
        storeTabs(updated_3);
        onTabChange == null ? void 0 : onTabChange(updated_3);
        return updated_3;
      });
    };
    $[55] = onTabChange;
    $[56] = storeTabs;
    $[57] = t12;
  } else {
    t12 = $[57];
  }
  const updateActiveTabValues = t12;
  const {
    onEditOperationName
  } = props;
  let t13;
  if ($[58] !== onEditOperationName || $[59] !== queryEditor || $[60] !== updateActiveTabValues) {
    t13 = (operationName) => {
      if (!queryEditor) {
        return;
      }
      updateQueryEditor(queryEditor, operationName);
      updateActiveTabValues({
        operationName
      });
      onEditOperationName == null ? void 0 : onEditOperationName(operationName);
    };
    $[58] = onEditOperationName;
    $[59] = queryEditor;
    $[60] = updateActiveTabValues;
    $[61] = t13;
  } else {
    t13 = $[61];
  }
  const setOperationName = t13;
  let t14;
  let map;
  if ($[62] !== props.externalFragments) {
    map = /* @__PURE__ */ new Map();
    if (Array.isArray(props.externalFragments)) {
      for (const fragment of props.externalFragments) {
        map.set(fragment.name.value, fragment);
      }
    } else {
      if (typeof props.externalFragments === "string") {
        visit(parse(props.externalFragments, {}), {
          FragmentDefinition(fragment_0) {
            map.set(fragment_0.name.value, fragment_0);
          }
        });
      } else {
        if (props.externalFragments) {
          throw new Error("The `externalFragments` prop must either be a string that contains the fragment definitions in SDL or a list of FragmentDefinitionNode objects.");
        }
      }
    }
    $[62] = props.externalFragments;
    $[63] = map;
  } else {
    map = $[63];
  }
  t14 = map;
  const externalFragments = t14;
  let t15;
  if ($[64] !== props.validationRules) {
    t15 = props.validationRules || [];
    $[64] = props.validationRules;
    $[65] = t15;
  } else {
    t15 = $[65];
  }
  const validationRules = t15;
  let t16;
  if ($[66] !== addTab || $[67] !== changeTab || $[68] !== closeTab || $[69] !== externalFragments || $[70] !== headerEditor || $[71] !== initialState.headers || $[72] !== initialState.query || $[73] !== initialState.response || $[74] !== initialState.variables || $[75] !== moveTab || $[76] !== queryEditor || $[77] !== responseEditor || $[78] !== setOperationName || $[79] !== setShouldPersistHeaders || $[80] !== shouldPersistHeaders || $[81] !== tabState_0 || $[82] !== updateActiveTabValues || $[83] !== validationRules || $[84] !== variableEditor) {
    t16 = {
      ...tabState_0,
      addTab,
      changeTab,
      moveTab,
      closeTab,
      updateActiveTabValues,
      headerEditor,
      queryEditor,
      responseEditor,
      variableEditor,
      setHeaderEditor,
      setQueryEditor,
      setResponseEditor,
      setVariableEditor,
      setOperationName,
      initialQuery: initialState.query,
      initialVariables: initialState.variables,
      initialHeaders: initialState.headers,
      initialResponse: initialState.response,
      externalFragments,
      validationRules,
      shouldPersistHeaders,
      setShouldPersistHeaders
    };
    $[66] = addTab;
    $[67] = changeTab;
    $[68] = closeTab;
    $[69] = externalFragments;
    $[70] = headerEditor;
    $[71] = initialState.headers;
    $[72] = initialState.query;
    $[73] = initialState.response;
    $[74] = initialState.variables;
    $[75] = moveTab;
    $[76] = queryEditor;
    $[77] = responseEditor;
    $[78] = setOperationName;
    $[79] = setShouldPersistHeaders;
    $[80] = shouldPersistHeaders;
    $[81] = tabState_0;
    $[82] = updateActiveTabValues;
    $[83] = validationRules;
    $[84] = variableEditor;
    $[85] = t16;
  } else {
    t16 = $[85];
  }
  const value = t16;
  let t17;
  if ($[86] !== children || $[87] !== value) {
    t17 = /* @__PURE__ */ jsx(EditorContext.Provider, { value, children });
    $[86] = children;
    $[87] = value;
    $[88] = t17;
  } else {
    t17 = $[88];
  }
  return t17;
}
function updateQueryEditor(queryEditor, operationName) {
  queryEditor.operationName = operationName;
}
const useEditorContext = createContextHook(EditorContext);
const PERSIST_HEADERS_STORAGE_KEY = "shouldPersistHeaders";
const DEFAULT_QUERY = `# Welcome to GraphiQL
#
# GraphiQL is an in-browser tool for writing, validating, and
# testing GraphQL queries.
#
# Type queries into this side of the screen, and you will see intelligent
# typeaheads aware of the current GraphQL type schema and live syntax and
# validation errors highlighted within the text.
#
# GraphQL queries typically start with a "{" character. Lines that start
# with a # are ignored.
#
# An example GraphQL query might look like:
#
#     {
#       field(arg: "value") {
#         subField
#       }
#     }
#
# Keyboard shortcuts:
#
#   Prettify query:  Shift-Ctrl-P (or press the prettify button)
#
#  Merge fragments:  Shift-Ctrl-M (or press the merge button)
#
#        Run Query:  Ctrl-Enter (or press the play button)
#
#    Auto Complete:  Ctrl-Space (or just start typing)
#

`;
export {
  DEFAULT_QUERY,
  EditorContext,
  EditorContextProvider,
  useEditorContext
};
//# sourceMappingURL=context.js.map
