import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { formatError } from "@graphiql/toolkit";
import { useRef, useEffect } from "react";
import { createRoot } from "react-dom/client";
import { useSchemaContext } from "../schema.js";
import { DEFAULT_EDITOR_THEME, commonKeys, DEFAULT_KEY_MAP, importCodeMirror } from "./common.js";
import { useEditorContext } from "./context.js";
import { useSynchronizeOption } from "./hooks.js";
import { ImagePreview } from "./components/image-preview.js";
function importCodeMirrorImports() {
  return importCodeMirror([
    import("codemirror/addon/fold/foldgutter.js"),
    import("codemirror/addon/fold/brace-fold.js"),
    import("codemirror/addon/dialog/dialog.js"),
    import("codemirror/addon/search/search.js"),
    import("codemirror/addon/search/searchcursor.js"),
    import("codemirror/addon/search/jump-to-line.js"),
    // @ts-expect-error
    import("codemirror/keymap/sublime.js"),
    import("codemirror-graphql/esm/results/mode.js"),
    import("codemirror-graphql/esm/utils/info-addon.js")
  ], {
    useCommonAddons: false
  });
}
const _useResponseEditor = useResponseEditor;
function useResponseEditor(t0, caller) {
  const $ = c(19);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    responseTooltip,
    editorTheme: t2,
    keyMap: t3
  } = t1;
  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;
  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;
  const t4 = caller || _useResponseEditor;
  let t5;
  if ($[2] !== t4) {
    t5 = {
      nonNull: true,
      caller: t4
    };
    $[2] = t4;
    $[3] = t5;
  } else {
    t5 = $[3];
  }
  const {
    fetchError,
    validationErrors
  } = useSchemaContext(t5);
  const t6 = caller || _useResponseEditor;
  let t7;
  if ($[4] !== t6) {
    t7 = {
      nonNull: true,
      caller: t6
    };
    $[4] = t6;
    $[5] = t7;
  } else {
    t7 = $[5];
  }
  const {
    initialResponse,
    responseEditor,
    setResponseEditor
  } = useEditorContext(t7);
  const ref = useRef(null);
  const responseTooltipRef = useRef(responseTooltip);
  let t8;
  let t9;
  if ($[6] !== responseTooltip) {
    t8 = () => {
      responseTooltipRef.current = responseTooltip;
    };
    t9 = [responseTooltip];
    $[6] = responseTooltip;
    $[7] = t8;
    $[8] = t9;
  } else {
    t8 = $[7];
    t9 = $[8];
  }
  useEffect(t8, t9);
  let t10;
  let t11;
  if ($[9] !== editorTheme || $[10] !== initialResponse || $[11] !== setResponseEditor) {
    t10 = () => {
      let isActive;
      isActive = true;
      importCodeMirrorImports().then((CodeMirror) => {
        if (!isActive) {
          return;
        }
        const tooltipContainer = document.createElement("div");
        const tooltipRoot = createRoot(tooltipContainer);
        CodeMirror.registerHelper("info", "graphql-results", (token, _options, _cm, pos) => {
          const ResponseTooltip = responseTooltipRef.current;
          const infoElements = [ResponseTooltip && /* @__PURE__ */ jsx(ResponseTooltip, { pos, token }), ImagePreview.shouldRender(token) && /* @__PURE__ */ jsx(ImagePreview, { token }, "image-preview")].filter(_temp);
          if (infoElements.length) {
            tooltipRoot.render(infoElements);
            return tooltipContainer;
          }
          tooltipRoot.unmount();
        });
        const container = ref.current;
        if (!container) {
          return;
        }
        const newEditor = CodeMirror(container, {
          value: initialResponse,
          lineWrapping: true,
          readOnly: true,
          theme: editorTheme,
          mode: "graphql-results",
          foldGutter: true,
          gutters: ["CodeMirror-foldgutter"],
          info: true,
          extraKeys: commonKeys
        });
        setResponseEditor(newEditor);
      });
      return () => {
        isActive = false;
      };
    };
    t11 = [editorTheme, initialResponse, setResponseEditor];
    $[9] = editorTheme;
    $[10] = initialResponse;
    $[11] = setResponseEditor;
    $[12] = t10;
    $[13] = t11;
  } else {
    t10 = $[12];
    t11 = $[13];
  }
  useEffect(t10, t11);
  useSynchronizeOption(responseEditor, "keyMap", keyMap);
  let t12;
  let t13;
  if ($[14] !== fetchError || $[15] !== responseEditor || $[16] !== validationErrors) {
    t12 = () => {
      if (fetchError) {
        responseEditor == null ? void 0 : responseEditor.setValue(fetchError);
      }
      if (validationErrors.length) {
        responseEditor == null ? void 0 : responseEditor.setValue(formatError(validationErrors));
      }
    };
    t13 = [responseEditor, fetchError, validationErrors];
    $[14] = fetchError;
    $[15] = responseEditor;
    $[16] = validationErrors;
    $[17] = t12;
    $[18] = t13;
  } else {
    t12 = $[17];
    t13 = $[18];
  }
  useEffect(t12, t13);
  return ref;
}
function _temp(v) {
  return Boolean(v);
}
export {
  useResponseEditor
};
//# sourceMappingURL=response-editor.js.map
