import { jsx, jsxs } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { DefaultValue } from "./default-value.js";
import { TypeLink } from "./type-link.js";
/* empty css             */
import { MarkdownContent } from "../../ui/markdown.js";
function Argument(t0) {
  const $ = c(19);
  const {
    arg,
    showDefaultValue,
    inline
  } = t0;
  let t1;
  if ($[0] !== arg.name) {
    t1 = /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-argument-name", children: arg.name });
    $[0] = arg.name;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] !== arg.type) {
    t2 = /* @__PURE__ */ jsx(TypeLink, { type: arg.type });
    $[2] = arg.type;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  let t3;
  if ($[4] !== arg || $[5] !== showDefaultValue) {
    t3 = showDefaultValue !== false && /* @__PURE__ */ jsx(DefaultValue, { field: arg });
    $[4] = arg;
    $[5] = showDefaultValue;
    $[6] = t3;
  } else {
    t3 = $[6];
  }
  let t4;
  if ($[7] !== t1 || $[8] !== t2 || $[9] !== t3) {
    t4 = /* @__PURE__ */ jsxs("span", { children: [
      t1,
      ": ",
      t2,
      t3
    ] });
    $[7] = t1;
    $[8] = t2;
    $[9] = t3;
    $[10] = t4;
  } else {
    t4 = $[10];
  }
  const definition = t4;
  if (inline) {
    return definition;
  }
  let t5;
  if ($[11] !== arg.description) {
    t5 = arg.description ? /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: arg.description }) : null;
    $[11] = arg.description;
    $[12] = t5;
  } else {
    t5 = $[12];
  }
  let t6;
  if ($[13] !== arg.deprecationReason) {
    t6 = arg.deprecationReason ? /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-argument-deprecation", children: [
      /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-argument-deprecation-label", children: "Deprecated" }),
      /* @__PURE__ */ jsx(MarkdownContent, { type: "deprecation", children: arg.deprecationReason })
    ] }) : null;
    $[13] = arg.deprecationReason;
    $[14] = t6;
  } else {
    t6 = $[14];
  }
  let t7;
  if ($[15] !== definition || $[16] !== t5 || $[17] !== t6) {
    t7 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-argument", children: [
      definition,
      t5,
      t6
    ] });
    $[15] = definition;
    $[16] = t5;
    $[17] = t6;
    $[18] = t7;
  } else {
    t7 = $[18];
  }
  return t7;
}
export {
  Argument
};
//# sourceMappingURL=argument.js.map
