import { jsxs, jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { isType } from "graphql";
import { ChevronLeftIcon } from "../../icons/index.js";
import { useSchemaContext } from "../../schema.js";
import { useExplorerContext } from "../context.js";
import { FieldDocumentation } from "./field-documentation.js";
import { SchemaDocumentation } from "./schema-documentation.js";
import { Search } from "./search.js";
import { TypeDocumentation } from "./type-documentation.js";
/* empty css                 */
import { Spinner } from "../../ui/spinner.js";
function DocExplorer() {
  const $ = c(40);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: DocExplorer
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    fetchError,
    isFetching,
    schema,
    validationErrors
  } = useSchemaContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: DocExplorer
    };
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    explorerNavStack,
    pop
  } = useExplorerContext(t1);
  let content;
  let navItem;
  if ($[2] !== explorerNavStack || $[3] !== fetchError || $[4] !== isFetching || $[5] !== schema || $[6] !== validationErrors) {
    navItem = explorerNavStack.at(-1);
    content = null;
    if (fetchError) {
      let t22;
      if ($[9] === Symbol.for("react.memo_cache_sentinel")) {
        t22 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-error", children: "Error fetching schema" });
        $[9] = t22;
      } else {
        t22 = $[9];
      }
      content = t22;
    } else {
      if (validationErrors.length > 0) {
        let t22;
        if ($[10] !== validationErrors[0].message) {
          t22 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-error", children: [
            "Schema is invalid: ",
            validationErrors[0].message
          ] });
          $[10] = validationErrors[0].message;
          $[11] = t22;
        } else {
          t22 = $[11];
        }
        content = t22;
      } else {
        if (isFetching) {
          let t22;
          if ($[12] === Symbol.for("react.memo_cache_sentinel")) {
            t22 = /* @__PURE__ */ jsx(Spinner, {});
            $[12] = t22;
          } else {
            t22 = $[12];
          }
          content = t22;
        } else {
          if (!schema) {
            let t22;
            if ($[13] === Symbol.for("react.memo_cache_sentinel")) {
              t22 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-error", children: "No GraphQL schema available" });
              $[13] = t22;
            } else {
              t22 = $[13];
            }
            content = t22;
          } else {
            if (explorerNavStack.length === 1) {
              let t22;
              if ($[14] !== schema) {
                t22 = /* @__PURE__ */ jsx(SchemaDocumentation, { schema });
                $[14] = schema;
                $[15] = t22;
              } else {
                t22 = $[15];
              }
              content = t22;
            } else {
              if (isType(navItem.def)) {
                let t22;
                if ($[16] !== navItem.def) {
                  t22 = /* @__PURE__ */ jsx(TypeDocumentation, { type: navItem.def });
                  $[16] = navItem.def;
                  $[17] = t22;
                } else {
                  t22 = $[17];
                }
                content = t22;
              } else {
                if (navItem.def) {
                  let t22;
                  if ($[18] !== navItem.def) {
                    t22 = /* @__PURE__ */ jsx(FieldDocumentation, { field: navItem.def });
                    $[18] = navItem.def;
                    $[19] = t22;
                  } else {
                    t22 = $[19];
                  }
                  content = t22;
                }
              }
            }
          }
        }
      }
    }
    $[2] = explorerNavStack;
    $[3] = fetchError;
    $[4] = isFetching;
    $[5] = schema;
    $[6] = validationErrors;
    $[7] = content;
    $[8] = navItem;
  } else {
    content = $[7];
    navItem = $[8];
  }
  let prevName;
  if (explorerNavStack.length > 1) {
    let t22;
    if ($[20] !== explorerNavStack) {
      t22 = explorerNavStack.at(-2);
      $[20] = explorerNavStack;
      $[21] = t22;
    } else {
      t22 = $[21];
    }
    prevName = t22.name;
  }
  let t2;
  if ($[22] !== pop || $[23] !== prevName) {
    t2 = prevName && /* @__PURE__ */ jsxs("a", { href: "#", className: "graphiql-doc-explorer-back", onClick: (event) => {
      event.preventDefault();
      pop();
    }, "aria-label": `Go back to ${prevName}`, children: [
      /* @__PURE__ */ jsx(ChevronLeftIcon, {}),
      prevName
    ] });
    $[22] = pop;
    $[23] = prevName;
    $[24] = t2;
  } else {
    t2 = $[24];
  }
  let t3;
  if ($[25] !== navItem.name) {
    t3 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-title", children: navItem.name });
    $[25] = navItem.name;
    $[26] = t3;
  } else {
    t3 = $[26];
  }
  let t4;
  if ($[27] !== t2 || $[28] !== t3) {
    t4 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-header-content", children: [
      t2,
      t3
    ] });
    $[27] = t2;
    $[28] = t3;
    $[29] = t4;
  } else {
    t4 = $[29];
  }
  let t5;
  if ($[30] !== navItem.name) {
    t5 = /* @__PURE__ */ jsx(Search, {}, navItem.name);
    $[30] = navItem.name;
    $[31] = t5;
  } else {
    t5 = $[31];
  }
  let t6;
  if ($[32] !== t4 || $[33] !== t5) {
    t6 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-header", children: [
      t4,
      t5
    ] });
    $[32] = t4;
    $[33] = t5;
    $[34] = t6;
  } else {
    t6 = $[34];
  }
  let t7;
  if ($[35] !== content) {
    t7 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-content", children: content });
    $[35] = content;
    $[36] = t7;
  } else {
    t7 = $[36];
  }
  let t8;
  if ($[37] !== t6 || $[38] !== t7) {
    t8 = /* @__PURE__ */ jsxs("section", { className: "graphiql-doc-explorer", "aria-label": "Documentation Explorer", children: [
      t6,
      t7
    ] });
    $[37] = t6;
    $[38] = t7;
    $[39] = t8;
  } else {
    t8 = $[39];
  }
  return t8;
}
export {
  DocExplorer
};
//# sourceMappingURL=doc-explorer.js.map
