import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useState } from "react";
import { Argument } from "./argument.js";
import { DeprecationReason } from "./deprecation-reason.js";
import { Directive } from "./directive.js";
import { ExplorerSection } from "./section.js";
import { TypeLink } from "./type-link.js";
import { MarkdownContent } from "../../ui/markdown.js";
import { Button } from "../../ui/button.js";
function FieldDocumentation(props) {
  const $ = c(15);
  let t0;
  if ($[0] !== props.field.description) {
    t0 = props.field.description ? /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: props.field.description }) : null;
    $[0] = props.field.description;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== props.field.deprecationReason) {
    t1 = /* @__PURE__ */ jsx(DeprecationReason, { preview: false, children: props.field.deprecationReason });
    $[2] = props.field.deprecationReason;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  let t2;
  if ($[4] !== props.field.type) {
    t2 = /* @__PURE__ */ jsx(ExplorerSection, { title: "Type", children: /* @__PURE__ */ jsx(TypeLink, { type: props.field.type }) });
    $[4] = props.field.type;
    $[5] = t2;
  } else {
    t2 = $[5];
  }
  let t3;
  let t4;
  if ($[6] !== props.field) {
    t3 = /* @__PURE__ */ jsx(Arguments, { field: props.field });
    t4 = /* @__PURE__ */ jsx(Directives, { field: props.field });
    $[6] = props.field;
    $[7] = t3;
    $[8] = t4;
  } else {
    t3 = $[7];
    t4 = $[8];
  }
  let t5;
  if ($[9] !== t0 || $[10] !== t1 || $[11] !== t2 || $[12] !== t3 || $[13] !== t4) {
    t5 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t0,
      t1,
      t2,
      t3,
      t4
    ] });
    $[9] = t0;
    $[10] = t1;
    $[11] = t2;
    $[12] = t3;
    $[13] = t4;
    $[14] = t5;
  } else {
    t5 = $[14];
  }
  return t5;
}
function Arguments(t0) {
  const $ = c(12);
  const {
    field
  } = t0;
  const [showDeprecated, setShowDeprecated] = useState(false);
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = () => {
      setShowDeprecated(true);
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const handleShowDeprecated = t1;
  if (!("args" in field)) {
    return null;
  }
  let args;
  let deprecatedArgs;
  let t2;
  if ($[1] !== field.args) {
    args = [];
    deprecatedArgs = [];
    for (const argument of field.args) {
      if (argument.deprecationReason) {
        deprecatedArgs.push(argument);
      } else {
        args.push(argument);
      }
    }
    t2 = args.length > 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Arguments", children: args.map(_temp) }) : null;
    $[1] = field.args;
    $[2] = args;
    $[3] = deprecatedArgs;
    $[4] = t2;
  } else {
    args = $[2];
    deprecatedArgs = $[3];
    t2 = $[4];
  }
  let t3;
  if ($[5] !== args.length || $[6] !== deprecatedArgs || $[7] !== showDeprecated) {
    t3 = deprecatedArgs.length > 0 ? showDeprecated || args.length === 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Deprecated Arguments", children: deprecatedArgs.map(_temp2) }) : /* @__PURE__ */ jsx(Button, { type: "button", onClick: handleShowDeprecated, children: "Show Deprecated Arguments" }) : null;
    $[5] = args.length;
    $[6] = deprecatedArgs;
    $[7] = showDeprecated;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  let t4;
  if ($[9] !== t2 || $[10] !== t3) {
    t4 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t2,
      t3
    ] });
    $[9] = t2;
    $[10] = t3;
    $[11] = t4;
  } else {
    t4 = $[11];
  }
  return t4;
}
function _temp2(arg_0) {
  return /* @__PURE__ */ jsx(Argument, { arg: arg_0 }, arg_0.name);
}
function _temp(arg) {
  return /* @__PURE__ */ jsx(Argument, { arg }, arg.name);
}
function Directives(t0) {
  var _a, _b, _c;
  const $ = c(6);
  const {
    field
  } = t0;
  let t1;
  if ($[0] !== ((_a = field.astNode) == null ? void 0 : _a.directives)) {
    t1 = ((_b = field.astNode) == null ? void 0 : _b.directives) || [];
    $[0] = (_c = field.astNode) == null ? void 0 : _c.directives;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const directives = t1;
  if (!directives || directives.length === 0) {
    return null;
  }
  let t2;
  if ($[2] !== directives) {
    t2 = directives.map(_temp3);
    $[2] = directives;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  let t3;
  if ($[4] !== t2) {
    t3 = /* @__PURE__ */ jsx(ExplorerSection, { title: "Directives", children: t2 });
    $[4] = t2;
    $[5] = t3;
  } else {
    t3 = $[5];
  }
  return t3;
}
function _temp3(directive) {
  return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(Directive, { directive }) }, directive.name.value);
}
export {
  FieldDocumentation
};
//# sourceMappingURL=field-documentation.js.map
