import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { ExplorerSection } from "./section.js";
import { TypeLink } from "./type-link.js";
/* empty css                         */
import { MarkdownContent } from "../../ui/markdown.js";
function SchemaDocumentation(props) {
  var _a, _b, _c, _d;
  const $ = c(39);
  let t0;
  if ($[0] !== props.schema) {
    t0 = props.schema.getQueryType();
    $[0] = props.schema;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  const queryType = t0;
  let t1;
  if ($[2] !== props.schema) {
    t1 = (_b = (_a = props.schema).getMutationType) == null ? void 0 : _b.call(_a);
    $[2] = props.schema;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  const mutationType = t1;
  let t2;
  if ($[4] !== props.schema) {
    t2 = (_d = (_c = props.schema).getSubscriptionType) == null ? void 0 : _d.call(_c);
    $[4] = props.schema;
    $[5] = t2;
  } else {
    t2 = $[5];
  }
  const subscriptionType = t2;
  let T0;
  let t3;
  let t4;
  let t5;
  let t6;
  if ($[6] !== mutationType || $[7] !== props.schema || $[8] !== queryType || $[9] !== subscriptionType) {
    const typeMap = props.schema.getTypeMap();
    const t72 = queryType == null ? void 0 : queryType.name;
    const t82 = mutationType == null ? void 0 : mutationType.name;
    const t9 = subscriptionType == null ? void 0 : subscriptionType.name;
    let t10;
    if ($[15] !== t72 || $[16] !== t82 || $[17] !== t9) {
      t10 = [t72, t82, t9];
      $[15] = t72;
      $[16] = t82;
      $[17] = t9;
      $[18] = t10;
    } else {
      t10 = $[18];
    }
    const ignoreTypesInAllSchema = t10;
    const t11 = props.schema.description || "A GraphQL schema provides a root type for each kind of operation.";
    if ($[19] !== t11) {
      t5 = /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: t11 });
      $[19] = t11;
      $[20] = t5;
    } else {
      t5 = $[20];
    }
    let t12;
    if ($[21] !== queryType) {
      t12 = queryType ? /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-root-type", children: "query" }),
        ": ",
        /* @__PURE__ */ jsx(TypeLink, { type: queryType })
      ] }) : null;
      $[21] = queryType;
      $[22] = t12;
    } else {
      t12 = $[22];
    }
    let t13;
    if ($[23] !== mutationType) {
      t13 = mutationType && /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-root-type", children: "mutation" }),
        ": ",
        /* @__PURE__ */ jsx(TypeLink, { type: mutationType })
      ] });
      $[23] = mutationType;
      $[24] = t13;
    } else {
      t13 = $[24];
    }
    let t14;
    if ($[25] !== subscriptionType) {
      t14 = subscriptionType && /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("span", { className: "graphiql-doc-explorer-root-type", children: "subscription" }),
        ": ",
        /* @__PURE__ */ jsx(TypeLink, { type: subscriptionType })
      ] });
      $[25] = subscriptionType;
      $[26] = t14;
    } else {
      t14 = $[26];
    }
    if ($[27] !== t12 || $[28] !== t13 || $[29] !== t14) {
      t6 = /* @__PURE__ */ jsxs(ExplorerSection, { title: "Root Types", children: [
        t12,
        t13,
        t14
      ] });
      $[27] = t12;
      $[28] = t13;
      $[29] = t14;
      $[30] = t6;
    } else {
      t6 = $[30];
    }
    T0 = ExplorerSection;
    t3 = "All Schema Types";
    t4 = typeMap && /* @__PURE__ */ jsx("div", { children: Object.values(typeMap).map((type) => {
      if (ignoreTypesInAllSchema.includes(type.name) || type.name.startsWith("__")) {
        return null;
      }
      return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(TypeLink, { type }) }, type.name);
    }) });
    $[6] = mutationType;
    $[7] = props.schema;
    $[8] = queryType;
    $[9] = subscriptionType;
    $[10] = T0;
    $[11] = t3;
    $[12] = t4;
    $[13] = t5;
    $[14] = t6;
  } else {
    T0 = $[10];
    t3 = $[11];
    t4 = $[12];
    t5 = $[13];
    t6 = $[14];
  }
  let t7;
  if ($[31] !== T0 || $[32] !== t3 || $[33] !== t4) {
    t7 = /* @__PURE__ */ jsx(T0, { title: t3, children: t4 });
    $[31] = T0;
    $[32] = t3;
    $[33] = t4;
    $[34] = t7;
  } else {
    t7 = $[34];
  }
  let t8;
  if ($[35] !== t5 || $[36] !== t6 || $[37] !== t7) {
    t8 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t5,
      t6,
      t7
    ] });
    $[35] = t5;
    $[36] = t6;
    $[37] = t7;
    $[38] = t8;
  } else {
    t8 = $[38];
  }
  return t8;
}
export {
  SchemaDocumentation
};
//# sourceMappingURL=schema-documentation.js.map
