import { jsxs, Fragment, jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { isNamedType, isObjectType, isInterfaceType, isInputObjectType, isEnumType, isAbstractType } from "graphql";
import { useState } from "react";
import { useSchemaContext } from "../../schema.js";
import { Argument } from "./argument.js";
import { DefaultValue } from "./default-value.js";
import { DeprecationReason } from "./deprecation-reason.js";
import { FieldLink } from "./field-link.js";
import { ExplorerSection } from "./section.js";
import { TypeLink } from "./type-link.js";
/* empty css                       */
import { MarkdownContent } from "../../ui/markdown.js";
import { Button } from "../../ui/button.js";
function TypeDocumentation(props) {
  const $ = c(2);
  let t0;
  if ($[0] !== props.type) {
    t0 = isNamedType(props.type) ? /* @__PURE__ */ jsxs(Fragment, { children: [
      props.type.description ? /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: props.type.description }) : null,
      /* @__PURE__ */ jsx(ImplementsInterfaces, { type: props.type }),
      /* @__PURE__ */ jsx(Fields, { type: props.type }),
      /* @__PURE__ */ jsx(EnumValues, { type: props.type }),
      /* @__PURE__ */ jsx(PossibleTypes, { type: props.type })
    ] }) : null;
    $[0] = props.type;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
}
function ImplementsInterfaces(t0) {
  const $ = c(5);
  const {
    type
  } = t0;
  if (!isObjectType(type)) {
    return null;
  }
  let t1;
  if ($[0] !== type) {
    t1 = type.getInterfaces();
    $[0] = type;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const interfaces = t1;
  let t2;
  if ($[2] !== interfaces.length || $[3] !== type) {
    t2 = interfaces.length > 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Implements", children: type.getInterfaces().map(_temp) }) : null;
    $[2] = interfaces.length;
    $[3] = type;
    $[4] = t2;
  } else {
    t2 = $[4];
  }
  return t2;
}
function _temp(implementedInterface) {
  return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(TypeLink, { type: implementedInterface }) }, implementedInterface.name);
}
function Fields(t0) {
  const $ = c(12);
  const {
    type
  } = t0;
  const [showDeprecated, setShowDeprecated] = useState(false);
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = () => {
      setShowDeprecated(true);
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const handleShowDeprecated = t1;
  if (!isObjectType(type) && !isInterfaceType(type) && !isInputObjectType(type)) {
    return null;
  }
  let deprecatedFields;
  let fields;
  let t2;
  if ($[1] !== type) {
    const fieldMap = type.getFields();
    fields = [];
    deprecatedFields = [];
    for (const field of Object.keys(fieldMap).map((name) => fieldMap[name])) {
      if (field.deprecationReason) {
        deprecatedFields.push(field);
      } else {
        fields.push(field);
      }
    }
    t2 = fields.length > 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Fields", children: fields.map(_temp2) }) : null;
    $[1] = type;
    $[2] = deprecatedFields;
    $[3] = fields;
    $[4] = t2;
  } else {
    deprecatedFields = $[2];
    fields = $[3];
    t2 = $[4];
  }
  let t3;
  if ($[5] !== deprecatedFields || $[6] !== fields.length || $[7] !== showDeprecated) {
    t3 = deprecatedFields.length > 0 ? showDeprecated || fields.length === 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Deprecated Fields", children: deprecatedFields.map(_temp3) }) : /* @__PURE__ */ jsx(Button, { type: "button", onClick: handleShowDeprecated, children: "Show Deprecated Fields" }) : null;
    $[5] = deprecatedFields;
    $[6] = fields.length;
    $[7] = showDeprecated;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  let t4;
  if ($[9] !== t2 || $[10] !== t3) {
    t4 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t2,
      t3
    ] });
    $[9] = t2;
    $[10] = t3;
    $[11] = t4;
  } else {
    t4 = $[11];
  }
  return t4;
}
function _temp3(field_1) {
  return /* @__PURE__ */ jsx(Field, { field: field_1 }, field_1.name);
}
function _temp2(field_0) {
  return /* @__PURE__ */ jsx(Field, { field: field_0 }, field_0.name);
}
function Field(t0) {
  const $ = c(22);
  const {
    field
  } = t0;
  let t1;
  let t2;
  let t3;
  if ($[0] !== field) {
    const args = "args" in field ? field.args.filter(_temp4) : [];
    t3 = "graphiql-doc-explorer-item";
    t1 = /* @__PURE__ */ jsx(FieldLink, { field });
    t2 = args.length > 0 ? /* @__PURE__ */ jsxs(Fragment, { children: [
      "(",
      /* @__PURE__ */ jsx("span", { children: args.map((arg_0) => args.length === 1 ? /* @__PURE__ */ jsx(Argument, { arg: arg_0, inline: true }, arg_0.name) : /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-argument-multiple", children: /* @__PURE__ */ jsx(Argument, { arg: arg_0, inline: true }) }, arg_0.name)) }),
      ")"
    ] }) : null;
    $[0] = field;
    $[1] = t1;
    $[2] = t2;
    $[3] = t3;
  } else {
    t1 = $[1];
    t2 = $[2];
    t3 = $[3];
  }
  let t4;
  if ($[4] !== field.type) {
    t4 = /* @__PURE__ */ jsx(TypeLink, { type: field.type });
    $[4] = field.type;
    $[5] = t4;
  } else {
    t4 = $[5];
  }
  let t5;
  if ($[6] !== field) {
    t5 = /* @__PURE__ */ jsx(DefaultValue, { field });
    $[6] = field;
    $[7] = t5;
  } else {
    t5 = $[7];
  }
  let t6;
  if ($[8] !== t1 || $[9] !== t2 || $[10] !== t4 || $[11] !== t5) {
    t6 = /* @__PURE__ */ jsxs("div", { children: [
      t1,
      t2,
      ": ",
      t4,
      t5
    ] });
    $[8] = t1;
    $[9] = t2;
    $[10] = t4;
    $[11] = t5;
    $[12] = t6;
  } else {
    t6 = $[12];
  }
  let t7;
  if ($[13] !== field.description) {
    t7 = field.description ? /* @__PURE__ */ jsx(MarkdownContent, { type: "description", onlyShowFirstChild: true, children: field.description }) : null;
    $[13] = field.description;
    $[14] = t7;
  } else {
    t7 = $[14];
  }
  let t8;
  if ($[15] !== field.deprecationReason) {
    t8 = /* @__PURE__ */ jsx(DeprecationReason, { children: field.deprecationReason });
    $[15] = field.deprecationReason;
    $[16] = t8;
  } else {
    t8 = $[16];
  }
  let t9;
  if ($[17] !== t3 || $[18] !== t6 || $[19] !== t7 || $[20] !== t8) {
    t9 = /* @__PURE__ */ jsxs("div", { className: t3, children: [
      t6,
      t7,
      t8
    ] });
    $[17] = t3;
    $[18] = t6;
    $[19] = t7;
    $[20] = t8;
    $[21] = t9;
  } else {
    t9 = $[21];
  }
  return t9;
}
function _temp4(arg) {
  return !arg.deprecationReason;
}
function EnumValues(t0) {
  const $ = c(12);
  const {
    type
  } = t0;
  const [showDeprecated, setShowDeprecated] = useState(false);
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = () => {
      setShowDeprecated(true);
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const handleShowDeprecated = t1;
  if (!isEnumType(type)) {
    return null;
  }
  let deprecatedValues;
  let t2;
  let values;
  if ($[1] !== type) {
    values = [];
    deprecatedValues = [];
    for (const value of type.getValues()) {
      if (value.deprecationReason) {
        deprecatedValues.push(value);
      } else {
        values.push(value);
      }
    }
    t2 = values.length > 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Enum Values", children: values.map(_temp5) }) : null;
    $[1] = type;
    $[2] = deprecatedValues;
    $[3] = t2;
    $[4] = values;
  } else {
    deprecatedValues = $[2];
    t2 = $[3];
    values = $[4];
  }
  let t3;
  if ($[5] !== deprecatedValues || $[6] !== showDeprecated || $[7] !== values.length) {
    t3 = deprecatedValues.length > 0 ? showDeprecated || values.length === 0 ? /* @__PURE__ */ jsx(ExplorerSection, { title: "Deprecated Enum Values", children: deprecatedValues.map(_temp6) }) : /* @__PURE__ */ jsx(Button, { type: "button", onClick: handleShowDeprecated, children: "Show Deprecated Values" }) : null;
    $[5] = deprecatedValues;
    $[6] = showDeprecated;
    $[7] = values.length;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  let t4;
  if ($[9] !== t2 || $[10] !== t3) {
    t4 = /* @__PURE__ */ jsxs(Fragment, { children: [
      t2,
      t3
    ] });
    $[9] = t2;
    $[10] = t3;
    $[11] = t4;
  } else {
    t4 = $[11];
  }
  return t4;
}
function _temp6(value_1) {
  return /* @__PURE__ */ jsx(EnumValue, { value: value_1 }, value_1.name);
}
function _temp5(value_0) {
  return /* @__PURE__ */ jsx(EnumValue, { value: value_0 }, value_0.name);
}
function EnumValue(t0) {
  const $ = c(10);
  const {
    value
  } = t0;
  let t1;
  if ($[0] !== value.name) {
    t1 = /* @__PURE__ */ jsx("div", { className: "graphiql-doc-explorer-enum-value", children: value.name });
    $[0] = value.name;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  let t2;
  if ($[2] !== value.description) {
    t2 = value.description ? /* @__PURE__ */ jsx(MarkdownContent, { type: "description", children: value.description }) : null;
    $[2] = value.description;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  let t3;
  if ($[4] !== value.deprecationReason) {
    t3 = value.deprecationReason ? /* @__PURE__ */ jsx(MarkdownContent, { type: "deprecation", children: value.deprecationReason }) : null;
    $[4] = value.deprecationReason;
    $[5] = t3;
  } else {
    t3 = $[5];
  }
  let t4;
  if ($[6] !== t1 || $[7] !== t2 || $[8] !== t3) {
    t4 = /* @__PURE__ */ jsxs("div", { className: "graphiql-doc-explorer-item", children: [
      t1,
      t2,
      t3
    ] });
    $[6] = t1;
    $[7] = t2;
    $[8] = t3;
    $[9] = t4;
  } else {
    t4 = $[9];
  }
  return t4;
}
function PossibleTypes(t0) {
  const $ = c(7);
  const {
    type
  } = t0;
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const {
    schema
  } = useSchemaContext(t1);
  if (!schema || !isAbstractType(type)) {
    return null;
  }
  const t2 = isInterfaceType(type) ? "Implementations" : "Possible Types";
  let t3;
  if ($[1] !== schema || $[2] !== type) {
    t3 = schema.getPossibleTypes(type).map(_temp7);
    $[1] = schema;
    $[2] = type;
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  let t4;
  if ($[4] !== t2 || $[5] !== t3) {
    t4 = /* @__PURE__ */ jsx(ExplorerSection, { title: t2, children: t3 });
    $[4] = t2;
    $[5] = t3;
    $[6] = t4;
  } else {
    t4 = $[6];
  }
  return t4;
}
function _temp7(possibleType) {
  return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(TypeLink, { type: possibleType }) }, possibleType.name);
}
export {
  TypeDocumentation
};
//# sourceMappingURL=type-documentation.js.map
