import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { isNamedType, isObjectType, isInputObjectType, isScalarType, isEnumType, isInterfaceType, isUnionType } from "graphql";
import { useState, useEffect } from "react";
import { useSchemaContext } from "../schema.js";
import { createNullableContext, createContextHook } from "../utility/context.js";
const initialNavStackItem = {
  name: "Docs"
};
const ExplorerContext = createNullableContext("ExplorerContext");
function ExplorerContextProvider(props) {
  const $ = c(14);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: ExplorerContextProvider
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    schema,
    validationErrors
  } = useSchemaContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = [initialNavStackItem];
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const [navStack, setNavStack] = useState(t1);
  let t2;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = (item) => {
      setNavStack((currentState) => {
        const lastItem = currentState.at(-1);
        return lastItem.def === item.def ? currentState : [...currentState, item];
      });
    };
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const push = t2;
  let t3;
  if ($[3] === Symbol.for("react.memo_cache_sentinel")) {
    t3 = () => {
      setNavStack(_temp);
    };
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const pop = t3;
  let t4;
  if ($[4] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = () => {
      setNavStack(_temp2);
    };
    $[4] = t4;
  } else {
    t4 = $[4];
  }
  const reset = t4;
  let t5;
  let t6;
  if ($[5] !== schema || $[6] !== validationErrors) {
    t5 = () => {
      if (schema == null || validationErrors.length > 0) {
        reset();
      } else {
        setNavStack((oldNavStack) => {
          if (oldNavStack.length === 1) {
            return oldNavStack;
          }
          const newNavStack = [initialNavStackItem];
          let lastEntity = null;
          for (const item_0 of oldNavStack) {
            if (item_0 === initialNavStackItem) {
              continue;
            }
            if (item_0.def) {
              if (isNamedType(item_0.def)) {
                const newType = schema.getType(item_0.def.name);
                if (newType) {
                  newNavStack.push({
                    name: item_0.name,
                    def: newType
                  });
                  lastEntity = newType;
                } else {
                  break;
                }
              } else {
                if (lastEntity === null) {
                  break;
                } else {
                  if (isObjectType(lastEntity) || isInputObjectType(lastEntity)) {
                    const field = lastEntity.getFields()[item_0.name];
                    if (field) {
                      newNavStack.push({
                        name: item_0.name,
                        def: field
                      });
                    } else {
                      break;
                    }
                  } else {
                    if (isScalarType(lastEntity) || isEnumType(lastEntity) || isInterfaceType(lastEntity) || isUnionType(lastEntity)) {
                      break;
                    } else {
                      const field_0 = lastEntity;
                      const arg = field_0.args.find((a) => a.name === item_0.name);
                      if (arg) {
                        newNavStack.push({
                          name: item_0.name,
                          def: field_0
                        });
                      } else {
                        break;
                      }
                    }
                  }
                }
              }
            } else {
              lastEntity = null;
              newNavStack.push(item_0);
            }
          }
          return newNavStack;
        });
      }
    };
    t6 = [schema, validationErrors];
    $[5] = schema;
    $[6] = validationErrors;
    $[7] = t5;
    $[8] = t6;
  } else {
    t5 = $[7];
    t6 = $[8];
  }
  useEffect(t5, t6);
  let t7;
  if ($[9] !== navStack) {
    t7 = {
      explorerNavStack: navStack,
      push,
      pop,
      reset
    };
    $[9] = navStack;
    $[10] = t7;
  } else {
    t7 = $[10];
  }
  const value = t7;
  let t8;
  if ($[11] !== props.children || $[12] !== value) {
    t8 = /* @__PURE__ */ jsx(ExplorerContext.Provider, { value, children: props.children });
    $[11] = props.children;
    $[12] = value;
    $[13] = t8;
  } else {
    t8 = $[13];
  }
  return t8;
}
function _temp2(currentState_1) {
  return currentState_1.length === 1 ? currentState_1 : [initialNavStackItem];
}
function _temp(currentState_0) {
  return currentState_0.length > 1 ? currentState_0.slice(0, -1) : currentState_0;
}
const useExplorerContext = createContextHook(ExplorerContext);
export {
  ExplorerContext,
  ExplorerContextProvider,
  useExplorerContext
};
//# sourceMappingURL=context.js.map
