import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useState, useEffect, useRef } from "react";
import { clsx } from "clsx";
import { CloseIcon, PenIcon, StarFilledIcon, StarIcon, TrashIcon } from "../icons/index.js";
import { useHistoryContext } from "./context.js";
/* empty css          */
import { Button, UnStyledButton } from "../ui/button.js";
import { useEditorContext } from "../editor/context.js";
import { Tooltip } from "../ui/tooltip.js";
function handleDelete(items, deleteFromHistory) {
  for (const item of items) {
    deleteFromHistory(item, true);
  }
}
function History() {
  const $ = c(11);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    items: all,
    deleteFromHistory
  } = useHistoryContext(t0);
  let items;
  items = all.slice().map(_temp).reverse();
  const favorites = items.filter(_temp2);
  if (favorites.length) {
    items = items.filter(_temp3);
  }
  const [clearStatus, setClearStatus] = useState(null);
  let t1;
  let t2;
  if ($[1] !== clearStatus) {
    t1 = () => {
      if (clearStatus) {
        setTimeout(() => {
          setClearStatus(null);
        }, 2e3);
      }
    };
    t2 = [clearStatus];
    $[1] = clearStatus;
    $[2] = t1;
    $[3] = t2;
  } else {
    t1 = $[2];
    t2 = $[3];
  }
  useEffect(t1, t2);
  const handleClearStatus = () => {
    try {
      handleDelete(items, deleteFromHistory);
      setClearStatus("success");
    } catch {
      setClearStatus("error");
    }
  };
  const t3 = "History";
  const t4 = "graphiql-history";
  const t5 = (clearStatus || items.length > 0) && /* @__PURE__ */ jsx(Button, { type: "button", state: clearStatus || void 0, disabled: !items.length, onClick: handleClearStatus, children: {
    success: "Cleared",
    error: "Failed to Clear"
  }[clearStatus] || "Clear" });
  let t6;
  if ($[4] !== t5) {
    t6 = /* @__PURE__ */ jsxs("div", { className: "graphiql-history-header", children: [
      "History",
      t5
    ] });
    $[4] = t5;
    $[5] = t6;
  } else {
    t6 = $[5];
  }
  const t7 = Boolean(favorites.length) && /* @__PURE__ */ jsx("ul", { className: "graphiql-history-items", children: favorites.map(_temp4) });
  const t8 = Boolean(favorites.length) && Boolean(items.length) && /* @__PURE__ */ jsx("div", { className: "graphiql-history-item-spacer" });
  const t9 = Boolean(items.length) && /* @__PURE__ */ jsx("ul", { className: "graphiql-history-items", children: items.map(_temp5) });
  let t10;
  if ($[6] !== t6 || $[7] !== t7 || $[8] !== t8 || $[9] !== t9) {
    t10 = /* @__PURE__ */ jsxs("section", { "aria-label": t3, className: t4, children: [
      t6,
      t7,
      t8,
      t9
    ] });
    $[6] = t6;
    $[7] = t7;
    $[8] = t8;
    $[9] = t9;
    $[10] = t10;
  } else {
    t10 = $[10];
  }
  return t10;
}
function _temp5(item_3) {
  return /* @__PURE__ */ jsx(HistoryItem, { item: item_3 }, item_3.index);
}
function _temp4(item_2) {
  return /* @__PURE__ */ jsx(HistoryItem, { item: item_2 }, item_2.index);
}
function _temp3(item_1) {
  return !item_1.favorite;
}
function _temp2(item_0) {
  return item_0.favorite;
}
function _temp(item, i) {
  return {
    ...item,
    index: i
  };
}
function HistoryItem(props) {
  const $ = c(40);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: HistoryItem
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    editLabel,
    toggleFavorite,
    deleteFromHistory,
    setActive
  } = useHistoryContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: HistoryItem
    };
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    headerEditor,
    queryEditor,
    variableEditor
  } = useEditorContext(t1);
  const inputRef = useRef(null);
  const buttonRef = useRef(null);
  const [isEditable, setIsEditable] = useState(false);
  let t2;
  let t3;
  if ($[2] !== isEditable) {
    t2 = () => {
      var _a;
      if (isEditable) {
        (_a = inputRef.current) == null ? void 0 : _a.focus();
      }
    };
    t3 = [isEditable];
    $[2] = isEditable;
    $[3] = t2;
    $[4] = t3;
  } else {
    t2 = $[3];
    t3 = $[4];
  }
  useEffect(t2, t3);
  let t4;
  if ($[5] !== props.item.label || $[6] !== props.item.operationName || $[7] !== props.item.query) {
    t4 = props.item.label || props.item.operationName || formatQuery(props.item.query);
    $[5] = props.item.label;
    $[6] = props.item.operationName;
    $[7] = props.item.query;
    $[8] = t4;
  } else {
    t4 = $[8];
  }
  const displayName = t4;
  let t5;
  if ($[9] !== editLabel || $[10] !== props.item) {
    t5 = () => {
      var _a;
      setIsEditable(false);
      const {
        index,
        ...item
      } = props.item;
      editLabel({
        ...item,
        label: (_a = inputRef.current) == null ? void 0 : _a.value
      }, index);
    };
    $[9] = editLabel;
    $[10] = props.item;
    $[11] = t5;
  } else {
    t5 = $[11];
  }
  const handleSave = t5;
  let t6;
  if ($[12] === Symbol.for("react.memo_cache_sentinel")) {
    t6 = () => {
      setIsEditable(false);
    };
    $[12] = t6;
  } else {
    t6 = $[12];
  }
  const handleClose = t6;
  let t7;
  if ($[13] === Symbol.for("react.memo_cache_sentinel")) {
    t7 = (e) => {
      e.stopPropagation();
      setIsEditable(true);
    };
    $[13] = t7;
  } else {
    t7 = $[13];
  }
  const handleEditLabel = t7;
  let t8;
  if ($[14] !== headerEditor || $[15] !== props.item || $[16] !== queryEditor || $[17] !== setActive || $[18] !== variableEditor) {
    t8 = () => {
      const {
        query,
        variables,
        headers
      } = props.item;
      queryEditor == null ? void 0 : queryEditor.setValue(query ?? "");
      variableEditor == null ? void 0 : variableEditor.setValue(variables ?? "");
      headerEditor == null ? void 0 : headerEditor.setValue(headers ?? "");
      setActive(props.item);
    };
    $[14] = headerEditor;
    $[15] = props.item;
    $[16] = queryEditor;
    $[17] = setActive;
    $[18] = variableEditor;
    $[19] = t8;
  } else {
    t8 = $[19];
  }
  const handleHistoryItemClick = t8;
  let t9;
  if ($[20] !== deleteFromHistory || $[21] !== props.item) {
    t9 = (e_0) => {
      e_0.stopPropagation();
      deleteFromHistory(props.item);
    };
    $[20] = deleteFromHistory;
    $[21] = props.item;
    $[22] = t9;
  } else {
    t9 = $[22];
  }
  const handleDeleteItemFromHistory = t9;
  let t10;
  if ($[23] !== props.item || $[24] !== toggleFavorite) {
    t10 = (e_1) => {
      e_1.stopPropagation();
      toggleFavorite(props.item);
    };
    $[23] = props.item;
    $[24] = toggleFavorite;
    $[25] = t10;
  } else {
    t10 = $[25];
  }
  const handleToggleFavorite = t10;
  const t11 = isEditable && "editable";
  let t12;
  if ($[26] !== t11) {
    t12 = clsx("graphiql-history-item", t11);
    $[26] = t11;
    $[27] = t12;
  } else {
    t12 = $[27];
  }
  let t13;
  if ($[28] !== displayName || $[29] !== editLabel || $[30] !== handleDeleteItemFromHistory || $[31] !== handleHistoryItemClick || $[32] !== handleSave || $[33] !== handleToggleFavorite || $[34] !== isEditable || $[35] !== props.item) {
    t13 = isEditable ? /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx("input", { type: "text", defaultValue: props.item.label, ref: inputRef, onKeyDown: (e_2) => {
        if (e_2.key === "Esc") {
          setIsEditable(false);
        } else {
          if (e_2.key === "Enter") {
            setIsEditable(false);
            editLabel({
              ...props.item,
              label: e_2.currentTarget.value
            });
          }
        }
      }, placeholder: "Type a label" }),
      /* @__PURE__ */ jsx(UnStyledButton, { type: "button", ref: buttonRef, onClick: handleSave, children: "Save" }),
      /* @__PURE__ */ jsx(UnStyledButton, { type: "button", ref: buttonRef, onClick: handleClose, children: /* @__PURE__ */ jsx(CloseIcon, {}) })
    ] }) : /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(Tooltip, { label: "Set active", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-history-item-label", onClick: handleHistoryItemClick, "aria-label": "Set active", children: displayName }) }),
      /* @__PURE__ */ jsx(Tooltip, { label: "Edit label", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-history-item-action", onClick: handleEditLabel, "aria-label": "Edit label", children: /* @__PURE__ */ jsx(PenIcon, { "aria-hidden": "true" }) }) }),
      /* @__PURE__ */ jsx(Tooltip, { label: props.item.favorite ? "Remove favorite" : "Add favorite", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-history-item-action", onClick: handleToggleFavorite, "aria-label": props.item.favorite ? "Remove favorite" : "Add favorite", children: props.item.favorite ? /* @__PURE__ */ jsx(StarFilledIcon, { "aria-hidden": "true" }) : /* @__PURE__ */ jsx(StarIcon, { "aria-hidden": "true" }) }) }),
      /* @__PURE__ */ jsx(Tooltip, { label: "Delete from history", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-history-item-action", onClick: handleDeleteItemFromHistory, "aria-label": "Delete from history", children: /* @__PURE__ */ jsx(TrashIcon, { "aria-hidden": "true" }) }) })
    ] });
    $[28] = displayName;
    $[29] = editLabel;
    $[30] = handleDeleteItemFromHistory;
    $[31] = handleHistoryItemClick;
    $[32] = handleSave;
    $[33] = handleToggleFavorite;
    $[34] = isEditable;
    $[35] = props.item;
    $[36] = t13;
  } else {
    t13 = $[36];
  }
  let t14;
  if ($[37] !== t12 || $[38] !== t13) {
    t14 = /* @__PURE__ */ jsx("li", { className: t12, children: t13 });
    $[37] = t12;
    $[38] = t13;
    $[39] = t14;
  } else {
    t14 = $[39];
  }
  return t14;
}
function formatQuery(query) {
  return query == null ? void 0 : query.split("\n").map((line) => line.replace(/#(.*)/, "")).join(" ").replaceAll("{", " { ").replaceAll("}", " } ").replaceAll(/[\s]{2,}/g, " ");
}
export {
  History,
  HistoryItem,
  formatQuery
};
//# sourceMappingURL=components.js.map
