import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { HistoryStore, StorageAPI } from "@graphiql/toolkit";
import { useState } from "react";
import { useStorageContext } from "../storage.js";
import { createNullableContext, createContextHook } from "../utility/context.js";
const HistoryContext = createNullableContext("HistoryContext");
function HistoryContextProvider(t0) {
  const $ = c(11);
  const {
    maxHistoryLength: t1,
    children
  } = t0;
  const maxHistoryLength = t1 === void 0 ? DEFAULT_HISTORY_LENGTH : t1;
  const storage = useStorageContext();
  let t2;
  if ($[0] !== maxHistoryLength || $[1] !== storage) {
    t2 = () => new HistoryStore(storage || new StorageAPI(null), maxHistoryLength);
    $[0] = maxHistoryLength;
    $[1] = storage;
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const [historyStore] = useState(t2);
  let t3;
  if ($[3] !== historyStore.queries) {
    t3 = () => historyStore.queries || [];
    $[3] = historyStore.queries;
    $[4] = t3;
  } else {
    t3 = $[4];
  }
  const [items, setItems] = useState(t3);
  let t4;
  if ($[5] !== historyStore || $[6] !== items) {
    t4 = {
      addToHistory(operation) {
        historyStore.updateHistory(operation);
        setItems(historyStore.queries);
      },
      editLabel(operation_0, index) {
        historyStore.editLabel(operation_0, index);
        setItems(historyStore.queries);
      },
      items,
      toggleFavorite(operation_1) {
        historyStore.toggleFavorite(operation_1);
        setItems(historyStore.queries);
      },
      setActive: _temp,
      deleteFromHistory(item_0, clearFavorites) {
        historyStore.deleteHistory(item_0, clearFavorites);
        setItems(historyStore.queries);
      }
    };
    $[5] = historyStore;
    $[6] = items;
    $[7] = t4;
  } else {
    t4 = $[7];
  }
  const value = t4;
  let t5;
  if ($[8] !== children || $[9] !== value) {
    t5 = /* @__PURE__ */ jsx(HistoryContext.Provider, { value, children });
    $[8] = children;
    $[9] = value;
    $[10] = t5;
  } else {
    t5 = $[10];
  }
  return t5;
}
function _temp(item) {
  return item;
}
const useHistoryContext = createContextHook(HistoryContext);
const DEFAULT_HISTORY_LENGTH = 20;
export {
  HistoryContext,
  HistoryContextProvider,
  useHistoryContext
};
//# sourceMappingURL=context.js.map
