import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useState, useEffect } from "react";
import { HistoryIcon, DocsFilledIcon, DocsIcon } from "./icons/index.js";
import { useStorageContext } from "./storage.js";
import { createNullableContext, createContextHook } from "./utility/context.js";
import { DocExplorer } from "./explorer/components/doc-explorer.js";
import { History } from "./history/components.js";
import { useExplorerContext } from "./explorer/context.js";
import { useHistoryContext } from "./history/context.js";
const DOC_EXPLORER_PLUGIN = {
  title: "Documentation Explorer",
  icon: function Icon() {
    const pluginContext = usePluginContext();
    return (pluginContext == null ? void 0 : pluginContext.visiblePlugin) === DOC_EXPLORER_PLUGIN ? /* @__PURE__ */ jsx(DocsFilledIcon, {}) : /* @__PURE__ */ jsx(DocsIcon, {});
  },
  content: DocExplorer
};
const HISTORY_PLUGIN = {
  title: "History",
  icon: HistoryIcon,
  content: History
};
const PluginContext = createNullableContext("PluginContext");
function PluginContextProvider(props) {
  const $ = c(27);
  const storage = useStorageContext();
  const explorerContext = useExplorerContext();
  const historyContext = useHistoryContext();
  const hasExplorerContext = Boolean(explorerContext);
  const hasHistoryContext = Boolean(historyContext);
  let t0;
  let pluginList;
  if ($[0] !== hasExplorerContext || $[1] !== hasHistoryContext || $[2] !== props.plugins) {
    pluginList = [];
    const pluginTitles = {};
    if (hasExplorerContext) {
      pluginList.push(DOC_EXPLORER_PLUGIN);
      pluginTitles[DOC_EXPLORER_PLUGIN.title] = true;
    }
    if (hasHistoryContext) {
      pluginList.push(HISTORY_PLUGIN);
      pluginTitles[HISTORY_PLUGIN.title] = true;
    }
    let t12;
    if ($[4] !== props.plugins) {
      t12 = props.plugins || [];
      $[4] = props.plugins;
      $[5] = t12;
    } else {
      t12 = $[5];
    }
    for (const plugin of t12) {
      if (typeof plugin.title !== "string" || !plugin.title) {
        throw new Error("All GraphiQL plugins must have a unique title");
      }
      if (pluginTitles[plugin.title]) {
        throw new Error(`All GraphiQL plugins must have a unique title, found two plugins with the title '${plugin.title}'`);
      } else {
        pluginList.push(plugin);
        pluginTitles[plugin.title] = true;
      }
    }
    $[0] = hasExplorerContext;
    $[1] = hasHistoryContext;
    $[2] = props.plugins;
    $[3] = pluginList;
  } else {
    pluginList = $[3];
  }
  t0 = pluginList;
  const plugins = t0;
  let t1;
  if ($[6] !== plugins || $[7] !== props.visiblePlugin || $[8] !== storage) {
    t1 = () => {
      const storedValue = storage == null ? void 0 : storage.get(STORAGE_KEY);
      const pluginForStoredValue = plugins.find((plugin_0) => plugin_0.title === storedValue);
      if (pluginForStoredValue) {
        return pluginForStoredValue;
      }
      if (storedValue) {
        storage == null ? void 0 : storage.set(STORAGE_KEY, "");
      }
      if (!props.visiblePlugin) {
        return null;
      }
      return plugins.find((plugin_1) => (typeof props.visiblePlugin === "string" ? plugin_1.title : plugin_1) === props.visiblePlugin) || null;
    };
    $[6] = plugins;
    $[7] = props.visiblePlugin;
    $[8] = storage;
    $[9] = t1;
  } else {
    t1 = $[9];
  }
  const [visiblePlugin, internalSetVisiblePlugin] = useState(t1);
  const {
    onTogglePluginVisibility,
    children
  } = props;
  let t2;
  if ($[10] !== onTogglePluginVisibility || $[11] !== plugins) {
    t2 = (plugin_2) => {
      const newVisiblePlugin = plugin_2 ? plugins.find((p) => (typeof plugin_2 === "string" ? p.title : p) === plugin_2) || null : null;
      internalSetVisiblePlugin((current) => {
        if (newVisiblePlugin === current) {
          return current;
        }
        onTogglePluginVisibility == null ? void 0 : onTogglePluginVisibility(newVisiblePlugin);
        return newVisiblePlugin;
      });
    };
    $[10] = onTogglePluginVisibility;
    $[11] = plugins;
    $[12] = t2;
  } else {
    t2 = $[12];
  }
  const setVisiblePlugin = t2;
  let t3;
  if ($[13] !== props.visiblePlugin || $[14] !== setVisiblePlugin) {
    t3 = () => {
      if (props.visiblePlugin) {
        setVisiblePlugin(props.visiblePlugin);
      }
    };
    $[13] = props.visiblePlugin;
    $[14] = setVisiblePlugin;
    $[15] = t3;
  } else {
    t3 = $[15];
  }
  let t4;
  if ($[16] !== plugins || $[17] !== props.visiblePlugin || $[18] !== setVisiblePlugin) {
    t4 = [plugins, props.visiblePlugin, setVisiblePlugin];
    $[16] = plugins;
    $[17] = props.visiblePlugin;
    $[18] = setVisiblePlugin;
    $[19] = t4;
  } else {
    t4 = $[19];
  }
  useEffect(t3, t4);
  let t5;
  if ($[20] !== plugins || $[21] !== setVisiblePlugin || $[22] !== visiblePlugin) {
    t5 = {
      plugins,
      setVisiblePlugin,
      visiblePlugin
    };
    $[20] = plugins;
    $[21] = setVisiblePlugin;
    $[22] = visiblePlugin;
    $[23] = t5;
  } else {
    t5 = $[23];
  }
  const value = t5;
  let t6;
  if ($[24] !== children || $[25] !== value) {
    t6 = /* @__PURE__ */ jsx(PluginContext.Provider, { value, children });
    $[24] = children;
    $[25] = value;
    $[26] = t6;
  } else {
    t6 = $[26];
  }
  return t6;
}
const usePluginContext = createContextHook(PluginContext);
const STORAGE_KEY = "visiblePlugin";
export {
  DOC_EXPLORER_PLUGIN,
  HISTORY_PLUGIN,
  PluginContext,
  PluginContextProvider,
  usePluginContext
};
//# sourceMappingURL=plugin.js.map
