import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { ExecutionContextProvider } from "./execution.js";
import { ExplorerContextProvider } from "./explorer/context.js";
import { PluginContextProvider } from "./plugin.js";
import { SchemaContextProvider } from "./schema.js";
import { StorageContextProvider } from "./storage.js";
import { EditorContextProvider } from "./editor/context.js";
import { HistoryContextProvider } from "./history/context.js";
function GraphiQLProvider(t0) {
  const $ = c(39);
  const {
    children,
    dangerouslyAssumeSchemaIsValid,
    defaultQuery,
    defaultHeaders,
    defaultTabs,
    externalFragments,
    fetcher,
    getDefaultFieldNames,
    headers,
    inputValueDeprecation,
    introspectionQueryName,
    maxHistoryLength,
    onEditOperationName,
    onSchemaChange,
    onTabChange,
    onTogglePluginVisibility,
    operationName,
    plugins,
    query,
    response,
    schema,
    schemaDescription,
    shouldPersistHeaders,
    storage,
    validationRules,
    variables,
    visiblePlugin
  } = t0;
  let t1;
  if ($[0] !== children || $[1] !== onTogglePluginVisibility || $[2] !== plugins || $[3] !== visiblePlugin) {
    t1 = /* @__PURE__ */ jsx(ExplorerContextProvider, { children: /* @__PURE__ */ jsx(PluginContextProvider, { onTogglePluginVisibility, plugins, visiblePlugin, children }) });
    $[0] = children;
    $[1] = onTogglePluginVisibility;
    $[2] = plugins;
    $[3] = visiblePlugin;
    $[4] = t1;
  } else {
    t1 = $[4];
  }
  let t2;
  if ($[5] !== fetcher || $[6] !== getDefaultFieldNames || $[7] !== operationName || $[8] !== t1) {
    t2 = /* @__PURE__ */ jsx(ExecutionContextProvider, { getDefaultFieldNames, fetcher, operationName, children: t1 });
    $[5] = fetcher;
    $[6] = getDefaultFieldNames;
    $[7] = operationName;
    $[8] = t1;
    $[9] = t2;
  } else {
    t2 = $[9];
  }
  let t3;
  if ($[10] !== dangerouslyAssumeSchemaIsValid || $[11] !== fetcher || $[12] !== inputValueDeprecation || $[13] !== introspectionQueryName || $[14] !== onSchemaChange || $[15] !== schema || $[16] !== schemaDescription || $[17] !== t2) {
    t3 = /* @__PURE__ */ jsx(SchemaContextProvider, { dangerouslyAssumeSchemaIsValid, fetcher, inputValueDeprecation, introspectionQueryName, onSchemaChange, schema, schemaDescription, children: t2 });
    $[10] = dangerouslyAssumeSchemaIsValid;
    $[11] = fetcher;
    $[12] = inputValueDeprecation;
    $[13] = introspectionQueryName;
    $[14] = onSchemaChange;
    $[15] = schema;
    $[16] = schemaDescription;
    $[17] = t2;
    $[18] = t3;
  } else {
    t3 = $[18];
  }
  let t4;
  if ($[19] !== defaultHeaders || $[20] !== defaultQuery || $[21] !== defaultTabs || $[22] !== externalFragments || $[23] !== headers || $[24] !== onEditOperationName || $[25] !== onTabChange || $[26] !== query || $[27] !== response || $[28] !== shouldPersistHeaders || $[29] !== t3 || $[30] !== validationRules || $[31] !== variables) {
    t4 = /* @__PURE__ */ jsx(EditorContextProvider, { defaultQuery, defaultHeaders, defaultTabs, externalFragments, headers, onEditOperationName, onTabChange, query, response, shouldPersistHeaders, validationRules, variables, children: t3 });
    $[19] = defaultHeaders;
    $[20] = defaultQuery;
    $[21] = defaultTabs;
    $[22] = externalFragments;
    $[23] = headers;
    $[24] = onEditOperationName;
    $[25] = onTabChange;
    $[26] = query;
    $[27] = response;
    $[28] = shouldPersistHeaders;
    $[29] = t3;
    $[30] = validationRules;
    $[31] = variables;
    $[32] = t4;
  } else {
    t4 = $[32];
  }
  let t5;
  if ($[33] !== maxHistoryLength || $[34] !== t4) {
    t5 = /* @__PURE__ */ jsx(HistoryContextProvider, { maxHistoryLength, children: t4 });
    $[33] = maxHistoryLength;
    $[34] = t4;
    $[35] = t5;
  } else {
    t5 = $[35];
  }
  let t6;
  if ($[36] !== storage || $[37] !== t5) {
    t6 = /* @__PURE__ */ jsx(StorageContextProvider, { storage, children: t5 });
    $[36] = storage;
    $[37] = t5;
    $[38] = t6;
  } else {
    t6 = $[38];
  }
  return t6;
}
export {
  GraphiQLProvider
};
//# sourceMappingURL=provider.js.map
