import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { formatError, fetcherReturnToPromise, isPromise, formatResult } from "@graphiql/toolkit";
import { validateSchema, getIntrospectionQuery, isSchema, buildClientSchema } from "graphql";
import { useState, useRef, useEffect } from "react";
import { createNullableContext, createContextHook } from "./utility/context.js";
import { useEditorContext } from "./editor/context.js";
const SchemaContext = createNullableContext("SchemaContext");
function SchemaContextProvider(t0) {
  const $ = c(38);
  let fetcher;
  let onSchemaChange;
  let props;
  if ($[0] !== t0) {
    ({
      fetcher,
      onSchemaChange,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = fetcher;
    $[2] = onSchemaChange;
    $[3] = props;
  } else {
    fetcher = $[1];
    onSchemaChange = $[2];
    props = $[3];
  }
  if (!fetcher) {
    throw new TypeError("The `SchemaContextProvider` component requires a `fetcher` function to be passed as prop.");
  }
  let t1;
  if ($[4] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: SchemaContextProvider
    };
    $[4] = t1;
  } else {
    t1 = $[4];
  }
  const {
    initialHeaders,
    headerEditor
  } = useEditorContext(t1);
  const [schema, setSchema] = useState();
  const [isFetching, setIsFetching] = useState(false);
  const [fetchError, setFetchError] = useState(null);
  const counterRef = useRef(0);
  let t2;
  let t3;
  if ($[5] !== props.schema) {
    t2 = () => {
      setSchema(isSchema(props.schema) || props.schema == null ? props.schema : void 0);
      counterRef.current = counterRef.current + 1;
    };
    t3 = [props.schema];
    $[5] = props.schema;
    $[6] = t2;
    $[7] = t3;
  } else {
    t2 = $[6];
    t3 = $[7];
  }
  useEffect(t2, t3);
  const headersRef = useRef(initialHeaders);
  let t4;
  if ($[8] !== headerEditor) {
    t4 = () => {
      if (headerEditor) {
        headersRef.current = headerEditor.getValue();
      }
    };
    $[8] = headerEditor;
    $[9] = t4;
  } else {
    t4 = $[9];
  }
  useEffect(t4);
  let t5;
  if ($[10] !== props.inputValueDeprecation || $[11] !== props.introspectionQueryName || $[12] !== props.schemaDescription) {
    t5 = {
      inputValueDeprecation: props.inputValueDeprecation,
      introspectionQueryName: props.introspectionQueryName,
      schemaDescription: props.schemaDescription
    };
    $[10] = props.inputValueDeprecation;
    $[11] = props.introspectionQueryName;
    $[12] = props.schemaDescription;
    $[13] = t5;
  } else {
    t5 = $[13];
  }
  const {
    introspectionQuery,
    introspectionQueryName,
    introspectionQuerySansSubscriptions
  } = useIntrospectionQuery(t5);
  let t6;
  if ($[14] !== fetcher || $[15] !== introspectionQuery || $[16] !== introspectionQueryName || $[17] !== introspectionQuerySansSubscriptions || $[18] !== onSchemaChange || $[19] !== props.schema) {
    t6 = () => {
      if (isSchema(props.schema) || props.schema === null) {
        return;
      }
      const counter = counterRef.current = counterRef.current + 1;
      const maybeIntrospectionData = props.schema;
      const fetchIntrospectionData = async function fetchIntrospectionData2() {
        if (maybeIntrospectionData) {
          return maybeIntrospectionData;
        }
        const parsedHeaders = parseHeaderString(headersRef.current);
        if (!parsedHeaders.isValidJSON) {
          setFetchError("Introspection failed as headers are invalid.");
          return;
        }
        const fetcherOpts = parsedHeaders.headers ? {
          headers: parsedHeaders.headers
        } : {};
        const fetch = fetcherReturnToPromise(fetcher({
          query: introspectionQuery,
          operationName: introspectionQueryName
        }, fetcherOpts));
        if (!isPromise(fetch)) {
          setFetchError("Fetcher did not return a Promise for introspection.");
          return;
        }
        setIsFetching(true);
        setFetchError(null);
        let result = await fetch;
        if (typeof result !== "object" || result === null || !("data" in result)) {
          const fetch2 = fetcherReturnToPromise(fetcher({
            query: introspectionQuerySansSubscriptions,
            operationName: introspectionQueryName
          }, fetcherOpts));
          if (!isPromise(fetch2)) {
            throw new Error("Fetcher did not return a Promise for introspection.");
          }
          result = await fetch2;
        }
        setIsFetching(false);
        if ((result == null ? void 0 : result.data) && "__schema" in result.data) {
          return result.data;
        }
        const responseString = typeof result === "string" ? result : formatResult(result);
        setFetchError(responseString);
      };
      fetchIntrospectionData().then((introspectionData) => {
        if (counter !== counterRef.current || !introspectionData) {
          return;
        }
        try {
          const newSchema = buildClientSchema(introspectionData);
          setSchema(newSchema);
          if (onSchemaChange) {
            onSchemaChange(newSchema);
          }
        } catch (t72) {
          const error = t72;
          setFetchError(formatError(error));
        }
      }).catch((error_0) => {
        if (counter !== counterRef.current) {
          return;
        }
        setFetchError(formatError(error_0));
        setIsFetching(false);
      });
    };
    $[14] = fetcher;
    $[15] = introspectionQuery;
    $[16] = introspectionQueryName;
    $[17] = introspectionQuerySansSubscriptions;
    $[18] = onSchemaChange;
    $[19] = props.schema;
    $[20] = t6;
  } else {
    t6 = $[20];
  }
  const introspect = t6;
  let t7;
  let t8;
  if ($[21] !== introspect) {
    t7 = () => {
      introspect();
    };
    t8 = [introspect];
    $[21] = introspect;
    $[22] = t7;
    $[23] = t8;
  } else {
    t7 = $[22];
    t8 = $[23];
  }
  useEffect(t7, t8);
  let t9;
  if ($[24] !== introspect) {
    t9 = () => {
      const triggerIntrospection = function triggerIntrospection2(event) {
        if (event.ctrlKey && event.key === "R") {
          introspect();
        }
      };
      window.addEventListener("keydown", triggerIntrospection);
      return () => {
        window.removeEventListener("keydown", triggerIntrospection);
      };
    };
    $[24] = introspect;
    $[25] = t9;
  } else {
    t9 = $[25];
  }
  useEffect(t9);
  let t10;
  if ($[26] !== props.dangerouslyAssumeSchemaIsValid || $[27] !== schema) {
    t10 = !schema || props.dangerouslyAssumeSchemaIsValid ? [] : validateSchema(schema);
    $[26] = props.dangerouslyAssumeSchemaIsValid;
    $[27] = schema;
    $[28] = t10;
  } else {
    t10 = $[28];
  }
  const validationErrors = t10;
  let t11;
  if ($[29] !== fetchError || $[30] !== introspect || $[31] !== isFetching || $[32] !== schema || $[33] !== validationErrors) {
    t11 = {
      fetchError,
      introspect,
      isFetching,
      schema,
      validationErrors
    };
    $[29] = fetchError;
    $[30] = introspect;
    $[31] = isFetching;
    $[32] = schema;
    $[33] = validationErrors;
    $[34] = t11;
  } else {
    t11 = $[34];
  }
  const value = t11;
  let t12;
  if ($[35] !== props.children || $[36] !== value) {
    t12 = /* @__PURE__ */ jsx(SchemaContext.Provider, { value, children: props.children });
    $[35] = props.children;
    $[36] = value;
    $[37] = t12;
  } else {
    t12 = $[37];
  }
  return t12;
}
const useSchemaContext = createContextHook(SchemaContext);
function useIntrospectionQuery({
  inputValueDeprecation,
  introspectionQueryName,
  schemaDescription
}) {
  const queryName = introspectionQueryName || "IntrospectionQuery";
  let query = getIntrospectionQuery({
    inputValueDeprecation,
    schemaDescription
  });
  if (introspectionQueryName) {
    query = query.replace("query IntrospectionQuery", `query ${queryName}`);
  }
  const querySansSubscriptions = query.replace("subscriptionType { name }", "");
  return {
    introspectionQueryName: queryName,
    introspectionQuery: query,
    introspectionQuerySansSubscriptions: querySansSubscriptions
  };
}
function parseHeaderString(headersString) {
  let headers = null;
  let isValidJSON = true;
  try {
    if (headersString) {
      headers = JSON.parse(headersString);
    }
  } catch {
    isValidJSON = false;
  }
  return {
    headers,
    isValidJSON
  };
}
export {
  SchemaContext,
  SchemaContextProvider,
  useSchemaContext
};
//# sourceMappingURL=schema.js.map
