import { c } from "react-compiler-runtime";
import { useState, useLayoutEffect } from "react";
import { useStorageContext } from "./storage.js";
function useTheme(t0) {
  const $ = c(11);
  const defaultTheme = t0 === void 0 ? null : t0;
  const storageContext = useStorageContext();
  let t1;
  if ($[0] !== defaultTheme || $[1] !== storageContext) {
    t1 = () => {
      if (!storageContext) {
        return null;
      }
      const stored = storageContext.get(STORAGE_KEY);
      switch (stored) {
        case "light": {
          return "light";
        }
        case "dark": {
          return "dark";
        }
        default: {
          if (typeof stored === "string") {
            storageContext.set(STORAGE_KEY, "");
          }
          return defaultTheme;
        }
      }
    };
    $[0] = defaultTheme;
    $[1] = storageContext;
    $[2] = t1;
  } else {
    t1 = $[2];
  }
  const [theme, setThemeInternal] = useState(t1);
  let t2;
  let t3;
  if ($[3] !== theme) {
    t2 = () => {
      if (typeof window === "undefined") {
        return;
      }
      document.body.classList.remove("graphiql-light", "graphiql-dark");
      if (theme) {
        document.body.classList.add(`graphiql-${theme}`);
      }
    };
    t3 = [theme];
    $[3] = theme;
    $[4] = t2;
    $[5] = t3;
  } else {
    t2 = $[4];
    t3 = $[5];
  }
  useLayoutEffect(t2, t3);
  let t4;
  if ($[6] !== storageContext) {
    t4 = (newTheme) => {
      storageContext == null ? void 0 : storageContext.set(STORAGE_KEY, newTheme || "");
      setThemeInternal(newTheme);
    };
    $[6] = storageContext;
    $[7] = t4;
  } else {
    t4 = $[7];
  }
  const setTheme = t4;
  let t5;
  if ($[8] !== setTheme || $[9] !== theme) {
    t5 = {
      theme,
      setTheme
    };
    $[8] = setTheme;
    $[9] = theme;
    $[10] = t5;
  } else {
    t5 = $[10];
  }
  return t5;
}
const STORAGE_KEY = "theme";
export {
  useTheme
};
//# sourceMappingURL=theme.js.map
