import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { forwardRef, useState } from "react";
import { clsx } from "clsx";
/* empty css           */
import { UnStyledButton } from "../ui/button.js";
import { Tooltip } from "../ui/tooltip.js";
const ToolbarButton = forwardRef((t0, ref) => {
  const $ = c(19);
  let label;
  let onClick;
  let props;
  if ($[0] !== t0) {
    ({
      label,
      onClick,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = label;
    $[2] = onClick;
    $[3] = props;
  } else {
    label = $[1];
    onClick = $[2];
    props = $[3];
  }
  const [error, setError] = useState(null);
  let t1;
  if ($[4] !== onClick) {
    t1 = (event) => {
      try {
        if (onClick) {
          onClick(event);
        }
        setError(null);
      } catch (t22) {
        const err = t22;
        setError(err instanceof Error ? err : new Error(`Toolbar button click failed: ${err}`));
      }
    };
    $[4] = onClick;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  const handleClick = t1;
  const t2 = error && "error";
  let t3;
  if ($[6] !== props.className || $[7] !== t2) {
    t3 = clsx("graphiql-toolbar-button", t2, props.className);
    $[6] = props.className;
    $[7] = t2;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  const t4 = error ? error.message : label;
  const t5 = error ? "true" : props["aria-invalid"];
  let t6;
  if ($[9] !== handleClick || $[10] !== props || $[11] !== ref || $[12] !== t3 || $[13] !== t4 || $[14] !== t5) {
    t6 = /* @__PURE__ */ jsx(UnStyledButton, { ...props, ref, type: "button", className: t3, onClick: handleClick, "aria-label": t4, "aria-invalid": t5 });
    $[9] = handleClick;
    $[10] = props;
    $[11] = ref;
    $[12] = t3;
    $[13] = t4;
    $[14] = t5;
    $[15] = t6;
  } else {
    t6 = $[15];
  }
  let t7;
  if ($[16] !== label || $[17] !== t6) {
    t7 = /* @__PURE__ */ jsx(Tooltip, { label, children: t6 });
    $[16] = label;
    $[17] = t6;
    $[18] = t7;
  } else {
    t7 = $[18];
  }
  return t7;
});
ToolbarButton.displayName = "ToolbarButton";
export {
  ToolbarButton
};
//# sourceMappingURL=button.js.map
