import { jsxs, jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useExecutionContext } from "../execution.js";
import { StopIcon, PlayIcon } from "../icons/index.js";
/* empty css            */
import { useEditorContext } from "../editor/context.js";
import { DropdownMenu } from "../ui/dropdown.js";
import { Tooltip } from "../ui/tooltip.js";
function ExecuteButton() {
  const $ = c(19);
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true,
      caller: ExecuteButton
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    queryEditor,
    setOperationName
  } = useEditorContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: ExecuteButton
    };
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    isFetching,
    isSubscribed,
    operationName,
    run,
    stop
  } = useExecutionContext(t1);
  let t2;
  if ($[2] !== (queryEditor == null ? void 0 : queryEditor.operations)) {
    t2 = (queryEditor == null ? void 0 : queryEditor.operations) || [];
    $[2] = queryEditor == null ? void 0 : queryEditor.operations;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  const operations = t2;
  const hasOptions = operations.length > 1 && typeof operationName !== "string";
  const isRunning = isFetching || isSubscribed;
  const label = `${isRunning ? "Stop" : "Execute"} query (Ctrl-Enter)`;
  let t3;
  if ($[4] !== isRunning) {
    t3 = isRunning ? /* @__PURE__ */ jsx(StopIcon, {}) : /* @__PURE__ */ jsx(PlayIcon, {});
    $[4] = isRunning;
    $[5] = t3;
  } else {
    t3 = $[5];
  }
  let t4;
  if ($[6] !== label || $[7] !== t3) {
    t4 = {
      type: "button",
      className: "graphiql-execute-button",
      children: t3,
      "aria-label": label
    };
    $[6] = label;
    $[7] = t3;
    $[8] = t4;
  } else {
    t4 = $[8];
  }
  const buttonProps = t4;
  let t5;
  if ($[9] !== buttonProps || $[10] !== hasOptions || $[11] !== isRunning || $[12] !== label || $[13] !== operations || $[14] !== queryEditor || $[15] !== run || $[16] !== setOperationName || $[17] !== stop) {
    t5 = hasOptions && !isRunning ? /* @__PURE__ */ jsxs(DropdownMenu, { children: [
      /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx(DropdownMenu.Button, { ...buttonProps }) }),
      /* @__PURE__ */ jsx(DropdownMenu.Content, { children: operations.map((operation, i) => {
        const opName = operation.name ? operation.name.value : `<Unnamed ${operation.operation}>`;
        return /* @__PURE__ */ jsx(DropdownMenu.Item, { onSelect: () => {
          var _a;
          const selectedOperationName = (_a = operation.name) == null ? void 0 : _a.value;
          if (queryEditor && selectedOperationName && selectedOperationName !== queryEditor.operationName) {
            setOperationName(selectedOperationName);
          }
          run();
        }, children: opName }, `${opName}-${i}`);
      }) })
    ] }) : /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx("button", { ...buttonProps, onClick: () => {
      if (isRunning) {
        stop();
      } else {
        run();
      }
    } }) });
    $[9] = buttonProps;
    $[10] = hasOptions;
    $[11] = isRunning;
    $[12] = label;
    $[13] = operations;
    $[14] = queryEditor;
    $[15] = run;
    $[16] = setOperationName;
    $[17] = stop;
    $[18] = t5;
  } else {
    t5 = $[18];
  }
  return t5;
}
export {
  ExecuteButton
};
//# sourceMappingURL=execute.js.map
