import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { forwardRef } from "react";
import { clsx } from "clsx";
import { Root, Portal, Content as Content$1, Item as Item$1, Trigger } from "@radix-ui/react-dropdown-menu";
/* empty css             */
const Button = forwardRef((props, ref) => {
  const $ = c(6);
  let t0;
  if ($[0] !== props.className) {
    t0 = clsx("graphiql-un-styled", props.className);
    $[0] = props.className;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== props || $[3] !== ref || $[4] !== t0) {
    t1 = /* @__PURE__ */ jsx(Trigger, { asChild: true, children: /* @__PURE__ */ jsx("button", { ...props, ref, className: t0 }) });
    $[2] = props;
    $[3] = ref;
    $[4] = t0;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  return t1;
});
Button.displayName = "DropdownMenuButton";
function Content(t0) {
  const $ = c(14);
  let children;
  let className;
  let props;
  let t1;
  let t2;
  if ($[0] !== t0) {
    ({
      children,
      align: t1,
      sideOffset: t2,
      className,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = className;
    $[3] = props;
    $[4] = t1;
    $[5] = t2;
  } else {
    children = $[1];
    className = $[2];
    props = $[3];
    t1 = $[4];
    t2 = $[5];
  }
  const align = t1 === void 0 ? "start" : t1;
  const sideOffset = t2 === void 0 ? 5 : t2;
  let t3;
  if ($[6] !== className) {
    t3 = clsx("graphiql-dropdown-content", className);
    $[6] = className;
    $[7] = t3;
  } else {
    t3 = $[7];
  }
  let t4;
  if ($[8] !== align || $[9] !== children || $[10] !== props || $[11] !== sideOffset || $[12] !== t3) {
    t4 = /* @__PURE__ */ jsx(Portal, { children: /* @__PURE__ */ jsx(Content$1, { align, sideOffset, className: t3, ...props, children }) });
    $[8] = align;
    $[9] = children;
    $[10] = props;
    $[11] = sideOffset;
    $[12] = t3;
    $[13] = t4;
  } else {
    t4 = $[13];
  }
  return t4;
}
const Item = (t0) => {
  const $ = c(10);
  let children;
  let className;
  let props;
  if ($[0] !== t0) {
    ({
      className,
      children,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = className;
    $[3] = props;
  } else {
    children = $[1];
    className = $[2];
    props = $[3];
  }
  let t1;
  if ($[4] !== className) {
    t1 = clsx("graphiql-dropdown-item", className);
    $[4] = className;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  let t2;
  if ($[6] !== children || $[7] !== props || $[8] !== t1) {
    t2 = /* @__PURE__ */ jsx(Item$1, { className: t1, ...props, children });
    $[6] = children;
    $[7] = props;
    $[8] = t1;
    $[9] = t2;
  } else {
    t2 = $[9];
  }
  return t2;
};
const DropdownMenu = Object.assign(Root, {
  Button,
  Item,
  Content
});
export {
  DropdownMenu
};
//# sourceMappingURL=dropdown.js.map
